Sk.builtinFiles={"files": {"src/lib/pythonds/trees/binheap.py": "# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005\n# \n\n# this heap takes key value pairs, we will assume that the keys are integers\nclass BinHeap:\n    def __init__(self):\n        self.heapList = [0]\n        self.currentSize = 0\n\n\n    def buildHeap(self,alist):\n        i = len(alist) // 2\n        self.currentSize = len(alist)\n        self.heapList = [0] + alist[:]\n        print(len(self.heapList), i)\n        while (i > 0):\n            print(self.heapList, i)\n            self.percDown(i)\n            i = i - 1\n        print(self.heapList,i)\n                        \n    def percDown(self,i):\n        while (i * 2) <= self.currentSize:\n            mc = self.minChild(i)\n            if self.heapList[i] > self.heapList[mc]:\n                tmp = self.heapList[i]\n                self.heapList[i] = self.heapList[mc]\n                self.heapList[mc] = tmp\n            i = mc\n                \n    def minChild(self,i):\n        if i * 2 + 1 > self.currentSize:\n            return i * 2\n        else:\n            if self.heapList[i * 2] < self.heapList[i * 2 + 1]:\n                return i * 2\n            else:\n                return i * 2 + 1\n\n    def percUp(self,i):\n        while i // 2 > 0:\n            if self.heapList[i] < self.heapList[i//2]:\n               tmp = self.heapList[i // 2]\n               self.heapList[i // 2] = self.heapList[i]\n               self.heapList[i] = tmp\n            i = i // 2\n \n    def insert(self,k):\n        self.heapList.append(k)\n        self.currentSize = self.currentSize + 1\n        self.percUp(self.currentSize)\n\n    def delMin(self):\n        retval = self.heapList[1]\n        self.heapList[1] = self.heapList[self.currentSize]\n        self.currentSize = self.currentSize - 1\n        self.heapList.pop()\n        self.percDown(1)\n        return retval\n        \n    def isEmpty(self):\n        if currentSize == 0:\n            return True\n        else:\n            return False\n", "src/lib/pythonds/basic/stack.py": "# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005\n# \n#stack.py\n\nclass Stack:\n    def __init__(self):\n        self.items = []\n\n    def isEmpty(self):\n        return self.items == []\n\n    def push(self, item):\n        self.items.append(item)\n\n    def pop(self):\n        return self.items.pop()\n\n    def peek(self):\n        return self.items[len(self.items)-1]\n\n    def size(self):\n        return len(self.items)\n\n", "src/lib/pythonds/trees/bst.py": "#!/bin/env python3.1\n# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005, 2010\n# \n\nclass BinarySearchTree:\n    '''\n    Author:  Brad Miller\n    Date:  1/15/2005\n    Description:  Imlement a binary search tree with the following interface\n                  functions:  \n                  __contains__(y) <==> y in x\n                  __getitem__(y) <==> x[y]\n                  __init__()\n                  __len__() <==> len(x)\n                  __setitem__(k,v) <==> x[k] = v\n                  clear()\n                  get(k)\n                  items() \n                  keys() \n                  values()\n                  put(k,v)\n                  in\n                  del <==> \n    '''\n\n    def __init__(self):\n        self.root = None\n        self.size = 0\n    \n    def put(self,key,val):\n        if self.root:\n            self._put(key,val,self.root)\n        else:\n            self.root = TreeNode(key,val)\n        self.size = self.size + 1\n\n    def _put(self,key,val,currentNode):\n        if key < currentNode.key:\n            if currentNode.hasLeftChild():\n                self._put(key,val,currentNode.leftChild)\n            else:\n                currentNode.leftChild = TreeNode(key,val,parent=currentNode)\n        else:\n            if currentNode.hasRightChild():\n                self._put(key,val,currentNode.rightChild)\n            else:\n                currentNode.rightChild = TreeNode(key,val,parent=currentNode)\n            \n    def __setitem__(self,k,v):\n        self.put(k,v)\n\n    def get(self,key):\n        if self.root:\n            res = self._get(key,self.root)\n            if res:\n                return res.payload\n            else:\n                return None\n        else:\n            return None\n        \n    def _get(self,key,currentNode):\n        if not currentNode:\n            return None\n        elif currentNode.key == key:\n            return currentNode\n        elif key < currentNode.key:\n            return self._get(key,currentNode.leftChild)\n        else:\n            return self._get(key,currentNode.rightChild)\n            \n        \n    def __getitem__(self,key):\n        res = self.get(key)\n        if res:\n            return res\n        else:\n            raise KeyError('Error, key not in tree')\n            \n\n    def __contains__(self,key):\n        if self._get(key,self.root):\n            return True\n        else:\n            return False\n        \n    def length(self):\n        return self.size\n\n    def __len__(self):\n        return self.size\n\n    def __iter__(self):\n        return self.root.__iter__()\n    \n    def delete(self,key):\n        if self.size > 1:\n            nodeToRemove = self._get(key,self.root)\n            if nodeToRemove:\n                self.remove(nodeToRemove)\n                self.size = self.size-1\n            else:\n                raise KeyError('Error, key not in tree')\n        elif self.size == 1 and self.root.key == key:\n            self.root = None\n            self.size = self.size - 1\n        else:\n            raise KeyError('Error, key not in tree')\n\n    def __delitem__(self,key):\n        self.delete(key)\n    \n    def remove(self,currentNode):\n        if currentNode.isLeaf(): #leaf\n            if currentNode == currentNode.parent.leftChild:\n                currentNode.parent.leftChild = None\n            else:\n                currentNode.parent.rightChild = None\n        elif currentNode.hasBothChildren(): #interior\n            succ = currentNode.findSuccessor()\n            succ.spliceOut()\n            currentNode.key = succ.key\n            currentNode.payload = succ.payload\n        else: # this node has one child\n            if currentNode.hasLeftChild():\n                if currentNode.isLeftChild():\n                    currentNode.leftChild.parent = currentNode.parent\n                    currentNode.parent.leftChild = currentNode.leftChild\n                elif currentNode.isRightChild():\n                    currentNode.leftChild.parent = currentNode.parent\n                    currentNode.parent.rightChild = currentNode.leftChild\n                else:\n                    currentNode.replaceNodeData(currentNode.leftChild.key,\n                                       currentNode.leftChild.payload,\n                                       currentNode.leftChild.leftChild,\n                                       currentNode.leftChild.rightChild)\n            else:\n                if currentNode.isLeftChild():\n                    currentNode.rightChild.parent = currentNode.parent\n                    currentNode.parent.leftChild = currentNode.rightChild\n                elif currentNode.isRightChild():\n                    currentNode.rightChild.parent = currentNode.parent\n                    currentNode.parent.rightChild = currentNode.rightChild\n                else:\n                    currentNode.replaceNodeData(currentNode.rightChild.key,\n                                       currentNode.rightChild.payload,\n                                       currentNode.rightChild.leftChild,\n                                       currentNode.rightChild.rightChild)\n\n    def inorder(self):\n        self._inorder(self.root)\n\n    def _inorder(self,tree):\n        if tree != None:\n            self._inorder(tree.leftChild)\n            print(tree.key)\n            self._inorder(tree.rightChild)\n\n    def postorder(self):\n        self._postorder(self.root)\n\n    def _postorder(self, tree):\n        if tree:\n            self._postorder(tree.rightChild)\n            self._postorder(tree.leftChild)\n            print(tree.key)            \n\n    def preorder(self):\n        self._preorder(self,self.root)\n\n    def _preorder(self,tree):\n        if tree:\n            print(tree.key)            \n            self._preorder(tree.leftChild)\n            self._preorder(tree.rightChild)\n\n                \nclass TreeNode:\n    def __init__(self,key,val,left=None,right=None,parent=None):\n        self.key = key\n        self.payload = val\n        self.leftChild = left\n        self.rightChild = right\n        self.parent = parent\n        self.balanceFactor = 0\n        \n    def hasLeftChild(self):\n        return self.leftChild\n\n    def hasRightChild(self):\n        return self.rightChild\n    \n    def isLeftChild(self):\n        return self.parent and self.parent.leftChild == self\n\n    def isRightChild(self):\n        return self.parent and self.parent.rightChild == self\n\n    def isRoot(self):\n        return not self.parent\n\n    def isLeaf(self):\n        return not (self.rightChild or self.leftChild)\n\n    def hasAnyChildren(self):\n        return self.rightChild or self.leftChild\n\n    def hasBothChildren(self):\n        return self.rightChild and self.leftChild\n    \n    def replaceNodeData(self,key,value,lc,rc):\n        self.key = key\n        self.payload = value\n        self.leftChild = lc\n        self.rightChild = rc\n        if self.hasLeftChild():\n            self.leftChild.parent = self\n        if self.hasRightChild():\n            self.rightChild.parent = self\n        \n    def findSuccessor(self):\n        succ = None\n        if self.hasRightChild():\n            succ = self.rightChild.findMin()\n        else:\n            if self.parent:\n                if self.isLeftChild():\n                    succ = self.parent\n                else:\n                    self.parent.rightChild = None\n                    succ = self.parent.findSuccessor()\n                    self.parent.rightChild = self\n        return succ\n\n\n    def spliceOut(self):\n        if self.isLeaf():\n            if self.isLeftChild():\n                self.parent.leftChild = None\n            else:\n                self.parent.rightChild = None\n        elif self.hasAnyChildren():\n            if self.hasLeftChild():\n                if self.isLeftChild():\n                    self.parent.leftChild = self.leftChild\n                else:\n                    self.parent.rightChild = self.leftChild\n                self.leftChild.parent = self.parent\n            else:\n                if self.isLeftChild():\n                    self.parent.leftChild = self.rightChild\n                else:\n                    self.parent.rightChild = self.rightChild\n                self.rightChild.parent = self.parent\n\n    def findMin(self):\n        current = self\n        while current.hasLeftChild():\n            current = current.leftChild\n        return current\n\n    def __iter__(self):\n        \"\"\"The standard inorder traversal of a binary tree.\"\"\"\n        if self:\n            if self.hasLeftChild():\n                for elem in self.leftChild:\n                    yield elem\n            yield self.key\n            if self.hasRightChild():\n                for elem in self.rightChild:\n                    yield elem\n\n            \n", "src/lib/time/__init__.js": "\n/*\n\tBarebones implementation of the Python time package.\n\n\tFor now, only the time() function is implemented.\n*/\n \nvar $builtinmodule = function(name)\n{\n    var mod = {};\n\n    mod.time = new Sk.builtin.func(function() {\n\t  return Sk.builtin.assk$(new Date().getTime() / 1000, undefined);\n    });\n\n    return mod;\n}\n", "src/lib/operator/__init__.js": "/*\n *  __author__: Isaac Dontje Lindell (i@isaacdontjelindell.com)\n *\n *  Implementation of the Python operator module.\n */\n\nvar $builtinmodule = function(name) {\n    var mod = {};\n\n    mod.lt = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'Lt')); });\n    mod.__lt__ = mod.lt;\n\n    mod.le = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'LtE')); });\n    mod.__le__ = mod.le;\n\n    mod.eq = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'Eq')); });\n    mod.__eq__ = mod.eq;\n\n    mod.ne = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'NotEq')); });\n    mod.__ne__ = mod.ne;\n\n    mod.ge = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'GtE')); });\n    mod.__ge__ = mod.ge;\n\n    mod.gt = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'Gt')); });\n    mod.__gt__ = mod.gt;\n\n    mod.not_ = new Sk.builtin.func(function (obj) { throw new Sk.builtin.NotImplementedError(\"operator.not_() is not yet implemented in Skulpt\"); });\n\n    mod.truth = new Sk.builtin.func(function(obj) { return Sk.builtin.bool(obj); });\n\n    mod.is_ = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'Is')); });\n\n    mod.is_not = new Sk.builtin.func(function(a, b) { return Sk.builtin.bool(Sk.misceval.richCompareBool(a, b, 'IsNot')); });\n\n    mod.abs = new Sk.builtin.func(function(obj) { return Sk.misceval.callsim(Sk.builtin.abs, obj); });\n    mod.__abs__ = mod.abs;\n\n    // The documentation says that operator.add() is defined for a and b numbers, but\n    // CPython (2.6) allows a and b to be other types (e.g. str)\n    mod.add = new Sk.builtin.func(function (a, b) { return Sk.abstr.objectAdd(a, b); });\n    mod.__add__ = mod.add;\n\n    mod.and_ = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$and'].call(a, b); });\n    mod.__and__ = mod.and_;\n\n    mod.div = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$divide'].call(a, b); });\n    mod.__div__ = mod.div;\n\n    mod.floordiv = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$floor_divide'].call(a, b); });\n    mod.__floordiv__ = mod.floordiv;\n\n    // Doesn't look like anything has the __index__ magic function anyway\n    mod.index = new Sk.builtin.func(function (a) { throw new Sk.builtin.NotImplementedError(\"operator.index() is not yet implemented in Skulpt\"); });\n    mod.__index__ = mod.index;\n\n    // Note: Sk.abstr.numberUnaryOp(obj, 'Invert') looks for the function nb$invert() on obj.\n    // However, it doesn't look like that function has been implemented for any existing object types.\n    // I've gone ahead and created this function for completeness' sake, but expect any use of it to\n    // result in an error.\n    mod.inv = new Sk.builtin.func(function (obj) { return Sk.abstr.numberUnaryOp(obj, 'Invert'); });\n    mod.__inv__ = mod.inv;\n    mod.invert = mod.inv;\n    mod.__invert__ = mod.inv;\n\n    mod.lshift = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$lshift'].call(a, b); });\n    mod.__lshift__ = mod.lshift;\n\n    mod.mod = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$remainder'].call(a, b); });\n    mod.__mod__ = mod.mod;\n\n    mod.mul = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$multiply'].call(a, b); });\n    mod.__mul__ = mod.mul;\n\n    mod.neg = new Sk.builtin.func(function (obj) { return Sk.abstr.objectNegative(obj); });\n    mod.__neg__ = mod.neg;\n\n    mod.or_ = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$or'].call(a, b); });\n    mod.__or__ = mod.or_;\n\n    mod.pos = new Sk.builtin.func(function (obj) { return Sk.abstr.objectPositive(obj); });\n    mod.__pos__ = mod.pos;\n\n    mod.pow = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$power'].call(a, b); });\n    mod.__pow__ = mod.pow;\n\n    mod.rshift = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$rshift'].call(a, b); });\n    mod.__rshift__ = mod.rshift;\n\n    mod.sub = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$subtract'].call(a, b); });\n    mod.__sub__ = mod.sub;\n\n    mod.truediv = mod.div;\n    mod.__truediv__ = mod.div;\n\n    mod.xor = new Sk.builtin.func(function (a, b) { return Sk.builtin.nmber.prototype['nb$xor'].call(a, b); });\n    mod.__xor__ = mod.xor;\n\n    mod.concat = new Sk.builtin.func(function (a, b) { return Sk.abstr.sequenceConcat(a, b); });\n    mod.__concat__ = mod.concat;\n\n    mod.contains = new Sk.builtin.func(function (a, b) { return Sk.builtin.bool(Sk.abstr.sequenceContains(a, b)); });\n    mod.__contains__ = mod.contains;\n\n    mod.countOf = new Sk.builtin.func(function (a, b) { return Sk.abstr.sequenceGetCountOf(a, b); });\n\n    mod.delitem = new Sk.builtin.func(function (a, b) { return Sk.abstr.sequenceDelItem(a, b); });\n    mod.__delitem__ = mod.delitem;\n\n    mod.getitem = new Sk.builtin.func(function (a, b) { return Sk.abstr.sequenceGetItem(a, b); });\n    mod.__getitem__ = mod.getitem;\n\n    mod.indexOf = new Sk.builtin.func(function (a, b) { return Sk.abstr.sequenceGetIndexOf(a, b); });\n\n    mod.setitem = new Sk.builtin.func(function (a, b, c) { return Sk.abstr.sequenceSetItem(a, b, c); });\n    mod.__setitem__ = mod.setitem;\n\n    return mod;\n};\n", "src/lib/image/__init__.js": "var ImageMod; // the single identifier needed in the global scope\n\nif (! ImageMod) {\n    ImageMod = { };\n    ImageMod.canvasLib = [];\n}\n\n//  todo create an empty image by reading image data from a blank canvas of the appropriate size\n\nvar $builtinmodule = function(name) {\n    var mod = {};\n\n    var image = function($gbl, $loc) {\n        $loc.__init__ = new Sk.builtin.func(function(self,imageId) {\n            self.image = document.getElementById(imageId.v);\n            if (self.image == null) {\n                throw \"There is no image on this page named: \" + imageId.v;\n            }\n            self.width = self.image.width;\n            self.height = self.image.height;\n            self.canvas = document.createElement(\"canvas\");\n            self.canvas.height = self.height;\n            self.canvas.width = self.width;\n            self.ctx = self.canvas.getContext(\"2d\");\n            self.ctx.drawImage(self.image,0,0)\n            self.imagedata = self.ctx.getImageData(0,0,self.width,self.height);\n        });\n\n        $loc.getPixel = new Sk.builtin.func(function(self,x,y) {\n\t\t\tx = Sk.builtin.asnum$(x);\n\t\t\ty = Sk.builtin.asnum$(y);\n            var index = (y*4)*self.width+(x*4);\n            var red = self.imagedata.data[index]\n            var green = self.imagedata.data[index+1]\n            var blue = self.imagedata.data[index+2]\n            return Sk.misceval.callsim(mod.Pixel,red,green,blue);\n        });\n\n        $loc.setPixel = new Sk.builtin.func(function(self, x, y, pix) {\n\t\t\tx = Sk.builtin.asnum$(x);\n\t\t\ty = Sk.builtin.asnum$(y);\n            var index = (y*4)*self.width+(x*4);\n            self.imagedata.data[index] = Sk.misceval.callsim(pix.getRed,pix);\n            self.imagedata.data[index+1] = Sk.misceval.callsim(pix.getGreen,pix);\n            self.imagedata.data[index+2] = Sk.misceval.callsim(pix.getBlue,pix);\n            self.imagedata.data[index+3] = 255;\n        });\n\n        $loc.getHeight = new Sk.builtin.func(function(self) {\n            return self.image.height;\n        });\n\n        $loc.getWidth = new Sk.builtin.func(function(self,titlestring) {\n            return self.image.width;\n        });\n\n        $loc.draw = new Sk.builtin.func(function(self,win,ulx,uly) {\n\t\t\twin = Sk.builtin.asnum$(win);\n\t\t\tulx = Sk.builtin.asnum$(ulx);\n\t\t\tuly = Sk.builtin.asnum$(uly);\n            var can = Sk.misceval.callsim(win.getWin,win);\n            var ctx = can.getContext(\"2d\");\n            //ctx.putImageData(self.imagedata,0,0,0,0,self.imagedata.width,self.imagedata.height);\n            if (! ulx) {\n                ulx = 0;\n                uly = 0;\n            }\n            ctx.putImageData(self.imagedata,ulx,uly);\n        });\n\n        // toList\n\n    }\n\n    mod.Image = Sk.misceval.buildClass(mod, image, 'Image', []);\n\n    var eImage = function($gbl, $loc) {\n        $loc.__init__ = new Sk.builtin.func(function(self,width,height) {\n            self.width = Sk.builtin.asnum$(width);\n            self.height = Sk.builtin.asnum$(height);\n            self.canvas = document.createElement(\"canvas\");\n            self.ctx = self.canvas.getContext('2d');\n            self.canvas.height = self.height;\n            self.canvas.width = self.width;\n            self.imagedata = self.ctx.getImageData(0,0,self.width,self.height);\n        });\n\n    }\n\n    mod.EmptyImage = Sk.misceval.buildClass(mod, eImage, 'EmptyImage', [mod.Image]);\n\n    // create a ListImage object\n\n    \n    var pixel = function($gbl, $loc) {\n        $loc.__init__ = new Sk.builtin.func(function(self,r,g,b) {\n            self.red = Sk.builtin.asnum$(r);\n            self.green = Sk.builtin.asnum$(g);\n            self.blue = Sk.builtin.asnum$(b);\n        });\n\n        $loc.getRed = new Sk.builtin.func(function(self) {\n           return self.red;\n        });\n\n        $loc.getGreen = new Sk.builtin.func(function(self) {\n           return self.green;\n        });\n\n        $loc.getBlue = new Sk.builtin.func(function(self) {\n           return self.blue;\n        });\n\n        $loc.setRed = new Sk.builtin.func(function(self,r) {\n           self.red = Sk.builtin.asnum$(r);\n        });\n\n        $loc.setGreen = new Sk.builtin.func(function(self,g) {\n           self.green = Sk.builtin.asnum$(g);\n        });\n\n        $loc.setBlue = new Sk.builtin.func(function(self,b) {\n           self.blue = Sk.builtin.asnum$(b);\n        });\n\n        $loc.__getitem__ = new Sk.builtin.func(function(self,k) {\n\t\t   k = Sk.builtin.asnum$(k);\n           if(k == 0) {\n               return self.red;\n           } else if (k == 1) {\n               return self.green;\n           } else if (k == 2) {\n               return self.blue;\n           }\n        });\n\n        $loc.__str__ = new Sk.builtin.func(function(self) {\n            return \"[\" + self.red + \",\" + self.green + \",\" + self.blue + \"]\"\n        });\n        \n        //getColorTuple\n        $loc.getColorTuple = new Sk.builtin.func(function(self,x,y) {\n\n        });\n\n        //setRange -- change from 0..255 to 0.0 .. 1.0\n        $loc.setRange = new Sk.builtin.func(function(self,mx) {\n            self.max = Sk.builtin.asnum$(mx);\n        });\n\n    }\n    mod.Pixel = Sk.misceval.buildClass(mod, pixel, 'Pixel', []);\n\n\n\n    var screen = function($gbl, $loc) {\n        $loc.__init__ = new Sk.builtin.func(function(self,width,height) {\n            var currentCanvas = ImageMod.canvasLib[Sk.canvas];\n            if (currentCanvas === undefined) {\n                self.theScreen = document.getElementById(Sk.canvas);\n                if (width !== undefined) {\n                    self.theScreen.height = height;\n                    self.theScreen.width = width;\n                }\n\n                ImageMod.canvasLib[Sk.canvas] = self.theScreen;\n            } else {\n                self.theScreen = currentCanvas;\n                self.theScreen.height = self.theScreen.height;\n            }\n            self.theScreen.style.display = \"block\";\n        });\n\n        $loc.getWin = new Sk.builtin.func(function(self) {\n           return self.theScreen;\n        });\n\n        // exitonclick\n        $loc.exitonclick = new Sk.builtin.func(function(self) {\n            var canvas_id = self.theScreen.id;\n            self.theScreen.onclick = function() {\n                document.getElementById(canvas_id).style.display = 'none';\n                document.getElementById(canvas_id).onclick = null;\n                delete ImageMod.canvasLib[canvas_id];\n            }\n\n        });\n        //getMouse\n    }\n\n    mod.ImageWin = Sk.misceval.buildClass(mod, screen, 'ImageWin', []);\n\n    return mod\n}\n", "src/lib/pythonds/basic/__init__.py": "\n#__all__ = [\"stack\"]\n\n\n#from .stack import Stack\n#from .queue import Queue\n\n\n\n", "src/lib/unittest/__init__.py": "__author__ = 'bmiller'\n'''\nThis is the start of something that behaves like\nthe unittest module from cpython.\n\n'''\n\n\nclass TestCase:\n    def __init__(self):\n        self.numPassed = 0\n        self.numFailed = 0\n\n        self.tlist = []\n        testNames = {}\n        for name in dir(self):\n            if name[:4] == 'test' and name not in testNames:\n                self.tlist.append(getattr(self,name))\n                testNames[name]=True\n\n    def setup(self):\n        pass\n\n    def tearDown(self):\n        pass\n\n    def main(self):\n\n        for func in self.tlist:\n            try:\n                self.setup()\n                func()\n                self.tearDown()\n            except:\n                self.appendResult('Error',None,None,None)\n                self.numFailed += 1\n        self.showSummary()\n\n    def assertEqual(self, actual, expected, feedback=\"\"):\n        res = actual==expected\n        self.appendResult(res,str(actual)+' to be equal to ',expected, feedback)\n\n    def assertNotEqual(actual, expected, feedback=\"\"):\n        res = actual != expected\n        self.appendResult(res,str(actual)+' to not equal ',expected,feedback)\n\n    def assertTrue(self,x, feedback=\"\"):\n        res = x\n        self.appendResult(res,str(x)+' to be ',True,feedback)\n\n    def assertFalse(self,x, feedback=\"\"):\n        res = not x\n        self.appendResult(res,str(x)+' to be ',False,feedback)\n\n    def assertIs(self,a,b, feedback=\"\"):\n        res = a is b\n        self.appendResult(res,str(a)+' to be the same object as ',b,feedback)\n\n    def assertIsNot(self,a,b, feedback=\"\"):\n        res = a is not b\n        self.appendResult(res,str(a)+' to not be the same object as ',b,feedback)\n\n    def assertIsNone(self,x, feedback=\"\"):\n        res = x is None\n        self.appendResult(res,x,None,feedback)\n\n    def assertIsNotNone(self,x, feedback=\"\"):\n        res = x is not None\n        self.appendResult(res,str(x)+' to not be ',None,feedback)\n\n    def assertIn(self,a,b, feedback=\"\"):\n        res = a in b\n        self.appendResult(res,str(a)+' to be in ',b,feedback)\n\n    def assertNotIn(self,a,b, feedback=\"\"):\n        res = a not in b\n        self.appendResult(res,str(a)+' to not be in ',b,feedback)\n\n    def assertIsInstance(self,a,b, feedback=\"\"):\n        res = isinstance(a,b)\n        self.appendResult(res,str(a)+' to be an instance of ',b,feedback)\n\n    def assertNotIsInstance(self,a,b, feedback=\"\"):\n        res = not isinstance(a,b)\n        self.appendResult(res,str(a)+' to not be an instance of ',b,feedback)\n\n    def assertAlmostEqual(self,a,b, feedback=\"\"):\n        res = round(a-b,7) == 0\n        self.appendResult(res,str(a)+' to equal ',b,feedback)\n\n    def assertNotAlmostEqual(self,a,b, feedback=\"\"):\n        res = round(a-b,7) != 0\n        self.appendResult(res,str(a)+' to not equal ',b,feedback)\n\n    def assertGreater(self,a,b, feedback=\"\"):\n        res = a > b\n        self.appendResult(res,str(a)+' to be greater than ',b,feedback)\n\n    def assertGreaterEqual(self,a,b, feedback=\"\"):\n        res = a >= b\n        self.appendResult(res,str(a)+' to be greater than or equal to ',b,feedback)\n\n    def assertLess(self,a,b, feedback=\"\"):\n        res = a < b\n        self.appendResult(res,str(a)+' to be less than ',b,feedback)\n\n    def assertLessEqual(self,a,b, feedback=\"\"):\n        res = a <= b\n        self.appendResult(res,str(a)+' to be less than or equal to ',b,feedback)\n\n    def appendResult(self,res,actual,expected,feedback):\n        if res == 'Error':\n            msg = 'Error'\n        elif res:\n            msg = 'Pass'\n            self.numPassed += 1\n        else:\n            msg = 'Fail: expected %s  %s ' % (str(actual),str(expected)) + feedback\n            self.numFailed += 1\n\n    def showSummary(self):\n        pct = self.numPassed / (self.numPassed+self.numFailed) * 100\n        print \"ran %d tests, passed %d \\n\" % (self.numPassed+self.numFailed, self.numPassed)\n\n\n\ndef main():\n    glob = globals()  # globals() still needs work\n    for name in glob:\n        if issubclass(glob[name],TestCase):\n            glob[name]().main()  \n\n", "src/lib/test/__init__.py": "__author__ = 'bmiller'\n\ndef testEqual(actual, expected):\n    if type(expected) == type(1):\n        if actual == expected:\n            print('Pass')\n            return True\n    elif type(expected) == type(1.11):\n        if abs(actual-expected) < 0.00001:\n            print('Pass')\n            return True\n    else:\n        if actual == expected:\n            print('Pass')\n            return True\n    print('Test Failed: expected ' + str(expected) + ' but got ' + str(actual))\n    return False\n\ndef testNotEqual(actual, expected):\n    pass\n\n", "src/lib/string/__init__.js": "/*\n *  __author__: Isaac Dontje Lindell (i@isaacdontjelindell.com)\n *\n *  Implementation of the Python string module.\n */\n\n\nvar $builtinmodule = function(name) {\n    var mod = {};\n\n    mod.ascii_lowercase = Sk.builtin.str('abcdefghijklmnopqrstuvwxyz');\n    mod.ascii_uppercase = Sk.builtin.str('ABCDEFGHIJKLMNOPQRSTUVWXYZ');\n    mod.ascii_letters = Sk.builtin.str(mod.ascii_lowercase.v + mod.ascii_uppercase.v);\n\n    mod.lowercase = Sk.builtin.str('abcdefghijklmnopqrstuvwxyz');\n    mod.uppercase = Sk.builtin.str('ABCDEFGHIJKLMNOPQRSTUVWXYZ');\n    mod.letters = Sk.builtin.str(mod.lowercase.v + mod.uppercase.v);\n\n    mod.digits = Sk.builtin.str('0123456789', Sk.builtin.str);\n    mod.hexdigits = Sk.builtin.str('0123456789abcdefABCDEF');\n    mod.octdigits = Sk.builtin.str('01234567');\n\n    mod.punctuation = Sk.builtin.str('!\"#$%&\\'()*+,-./:;<=>?@[\\\\]^_`{|}~');\n    mod.whitespace = Sk.builtin.str('\\t\\n\\x0b\\x0c\\r ');\n\n    /* Note: The docs for string.printable say that it's the concatenation of string.digits,\n     * string.letters, string.punctuation, and string.whitespace. The CPython interpreter\n     * outputs the whitespace characters in one order when string.whitespace is used, and a\n     * slightly different order when string.printable is used. I've elected to follow the\n     * behavior of CPython here rather than the spec. */\n    mod.printable = Sk.builtin.str(mod.digits.v + mod.letters.v + mod.punctuation.v + \" \\t\\n\\r\\x0b\\x0c\");\n\n\n    mod.split = new Sk.builtin.func(function(s, sep, maxsplit) {\n        return Sk.misceval.callsim(Sk.builtin.str.prototype['split'], s, sep, maxsplit);\n    });\n\n    /* Return a copy of word with only its first character capitalized. */\n    mod.capitalize = new Sk.builtin.func(function(word) {\n        return Sk.misceval.callsim(Sk.builtin.str.prototype['capitalize'], word);\n    });\n\n    /* Concatenate a list or tuple of words with intervening occurrences\n     * of sep. The default value for sep is a single space character. */\n    mod.join = new Sk.builtin.func(function(words, sep) {\n        if (sep === undefined) {\n            sep = Sk.builtin.str(' ');\n        }\n        return Sk.misceval.callsim(Sk.builtin.str.prototype['join'], sep, words);\n    });\n\n\n    /* Split the argument into words using split(), capitalize each word\n     * using capitalize(), and join the capitalized words using join().\n     * Note that this replaces runs of whitespace characters by a single\n     * space, and removes leading and trailing whitespace. */\n    mod.capwords = new Sk.builtin.func(function(s, sep) {\n        Sk.builtin.pyCheckArgs('capwords', arguments, 1, 2);\n        if (!Sk.builtin.checkString(s)) {\n            throw new Sk.builtin.TypeError(\"s must be a string\");\n        }\n        if (sep === undefined) {\n            sep = Sk.builtin.str(' ');\n        }\n        if(!Sk.builtin.checkString(sep)) {\n            throw new Sk.builtin.TypeError(\"sep must be a string\");\n        }\n\n        var words = Sk.misceval.callsim(mod.split, s, sep);\n        var capWords = [];\n        for (var i=0; i<words.v.length; i++) {\n            var word = Sk.builtin.list.prototype['list_subscript_'].call(words, i);\n            var cap = Sk.misceval.callsim(mod.capitalize, word);\n            capWords.push(cap);\n        }\n\n        return Sk.misceval.callsim(mod.join, Sk.builtin.list(capWords), sep);\n    });\n\n\n    return mod;\n};", "src/builtin/sys.js": "var $builtinmodule = function(name)\n{\n    var sys = {};\n\n    var args = [];\n    var argv = Sk.getSysArgv();\n    for (var i = 0; i < argv.length; ++i)\n        args.push(new Sk.builtin.str(argv[i]));\n    sys.argv = new Sk.builtins['list'](args);\n\n    sys.copyright = Sk.builtin['str'](\"Copyright 2009-2010 Scott Graham.\\nAll Rights Reserved.\\n\");\n\n    sys.modules = Sk.sysmodules;\n\n    sys.path = Sk.realsyspath;\n\n    sys.getExecutionLimit = new Sk.builtin.func(function() {\n        return Sk.builtin.assk$(Sk.execLimit, Sk.builtin.nmber.int$);\n    });\n\n    sys.setExecutionLimit = new Sk.builtin.func(function(t) {\n        if (t !==  undefined) {\n            Sk.execLimit = Sk.builtin.asnum$(t);\n        }\n    });\n\n    sys.resetTimeout = new Sk.builtin.func(function() {\n        Sk.execStart = new Date();\n    });\n\n    sys.debug = new Sk.builtin.func(function() {\n        debugger;\n    });\n\n    return sys;\n};\n", "src/lib/pythonds/trees/balance.py": "#!/bin/env python3.1\n# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005, 2010\n# \n\nfrom .bst import BinarySearchTree, TreeNode\n\nclass AVLTree(BinarySearchTree):\n    '''\n    Author:  Brad Miller\n    Date:  1/15/2005\n    Description:  Imlement a binary search tree with the following interface\n                  functions:  \n                  __contains__(y) <==> y in x\n                  __getitem__(y) <==> x[y]\n                  __init__()\n                  __len__() <==> len(x)\n                  __setitem__(k,v) <==> x[k] = v\n                  clear()\n                  get(k)\n                  has_key(k)\n                  items() \n                  keys() \n                  values()\n                  put(k,v)\n    '''\n\n\n    def _put(self,key,val,currentNode):\n        if key < currentNode.key:\n            if currentNode.hasLeftChild():\n                self._put(key,val,currentNode.leftChild)\n            else:\n                currentNode.leftChild = TreeNode(key,val,parent=currentNode)\n                self.updateBalance(currentNode.leftChild)\n        else:\n            if currentNode.hasRightChild():\n                self._put(key,val,currentNode.rightChild)\n            else:\n                currentNode.rightChild = TreeNode(key,val,parent=currentNode)\n                self.updateBalance(currentNode.rightChild)                \n\n    def updateBalance(self,node):\n        if node.balanceFactor > 1 or node.balanceFactor < -1:\n            self.rebalance(node)\n            return\n        if node.parent != None:\n            if node.isLeftChild():\n                node.parent.balanceFactor += 1\n            elif node.isRightChild():\n                node.parent.balanceFactor -= 1\n\n            if node.parent.balanceFactor != 0:\n                self.updateBalance(node.parent)\n\n    def rebalance(self,node):\n        if node.balanceFactor < 0:\n            if node.rightChild.balanceFactor > 0:\n                # Do an LR Rotation\n                self.rotateRight(node.rightChild)\n                self.rotateLeft(node)\n            else:\n                # single left\n                self.rotateLeft(node)\n        elif node.balanceFactor > 0:\n            if node.leftChild.balanceFactor < 0:\n                # Do an RL Rotation\n                self.rotateLeft(node.leftChild)\n                self.rotateRight(node)\n            else:\n                # single right\n                self.rotateRight(node)\n\n    def rotateLeft(self,rotRoot):\n        newRoot = rotRoot.rightChild\n        rotRoot.rightChild = newRoot.leftChild\n        if newRoot.leftChild != None:\n            newRoot.leftChild.parent = rotRoot\n        newRoot.parent = rotRoot.parent\n        if rotRoot.isRoot():\n            self.root = newRoot\n        else:\n            if rotRoot.isLeftChild():\n                rotRoot.parent.leftChild = newRoot\n            else:\n                rotRoot.parent.rightChild = newRoot\n        newRoot.leftChild = rotRoot\n        rotRoot.parent = newRoot\n        rotRoot.balanceFactor = rotRoot.balanceFactor + 1 - min(newRoot.balanceFactor, 0)\n        newRoot.balanceFactor = newRoot.balanceFactor + 1 + max(rotRoot.balanceFactor, 0)\n\n\n    def rotateRight(self,rotRoot):\n        newRoot = rotRoot.leftChild\n        rotRoot.leftChild = newRoot.rightChild\n        if newRoot.rightChild != None:\n            newRoot.rightChild.parent = rotRoot\n        newRoot.parent = rotRoot.parent\n        if rotRoot.isRoot():\n            self.root = newRoot\n        else:\n            if rotRoot.isRightChild():\n                rotRoot.parent.rightChild = newRoot\n            else:\n                rotRoot.parent.leftChild = newRoot\n        newRoot.rightChild = rotRoot\n        rotRoot.parent = newRoot\n        rotRoot.balanceFactor = rotRoot.balanceFactor - 1 - max(newRoot.balanceFactor, 0)\n        newRoot.balanceFactor = newRoot.balanceFactor - 1 + min(rotRoot.balanceFactor, 0)\n        \n", "src/lib/urllib/request/__init__.js": "var $builtinmodule = function(name)\n{\n  var request = {};\n\n\n  //~ Classes .................................................................\n\n  // Response class\n  //\n  // Response objects are returned by the request, get, post, etc.\n  // methods, allowing the user to access the response text, status\n  // code, and other information.\n\n  // ------------------------------------------------------------\n  var response = function($gbl, $loc) {\n\n    // ------------------------------------------------------------\n    $loc.__init__ = new Sk.builtin.func(function(self, xhr) {\n      self.data$ = xhr.responseText;\n      self.lineList = self.data$.split(\"\\n\");\n      self.lineList = self.lineList.slice(0,-1);\n      for(var i =0 ; i < self.lineList.length; i++) {\n        self.lineList[i] = self.lineList[i]+'\\n';\n      }\n      self.currentLine = 0;\n      self.pos$ = 0;\n    });\n\n\n    // ------------------------------------------------------------\n    $loc.__str__ = new Sk.builtin.func(function(self) {\n      return Sk.ffi.remapToPy('<Response>');\n    });\n\n\n    // ------------------------------------------------------------\n    $loc.__iter__ = new Sk.builtin.func(function(self) {\n      var allLines = self.lineList;\n\n      return Sk.builtin.makeGenerator(function() {\n          if (this.$index >= this.$lines.length) return undefined;\n          return new Sk.builtin.str(this.$lines[this.$index++]);\n        }, {\n          $obj: self,\n          $index: 0,\n          $lines: allLines\n        });\n    });\n\n\n    // ------------------------------------------------------------\n    $loc.read = new Sk.builtin.func(function(self, size) {\n      if (self.closed) throw new Sk.builtin.ValueError(\"I/O operation on closed file\");\n      var len = self.data$.length;\n      if (size === undefined) size = len;\n      var ret = new Sk.builtin.str(self.data$.substr(self.pos$, size));\n      self.pos$ += size;\n      if (self.pos$ >= len) self.pos$ = len;\n      return ret;\n    });\n\n\n    // ------------------------------------------------------------\n    $loc.readline = new Sk.builtin.func(function(self, size) {\n      var line = \"\";\n      if (self.currentLine < self.lineList.length) {\n        line = self.lineList[self.currentLine];\n        self.currentLine++;\n      }\n      return new Sk.builtin.str(line);\n    });\n\n\n    // ------------------------------------------------------------\n    $loc.readlines = new Sk.builtin.func(function(self, sizehint) {\n      var arr = [];\n      for(var i = self.currentLine; i < self.lineList.length; i++) {\n        arr.push(new Sk.builtin.str(self.lineList[i]));\n      }\n      return new Sk.builtin.list(arr);\n    });\n\n  };\n\n  request.Response =\n    Sk.misceval.buildClass(request, response, 'Response', []);\n\n\n  //~ Module functions ........................................................\n\n  // ------------------------------------------------------------\n  /**\n   * Constructs and sends a Request. Returns Response object.\n   *\n   * http://docs.python-requests.org/en/latest/api/#requests.request\n   *\n   * For now, this implementation doesn't actually construct a Request\n   * object; it just makes the request through jQuery.ajax and then\n   * constructs a Response.\n   */\n  request.urlopen = new Sk.builtin.func(function(url, data, timeout) {\n    var xmlhttp = new XMLHttpRequest();\n    xmlhttp.open(\"GET\",url.v,false);\n    xmlhttp.send(null);\n\n    return Sk.misceval.callsim(request.Response,xmlhttp)\n  });\n\n\n  return request;\n};\n", "src/lib/pythonds/basic/queue.py": "# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005\n# \n#queue.py\n\nclass Queue:\n    def __init__(self):\n        self.items = []\n\n    def isEmpty(self):\n        return self.items == []\n\n    def enqueue(self, item):\n        self.items.insert(0,item)\n\n    def dequeue(self):\n        return self.items.pop()\n\n    def size(self):\n        return len(self.items)\n", "src/lib/pythonds/graphs/adjGraph.py": "#\n#  adjGraph\n#\n#  Created by Brad Miller on 2005-02-24.\n#  Copyright (c) 2005 Brad Miller, David Ranum, Luther College. All rights reserved.\n#\n\nimport sys\nimport os\nimport unittest\n\nclass Graph:\n    def __init__(self):\n        self.vertices = {}\n        self.numVertices = 0\n        \n    def addVertex(self,key):\n        self.numVertices = self.numVertices + 1\n        newVertex = Vertex(key)\n        self.vertices[key] = newVertex\n        return newVertex\n    \n    def getVertex(self,n):\n        if n in self.vertices:\n            return self.vertices[n]\n        else:\n            return None\n\n    def __contains__(self,n):\n        return n in self.vertices\n    \n    def addEdge(self,f,t,cost=0):\n            if f not in self.vertices:\n                nv = self.addVertex(f)\n            if t not in self.vertices:\n                nv = self.addVertex(t)\n            self.vertices[f].addNeighbor(self.vertices[t],cost)\n    \n    def getVertices(self):\n        return list(self.vertices.keys())\n        \n    def __iter__(self):\n        return iter(self.vertices.values())\n                \nclass Vertex:\n    def __init__(self,num):\n        self.id = num\n        self.connectedTo = {}\n        self.color = 'white'\n        self.dist = sys.maxsize\n        self.pred = None\n        self.disc = 0\n        self.fin = 0\n\n    # def __lt__(self,o):\n    #     return self.id < o.id\n    \n    def addNeighbor(self,nbr,weight=0):\n        self.connectedTo[nbr] = weight\n        \n    def setColor(self,color):\n        self.color = color\n        \n    def setDistance(self,d):\n        self.dist = d\n\n    def setPred(self,p):\n        self.pred = p\n\n    def setDiscovery(self,dtime):\n        self.disc = dtime\n        \n    def setFinish(self,ftime):\n        self.fin = ftime\n        \n    def getFinish(self):\n        return self.fin\n        \n    def getDiscovery(self):\n        return self.disc\n        \n    def getPred(self):\n        return self.pred\n        \n    def getDistance(self):\n        return self.dist\n        \n    def getColor(self):\n        return self.color\n    \n    def getConnections(self):\n        return self.connectedTo.keys()\n        \n    def getWeight(self,nbr):\n        return self.connectedTo[nbr]\n                \n    def __str__(self):\n        return str(self.id) + \":color \" + self.color + \":disc \" + str(self.disc) + \":fin \" + str(self.fin) + \":dist \" + str(self.dist) + \":pred \\n\\t[\" + str(self.pred)+ \"]\\n\"\n    \n    def getId(self):\n        return self.id\n\nclass adjGraphTests(unittest.TestCase):\n    def setUp(self):\n        self.tGraph = Graph()\n        \n    def testMakeGraph(self):\n        gFile = open(\"test.dat\")\n        for line in gFile:\n            fVertex, tVertex = line.split('|')\n            fVertex = int(fVertex)\n            tVertex = int(tVertex)\n            self.tGraph.addEdge(fVertex,tVertex)\n        for i in self.tGraph:\n            adj = i.getAdj()\n            for k in adj:\n                print(i, k)\n\n        \nif __name__ == '__main__':\n    unittest.main()\n              \n", "src/lib/turtle/__init__.js": "//\n//\n// Turtle Graphics Module for Skulpt\n//\n// Brad Miller\n//\n//\n//\nvar TurtleGraphics;\n// the single identifier needed in the global scope\nif (!TurtleGraphics) {\n    TurtleGraphics = {\n        doneDelegates: [],\n        fadeOnExit: true,\n\t\tdefaults: {\n\t\t\tcanvasID: 'mycanvas',\n\t\t\tdegrees: true,\n\t\t\tanimate: true\n\t\t}\n    };\n}\n(function () {\n    'use strict';\n    // Define private constants\n    var Degree2Rad = Math.PI / 180,\n        // conversion factor for degrees to radians\n        Rad2Degree = 180 / Math.PI,\n        render,\n        allDone,\n        segmentLine,\n        clear_canvas;\n\n    // Create a 3d Vector class for manipulating turtle heading, and position.\n    function Vector(x, y, z) {\n        var i;\n        if ((typeof x).toLowerCase() === 'number') {\n            Array.prototype.push.call(this, x);\n            Array.prototype.push.call(this, y);\n            Array.prototype.push.call(this, z);\n        } else {\n            for (i = 0; i < x.length; i = i + 1) {\n                Array.prototype.push.call(this, x[i]);\n            }\n        }\n    }\n    // Create a vector object given a direction as an angle.\n    Vector.angle2vec = function (phi) {\n        var res = new Vector([0, 0, 0]);\n        phi = phi * Degree2Rad;\n        res[0] = Math.cos(phi);\n        res[1] = Math.sin(phi);\n        return res.normalize();\n    };\n    // This trick allows you to access a Vector object like an array\n    // myVec[0] == x\n    // myVec[1] == y\n    // myVec[2] == z\n    // we really only need the z for the convenience of rotating\n    Vector.prototype.addItem = function (item) {\n        Array.prototype.push.call(this, item);\n    };\n    Vector.prototype.linear = function (a, b, v) {\n        if (this.length !== 3 || v.length !== 3) {\n            return;\n        }\n        return new Vector([a * this[0] + b * v[0],\n                           a * this[1] + b * v[1],\n                           a * this[2] + b * v[2]]);\n\n\n    };\n    Vector.prototype.cross = function (v) {\n        if (this.length !== 3 || v.length !== 3) {\n            return;\n        }\n\n        return new Vector([this[1] * v[2] - this[2] * v[1],\n                    this[2] * v[0] - this[0] * v[2],\n                    this[0] * v[1] - this[1] * v[0]]);\n    };\n    Vector.prototype.rotate = function (angle) {\n        // Rotate this counter clockwise by angle.\n        var perp = new Vector(-this[1], this[0], 0),\n            c,\n            s;\n        angle = angle * Degree2Rad;\n        c = Math.cos(angle);\n        s = Math.sin(angle);\n        return new Vector(this[0] * c + perp[0] * s, this[1] * c + perp[1] * s, 0);\n    };\n    Vector.prototype.rotateNormal = function (v, alpha) {\n        // Return rotation of this in direction of v about w over alpha\n        // Requires: v, w are vectors; alpha is angle in radians\n        //   this, v, w are orthonormal\n        return this.linear(Math.cos(alpha), Math.sin(alpha), v);\n    };\n    Vector.prototype.normalize = function () {\n        var n = this.len(),\n            res = this.div(n);\n        return res;\n    };\n    Vector.prototype.toAngle = function () {\n        // workaround for values getting set to +/i xxx e -16 fooling the +/- checks below\n        if (Math.abs(this[1]) < 0.00001) {\n            this[1] = 0;\n        }\n        if (Math.abs(this[0]) < 0.00001) {\n            this[0] = 0;\n        }\n        var rads = Math.atan(Math.abs(this[1]) / Math.abs(this[0])),\n            deg = rads * Rad2Degree;\n        if (this[0] < 0 && this[1] > 0) {\n            deg = 180 - deg;\n        } else if (this[0] < 0 && this[1] <= 0) {\n            deg = 180 + deg;\n        } else if (this[0] >= 0 && this[1] < 0) {\n            deg = 360 - deg;\n        }\n        return deg;\n    };\n    // divide all vector components by the same value\n    Vector.prototype.div = function (n) {\n        var res = [];\n        res[0] = this[0] / n;\n        res[1] = this[1] / n;\n        res[2] = this[2] / n;\n        return new Vector(res);\n    };\n    // subtract one vector from another\n    Vector.prototype.sub = function (v) {\n        var res = new Vector(0, 0, 0);\n        res[0] = this[0] - v[0];\n        res[1] = this[1] - v[1];\n        res[2] = this[2] - v[2];\n        return res;\n    };\n    Vector.prototype.add = function (v) {\n        var res = new Vector(0, 0, 0);\n        res[0] = this[0] + v[0];\n        res[1] = this[1] + v[1];\n        res[2] = this[2] + v[2];\n        return res;\n    };\n    Vector.prototype.smul = function (k) {\n        // scalar multiplication\n        var res = new Vector(0, 0, 0);\n        res[0] = this[0] * k;\n        res[1] = this[1] * k;\n        res[2] = this[2] * k;\n        return res;\n    };\n    Vector.prototype.scale = function (xs, ys) {\n        var res = new Vector(0, 0, 0);\n        res[0] = this[0] * ys;\n        res[1] = this[1] * xs;\n        res[2] = 1;\n        return res;\n    };\n    Vector.prototype.len = function () {\n        return Math.sqrt(this[0] * this[0] + this[1] * this[1] + this[2] * this[2]);\n    };\n\n    allDone = function () {\n        var done = true, tix, theT;\n        for (tix = 0; tix < TurtleGraphics.turtleList.length; tix = tix + 1) {\n            theT = TurtleGraphics.turtleList[tix];\n            done = done && theT.aCount >= theT.drawingEvents.length;\n        }\n        return done;\n    };\n    //\n    //  This is the function that provides the animation\n    //\n    render = function () {\n        var context = document.getElementById(TurtleGraphics.defaults.canvasID).getContext('2d'),\n            canvasLib = TurtleGraphics.canvasLib[TurtleGraphics.defaults.canvasID],\n            incr = TurtleGraphics.canvasLib[TurtleGraphics.defaults.canvasID].getCounter(),\n            t,\n            tix,\n            i,\n\t\t\tcurrentPos,\n            currentHead,\n            filling,\n            oper,\n            ts,\n            tmpColor,\n            size,\n            speed;\n\n\t\tcontext.moveTo(0, 0);\n\t\tcontext.lineCap = 'round';\n\t\tcontext.lineJoin = 'round';\n        context.clearRect(canvasLib.llx, canvasLib.lly, canvasLib.urx - canvasLib.llx, canvasLib.ury - canvasLib.lly); //canvas.style.setProperty(\"background-color\",TurtleGraphics.turtleCanvas.bgcolor.v);\n        TurtleGraphics.renderClock += incr;\n        for (tix = 0; tix < TurtleGraphics.turtleList.length; tix = tix + 1) {\n            currentPos = new Vector(0, 0, 0);\n            currentHead = new Vector(1, 0, 0);\n            context.fillStyle = 'black';\n            context.strokeStyle = 'black';\n            t = TurtleGraphics.turtleList[tix];\n\t\t\tcurrentHead = t.heading;\n            context.lastCanvas = t.turtleCanvas;\n            if (t.aCount >= t.drawingEvents.length) {\n                t.aCount = t.drawingEvents.length - 1;\n            }\n\n\t\t\tcontext.lineWidth = t.get_pen_width();\n\n            filling = false;\n            if (isNaN(t.turtleCanvas.delay)) {\n                t.turtleCanvas.delay = 0;\n            }\n            //console.log(tix + \" : \" + t.clearPoint + \" to \" + t.aCount)\n            for (i = t.clearPoint; (i <= t.aCount || t.turtleCanvas.delay === 0) && i < t.drawingEvents.length; i = i + 1) {\n                if (i > t.aCount) {\n                    //If se jump past aCount, jump it ahead\n                    t.aCount = i;\n                }\n                oper = t.drawingEvents[i];\n                ts = oper[oper.length - 1];\n                //console.log(i + \"/\" + ts + oper [0] + \"{\" + oper [1] + \"}\" + t.turtleCanvas.delay)\n                if (ts <= TurtleGraphics.renderClock || t.turtleCanvas.delay === 0) {\n                    if (ts > TurtleGraphics.renderClock) {\n                        //If we go past the render clock, jump it ahead\n                        TurtleGraphics.renderClock = ts;\n                    }\n                    //console.log(\"<==\")\n                    switch (oper[0]) {\n                    case 'LT': //line To\n                        if (!filling) {\n                            context.beginPath();\n                            context.moveTo(oper[1], oper[2]);\n                        }\n                        context.lineTo(oper[3], oper[4]);\n                        context.strokeStyle = oper[5];\n                        context.stroke();\n                        currentPos = new Vector(oper[3], oper[4], 0);\n                        if (!filling) {\n                            context.closePath();\n                        }\n                        break;\n                    case 'MT': //move to\n                        context.moveTo(oper[3], oper[4]);\n                        currentPos = new Vector(oper[3], oper[4], 0);\n                        break;\n                    case 'BF': //begin fill\n                        context.beginPath();\n                        context.moveTo(oper[1], oper[2]);\n                        filling = true;\n                        break;\n                    case 'EF': //end fill\n                        context.fillStyle = oper[3];\n                        context.stroke();\n                        context.fill();\n                        context.closePath();\n                        filling = false;\n                        break;\n                    case 'FC': // fill color\n\t\t\t\t\t\tcontext.fillStyle = oper[1];\n                        break;\n                    case 'TC': // turtle color\n                        context.strokeStyle = oper[1];\n                        break;\n                    case 'PW': // Pen width\n                        context.lineWidth = oper[1];\n                        break;\n                    case 'DT': // Dot\n                        tmpColor = context.fillStyle;\n                        context.fillStyle = oper[2];\n                        size = oper[1];\n                        context.fillRect(oper[3] - size / 2, oper[4] - size / 2, size, size);\n                        context.fillStyle = tmpColor;\n                        break;\n                    case 'CI': // Circle\n                        if (!filling) {\n                            context.beginPath();\n                        }\n                        context.arc(oper[1], oper[2], oper[3], oper[4], oper[5], oper[6]);\n                        currentPos = new Vector(oper[1] + Math.cos(oper[5]) * oper[3], oper[2] + Math.sin(oper[5]) * oper[3], 0);\n                        context.stroke();\n                        if (!filling) {\n                            context.closePath();\n                        }\n                        break;\n                    case 'WT':\n                        // write\n                        if (context.font) {\n                            context.font = oper[2];\n                        }\n                        context.scale(1, -1);\n                        context.fillText(oper[1], oper[3], -oper[4]);\n                        context.scale(1, -1);\n                        break;\n                    case 'ST':\n                        // stamp\n                        t.drawturtle(oper[3], new Vector(oper[1], oper[2], 0));\n                        break;\n                    case 'HT': // hide turtle\n                        t.visible = false;\n                        break;\n                    case 'SH': // show turtle\n                        t.visible = true;\n                        break;\n                    case 'TT': // turn\n                        currentHead = oper[1];\n                        break;\n                    case 'CL': // clear\n                        clear_canvas(t.canvasID);\n                        t.clearPoint = i; // Different from reset that calls clear because it leaves the turtles where they are\n                        break;\n                    case 'DL':  // delay\n                        t.turtleCanvas.delay = oper[1];\n                        break;\n                    case 'SC': // speed change\n                        speed = oper[1];\n\n                        if (speed < 0) {\n                            t.turtleCanvas.delay = 0;\n                        } else {\n                            if (speed > 10) {\n                                speed = 10;\n                            }\n                            t.turtleCanvas.delay = (10 - speed % 11 + 1) * t.turtleCanvas.timeFactor; //10\n                        }\n\n                        //t.turtleCanvas.intervalId = clearInterval(t.turtleCanvas.intervalId);\n                        //t.turtleCanvas.intervalId = setInterval(render, t.turtleCanvas.delay)\n                        if (oper[2]) {\n                            t.turtleCanvas.setSegmentLength(oper[2]);\n                        }\n                        break;\n                    case 'CS': // change shape\n                        t.currentShape = oper[1];\n                        break;\n                    case 'NO':\n                        break;\n                    } //else {\n                        //console.log('unknown op: ' + oper[0]);\n                    //} // end of oper[0] test\n                } // end of if ts < render clock\n            }\n            // end of for\n            // console.log(TurtleGraphics.renderClock + \" / \" + t.aCount)\n            // console.log(\"------------------------------\")\n            t.aCount += incr;\n            if (t.visible) {\n                // draw the turtle\n                t.drawturtle(currentHead.toAngle(), currentPos); // just use currentHead\n            }\n        }\n        //if (t.aCount >= t.drawingEvents.length) {\n        if (TurtleGraphics.renderClock > TurtleGraphics.eventCount) {\n            // && allDone() ){\n            //  t.turtleCanvas.doneAnimating(t);\n            //  console.log(\"done animating\")\n            if (context.lastCanvas) {\n                context.lastCanvas.doneAnimating(t);\n            }\n        } else {\n            //t.turtleCanvas.intervalId = setTimeout(render, t.turtleCanvas.delay)\n            if (context.lastCanvas) {\n                context.lastCanvas.intervalId = setTimeout(render, context.lastCanvas.delay);\n            }\n        }\n    };\n    //\n    //  Drawing Functions\n    //\n    // break a line into segments\n    // sp:  Vector of starting position\n    // ep:  Vector of ending position\n    // sl:  int length of segments\n    segmentLine = function (sp, ep, sL, pen) {\n        var head = ep.sub(sp).normalize(),\n            numSegs = Math.floor(ep.sub(sp).len() / sL),\n            res = [],\n            oldp = sp,\n            newp,\n            op = '',\n            i;\n        if (pen) {\n            op = 'LT';\n        } else {\n            op = 'MT';\n        }\n        for (i = 0; i < numSegs; i = i + 1) {\n            newp = oldp.linear(1, sL, head);\n            res.push([\n                op,\n                oldp[0],\n                oldp[1],\n                newp[0],\n                newp[1]\n            ]);\n            oldp = newp;\n        }\n        if (!(oldp[0] === ep[0] && oldp[1] === ep[1])) {\n            res.push([\n                op,\n                oldp[0],\n                oldp[1],\n                ep[0],\n                ep[1]\n            ]);\n        }\n        return res;\n    };\n\n    clear_canvas = function (canId) {\n        var ctx = document.getElementById(canId).getContext('2d');\n        //if (arguments.length >= 2) {\n        //    fillStyle = arguments[1];\n        //    fillRect(0, 0, canvas.width, canvas.height);\n        //}\n        ctx.clearRect(-ctx.canvas.width / 2, -ctx.canvas.height / 2, ctx.canvas.width, ctx.canvas.height);\n    };\n    //\n    // Define TurtleCanvas\n    //\n    function TurtleCanvas(options) {\n        this.canvasID = TurtleGraphics.defaults.canvasID;\n        if (options.canvasID) {\n            this.canvasID = options.canvasID;\n        }\n        this.canvas = document.getElementById(this.canvasID);\n        this.context = this.canvas.getContext('2d');\n        this.canvas.style.display = 'block';\n        this.canvas.style.opacity = 1;\n        //$(this.canvas).fadeIn();\n        this.lineScale = 1;\n        this.xptscale = 1;\n        this.yptscale = 1;\n        this.llx = -this.canvas.width / 2;\n        this.lly = -this.canvas.height / 2;\n        this.urx = this.canvas.width / 2;\n        this.ury = this.canvas.height / 2;\n        this.setup(this.canvas.width, this.canvas.height);\n        TurtleGraphics.canvasInit = true;\n        this.tlist = [];\n        this.timeFactor = 5;\n        if (TurtleGraphics.defaults.animate) {\n            this.delay = 5 * this.timeFactor;\n        } else {\n            this.delay = 0;\n        }\n        this.segmentLength = 10;\n        this.renderCounter = 1;\n        this.clearPoint = 0;\n        TurtleGraphics.canvasLib[this.canvasID] = this;\n    }\n    TurtleCanvas.prototype.setup = function (width, height) {\n        this.canvas.width = width;\n        this.canvas.height = height;\n        this.lineScale = 1;\n        this.xptscale = 1;\n        this.yptscale = 1;\n        this.llx = -this.canvas.width / 2;\n        this.lly = -this.canvas.height / 2;\n        this.urx = this.canvas.width / 2;\n        this.ury = this.canvas.height / 2;\n        this.renderCounter = 1;\n        this.clearPoint = 0;\n        this.timeFactor = 5;\n        if (TurtleGraphics.defaults.animate) {\n            this.delay = 5 * this.timeFactor;\n        } else {\n            this.delay = 0;\n        }\n        if (TurtleGraphics.canvasInit === false) {\n            this.context.save();\n            this.context.translate(this.canvas.width / 2, this.canvas.height / 2);\n            // move 0,0 to center.\n            this.context.scale(1, -1);\n            // scaling like this flips the y axis the right way.\n            TurtleGraphics.canvasInit = true;\n            TurtleGraphics.eventCount = 0;\n            TurtleGraphics.renderClock = 0;\n            TurtleGraphics.renderTime = 0; // RNL\n        } else {\n            this.context.restore();\n            this.context.translate(this.canvas.width / 2, this.canvas.height / 2);\n            // move 0,0 to center.\n            this.context.scale(1, -1);\n            // scaling like this flips the y axis the right way.\n            this.context.clearRect(-this.canvas.width / 2, -this.canvas.height / 2, this.canvas.width, this.canvas.height);\n        }\n    };\n    TurtleCanvas.prototype.addToCanvas = function (t) {\n        this.tlist.push(t);\n    };\n    TurtleCanvas.prototype.onCanvas = function (t) {\n        return this.tlist.indexOf(t) >= 0;\n    };\n    TurtleCanvas.prototype.isAnimating = function () {\n        return this.tlist.length > 0;\n    };\n    TurtleCanvas.prototype.startAnimating = function (t) {\n        if (!this.isAnimating()) {\n            this.intervalId = setTimeout(render, this.delay); //setInterval(render, this.delay);\n        }\n        if (!this.onCanvas(t)) {\n            //Added by RNL in case startAnimating is called after it's already been added\n            this.addToCanvas(t);\n        }\n\t\ttry {\n\t\t\tSk.isTurtleProgram = true;\n\t\t} catch (ReferenceEror) {\n\t\t}\n    };\n    TurtleCanvas.prototype.doneAnimating = function () {\n        var i;\n        this.tlist.splice(0, this.tlist.length);\n        clearTimeout(this.intervalId);\n        if (TurtleGraphics.doneDelegates) {\n            for (i = 0; i < TurtleGraphics.doneDelegates.length; i = i + 1) {\n                TurtleGraphics.doneDelegates[i]();\n            }\n        }\n    };\n    TurtleCanvas.prototype.cancelAnimation = function () {\n        var t;\n        if (this.intervalId) {\n            clearTimeout(this.intervalId);\n        }\n        for (t = 0; t < this.tlist.length; t = t + 1) {\n            this.tlist[t].aCount = this.tlist[t].drawingEvents.length - 1;\n        }\n        render();\n    };\n    TurtleCanvas.prototype.setSpeedDelay = function (s) {\n        // RNL\n        var df = 10 - s % 11 + 1;\n        this.delay = df * this.timeFactor; //RNL was 10;\n    };\n    TurtleCanvas.prototype.setDelay = function (d) {\n        this.delay = d;\n    };\n    TurtleCanvas.prototype.getDelay = function () {\n        //RNL\n        return this.delay;\n    };\n    TurtleCanvas.prototype.setCounter = function (s) {\n        if (!s || s <= 0) {\n            //Don't let this be less than 1\n            s = 1;\n        }\n        this.renderCounter = s;\n    };\n    TurtleCanvas.prototype.getCounter = function () {\n        return this.renderCounter;\n    };\n    TurtleCanvas.prototype.setworldcoordinates = function (llx, lly, urx, ury) {\n        this.context.restore();\n        this.context.scale(this.canvas.width / (urx - llx), -this.canvas.height / (ury - lly));\n        if (lly === 0) {\n            this.context.translate(-llx, lly - (ury - lly));\n        } else if (lly > 0) {\n            this.context.translate(-llx, -lly * 2);\n        } else {\n            this.context.translate(-llx, -ury);\n        }\n        var xlinescale = (urx - llx) / this.canvas.width,\n            ylinescale = (ury - lly) / this.canvas.height;\n        this.xptscale = xlinescale;\n        this.yptscale = ylinescale;\n        this.lineScale = Math.min(xlinescale, ylinescale);\n        this.context.save();\n        this.llx = llx;\n        this.lly = lly;\n        this.urx = urx;\n        this.ury = ury;\n    };\n    TurtleCanvas.prototype.window_width = function () {\n        return this.canvas.width;\n    };\n    TurtleCanvas.prototype.window_height = function () {\n        return this.canvas.height;\n    };\n    TurtleCanvas.prototype.bgcolor = function (c) {\n        this.background_color = c;\n        this.canvas.style.setProperty('background-color', c.v); //$(this.canvas).css(\"background-color\",c.v);\n    };\n    TurtleCanvas.prototype.setSegmentLength = function (s) {\n        this.segmentLength = s;\n    };\n    TurtleCanvas.prototype.getSegmentLength = function () {\n        return this.segmentLength;\n    };\n    // todo: if animating, this should be deferred until the proper time\n    TurtleCanvas.prototype.exitonclick = function () {\n        var canvas_id = this.canvasID,\n            theCanvas = this,\n            eventHandler = function () {\n                if (!theCanvas.isAnimating()) {\n                    if (TurtleGraphics.fadeOnExit) {\n                        //Let's this be configurable\n                        document.getElementById(canvas_id).style.display = 'none'; //$(\"#\"+canvas_id).hide();\n                    }\n                    document.getElementById(canvas_id).removeEventListener('click', eventHandler);\n                    //$(\"#\"+canvas_id).unbind('click');\n                    TurtleGraphics.canvasInit = false;\n                    delete TurtleGraphics.canvasLib[canvas_id];\n                }\n            };\n        this.canvas.addEventListener('click', eventHandler, false);\n    };\n    TurtleCanvas.prototype.turtles = function () {\n        return TurtleGraphics.turtleList;\n    };\n    TurtleCanvas.prototype.tracer = function (t, d) {\n        var i;\n        //New version NOT attached to a turtle (as per real turtle)\n        this.setCounter(t);\n        if (t === 0) {\n            for (i = 0; i < this.turtleList; i = i + 1) {\n                this.turtleList[i].animate = false;\n            }\n            this.cancelAnimation();\n        }\n        if (d !== undefined) {\n            this.setDelay(d);\n        }\n    };\n    // Constructor for Turtle objects\n    function Turtle(opt) {\n        this.initialize(opt);\n        TurtleGraphics.turtleList.push(this);\n    }\n    Turtle.prototype.go_home = function () {\n        // Put turtle in initial state\n        // turtle is headed to the right\n        // with location 0,0,0 in the middle of the canvas.\n        // x grows to the right\n        // y grows towards the top of the canvas\n        this.position = this.home;\n        this.context.moveTo(this.home[0], this.home[1]);\n        this.heading = new Vector([1, 0, 0]);\n        // to the right; in turtle space x+ direction\n        this.normal = new Vector([0, 0, -1]); // in z- direction\n    };\n    Turtle.prototype.initialize = function (opt) {\n        function turtleShapePoints() {\n            var pl = [\n                    [ 0, 16 ],\n                    [ -2, 14 ],\n                    [ -1, 10 ],\n                    [ -4, 7 ],\n                    [ -7, 9 ],\n                    [ -9, 8 ],\n                    [ -6, 5 ],\n                    [ -7, 1 ],\n                    [ -5, -3 ],\n                    [ -8, -6 ],\n                    [ -6, -8 ],\n                    [ -4, -5 ],\n                    [ 0, -7 ],\n                    [ 4, -5 ],\n                    [ 6, -8 ],\n                    [ 8, -6 ],\n                    [ 5, -3 ],\n                    [ 7, 1 ],\n                    [ 6, 5 ],\n                    [ 9, 8 ],\n                    [ 7, 9 ],\n                    [ 4, 7 ],\n                    [ 1, 10 ],\n                    [ 2, 14 ]\n                ],\n                res = [],\n                p;\n            for (p = 0; p < pl.length; p = p + 1) {\n                res.push(new Vector(pl[p]));\n            }\n            return res;\n        }\n\n        function defaultShapePoints() {\n            var pl = [\n                    [ -10, 0 ],\n                    [ 10, 0 ],\n                    [ 0, 10 ]\n                ],\n                res = [],\n                p;\n            for (p = 0; p < pl.length; p = p + 1) {\n                res.push(new Vector(pl[p]));\n            }\n            return res;\n        }\n\n        function circleShapePoints() {\n            var pl = [\n                    [ 10, 0 ],\n                    [ 9.51, 3.09 ],\n                    [ 8.09, 5.88 ],\n                    [ 5.88, 8.09 ],\n                    [ 3.09, 9.51 ],\n                    [ 0, 10 ],\n                    [ -3.09, 9.51 ],\n                    [ -5.88, 8.09 ],\n                    [ -8.09, 5.88 ],\n                    [ -9.51, 3.09 ],\n                    [ -10, 0 ],\n                    [ -9.51, -3.09 ],\n                    [ -8.09, -5.88 ],\n                    [ -5.88, -8.09 ],\n                    [ -3.09, -9.51 ],\n                    [ -0, -10 ],\n                    [ 3.09, -9.51 ],\n                    [ 5.88, -8.09 ],\n                    [ 8.09, -5.88 ],\n                    [ 9.51, -3.09 ]\n                ],\n                res = [],\n                p;\n            for (p = 0; p < pl.length; p = p + 1) {\n                res.push(new Vector(pl[p]));\n            }\n            return res;\n        }\n\n        function triangleShapePoints() {\n            var pl = [\n                    [ 10, -5.77 ],\n                    [ 0, 11.55 ],\n                    [ -10, -5.77 ]\n                ],\n                res = [],\n                p;\n            for (p = 0; p < pl.length; p = p + 1) {\n                res.push(new Vector(pl[p]));\n            }\n            return res;\n        }\n\n        function squareShapePoints() {\n            var pl = [\n                    [ 10, -10 ],\n                    [ 10, 10 ],\n                    [ -10, 10 ],\n                    [ -10, -10 ]\n                ],\n                res = [],\n                p;\n            for (p = 0; p < pl.length; p = p + 1) {\n                res.push(new Vector(pl[p]));\n            }\n            return res;\n        }\n\n        function classicShapePoints() {\n            var pl = [\n                    [ 0, 0 ],\n                    [ -5, -9 ],\n                    [ 0, -7 ],\n                    [ 5, -9 ]\n                ],\n                res = [],\n                p;\n            for (p = 0; p < pl.length; p = p + 1) {\n                res.push(new Vector(pl[p]));\n            }\n            return res;\n        }\n\n        // Initialize the turtle.\n        var options = {}, ctx = null;\n        if (opt) {\n            options = opt;\n        }\n        this.canvasID = TurtleGraphics.defaults.canvasID;\n        if (options.canvasID) {\n            this.canvasID = options.canvasID;\n        }\n        this.context = document.getElementById(this.canvasID).getContext('2d');\n        this.animate = TurtleGraphics.defaults.animate;\n        ctx = this.context;\n        if (TurtleGraphics.canvasInit === false) {\n            // This is a workaround until I understand skulpt re-running better\n            // the downside is that this limits us to a single turtle...\n            ctx.save();\n            ctx.translate(ctx.canvas.width / 2, ctx.canvas.height / 2);\n            // move 0,0 to center.\n            ctx.scale(1, -1);\n            // scaling like this flips the y axis the right way.\n            if (!TurtleGraphics.canvasLib[this.canvasID]) {\n                TurtleGraphics.canvasLib[this.canvasID] = new TurtleCanvas(options);\n            }\n            TurtleGraphics.canvasInit = true;\n        } else {\n            clear_canvas(this.canvasID);\n        }\n        this.turtleCanvas = TurtleGraphics.canvasLib[this.canvasID];\n        this.home = new Vector([0, 0, 0]);\n        this.visible = true;\n        this.shapeStore = {};\n        this.shapeStore.turtle = turtleShapePoints();\n        this.shapeStore.arrow = defaultShapePoints();\n        this.shapeStore.circle = circleShapePoints();\n        this.shapeStore.square = squareShapePoints();\n        this.shapeStore.triangle = triangleShapePoints();\n        this.shapeStore.blank = [new Vector(0, 0)];\n        this.shapeStore.classic = classicShapePoints();\n        this.currentShape = 'classic';\n        this.drawingEvents = [];\n        this.filling = false;\n        this.pen = true;\n        this.penStyle = 'black';\n        this.penWidth = 2;\n        this.fillStyle = 'black';\n        this.position = [];\n        this.heading = [];\n        this.normal = [];\n        this.go_home();\n        this.aCount = 0;\n        this.clearPoint = 0; // RNL for clear/clearScreen\n    };\n    Turtle.prototype.clean = function (color) {\n        // Clean the canvas\n        // Optional second argument is color\n        if (arguments.length >= 1) {\n            clear_canvas(this.canvasID, color);\n        } else {\n            clear_canvas(this.canvasID);\n        }\n        this.initialize();\n    };\n    Turtle.prototype.addDrawingEvent = function (eventList) {\n        TurtleGraphics.eventCount += 1;\n        eventList.push(TurtleGraphics.eventCount);\n        this.drawingEvents.push(eventList);\n    };\n    Turtle.prototype.draw_line = function (newposition) {\n        var ctx = this.context,\n            r,\n            s;\n        if (!this.animate) {\n            if (!this.filling) {\n                ctx.beginPath();\n                ctx.moveTo(this.position[0], this.position[1]);\n            }\n            ctx.lineCap = 'round';\n            ctx.lineJoin = 'round';\n            ctx.lineWidth = this.get_pen_width();\n            ctx.strokeStyle = this.penStyle;\n            ctx.lineTo(newposition[0], newposition[1]);\n\t\t\t//ctx.moveTo(newposition[0], newposition[1]);\n\t\t\tthis.position = newposition;\n            ctx.stroke();\n            if (!this.filling) {\n                ctx.closePath();\n            }\n        } else {\n            r = segmentLine(this.position, newposition, this.turtleCanvas.getSegmentLength(), this.pen);\n            for (s = 0; s < r.length; s = s + 1) {\n                r[s].push(this.penStyle);\n                this.addDrawingEvent(r[s]);\n            }\n            if (!this.turtleCanvas.isAnimating()) {\n                this.turtleCanvas.startAnimating(this);\n            } else {\n                if (!this.turtleCanvas.onCanvas(this)) {\n                    this.turtleCanvas.addToCanvas(this);\n                }\n            }\n        }\n    };\n    Turtle.prototype.forward = function (d) {\n        var newposition = this.position.linear(1, d, this.heading);\n        this.goto(newposition);\n    };\n    Turtle.prototype.backward = function (d) {\n        this.forward(-d);\n    };\n    //This is an internal function that sets the position without doing any drawing\n    Turtle.prototype.teleport_to = function (nx, ny) {\n        var newposition;\n        if (nx instanceof Vector) {\n            newposition = nx;\n        } else {\n            newposition = new Vector([nx, ny, 0]);\n        }\n        this.context.moveTo(newposition[0], newposition[1]);\n        this.position = newposition;\n    };\n    Turtle.prototype.goto = function (nx, ny) {\n        var newposition, r, s;\n        if (nx instanceof Vector) {\n            newposition = nx;\n        } else {\n            newposition = new Vector([nx, ny, 0]);\n        }\n\t\tif (this.pen) {\n            this.draw_line(newposition);\n        } else {\n            if (!this.animate) {\n                this.context.moveTo(newposition[0], newposition[1]);\n            } else {\n                r = segmentLine(this.position, newposition, this.turtleCanvas.getSegmentLength(), this.pen);\n                for (s = 0; s < r.length; s = s + 1) {\n                    this.addDrawingEvent(r[s]);\n                }\n                if (!this.turtleCanvas.isAnimating()) {\n                    this.turtleCanvas.startAnimating(this);\n                } else {\n                    if (!this.turtleCanvas.onCanvas(this)) {\n                        this.turtleCanvas.addToCanvas(this);\n                    }\n                }\n            }\n        }\n        this.position = newposition;\n    };\n    Turtle.prototype.delay = function (d) {\n        // RNL\n        if (d !== null) {\n            if (d < 0) {\n                d = -d;\n            }\n            if (!this.animate) {\n                this.turtleCanvas.setDelay(d);\n            } else {\n                this.turtleCanvas.setDelay(d);\n                this.addDrawingEvent([ 'DL', d ]);\n                this.addDrawingEvent(['NO']);\n            }\n        }\n        return this.turtleCanvas.getDelay();\n    };\n    Turtle.prototype.speed = function (s, t) {\n        if (s > 0 && !this.animate) {\n            this.animate = true;\n            this.turtleCanvas.setSpeedDelay(s);\n        } else if (s === 0 ) {\n            this.animate = false;\n            this.turtleCanvas.cancelAnimation();\n        } else {\n            this.turtleCanvas.setSpeedDelay(s);\n            this.addDrawingEvent([ 'SC', s, t ]);\n            this.addDrawingEvent(['NO']);\n        }\n        if (t) {\n            this.turtleCanvas.setSegmentLength(t); // set the number of units to divide a segment into\n        } else {\n            this.turtleCanvas.setSegmentLength(10);\n        }\n    };\n    Turtle.prototype.tracer = function (t, d) {\n        this.turtleCanvas.setCounter(t);\n        if (t === 0) {\n            this.animate = false;\n            this.turtleCanvas.cancelAnimation();\n        }\n        if (d !== undefined) {\n            this.turtleCanvas.setDelay(d);\n        }\n    };\n    Turtle.prototype.getRenderCounter = function () {\n        return this.turtleCanvas.getCounter();\n    };\n    Turtle.prototype.turn = function (phi) {\n        var alpha = phi * Degree2Rad,\n            left = this.normal.cross(this.heading),\n            newheading = this.heading.rotateNormal(left, alpha);\n        this.heading = newheading;\n        if (this.animate) {\n            this.addDrawingEvent([ 'TT', this.heading ]);\n        }\n    };\n    Turtle.prototype.right = Turtle.prototype.turn;\n    Turtle.prototype.left = function (phi) {\n        this.turn(-phi);\n    };\n    Turtle.prototype.get_heading = function () {\n        if (TurtleGraphics.defaults.degrees) {\n            return this.heading.toAngle();\n        }\n        return this.heading;\n    };\n    Turtle.prototype.get_position = function () {\n        return this.position;\n    };\n    Turtle.prototype.getx = function () {\n        return this.position[0];\n    };\n    Turtle.prototype.gety = function () {\n        return this.position[1];\n    };\n    Turtle.prototype.set_heading = function (newhead) {\n        if ((typeof newhead).toLowerCase() === 'number') {\n            this.heading = Vector.angle2vec(newhead);\n        } else {\n            this.heading = newhead;\n        }\n    };\n    Turtle.prototype.towards = function (to, y) {\n        // set heading vector to point towards another point.\n        if ((typeof to).toLowerCase() === 'number') {\n            to = new Vector(to, y, 0);\n        } else if (!(to instanceof Vector)) {\n            to = new Vector(to);\n        }\n        var res = to.sub(this.position);\n        res = res.normalize();\n        if (TurtleGraphics.defaults.degrees) {\n            return res.toAngle();\n        }\n        return res;\n    };\n    Turtle.prototype.distance = function (to, y) {\n        if ((typeof to).toLowerCase() === 'number') {\n            to = new Vector(to, y, 0);\n        }\n        return this.position.sub(new Vector(to)).len();\n    };\n    Turtle.prototype.dot = function (psize, pcolor) {\n        var size = 2,\n            ctx = this.context,\n            curPenStyle = this.penStyle,\n\t\t\tcurFillStyle = this.fillStyle;\n\n        if (arguments.length >= 1) {\n            size = psize;\n        }\n        size = size * this.turtleCanvas.lineScale;\n\n        if (!this.animate) {\n\t\t\tif (pcolor) {\n\t\t\t\tctx.fillStyle = pcolor;\n\t\t\t\tctx.strokeStyle = pcolor;\n\t\t\t}\n            ctx.fillRect(this.position[0] - size / 2, this.position[1] - size / 2, size, size);\n\t\t\tif (pcolor) {\n\t\t\t\tctx.fillStyle = curFillStyle;\n\t\t\t\tctx.strokeStyle = curPenStyle;\n\t\t\t}\n        } else {\n            this.addDrawingEvent([\n                'DT',\n                size,\n                pcolor || ctx.strokeStyle,\n                this.position[0],\n                this.position[1]\n            ]);\n        }\n    };\n    Turtle.prototype.circle = function (radius, extent) {\n        var arcLen, segLen, extentPart, extentLeft;\n        if (extent === undefined) {\n            extent = 360;\n        }\n        if (this.animate) {\n            arcLen = Math.abs(radius * Math.PI * 2 * extent / 360);\n            segLen = this.turtleCanvas.getSegmentLength();\n            if (arcLen <= segLen) {\n                this.arc(radius, extent);\n            } else {\n                //Break the arc into segments for animation\n                extentPart = segLen / arcLen * extent;\n                extentLeft = extent;\n                while (Math.abs(extentLeft) > Math.abs(extentPart)) {\n                    this.arc(radius, extentPart);\n                    extentLeft = extentLeft - extentPart;\n                }\n                if (Math.abs(extentLeft) > 0.01) {\n                    this.arc(radius, extentLeft);\n                }\n            }\n            if (!this.turtleCanvas.isAnimating()) {\n                this.turtleCanvas.startAnimating(this);\n            } else {\n                if (!this.turtleCanvas.onCanvas(this)) {\n                    this.turtleCanvas.addToCanvas(this);\n                }\n            }\n        } else {\n            this.arc(radius, extent);\n        }\n    };\n    Turtle.prototype.arc = function (radius, extent) {\n        //Figure out where the turtle is and which way it's facing\n        var turtleHeading = this.get_heading(),\n            tx = this.position[0],\n            ty = this.position[1],\n            //Figure out the circle center\n            cx = tx + radius * Math.cos((turtleHeading + 90) * Degree2Rad),\n            cy = ty + radius * Math.sin((turtleHeading + 90) * Degree2Rad),\n            //Canvas arc angles go CLOCKWISE, not COUNTERCLOCKWISE like Turtle\n            //Figure out our arc angles\n            startAngleDeg,\n            endAngleDeg,\n            startAngle,\n            endAngle,\n            turtleArc,\n            newTurtleHeading,\n            nx,\n            ny;\n\n        if (radius >= 0) {\n            startAngleDeg = turtleHeading - 90;\n        } else {\n            startAngleDeg = turtleHeading + 90;\n        }\n\n        if (extent) {\n            if (radius >= 0) {\n                endAngleDeg = startAngleDeg + extent;\n            } else {\n                endAngleDeg = startAngleDeg - extent;\n            }\n        } else {\n            if (radius >= 0) {\n                endAngleDeg = startAngleDeg + 360;\n            } else {\n                endAngleDeg = startAngleDeg - 360;\n            }\n        }\n        //Canvas angles are opposite\n        startAngleDeg = 360 - startAngleDeg;\n        endAngleDeg = 360 - endAngleDeg;\n        //Becuase the y axis has been flipped in HTML5 Canvas with a tanslation, we need to adjust the angles\n        startAngleDeg = -startAngleDeg;\n        endAngleDeg = -endAngleDeg;\n        //Convert to radians\n        startAngle = startAngleDeg * Degree2Rad;\n        endAngle = endAngleDeg * Degree2Rad;\n        //Do the drawing\n        if (!this.animate) {\n            if (!this.filling) {\n                this.context.beginPath();\n            }\n            this.context.arc(cx, cy, Math.abs(radius), startAngle, endAngle, radius * extent <= 0);\n            this.context.stroke();\n            if (!this.filling) {\n                this.context.closePath();\n            }\n        } else {\n            this.addDrawingEvent([\n                'CI',\n                cx,\n                cy,\n                Math.abs(radius),\n                startAngle,\n                endAngle,\n                radius * extent <= 0\n            ]);\n        }\n        //Move the turtle only if we have to\n        if (extent && extent % 360 !== 0) {\n            if (radius >= 0) {\n                turtleArc = extent;\n            } else {\n                turtleArc = -extent;\n            }\n            newTurtleHeading = (turtleHeading + turtleArc) % 360;\n            if (newTurtleHeading < 0) {\n                newTurtleHeading = newTurtleHeading + 360;\n            }\n            nx = cx + radius * Math.cos((newTurtleHeading - 90) * Degree2Rad);\n            ny = cy + radius * Math.sin((newTurtleHeading - 90) * Degree2Rad);\n            //y coord is inverted in turtle\n            //Move it internally\n            this.set_heading(newTurtleHeading);\n            this.teleport_to(nx, ny);\n            //If we're animating the turtle, move it on the screen\n            if (this.animate) {\n                this.addDrawingEvent([\n                    'TT',\n                    this.heading\n                ]);\n            }\n        }\n    };\n    Turtle.prototype.write = function (theText, /*move, align, */font) {\n        if (!this.animate) {\n            if (font) {\n                this.context.font = font.v;\n            }\n            this.context.scale(1, -1);\n            this.context.fillText(theText, this.position[0], -this.position[1]);\n            this.context.scale(1, -1);\n        } else {\n            var fontspec;\n            if (font) {\n                fontspec = font.v;\n            }\n            this.addDrawingEvent([\n                'WT',\n                theText,\n                fontspec,\n                this.position[0],\n                this.position[1]\n            ]);\n        }\n    };\n    Turtle.prototype.setworldcoordinates = function (llx, lly, urx, ury) {\n        this.turtleCanvas.setworldcoordinates(llx, lly, urx, ury);\n    };\n    //\n    // Pen and Style functions\n    //\n    Turtle.prototype.pen_down = function () {\n        this.pen = true;\n    };\n    Turtle.prototype.down = Turtle.prototype.pen_down;\n    Turtle.prototype.pen_up = function () {\n        this.pen = false;\n    };\n    Turtle.prototype.up = Turtle.prototype.pen_up;\n    Turtle.prototype.get_pen = function () {\n        return this.pen;\n    };\n    Turtle.prototype.set_pen_width = function (w) {\n        if (this.animate) {\n            this.addDrawingEvent([\n                'PW',\n                w * this.turtleCanvas.lineScale\n            ]);\n        } else {\n            this.penWidth = w;\n        }\n    };\n    Turtle.prototype.get_pen_width = function () {\n        return this.penWidth * this.turtleCanvas.lineScale;\n    };\n    Turtle.prototype.set_pen_color = function (c, g, b) {\n        if (typeof c === 'string') {\n            this.penStyle = c;\n        } else {\n            var rs, gs, bs, c0, c1, c2;\n            if (Array.isArray(c)) {\n                c0 = c[0];\n                c1 = c[1];\n                c2 = c[2];\n            } else {\n                c0 = c;\n                c1 = g;\n                c2 = b;\n            }\n            rs = Math.abs(c0).toString(16);\n            gs = Math.abs(c1).toString(16);\n            bs = Math.abs(c2).toString(16);\n            while (rs.length < 2) {\n                rs = '0' + rs;\n            }\n            while (gs.length < 2) {\n                gs = '0' + gs;\n            }\n            while (bs.length < 2) {\n                bs = '0' + bs;\n            }\n            c = '#' + rs + gs + bs;\n            this.penStyle = c;\n        }\n        this.context.strokeStyle = c;\n        if (this.animate) {\n            this.addDrawingEvent([\n                'TC',\n                c\n            ]);\n        }\n    };\n    Turtle.prototype.set_fill_color = function (c, g, b) {\n        if (typeof c === 'string') {\n            this.fillStyle = c;\n        } else {\n            var rs, gs, bs, c0, c1, c2;\n            if (Array.isArray(c)) {\n                c0 = c[0];\n                c1 = c[1];\n                c2 = c[2];\n            } else {\n                c0 = c;\n                c1 = g;\n                c2 = b;\n            }\n            rs = Math.abs(c0).toString(16);\n            gs = Math.abs(c1).toString(16);\n            bs = Math.abs(c2).toString(16);\n            while (rs.length < 2) {\n                rs = '0' + rs;\n            }\n            while (gs.length < 2) {\n                gs = '0' + gs;\n            }\n            while (bs.length < 2) {\n                bs = '0' + bs;\n            }\n            c = '#' + rs + gs + bs;\n            this.fillStyle = c;\n        }\n        this.context.fillStyle = c;\n        if (this.animate) {\n            this.addDrawingEvent([\n                'FC',\n                c\n            ]);\n        }\n    };\n    Turtle.prototype.begin_fill = function () {\n        if (!this.animate) {\n            this.filling = true;\n            this.context.beginPath();\n            this.context.moveTo(this.position[0], this.position[1]);\n        } else {\n            this.addDrawingEvent([\n                'BF',\n                this.position[0],\n                this.position[1]\n            ]);\n        }\n    };\n    Turtle.prototype.end_fill = function () {\n        if (!this.animate) {\n            this.context.stroke();\n            this.context.fill();\n            this.context.closePath();\n            this.filling = false;\n        } else {\n            this.addDrawingEvent([\n                'EF',\n                this.position[0],\n                this.position[1],\n                this.fillStyle\n            ]);\n        }\n    };\n    Turtle.prototype.showturtle = function () {\n        if (this.animate) {\n            this.addDrawingEvent(['SH']);\n        }\n        this.visible = true;\n    };\n    Turtle.prototype.hideturtle = function () {\n        if (this.animate) {\n            this.addDrawingEvent(['HT']);\n        }\n        this.visible = false;\n    };\n    Turtle.prototype.isvisible = function () {\n        return this.visible;\n    };\n    //\n    // Appearance\n    //\n    Turtle.prototype.shape = function (s) {\n        if (this.shapeStore[s]) {\n            this.addDrawingEvent(['CS', s]); // add a Change Shape event\n        }\n    };\n    Turtle.prototype.drawturtle = function (pHeading, pos) {\n        var rtPoints = [],\n            plist = this.shapeStore[this.currentShape],\n            head,\n            p,\n            i;\n\n        if (pHeading !== undefined) {\n            head = pHeading - 90;\n        } else {\n            head = this.heading.toAngle() - 90;\n        }\n\n        if (!pos) {\n            pos = this.position;\n        }\n\n        for (p = 0; p < plist.length; p = p + 1) {\n            rtPoints.push(plist[p]\n                          .scale(this.turtleCanvas.xptscale, this.turtleCanvas.yptscale)\n                          .rotate(head)\n                          .add(pos));\n        }\n        this.context.beginPath();\n        this.context.moveTo(rtPoints[0][0], rtPoints[0][1]);\n        for (i = 1; i < rtPoints.length; i = i + 1) {\n            this.context.lineTo(rtPoints[i][0], rtPoints[i][1]);\n        }\n        this.context.closePath();\n        this.context.stroke();\n        if (this.fillStyle) {\n            this.context.fill();\n        }\n    };\n    Turtle.prototype.stamp = function () {\n        // either call drawTurtle or just add a DT with current position and heading to the drawingEvents list.\n        if (this.animate) {\n            this.addDrawingEvent([\n                'ST',\n                this.position[0],\n                this.position[1],\n                this.heading.toAngle()\n            ]);\n        } else {\n            this.drawturtle();\n        }\n    };\n    Turtle.prototype.clear = function () {\n        if (this.animate) {\n            this.addDrawingEvent(['CL']);\n        } else {\n\t\t\tclear_canvas(this.canvasID);\n\t\t\tthis.penStyle = 'black';\n\t\t\tthis.penWidth = 2;\n\t\t\tthis.fillStyle = 'black';\n        }\n    };\n    TurtleGraphics.turtleList = [];\n    TurtleGraphics.Turtle = Turtle;\n    TurtleGraphics.TurtleCanvas = TurtleCanvas;\n    TurtleGraphics.canvasLib = {};\n    TurtleGraphics.clear_canvas = clear_canvas;\n    TurtleGraphics.Vector = Vector;\n    TurtleGraphics.canvasInit = false;\n    TurtleGraphics.eventCount = 0;\n    TurtleGraphics.renderClock = 0;\n    TurtleGraphics.renderTime = 0; // RNL\n}());\n//\n// Wrapper around the Turtle Module starts here.\n//\nvar $builtinmodule = function (name) {\n    'use strict';\n    var mod = {},\n\t\tinitializeTurtlegraphics = function() {\n\t\t\tif (!TurtleGraphics) { TurtleGraphics = {}; }\n\t\t\tif (!TurtleGraphics.defaults) {\n\t\t\t\tTurtleGraphics.defaults = {\n\t\t\t\t\tanimate: true,\n\t\t\t\t\tcanvasID: Sk.canvas,\n\t\t\t\t\tdegrees: true\n\t\t\t\t}\n\t\t\t} else if (Sk.canvas) {\n\t\t\t\tTurtleGraphics.defaults.canvasID = Sk.canvas;\n\t\t\t}\n\t\t\tif (!TurtleGraphics.doneDelegates) { TurtleGraphics.doneDelegates = []; }\n\t\t},\n\t\tremoveDisabled = function () {\n\t\t\tif (Sk.runButton) {\n\t\t\t\tSk.runButton.removeAttribute('disabled');\n\t\t\t}\n\t\t},\n        checkArgs = function (expected, actual, func) {\n            if (actual !== expected) {\n                throw new Sk.builtin.TypeError(func + ' takes exactly ' + expected + ' positional argument (' + actual + ' given)');\n            }\n        },\n        turtle = function ($gbl, $loc) {\n            $loc.__init__ = new Sk.builtin.func(function (self) {\n\t\t\t\tinitializeTurtlegraphics();\n\t\t\t\tif (TurtleGraphics.doneDelegates.indexOf(removeDisabled) === -1){\n\t\t\t\t\tTurtleGraphics.doneDelegates.push(removeDisabled);\n\t\t\t\t}\n                self.theTurtle = new TurtleGraphics.Turtle();\n            });\n            //\n            // Turtle Motion\n            //\n            //\n            // Move and Draw\n            //\n            $loc.forward = new Sk.builtin.func(function (self, dist) {\n                dist = Sk.builtin.asnum$(dist);\n                checkArgs(2, arguments.length, 'forward()');\n                self.theTurtle.forward(dist);\n            });\n            $loc.fd = $loc.forward;\n            $loc.backward = new Sk.builtin.func(function (self, dist) {\n                dist = Sk.builtin.asnum$(dist);\n                checkArgs(2, arguments.length, 'backward()');\n                self.theTurtle.forward(-dist);\n            });\n            $loc.back = $loc.backward;\n            $loc.bk = $loc.backward;\n            $loc.right = new Sk.builtin.func(function (self, angle) {\n                angle = Sk.builtin.asnum$(angle);\n                checkArgs(2, arguments.length, 'right()');\n                self.theTurtle.turn(angle);\n            });\n            $loc.rt = $loc.right;\n            $loc.left = new Sk.builtin.func(function (self, angle) {\n                angle = Sk.builtin.asnum$(angle);\n                checkArgs(2, arguments.length, 'left()');\n                self.theTurtle.turn(-angle);\n            });\n            $loc.lt = $loc.left;\n            $loc.goto_$rw$ = new Sk.builtin.func(function (self, nx, ny) {\n                nx = Sk.builtin.asnum$(nx);\n                ny = Sk.builtin.asnum$(ny);\n                checkArgs(3, arguments.length, 'goto()');\n                self.theTurtle.goto(nx, ny);\n            });\n            $loc.setposition = new Sk.builtin.func(function (self, nx, ny) {\n                nx = Sk.builtin.asnum$(nx);\n                ny = Sk.builtin.asnum$(ny);\n                checkArgs(3, arguments.length, 'setposition()');\n                self.theTurtle.up();\n                self.theTurtle.goto(nx, ny);\n                self.theTurtle.down();\n            });\n            $loc.setpos = $loc.setposition;\n            $loc.setx = new Sk.builtin.func(function (self, nx) {\n                nx = Sk.builtin.asnum$(nx);\n                checkArgs(2, arguments.length, 'setx()');\n                self.theTurtle.goto(nx, self.theTurtle.GetY());\n            });\n            $loc.sety = new Sk.builtin.func(function (self, ny) {\n                ny = Sk.builtin.asnum$(ny);\n                checkArgs(2, arguments.length, 'sety()');\n                self.theTurtle.goto(self.theTurtle.GetX(), ny);\n            });\n            $loc.setheading = new Sk.builtin.func(function (self, newhead) {\n                newhead = Sk.builtin.asnum$(newhead);\n                checkArgs(2, arguments.length, 'setheading()');\n                return self.theTurtle.set_heading(newhead);\n            });\n            $loc.seth = $loc.setheading;\n            $loc.home = new Sk.builtin.func(function (self) {\n                self.theTurtle.go_home();\n            });\n            $loc.dot = new Sk.builtin.func(function (self, size, color) {\n                size = Sk.builtin.asnum$(size);\n                size = size || 1;\n                if (color) {\n                    color = color.v || self.theTurtle.penStyle;\n                }\n                self.theTurtle.dot(size, color);\n            });\n            $loc.circle = new Sk.builtin.func(function (self, radius, extent) {\n                radius = Sk.builtin.asnum$(radius);\n                extent = Sk.builtin.asnum$(extent);\n                self.theTurtle.circle(radius, extent);\n            });\n            $loc.delay = new Sk.builtin.func(function (self, d) {\n                d = Sk.builtin.asnum$(d);\n                return self.theTurtle.delay(d);\n            });\n            $loc.speed = new Sk.builtin.func(function (self, s, t) {\n                s = Sk.builtin.asnum$(s);\n                t = Sk.builtin.asnum$(t);\n                self.theTurtle.speed(s, t);\n            });\n            $loc.tracer = new Sk.builtin.func(function (self, t, d) {\n                t = Sk.builtin.asnum$(t);\n                d = Sk.builtin.asnum$(d);\n                self.theTurtle.tracer(t, d);\n            });\n            $loc.update = new Sk.builtin.func(function (self) {});\n            // todo:  stamp, clearstamp, clearstamps, undo, speed\n            //\n            // Tell Turtle's state\n            //\n            $loc.heading = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'heading()');\n                return Sk.builtin.assk$(self.theTurtle.get_heading(), Sk.builtin.nmber.float$);\n            });\n            $loc.position = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'position()');\n                var res = self.theTurtle.get_position(),\n                    x = new Sk.builtin.tuple([\n                        Sk.builtin.assk$(res[0], Sk.builtin.nmber.float$),\n                        Sk.builtin.assk$(res[1], Sk.builtin.nmber.float$)\n                    ]);\n                return x;\n            });\n            $loc.pos = $loc.position;\n            $loc.xcor = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'xcor()');\n                var res = self.theTurtle.getx();\n                return Sk.builtin.assk$(res, Sk.builtin.nmber.float$);\n            });\n            $loc.ycor = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'ycor()');\n                var res = self.theTurtle.gety();\n                return Sk.builtin.assk$(res, Sk.builtin.nmber.float$);\n            });\n            $loc.towards = new Sk.builtin.func(function (self, tx, ty) {\n                tx = Sk.builtin.asnum$(tx);\n                ty = Sk.builtin.asnum$(ty);\n                if ((typeof tx).toLowerCase() === 'number') {\n                    tx = [ tx, ty, 0 ];\n                } else {\n                    tx = [\n                        Sk.builtin.asnum$(tx.theTurtle.getx()),\n                        Sk.builtin.asnum$(tx.theTurtle.gety()),\n                        Sk.builtin.asnum$(0)\n                    ];\n                }\n                return Sk.builtin.assk$(self.theTurtle.towards(tx), Sk.builtin.nmber.float$);\n            });\n            // tx can be either a number or a vector position.\n            // tx can not be a turtle at this time as multiple turtles have not been implemented yet.\n            $loc.distance = new Sk.builtin.func(function (self, tx, ty) {\n                tx = Sk.builtin.asnum$(tx);\n                ty = Sk.builtin.asnum$(ty);\n                if ((typeof tx).toLowerCase() === 'number') {\n                    tx = [\n                        tx,\n                        ty,\n                        0\n                    ];\n                } else {\n                    tx = [\n                        tx.theTurtle.getx(),\n                        tx.theTurtle.gety(),\n                        0\n                    ];\n                }\n                return Sk.builtin.assk$(self.theTurtle.distance(tx), Sk.builtin.nmber.float$);\n            });\n            //\n            // Setting and Measurement\n            //\n            // todo:  degrees and radians...\n            //\n            // Pen Control\n            //\n            //\n            // Drawing State\n            //\n            $loc.up = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'up()');\n                self.theTurtle.pen_up();\n            });\n            $loc.penup = $loc.up;\n            $loc.pu = $loc.up;\n            $loc.down = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'down()');\n                self.theTurtle.pen_down();\n            });\n            $loc.pendown = $loc.down;\n            $loc.pd = $loc.down;\n            $loc.width = new Sk.builtin.func(function (self, w) {\n                w = Sk.builtin.asnum$(w);\n                checkArgs(2, arguments.length, 'width()');\n                self.theTurtle.set_pen_width(w);\n            });\n            $loc.pensize = $loc.width;\n            $loc.isdown = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'isdown()');\n                return self.theTurtle.get_pen();\n            });\n            // todo:  pen  -- return a dictionary full of pen stuff\n            //\n            // Color Control\n            //\n            $loc.fillcolor = new Sk.builtin.func(function (self, color, green, blue) {\n                if (color) {\n                    if (blue) {\n                        color = Sk.builtin.asnum$(color);\n                        green = Sk.builtin.asnum$(green);\n                        blue = Sk.builtin.asnum$(blue);\n                        self.theTurtle.set_fill_color(color, green, blue);\n                    } else {\n                        color = color.v || self.theTurtle.context.fillStyle;\n                        self.theTurtle.set_fill_color(color);\n                    }\n                } else {\n                    return self.theTurtle.fillStyle;\n                }\n            });\n            $loc.pencolor = new Sk.builtin.func(function (self, color, green, blue) {\n                if (color) {\n                    if (blue) {\n                        color = Sk.builtin.asnum$(color);\n                        green = Sk.builtin.asnum$(green);\n                        blue = Sk.builtin.asnum$(blue);\n                        self.theTurtle.set_pen_color(color, green, blue);\n                    } else {\n                        color = color.v || self.theTurtle.context.fillStyle;\n                        self.theTurtle.set_pen_color(color);\n                    }\n                } else {\n                    return self.theTurtle.penStyle;\n                }\n            });\n            $loc.color = new Sk.builtin.func(function (self, color, green, blue) {\n                if (color) {\n                    if (blue) {\n                        color = Sk.builtin.asnum$(color);\n                        green = Sk.builtin.asnum$(green);\n                        blue = Sk.builtin.asnum$(blue);\n                        self.theTurtle.set_pen_color(color, green, blue);\n                        self.theTurtle.set_fill_color(color, green, blue);\n                    } else {\n                        color = color.v || self.theTurtle.context.fillStyle;\n                        self.theTurtle.set_pen_color(color);\n                        self.theTurtle.set_fill_color(color);\n                    }\n                } else {\n                    return [\n                        self.theTurtle.penStyle,\n                        self.theTurtle.fillStyle\n                    ];\n                }\n            });\n            //\n            //  Filling\n            //\n            $loc.begin_fill = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'begin_fill()');\n                self.theTurtle.begin_fill();\n            });\n            $loc.end_fill = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'end_fill()');\n                self.theTurtle.end_fill();\n            });\n            $loc.fill = new Sk.builtin.func(function (self, fillt) {\n                if (fillt === undefined) {\n                    return self.theTurtle.filling;\n                }\n                if (fillt) {\n                    self.theTurtle.begin_fill();\n                } else {\n                    self.theTurtle.end_fill();\n                }\n            });\n            //\n            // More drawing control\n            //\n            $loc.reset = new Sk.builtin.func(function (self) {\n                self.theTurtle.clean();\n            });\n            $loc.showturtle = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'showturtle()');\n                self.theTurtle.showturtle();\n            });\n            $loc.st = $loc.showturtle;\n            $loc.hideturtle = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'hideturtle()');\n                self.theTurtle.hideturtle();\n            });\n            $loc.ht = $loc.hideturtle;\n            $loc.isvisible = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'isvisible()');\n                self.theTurtle.isvisible();\n            });\n            $loc.stamp = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'stamp()');\n                self.theTurtle.stamp();\n            });\n            $loc.shape = new Sk.builtin.func(function (self, s) {\n                checkArgs(2, arguments.length, 'shape()');\n                self.theTurtle.shape(s.v);\n            });\n            //todo the move, align, and font parameters should be kwargs...\n            $loc.write = new Sk.builtin.func(function (self, mystr, move, align, font) {\n                self.theTurtle.write(mystr.v, /*move, align, */font);\n            });\n            //todo clean  -- again multiple turtles\n            $loc.setworldcoordinates = new Sk.builtin.func(function (self, llx, lly, urx, ury) {\n                llx = Sk.builtin.asnum$(llx);\n                lly = Sk.builtin.asnum$(lly);\n                urx = Sk.builtin.asnum$(urx);\n                ury = Sk.builtin.asnum$(ury);\n                self.theTurtle.setworldcoordinates(llx, lly, urx, ury);\n            });\n            //Added by RNL\n            $loc.clear = new Sk.builtin.func(function (self) {\n                self.theTurtle.clear();\n            });\n        },\n        screen = function ($gbl, $loc) {\n            $loc.__init__ = new Sk.builtin.func(function (self) {\n\t\t\t\tinitializeTurtlegraphics();\n                var currentCanvas = TurtleGraphics.canvasLib[TurtleGraphics.defaults.canvasID];\n                if (currentCanvas === undefined) {\n                    self.theScreen = new TurtleGraphics.TurtleCanvas(TurtleGraphics.defaults);\n                } else {\n                    self.theScreen = currentCanvas;\n                }\n            });\n            $loc.bgcolor = new Sk.builtin.func(function (self, c) {\n                self.theScreen.bgcolor(c);\n            });\n            $loc.setworldcoordinates = new Sk.builtin.func(function (self, llx, lly, urx, ury) {\n                llx = Sk.builtin.asnum$(llx);\n                lly = Sk.builtin.asnum$(lly);\n                urx = Sk.builtin.asnum$(urx);\n                ury = Sk.builtin.asnum$(ury);\n                self.theScreen.setworldcoordinates(llx, lly, urx, ury);\n            });\n            $loc.exitonclick = new Sk.builtin.func(function (self) {\n                self.theScreen.exitonclick();\n            });\n            $loc.title = new Sk.builtin.func(function (self, titlestring) {});\n            $loc.window_width = new Sk.builtin.func(function (self) {\n                return Sk.builtin.assk$(self.theScreen.window_width(), Sk.builtin.nmber.int$);\n            });\n            $loc.window_height = new Sk.builtin.func(function (self) {\n                return Sk.builtin.assk$(self.theScreen.window_height(), Sk.builtin.nmber.int$);\n            });\n            $loc.turtles = new Sk.builtin.func(function (self) {\n                return self.theScreen.turtles();\n            });\n            $loc.colormode = new Sk.builtin.func(function (self) {});\n            //        $loc.clear = new Sk.builtin.func(function(self) {\n            //\n            //        });\n            var myfunc = function (self, width, height, startx, starty) {\n                width = Sk.builtin.asnum$(width);\n                height = Sk.builtin.asnum$(height);\n                self.theScreen.setup(width, height);\n            };\n            // this should allow for named parameters\n            myfunc.co_varnames = [\n                'self',\n                'width',\n                'height',\n                'startx',\n                'starty'\n            ];\n            myfunc.$defaults = [\n                null,\n                500,\n                500,\n                0,\n                0\n            ];\n            $loc.setup = new Sk.builtin.func(myfunc);\n        };\n    // First we create an object, this will end up being the class\n    // class\n    Sk.tg = TurtleGraphics;\n    mod.Turtle = Sk.misceval.buildClass(mod, turtle, 'Turtle', []);\n    mod.Screen = Sk.misceval.buildClass(mod, screen, 'Screen', []);\n    mod.tracer = new Sk.builtin.func(function (t, d) {\n        var i;\n        t = Sk.builtin.asnum$(t);\n        d = Sk.builtin.asnum$(d);\n        for (i = 0; i < Sk.tg.canvasLib.length; i = i + 1) {\n            Sk.tg.canvasLib[i].tracer(t, d);\n        }\n    });\n    mod.update = new Sk.builtin.func(function (self) {});\n    return mod;\n};\n", "src/lib/van/__init__.js": "//\n// Controller for a van\n//\nfunction VanController() {\n    this.initialize();\n}\nVanController.prototype.initialize = function () {\n\n};\nVanController.prototype.highlightLineCallable = function(lineIndex, colour) {\n    var lines = $('#editor .CodeMirror-code')[0].children;\n    // unhighlight all lines\n    var i;\n    for (i = 0; i < lines.length; i++) {\n        lines[i].style.background = \"\";\n    }\n    // highlight desired line\n    lines[lineIndex].style.background = colour;\n};\nVanController.prototype.queueHighlight = function(colour) {\n    var self = this;\n    var lineIndex = Sk.currLineNo - 1;\n    ocargo.animation.appendAnimation({\n        type: 'callable',\n        functionCall: function () { self.highlightLineCallable(lineIndex, colour); },\n        description: 'highlight python callable',\n    });\n};\n//\n// Movement and condition functions delegated appropriately\n//\nVanController.prototype.move_forwards = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellowgreen\");\n    }\n    Sk.failed = Sk.failed || !ocargo.model.moveForwards();\n};\nVanController.prototype.turn_left = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellowgreen\");\n    }\n    Sk.failed |= Sk.failed || !ocargo.model.turnLeft();\n};\nVanController.prototype.turn_right = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellowgreen\");\n    }\n    Sk.failed = Sk.failed || !ocargo.model.turnRight();\n};\nVanController.prototype.turn_around = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellowgreen\");\n    }\n    Sk.failed = Sk.failed || !ocargo.model.turnAround();\n};\nVanController.prototype.wait = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellowgreen\");\n    }\n    Sk.failed = Sk.failed || !ocargo.model.wait();\n};\nVanController.prototype.deliver = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellowgreen\");\n    }\n    Sk.failed = Sk.failed || !ocargo.model.deliver();\n};\nVanController.prototype.at_dead_end = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        return ocargo.model.isDeadEnd();\n    }\n    return false;\n};\nVanController.prototype.at_destination = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        return ocargo.model.isAtADestination();\n    }\n    return false;\n};\nVanController.prototype.at_traffic_light = function (c) {\n    switch(c) {\n    case \"GREEN\":\n        return this.at_green_traffic_light();\n        break;\n    case \"RED\":\n        return this.at_red_traffic_light();\n        break;\n    default:\n        return false;\n    }\n};\nVanController.prototype.at_red_traffic_light = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        return ocargo.model.isTrafficLightRed();\n    }\n    return false;\n};\nVanController.prototype.at_green_traffic_light = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        return ocargo.model.isTrafficLightGreen();\n    }\n    return false;\n};\nVanController.prototype.is_road = function (d) {\n    switch(d) {\n    case \"FORWARD\":\n        return this.is_road_forward();\n        break;\n    case \"LEFT\":\n        return this.is_road_left();\n        break;\n    case \"RIGHT\":\n        return this.is_road_right();\n        break;\n    default:\n        return false;\n    }\n};\nVanController.prototype.is_road_forward = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        return ocargo.model.isRoadForward();\n    }\n    return false;\n\n};\nVanController.prototype.is_road_left = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        return ocargo.model.isRoadLeft();\n    }\n    return false;\n};\nVanController.prototype.is_road_right = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        return ocargo.model.isRoadRight();\n    }\n    return false;\n};\nVanController.prototype.get_current_coordinate = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        var coordinate = ocargo.model.getCurrentCoordinate();\n        return [coordinate.x, coordinate.y];\n    }\n    return null;\n};\nVanController.prototype.get_previous_coordinate = function () {\n    if (!Sk.failed) {\n        this.queueHighlight(\"yellow\");\n        var coordinate = ocargo.model.getPreviousCoordinate();\n        return [coordinate.x, coordinate.y];\n    }\n    return null;\n};\n\nvar $builtinmodule = function (name) {\n    'use strict';\n    var mod = {},\n        checkArgs = function (expected, actual, func) {\n            if (actual !== expected) {\n                throw new Sk.builtin.TypeError(func + ' takes exactly ' + expected + ' positional argument (' + actual + ' given)');\n            }\n        },\n        van = function ($gbl, $loc) {\n            $loc.__init__ = new Sk.builtin.func(function (self) {\n                self.theVan = new VanController();\n            });\n            //\n            // Van Action/Motion\n            //\n            $loc.move_forwards = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'move_forwards()');\n                self.theVan.move_forwards();\n            });\n            $loc.turn_left = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'turn_left()');\n                self.theVan.turn_left();\n            });\n            $loc.turn_right = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'turn_right()');\n                self.theVan.turn_right();\n            });\n            $loc.turn_around = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'turn_around()');\n                self.theVan.turn_around();\n            });\n            $loc.wait = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'wait()');\n                self.theVan.wait();\n            });\n            $loc.deliver = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'deliver()');\n                self.theVan.deliver();\n            });\n            //\n            // Van state\n            //\n            $loc.at_dead_end = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'at_dead_end()');\n                return Sk.builtin.bool(self.theVan.at_dead_end());\n            });\n            $loc.at_destination = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'at_destination()');\n                return Sk.builtin.bool(self.theVan.at_destination());\n            });\n            $loc.at_traffic_light = new Sk.builtin.func(function (self, c) {\n                checkArgs(2, arguments.length, 'at_traffic_light()');\n                return Sk.builtin.bool(self.theVan.at_traffic_light(new Sk.builtin.str(c).v));\n            });\n            $loc.at_red_traffic_light = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'at_red_traffic_light()');\n                return Sk.builtin.bool(self.theVan.at_red_traffic_light());\n            });\n            $loc.at_green_traffic_light = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'at_green_traffic_light()');\n                return Sk.builtin.bool(self.theVan.at_green_traffic_light());\n            });\n            $loc.is_road = new Sk.builtin.func(function (self, d) {\n                checkArgs(2, arguments.length, 'is_road()');\n                return Sk.builtin.bool(self.theVan.is_road(new Sk.builtin.str(d).v));\n            });\n            $loc.is_road_forward = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'is_road_forward()');\n                return Sk.builtin.bool(self.theVan.is_road_forward());\n            });\n            $loc.is_road_left = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'is_road_left()');\n                return Sk.builtin.bool(self.theVan.is_road_left());\n            });\n            $loc.is_road_right = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'is_road_right()');\n                return Sk.builtin.bool(self.theVan.is_road_right());\n            });\n            $loc.get_current_coordinate = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'get_current_coordinate()');\n                var coordinate = self.theVan.get_current_coordinate();\n                if (coordinate) {\n                    return Sk.builtin.tuple(coordinate);\n                } else {\n                    return Sk.builtin.none;\n                }\n            });\n            $loc.get_previous_coordinate = new Sk.builtin.func(function (self) {\n                checkArgs(1, arguments.length, 'get_previous_coordinate()');\n                var coordinate = self.theVan.get_previous_coordinate();\n                if (coordinate) {\n                    return Sk.builtin.tuple(coordinate);\n                } else {\n                    return Sk.builtin.none;\n                }\n            });\n        };\n\n    mod.Van = Sk.misceval.buildClass(mod, van, 'Van', []);\n\n    return mod;\n};\n", "src/lib/webgl/math.js": "var $builtinmodule = function(name)\n{\n    var mod = {};\n\n    // todo; should probably put this in a math package\n    mod.Mat44 = Sk.misceval.buildClass(mod, function($gbl, $loc)\n            {\n                $loc.__init__ = new Sk.builtin.func(function(self)\n                    {\n                        Sk.misceval.callsim($loc.loadIdentity, self);\n                        self.stack = [];\n                    });\n\n                $loc.push = new Sk.builtin.func(function(self)\n                    {\n                        self.stack.push(self.elements.slice(0));\n                    });\n\n                $loc.pop = new Sk.builtin.func(function(self)\n                    {\n                        self.elements = self.stack.pop();\n                    });\n\n                $loc.loadIdentity = new Sk.builtin.func(function(self)\n                    {\n                        self.elements = [1.0, 0.0, 0.0, 0.0,\n                                         0.0, 1.0, 0.0, 0.0,\n                                         0.0, 0.0, 1.0, 0.0,\n                                         0.0, 0.0, 0.0, 1.0];\n                    });\n\n                $loc.transform3 = new Sk.builtin.func(function(self, v)\n                    {\n                        var e = self.elements;\n                        return Sk.misceval.callsim(mod.Vec3,\n                            e[0] * v.x + e[4] * v.y + e[8] * v.z,\n                            e[1] * v.x + e[5] * v.y + e[9] * v.z,\n                            e[2] * v.x + e[6] * v.y + e[10] * v.z);\n                    });\n\n                $loc.scale = new Sk.builtin.func(function(self, sx, sy, sz)\n                        {\n                            self.elements[0*4+0] *= sx;\n                            self.elements[0*4+1] *= sx;\n                            self.elements[0*4+2] *= sx;\n                            self.elements[0*4+3] *= sx;\n\n                            self.elements[1*4+0] *= sy;\n                            self.elements[1*4+1] *= sy;\n                            self.elements[1*4+2] *= sy;\n                            self.elements[1*4+3] *= sy;\n\n                            self.elements[2*4+0] *= sz;\n                            self.elements[2*4+1] *= sz;\n                            self.elements[2*4+2] *= sz;\n                            self.elements[2*4+3] *= sz;\n\n                            return self;\n                        });\n\n                $loc.translate = new Sk.builtin.func(function(self, tx, ty, tz)\n                        {\n                            self.elements[3*4+0] += self.elements[0*4+0] * tx + self.elements[1*4+0] * ty + self.elements[2*4+0] * tz;\n                            self.elements[3*4+1] += self.elements[0*4+1] * tx + self.elements[1*4+1] * ty + self.elements[2*4+1] * tz;\n                            self.elements[3*4+2] += self.elements[0*4+2] * tx + self.elements[1*4+2] * ty + self.elements[2*4+2] * tz;\n                            self.elements[3*4+3] += self.elements[0*4+3] * tx + self.elements[1*4+3] * ty + self.elements[2*4+3] * tz;\n                            return self;\n                        });\n\n                $loc.rotate = new Sk.builtin.func(function(self, angle, x, y, z)\n                        {\n                            var mag = Math.sqrt(x*x + y*y + z*z);\n                            var sinAngle = Math.sin(angle * Math.PI / 180.0);\n                            var cosAngle = Math.cos(angle * Math.PI / 180.0);\n\n                            if (mag > 0)\n                            {\n                                var xx, yy, zz, xy, yz, zx, xs, ys, zs;\n                                var oneMinusCos;\n                                var rotMat;\n\n                                x /= mag;\n                                y /= mag;\n                                z /= mag;\n\n                                xx = x * x;\n                                yy = y * y;\n                                zz = z * z;\n                                xy = x * y;\n                                yz = y * z;\n                                zx = z * x;\n                                xs = x * sinAngle;\n                                ys = y * sinAngle;\n                                zs = z * sinAngle;\n                                oneMinusCos = 1.0 - cosAngle;\n\n                                rotMat = Sk.misceval.callsim(mod.Mat44);\n\n                                rotMat.elements[0*4+0] = (oneMinusCos * xx) + cosAngle;\n                                rotMat.elements[0*4+1] = (oneMinusCos * xy) - zs;\n                                rotMat.elements[0*4+2] = (oneMinusCos * zx) + ys;\n                                rotMat.elements[0*4+3] = 0.0;\n\n                                rotMat.elements[1*4+0] = (oneMinusCos * xy) + zs;\n                                rotMat.elements[1*4+1] = (oneMinusCos * yy) + cosAngle;\n                                rotMat.elements[1*4+2] = (oneMinusCos * yz) - xs;\n                                rotMat.elements[1*4+3] = 0.0;\n\n                                rotMat.elements[2*4+0] = (oneMinusCos * zx) - ys;\n                                rotMat.elements[2*4+1] = (oneMinusCos * yz) + xs;\n                                rotMat.elements[2*4+2] = (oneMinusCos * zz) + cosAngle;\n                                rotMat.elements[2*4+3] = 0.0;\n\n                                rotMat.elements[3*4+0] = 0.0;\n                                rotMat.elements[3*4+1] = 0.0;\n                                rotMat.elements[3*4+2] = 0.0;\n                                rotMat.elements[3*4+3] = 1.0;\n\n                                rotMat = rotMat.multiply(self);\n                                self.elements = rotMat.elements;\n                            }\n                            return self;\n                        });\n\n                $loc.multiply = new Sk.builtin.func(function(self, right)\n                        {\n                            var tmp = Sk.misceval.callsim(mod.Mat44);\n\n                            for (var i = 0; i < 4; i++)\n                            {\n                                tmp.elements[i*4+0] =\n                                (self.elements[i*4+0] * right.elements[0*4+0]) +\n                                (self.elements[i*4+1] * right.elements[1*4+0]) +\n                                (self.elements[i*4+2] * right.elements[2*4+0]) +\n                                (self.elements[i*4+3] * right.elements[3*4+0]) ;\n\n                                tmp.elements[i*4+1] =\n                                (self.elements[i*4+0] * right.elements[0*4+1]) +\n                                (self.elements[i*4+1] * right.elements[1*4+1]) +\n                                (self.elements[i*4+2] * right.elements[2*4+1]) +\n                                (self.elements[i*4+3] * right.elements[3*4+1]) ;\n\n                                tmp.elements[i*4+2] =\n                                (self.elements[i*4+0] * right.elements[0*4+2]) +\n                                (self.elements[i*4+1] * right.elements[1*4+2]) +\n                                (self.elements[i*4+2] * right.elements[2*4+2]) +\n                                (self.elements[i*4+3] * right.elements[3*4+2]) ;\n\n                                tmp.elements[i*4+3] =\n                                (self.elements[i*4+0] * right.elements[0*4+3]) +\n                                (self.elements[i*4+1] * right.elements[1*4+3]) +\n                                (self.elements[i*4+2] * right.elements[2*4+3]) +\n                                (self.elements[i*4+3] * right.elements[3*4+3]) ;\n                            }\n\n                            self.elements = tmp.elements;\n                            return self;\n                        });\n\n                /* Following gluLookAt implementation is adapted from\n                 * the Mesa 3D Graphics library. http://www.mesa3d.org\n                 */\n                // todo; rewrite this with proper vec/mat ops\n                $loc.lookAt = new Sk.builtin.func(function(self, eyeX, eyeY, eyeZ,\n                                                                 centerX, centerY, centerZ,\n                                                                 upX, upY, upZ)\n                        {\n                            /* Z vector */\n                            var z = [\n                                eyeX - centerX,\n                                eyeY - centerY,\n                                eyeZ - centerZ\n                            ];\n                            var mag = Math.sqrt(z[0] * z[0] + z[1] * z[1] + z[2] * z[2]);\n                            if (mag)\n                            {\n                                z[0] /= mag;\n                                z[1] /= mag;\n                                z[2] /= mag;\n                            }\n\n                            /* Y vector */\n                            var y = [ upX, upY, upZ ];\n\n                            /* X vector = Y cross Z */\n                            var x = [];\n                            x[0] = y[1] * z[2] - y[2] * z[1];\n                            x[1] = -y[0] * z[2] + y[2] * z[0];\n                            x[2] = y[0] * z[1] - y[1] * z[0];\n\n                            /* Recompute Y = Z cross X */\n                            y[0] = z[1] * x[2] - z[2] * x[1];\n                            y[1] = -z[0] * x[2] + z[2] * x[0];\n                            y[2] = z[0] * x[1] - z[1] * x[0];\n\n                            /* mpichler, 19950515 */\n                            /* cross product gives area of parallelogram, which is < 1.0 for\n                            * non-perpendicular unit-length vectors; so normalize x, y here\n                            */\n\n                            mag = Math.sqrt(x[0] * x[0] + x[1] * x[1] + x[2] * x[2]);\n                            if (mag) {\n                                x[0] /= mag;\n                                x[1] /= mag;\n                                x[2] /= mag;\n                            }\n\n                            mag = Math.sqrt(y[0] * y[0] + y[1] * y[1] + y[2] * y[2]);\n                            if (mag) {\n                                y[0] /= mag;\n                                y[1] /= mag;\n                                y[2] /= mag;\n                            }\n\n                            var lookAt = Sk.misceval.callsim(mod.Mat44);\n                            lookAt.elements[0 * 4 + 0] = x[0];\n                            lookAt.elements[1 * 4 + 0] = x[1];\n                            lookAt.elements[2 * 4 + 0] = x[2];\n                            lookAt.elements[3 * 4 + 0] = 0.;\n                            lookAt.elements[0 * 4 + 1] = y[0];\n                            lookAt.elements[1 * 4 + 1] = y[1];\n                            lookAt.elements[2 * 4 + 1] = y[2];\n                            lookAt.elements[3 * 4 + 1] = 0.;\n                            lookAt.elements[0 * 4 + 2] = z[0];\n                            lookAt.elements[1 * 4 + 2] = z[1];\n                            lookAt.elements[2 * 4 + 2] = z[2];\n                            lookAt.elements[3 * 4 + 2] = 0.;\n                            lookAt.elements[0 * 4 + 3] = 0.;\n                            lookAt.elements[1 * 4 + 3] = 0.;\n                            lookAt.elements[2 * 4 + 3] = 0.;\n                            lookAt.elements[3 * 4 + 3] = 1.;\n\n                            // log(lookAt.elements);\n\n                            lookAt = lookAt.multiply(self);\n                            self.elements = lookAt.elements;\n                            self.translate(-eyeX, -eyeY, -eyeZ);\n\n                            // log(this.elements);\n\n                            return self;\n                        });\n            },\n            'Mat44', []);\n\n    // todo; should probably put this in a math package\n    mod.Mat33 = Sk.misceval.buildClass(mod, function($gbl, $loc)\n            {\n                $loc.__init__ = new Sk.builtin.func(function(self)\n                    {\n                        Sk.misceval.callsim($loc.loadIdentity, self);\n                    });\n\n                $loc.loadIdentity = new Sk.builtin.func(function(self)\n                    {\n                        self.elements = [1.0, 0.0, 0.0,\n                                         0.0, 1.0, 0.0,\n                                         0.0, 0.0, 1.0];\n                    });\n            },\n            'Mat33', []);\n\n    mod.Vec3 = Sk.misceval.buildClass(mod, function($gbl, $loc)\n            {\n                $loc.__init__ = new Sk.builtin.func(function(self, x, y, z)\n                    {\n                        self.x = x;\n                        self.y = y;\n                        self.z = z;\n                    });\n                $loc.__sub__ = new Sk.builtin.func(function(self, other)\n                    {\n                        return Sk.misceval.callsim(mod.Vec3, self.x - other.x, self.y - other.y, self.z - other.z);\n                    });\n            },\n            'Vec3', []);\n    \n    mod.cross = new Sk.builtin.func(function(v1, v2)\n            {\n                goog.asserts.assert(v1 instanceof mod.Vec3 && v2 instanceof mod.Vec3);\n                return Sk.misceval.callsim(mod.Vec3,\n                    v1.y * v2.z - v1.z * v2.y,\n                    v1.z * v2.x - v1.x * v2.z,\n                    v1.x * v2.y - v1.y * v2.x);\n            });\n\n    return mod;\n};\n", "src/lib/pythonds/graphs/__init__.py": "\n\nfrom .adjGraph import Graph\nfrom .adjGraph import Vertex\nfrom .priorityQueue import PriorityQueue\n", "src/lib/pythonds/graphs/priorityQueue.py": "# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005\n# \nimport unittest\n\n# this implementation of binary heap takes key value pairs,\n# we will assume that the keys are all comparable\n\nclass PriorityQueue:\n    def __init__(self):\n        self.heapArray = [(0,0)]\n        self.currentSize = 0\n\n    def buildHeap(self,alist):\n        self.currentSize = len(alist)\n        self.heapArray = [(0,0)]\n        for i in alist:\n            self.heapArray.append(i)\n        i = len(alist) // 2            \n        while (i > 0):\n            self.percDown(i)\n            i = i - 1\n                        \n    def percDown(self,i):\n        while (i * 2) <= self.currentSize:\n            mc = self.minChild(i)\n            if self.heapArray[i][0] > self.heapArray[mc][0]:\n                tmp = self.heapArray[i]\n                self.heapArray[i] = self.heapArray[mc]\n                self.heapArray[mc] = tmp\n            i = mc\n                \n    def minChild(self,i):\n        if i*2 > self.currentSize:\n            return -1\n        else:\n            if i*2 + 1 > self.currentSize:\n                return i*2\n            else:\n                if self.heapArray[i*2][0] < self.heapArray[i*2+1][0]:\n                    return i*2\n                else:\n                    return i*2+1\n\n    def percUp(self,i):\n        while i // 2 > 0:\n            if self.heapArray[i][0] < self.heapArray[i//2][0]:\n               tmp = self.heapArray[i//2]\n               self.heapArray[i//2] = self.heapArray[i]\n               self.heapArray[i] = tmp\n            i = i//2\n \n    def add(self,k):\n        self.heapArray.append(k)\n        self.currentSize = self.currentSize + 1\n        self.percUp(self.currentSize)\n\n    def delMin(self):\n        retval = self.heapArray[1][1]\n        self.heapArray[1] = self.heapArray[self.currentSize]\n        self.currentSize = self.currentSize - 1\n        self.heapArray.pop()\n        self.percDown(1)\n        return retval\n        \n    def isEmpty(self):\n        if self.currentSize == 0:\n            return True\n        else:\n            return False\n\n    def decreaseKey(self,val,amt):\n        # this is a little wierd, but we need to find the heap thing to decrease by\n        # looking at its value\n        done = False\n        i = 1\n        myKey = 0\n        while not done and i <= self.currentSize:\n            if self.heapArray[i][1] == val:\n                done = True\n                myKey = i\n            else:\n                i = i + 1\n        if myKey > 0:\n            self.heapArray[myKey] = (amt,self.heapArray[myKey][1])\n            self.percUp(myKey)\n            \n    def __contains__(self,vtx):\n        for pair in self.heapArray:\n            if pair[1] == vtx:\n                return True\n        return False\n        \nclass TestBinHeap(unittest.TestCase):\n    def setUp(self):\n        self.theHeap = PriorityQueue()\n        self.theHeap.add((2,'x'))\n        self.theHeap.add((3,'y'))\n        self.theHeap.add((5,'z'))\n        self.theHeap.add((6,'a'))\n        self.theHeap.add((4,'d'))\n\n\n    def testInsert(self):\n        assert self.theHeap.currentSize == 5\n\n    def testDelmin(self):\n        assert self.theHeap.delMin() == 'x'\n        assert self.theHeap.delMin() == 'y'\n    \n    def testDecKey(self):\n        self.theHeap.decreaseKey('d',1)\n        assert self.theHeap.delMin() == 'd'\n        \nif __name__ == '__main__':\n    unittest.main()\n", "src/lib/pythonds/__init__.py": "", "src/lib/pythonds/basic/deque.py": "# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005\n# \n#deque.py\n\n\nclass Deque:\n    def __init__(self):\n        self.items = []\n\n    def isEmpty(self):\n        return self.items == []\n\n    def addFront(self, item):\n        self.items.append(item)\n\n    def addRear(self, item):\n        self.items.insert(0,item)\n\n    def removeFront(self):\n        return self.items.pop()\n\n    def removeRear(self):\n        return self.items.pop(0)\n\n    def size(self):\n        return len(self.items)\n", "src/lib/processing/__init__.js": "var $builtinmodule = function(name)\n{\n    var mod = {};\n    var imList = [];\n    var looping = true;\n\n    // We need this to store a reference to the actual processing object which is not created\n    // until the run function is called.  Even then the processing object is passed by the\n    // processing-js sytem as a parameter to the sketchProc function.  Why not set it to None here\n    //\n\n    // See:  http://processingjs.org/reference/\n\n    mod.processing = null\n    mod.p = null\n\n    mod.CENTER = Sk.builtin.assk$(3, Sk.builtin.nmber.int$);\n    mod.RADIUS = Sk.builtin.assk$(2, Sk.builtin.nmber.int$);\n    mod.CORNERS = Sk.builtin.assk$(1, Sk.builtin.nmber.int$);\n    mod.CORNER = Sk.builtin.assk$(0, Sk.builtin.nmber.int$);\n    mod.RGB = Sk.builtin.assk$(1, Sk.builtin.nmber.int$);\n    mod.HSB = Sk.builtin.assk$(3, Sk.builtin.nmber.int$);\n    mod.CMYK = Sk.builtin.assk$(5, Sk.builtin.nmber.int$);\n    mod.MITER = new Sk.builtin.str('miter');\n    mod.BEVEL = new Sk.builtin.str('bevel');\n    mod.ROUND = new Sk.builtin.str('round');\n    mod.SQUARE = new Sk.builtin.str('butt');\n    mod.PROJECT = new Sk.builtin.str('square');\n\n// 2D - Primitives\n    mod.line = new Sk.builtin.func(function(x1, y1, x2, y2) {\n        mod.processing.line(x1.v, y1.v, x2.v, y2.v);\n    });\n    \n    mod.ellipse = new Sk.builtin.func(function(x,y,r1,r2) {\n        mod.processing.ellipse(x.v,y.v,r1.v,r2.v)\n        \n    });\n\n    mod.text = new Sk.builtin.func(function(theText, x, y) {\n        mod.processing.text(theText.v, x.v, y.v);\n    });\n\n    mod.point = new Sk.builtin.func(function(x1,y1) {\n        mod.processing.point(x1.v,y1.v)\n    });\n        \n    mod.arc = new Sk.builtin.func(function(x, y, width, height, start, stop) {\n        mod.processing.arc(x.v, y.v, width.v, height.v, start.v, stop.v)\n    });\n\n    mod.quad = new Sk.builtin.func(function(x1, y1, x2, y2, x3, y3, x4, y4) {\n        mod.processing.quad(x1.v, y1.v, x2.v, y2.v, x3.v, y3.v, x4.v, y4.v)\n    });\n            \n    mod.rect = new Sk.builtin.func(function(x, y, width, height, radius) {\n        if (typeof(radius) == 'undefined') {\n            var rad = 0\n        } else {\n            var rad = radius.v\n        }\n        mod.processing.rect(x.v, y.v, width.v, height.v, rad)\n    });\n    \n    mod.triangle = new Sk.builtin.func(function(x1, y1, x2, y2, x3, y3) {\n            mod.processing.triangle(x1.v, y1.v, x2.v, y2.v, x3.v, y3.v)\n        });\n            \n\n    // 3D Primitives\n\n    // todo:  box, sphere, sphereDetail\n\n    // Color\n    mod.background = new Sk.builtin.func(function(r,g,b) {\n\n        if (typeof(g) !== 'undefined')\n            g = g.v\n        if (typeof(b) !== 'undefined')\n            b = b.v\n\n        mod.processing.background(r.v,g,b)\n        \n    });\n\n    mod.fill = new Sk.builtin.func(function(r,g,b) {\n        // r will be either:\n        //      a number in which case the fill will be grayscale\n        //      a color object\n        // g, and b may be undefined.  If they hold values it will\n        // be assumed that we have an r,g,b color tuple\n        if (typeof(g) !== 'undefined')\n            g = g.v\n        if (typeof(b) !== 'undefined')\n            b = b.v\n    \n        mod.processing.fill(r.v,g,b)\n        \n    });\n\n\n    mod.stroke = new Sk.builtin.func(function(r,g,b) {\n\n        if (typeof(g) !== 'undefined')\n            g = g.v\n        if (typeof(b) !== 'undefined')\n            b = b.v\n\n        mod.processing.stroke(r.v,g,b)\n        \n    });\n\n    mod.noStroke = new Sk.builtin.func(function() {\n        mod.processing.noStroke()\n    });\n    \n\n    mod.colorMode = new Sk.builtin.func(function(model, maxV) {\n        if (typeof(maxV) === 'undefined')\n            maxV = 255\n        else\n            maxV = maxV.v\n        mod.processing.colorMode(model.v, maxV)\n    });\n\n    mod.noFill = new Sk.builtin.func(function() {\n            mod.processing.noFill()\n        });\n            \n\n    // Environment\n\n    mod.loop = new Sk.builtin.func(function() {\n            if (mod.processing === null) {\n                throw new Sk.builtin.Exception(\"Loop should be called in setup\")\n            }\n            looping = true;\n            mod.processing.loop()\n        });\n            \n    mod.noLoop = new Sk.builtin.func(function() {\n        if (mod.processing === null) {\n            throw new Sk.builtin.Exception(\"noLoop should be called in setup\")\n        }\n        looping = false;\n        mod.processing.noLoop()\n    });\n    \n    mod.frameRate = new Sk.builtin.func(function(fr) {\n        mod.processing.frameRate(fr.v)\n        \n    });\n\n    mod.size = new Sk.builtin.func(function(h,w) {\n        mod.processing.size(h.v,w.v)\n        \n    });\n\n    mod.exitp = new Sk.builtin.func(function(h,w) {\n        mod.processing.exit()\n    });\n\n\n    mod.mouseX = new Sk.builtin.func(function() {\n        return Sk.builtin.assk$(mod.processing.mouseX, Sk.builtin.nmber.int$);\n        \n    });\n\n    mod.mouseY = new Sk.builtin.func(function() {\n        return Sk.builtin.assk$(mod.processing.mouseY, Sk.builtin.nmber.int$);\n        \n    });\n\n    // Attributes\n    mod.rectMode = new Sk.builtin.func(function(mode) {\n        mod.processing.rectMode(mode.v)\n    });\n\n    mod.strokeWeight = new Sk.builtin.func(function(wt) {\n        mod.processing.strokeWeight(wt.v)\n        \n    });\n\n    mod.smooth = new Sk.builtin.func(function() {\n        mod.processing.smooth()\n    });\n\n    mod.noSmooth = new Sk.builtin.func(function() {\n        mod.processing.noSmooth()\n        });\n            \n    mod.ellipseMode = new Sk.builtin.func(function(mode) {\n        mod.processing.ellipseMode(mode.v)\n        });\n\n    mod.strokeCap = new Sk.builtin.func(function(mode) {\n        mod.processing.strokeCap(mode.v)\n        });\n\n    mod.strokeJoin = new Sk.builtin.func(function(mode) {\n        mod.processing.strokeJoin(mode.v)\n    });\n    \n\n\n    // Transforms\n\n    mod.rotate = new Sk.builtin.func(function(rads) {\n        // rotation in radians\n        mod.processing.rotate(rads.v)\n        \n    });\n\n    mod.scale = new Sk.builtin.func(function(sx, sy, sz) {\n        if (typeof(sy) == 'undefined') {\n            sy = 1.0\n        } else \n            sy = sy.v\n        if (typeof(sz) == 'undefined') {\n            sz = 1.0\n        } else\n            sz = sz.v\n        mod.processing.scale(sx.v, sy, sz)\n    });\n\n    mod.translate = new Sk.builtin.func(function(sx, sy, sz) {\n        if (typeof(sy) == 'undefined') {\n            sy = 1.0\n        } else \n            sy = sy.v\n        if (typeof(sz) == 'undefined') {\n            sz = 1.0\n        } else\n            sz = sz.v\n        mod.processing.translate(sx.v, sy, sz)\n    });\n\n    // todo:  applyMatrix, popMatrix, printMatrix??, pushMatrix, resetMatrix, rotate{X,Y,Z}\n    \n\n    //  //////////////////////////////////////////////////////////////////////\n    //  Run\n    // \n    //  Create the processing context and setup of calls to setup, draw etc.\n    //\n    //\n    //  //////////////////////////////////////////////////////////////////////    \n    mod.run = new Sk.builtin.func(function() {\n        function sketchProc(processing) {\n            mod.processing = processing\n\n            // processing.setup = function() {\n            //     if Sk.globals['setup']\n            //         Sk.misceval.callsim(Sk.globals['setup'])\n            // }\n\n            \n            processing.draw = function() {\n                // if there are pending image loads then just use the natural looping calls to \n                // retry until all the images are loaded.  If noLoop was called in setup then make\n                // sure to revert to that after all the images in hand.\n                var wait = false\n                for (var i in imList) {\n                    if (imList[i].width == 0) {\n                        wait = true\n                    }\n                }\n                if (wait == true) {\n                    if (looping == true) \n                        return\n                    else {\n                        processing.loop()\n                        return\n                    }\n\n                } else {\n                    if (looping == false)\n                        processing.noLoop()\n                }\n\n                mod.frameCount = processing.frameCount  \n                if (Sk.globals['draw'])\n                    Sk.misceval.callsim(Sk.globals['draw'])\n            }\n            \n            var callBacks = ['setup', 'mouseMoved','mouseClicked', 'mouseDragged', 'mouseMoved', 'mouseOut',\n             'mouseOver', 'mousePressed', 'mouseReleased', 'keyPressed', 'keyReleased', 'keyTyped'\n             ];\n\n             for(var cb in callBacks) {\n                if (Sk.globals[callBacks[cb]]) {\n                    console.log('defining ' + callBacks[cb])                    \n                    processing[callBacks[cb]] = new Function(\"Sk.misceval.callsim(Sk.globals['\"+callBacks[cb]+\"']);\")\n                }\n            }\n        }\n        \n        var canvas = document.getElementById(Sk.canvas)\n        $(canvas).show()\n        mod.p = new Processing(canvas, sketchProc)\n\n        \n    });\n\n    var mouseClass = function($gbl, $loc) {\n\n        $loc.__getattr__ = new Sk.builtin.func(function(self,key) {\n            if (key == 'x') \n                return mod.processing.mouseX;\n            else if (key == 'y') \n                return mod.processing.mouseY;\n            else if (key == 'px')\n                return mod.processing.pmouseX;\n            else if (key == 'py')\n                return mod.processing.pmouseY;\n            else if (key == 'pressed')\n                return mod.processing.mousePressed;\n            else if (key == 'button')\n                return mod.processing.mouseButton\n        });\n\n\n    }\n\n\n    mod.Mouse = Sk.misceval.buildClass(mod, mouseClass, 'Mouse', []);\n\n    mod.mouse = Sk.misceval.callsim(mod.Mouse)\n\n    var keyboardClass = function($gbl, $loc) {\n\n        $loc.__getattr__ = new Sk.builtin.func(function(self,key) {\n            if (key == 'key') {\n                console.log(mod.processing.key)\n                return new Sk.builtin.str(mod.processing.key.toString())\n            }\n            else if (key == 'keyCode') \n                return mod.processing.keyCode\n            else if (key == 'keyPressed')\n                return new Sk.builtin.str(mod.processing.keyPressed) // todo bool\n        });\n\n\n    }\n\n    mod.Keyboard = Sk.misceval.buildClass(mod,keyboardClass,'Keyboard', [])\n\n    mod.keyboard = Sk.misceval.callsim(mod.Keyboard)\n\n\n\n    var environmentClass = function($gbl, $loc) {\n\n        $loc.__getattr__ = new Sk.builtin.func(function(self,key) {\n            if (key == 'frameCount') \n                return mod.processing.frameCount\n            else if (key == 'frameRate') \n                return mod.processing.frameRate\n            else if (key == 'height')\n                return mod.processing.height\n            else if (key == 'width')\n                return mod.processing.width\n            else if (key == 'online')\n                return mod.processing.online\n            else if (key == 'focused')\n                return mod.processing.focused\n        });\n\n\n    }\n\n    mod.Environment = Sk.misceval.buildClass(mod,environmentClass,'Environment', [])\n\n    mod.environment = Sk.misceval.callsim(mod.Environment)\n\n    var screenClass = function($gbl, $loc) {\n\n        $loc.__init__ = new Sk.builtin.func(function(self) {\n            self.pixels = null;\n        });\n\n        $loc.__getattr__ = new Sk.builtin.func(function(self,key) {\n            if (key == 'height')\n                return mod.processing.height\n            else if (key == 'width')\n                return mod.processing.width\n            else if (key == 'pixels')\n                if (self.pixels == null) {\n                    self.pixels = new Sk.builtin.list(mod.processing.pixels.toArray())\n                }\n                return self.pixels\n        });\n\n    }\n\n    mod.Screen = Sk.misceval.buildClass(mod,screenClass,'Screen', [])\n\n    mod.screen = Sk.misceval.callsim(mod.Screen)\n\n    mod.loadPixels = new Sk.builtin.func(function() {\n        mod.processing.loadPixels()\n        console.log(mod.processing.pixels)\n    });\n    \n\n    var colorClass = function($gbl, $loc) {\n        /* images are loaded async.. so its best to preload them */\n        $loc.__init__ = new Sk.builtin.func(function(self, val1, val2, val3, alpha) {\n            if (typeof(val2) !== 'undefined')\n                val2 = val2.v\n            if (typeof(val3) !== 'undefined')\n                val3 = val3.v\n            if (typeof(alpha) !== 'undefined')\n                alpha = alpha.v\n            self.v = mod.processing.color(val1.v, val2, val3, alpha)\n        })\n    \n    }\n\n    mod.color = Sk.misceval.buildClass(mod,colorClass,'color', [])\n\n    mod.red = new Sk.builtin.func(function(clr) {\n        return Sk.builtin.assk$(mod.processing.red(clr.v), Sk.builtin.nmber.int$);\n    });\n    \n    mod.green = new Sk.builtin.func(function(clr) {\n        return Sk.builtin.assk$(mod.processing.green(clr.v), Sk.builtin.nmber.int$);\n    });\n\n    mod.blue = new Sk.builtin.func(function(clr) {\n        return Sk.builtin.assk$(mod.processing.blue(clr.v), Sk.builtin.nmber.int$);\n    });\n\n    // Image class and functions\n    //\n    var imageClass = function($gbl, $loc) {\n        /* images are loaded async.. so its best to preload them */\n        $loc.__init__ = new Sk.builtin.func(function(self,im) {\n            self.v = im\n            self.width = Sk.builtin.assk$(im.width, Sk.builtin.nmber.int$);\n            self.height = Sk.builtin.assk$(im.height, Sk.builtin.nmber.int$);\n        })\n\n        $loc.__getattr__ = new Sk.builtin.func(function(self,key) {\n            if (key == 'width') return self.v.width;\n            if (key == 'height') return self.v.height;\n        });\n    \n    }\n\n    mod.PImage = Sk.misceval.buildClass(mod,imageClass,'PImage', [])\n\n    mod.loadImage = new Sk.builtin.func(function(imfile) {\n        var i = mod.processing.loadImage(imfile.v);\n        imList.push(i);\n        return Sk.misceval.callsim(mod.PImage,i);\n    });\n    \n\n    mod.image = new Sk.builtin.func(function(im,x,y) {\n        if (im.v.width > 0)\n            mod.processing.image(im.v,x.v,y.v,im.v.width,im.v.height)\n    });\n\n    mod.get = new Sk.builtin.func(function(x,y) {\n        var clr = mod.processing.get(x.v,y.v)\n        return Sk.misceval.callsim(mod.color,\n            Sk.builtin.assk$(mod.processing.red(clr), Sk.builtin.nmber.int$),\n            Sk.builtin.assk$(mod.processing.green(clr), Sk.builtin.nmber.int$),\n            Sk.builtin.assk$(mod.processing.blue(clr), Sk.builtin.nmber.int$));\n    });\n\n    mod.set = new Sk.builtin.func(function(x, y, color) {\n        mod.processing.set(x.v, y.v, color.v)\n    });\n    \n// todo  -- add a color class for creating color objects.\n\n\n    return mod;\n}\n", "src/lib/webgl/models.js": "// most of this file is from/based on 'tdl'\n\nvar $builtinmodule = function(name)\n{\n    var mod = {};\n\n    var Buffer = function(array, opt_target) {\n        var target = opt_target || gl.ARRAY_BUFFER;\n        var buf = gl.createBuffer();\n        this.target = target;\n        this.buf = buf;\n        this.set(array);\n        this.numComponents_ = array.numComponents;\n        this.numElements_ = array.numElements;\n        this.totalComponents_ = this.numComponents_ * this.numElements_;\n        if (array.buffer instanceof Float32Array) {\n            this.type_ = gl.FLOAT;\n        } else if (array.buffer instanceof Uint8Array) {\n            this.type_ = gl.UNSIGNED_BYTE;\n        } else if (array.buffer instanceof Int8Array) {\n            this.type_ = gl._BYTE;\n        } else if (array.buffer instanceof Uint16Array) {\n            this.type_ = gl.UNSIGNED_SHORT;\n        } else if (array.buffer instanceof Int16Array) {\n            this.type_ = gl.SHORT;\n        } else {\n            throw(\"unhandled type:\" + (typeof array.buffer));\n        }\n    };\n\n    Buffer.prototype.set = function(array) {\n        gl.bindBuffer(this.target, this.buf);\n        gl.bufferData(this.target, array.buffer, gl.STATIC_DRAW);\n    }\n\n    Buffer.prototype.type = function() {\n        return this.type_;\n    };\n\n    Buffer.prototype.numComponents = function() {\n        return this.numComponents_;\n    };\n\n    Buffer.prototype.numElements = function() {\n        return this.numElements_;\n    };\n\n    Buffer.prototype.totalComponents = function() {\n        return this.totalComponents_;\n    };\n\n    Buffer.prototype.buffer = function() {\n        return this.buf;\n    };\n\n    Buffer.prototype.stride = function() {\n        return 0;\n    };\n\n    Buffer.prototype.offset = function() {\n        return 0;\n    };\n\n\n\n    mod.Model = Sk.misceval.buildClass(mod, function($gbl, $loc)\n            {\n                $loc.__init__ = new Sk.builtin.func(function(self, shader, arrays, textures)\n                    {\n                        self.buffers = {};\n                        var setBuffer = function(name, array)\n                        {\n                            var target = (name == 'indices') ? gl.ELEMENT_ARRAY_BUFFER : gl.ARRAY_BUFFER;\n                            b = self.buffers[name];\n                            if (!b)\n                                b = new Buffer(array, target);\n                            else\n                                b.set(array);\n                            self.buffers[name] = b;\n                        };\n                        for (name in arrays)\n                            setBuffer(name, arrays[name]);\n\n                        var textureUnits = {};\n                        var unit = 0;\n                        for (var texture in textures)\n                        {\n                            textureUnits[texture] = unit++;\n                        }\n\n                        self.mode = gl.TRIANGLES;\n                        self.textures = textures.v;\n                        self.textureUnits = textureUnits;\n                        self.shader = shader;\n                    });\n\n                /**\n                * Sets up the shared parts of drawing this model. Uses the\n                * program, binds the buffers, sets the textures.\n                *\n                * @param {!Object.<string, *>} uniforms An object of names to\n                *     values to set on this models uniforms.\n                */\n                $loc.drawPrep = new Sk.builtin.func(function(self, uniforms)\n                    {\n                        var shader = self.shader;\n                        var buffers = self.buffers;\n                        var textures = self.textures;\n\n                        uniforms = Sk.ffi.remapToJs(uniforms);\n\n                        Sk.misceval.callsim(shader.use, shader);\n\n                        for (var buffer in buffers) {\n                            var b = buffers[buffer];\n                            if (buffer == 'indices') {\n                                gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, b.buffer());\n                            } else {\n                                var attrib = shader.attrib[buffer];\n                                if (attrib) {\n                                    attrib(b);\n                                }\n                            }\n                        }\n\n                        for (var texture in textures) {\n                            var unit = self.textureUnits[texture];\n                            shader.setUniform$impl(shader, textuer, unit);\n                            textures[texture].bindToUnit(unit);\n                        }\n\n                        for (var uniform in uniforms) {\n                            shader.setUniform$impl(shader, uniform, uniforms[uniform]);\n                        }\n                    });\n\n                /**\n                * Draws this model.\n                *\n                * After calling tdl.models.Model.drawPrep you can call this\n                * function multiple times to draw this model.\n                *\n                * @param {!Object.<string, *>} uniforms An object of names to\n                *     values to set on this models uniforms.\n                */\n                $loc.draw = new Sk.builtin.func(function(self, uniforms, opt_textures)\n                    {\n                        var shader = self.shader;\n                        uniforms = Sk.ffi.remapToJs(uniforms);\n                        for (uniform in uniforms) {\n                            shader.setUniform$impl(shader, uniform, uniforms[uniform]);\n                        }\n\n                        if (opt_textures) {\n                            for (var texture in opt_textures) {\n                                var unit = self.textureUnits[texture];\n                                shader.setUniform$impl(shader, texture, unit);\n                                opt_textures[texture].bindToUnit(unit);\n                            }\n                        }\n\n                        var buffers = self.buffers;\n                        gl.drawElements(self.mode, buffers.indices.totalComponents(), gl.UNSIGNED_SHORT, 0);\n                    });\n            },\n            'Model', []);\n\n    return mod;\n};\n", "src/lib/pythonds/trees/__init__.py": "\n# from .binaryTree import BinaryTree\n# from .balance import AVLTree\n# from .bst import BinarySearchTree\n# from .binheap import BinHeap\n\n\n", "src/lib/pythonds/trees/binaryTree.py": "# Bradley N. Miller, David L. Ranum\n# Introduction to Data Structures and Algorithms in Python\n# Copyright 2005\n# \n\nclass BinaryTree:\n    \"\"\"\n    A recursive implementation of Binary Tree\n    Using links and Nodes approach.\n    \"\"\"    \n    def __init__(self,rootObj):\n        self.key = rootObj\n        self.leftChild = None\n        self.rightChild = None\n\n    def insertLeft(self,newNode):\n        if self.leftChild == None:\n            self.leftChild = BinaryTree(newNode)\n        else:\n            t = BinaryTree(newNode)\n            t.left = self.leftChild\n            self.leftChild = t\n    \n    def insertRight(self,newNode):\n        if self.rightChild == None:\n            self.rightChild = BinaryTree(newNode)\n        else:\n            t = BinaryTree(newNode)\n            t.right = self.rightChild\n            self.rightChild = t\n\n    def isLeaf(self):\n        return ((not self.leftChild) and (not self.rightChild))\n\n    def getRightChild(self):\n        return self.rightChild\n\n    def getLeftChild(self):\n        return self.leftChild\n\n    def setRootVal(self,obj):\n        self.key = obj\n\n    def getRootVal(self,):\n        return self.key\n\n    def inorder(self):\n        if self.leftChild:\n            self.leftChild.inorder()\n        print(self.key)\n        if self.rightChild:\n            self.rightChild.inorder()\n\n    def postorder(self):\n        if self.leftChild:\n            self.leftChild.postorder()\n        if self.rightChild:\n            self.rightChild.postorder()\n        print(self.key)\n\n\n    def preorder(self):\n        print(self.key)\n        if self.leftChild:\n            self.leftChild.preorder()\n        if self.rightChild:\n            self.rightChild.preorder()\n\n    def printexp(self):\n        if self.leftChild:\n            print('(')\n            self.leftChild.printexp()\n        print(self.key)\n        if self.rightChild:\n            self.rightChild.printexp()\n            print(')')\n\n    def postordereval(self):\n        opers = {'+':operator.add, '-':operator.sub, '*':operator.mul, '/':operator.truediv}\n        res1 = None\n        res2 = None\n        if self.leftChild:\n            res1 = self.leftChild.postordereval()  #// \\label{peleft}\n        if self.rightChild:\n            res2 = self.rightChild.postordereval() #// \\label{peright}\n        if res1 and res2:\n            return opers[self.key](res1,res2) #// \\label{peeval}\n        else:\n            return self.key\n\ndef inorder(tree):\n    if tree != None:\n        inorder(tree.getLeftChild())\n        print(tree.getRootVal())\n        inorder(tree.getRightChild())\n\ndef printexp(tree):\n    if tree.leftChild:\n        print('(')\n        printexp(tree.getLeftChild())\n    print(tree.getRootVal())\n    if tree.rightChild:\n        printexp(tree.getRightChild())\n        print(')') \n\ndef printexp(tree):\n    sVal = \"\"\n    if tree:\n        sVal = '(' + printexp(tree.getLeftChild())\n        sVal = sVal + str(tree.getRootVal())\n        sVal = sVal + printexp(tree.getRightChild()) + ')'\n    return sVal\n\ndef postordereval(tree):\n    opers = {'+':operator.add, '-':operator.sub, '*':operator.mul, '/':operator.truediv}\n    res1 = None\n    res2 = None\n    if tree:\n        res1 = postordereval(tree.getLeftChild())  #// \\label{peleft}\n        res2 = postordereval(tree.getRightChild()) #// \\label{peright}\n        if res1 and res2:\n            return opers[tree.getRootVal()](res1,res2) #// \\label{peeval}\n        else:\n            return tree.getRootVal()\n\ndef height(tree):\n    if tree == None:\n        return -1\n    else:\n        return 1 + max(height(tree.leftChild),height(tree.rightChild))\n\n# t = BinaryTree(7)\n# t.insertLeft(3)\n# t.insertRight(9)\n# inorder(t)\n# import operator\n# x = BinaryTree('*')\n# x.insertLeft('+')\n# l = x.getLeftChild()\n# l.insertLeft(4)\n# l.insertRight(5)\n# x.insertRight(7)\n# print(printexp(x))\n# print(postordereval(x))\n# print(height(x))\n", "src/builtin/this.py": "s = \"\"\"Gur Mra bs Clguba, ol Gvz Crgref\n\nOrnhgvshy vf orggre guna htyl.\nRkcyvpvg vf orggre guna vzcyvpvg.\nFvzcyr vf orggre guna pbzcyrk.\nPbzcyrk vf orggre guna pbzcyvpngrq.\nSyng vf orggre guna arfgrq.\nFcnefr vf orggre guna qrafr.\nErnqnovyvgl pbhagf.\nFcrpvny pnfrf nera'g fcrpvny rabhtu gb oernx gur ehyrf.\nNygubhtu cenpgvpnyvgl orngf chevgl.\nReebef fubhyq arire cnff fvyragyl.\nHayrff rkcyvpvgyl fvyraprq.\nVa gur snpr bs nzovthvgl, ershfr gur grzcgngvba gb thrff.\nGurer fubhyq or bar-- naq cersrenoyl bayl bar --boivbhf jnl gb qb vg.\nNygubhtu gung jnl znl abg or boivbhf ng svefg hayrff lbh'er Qhgpu.\nAbj vf orggre guna arire.\nNygubhtu arire vf bsgra orggre guna *evtug* abj.\nVs gur vzcyrzragngvba vf uneq gb rkcynva, vg'f n onq vqrn.\nVs gur vzcyrzragngvba vf rnfl gb rkcynva, vg znl or n tbbq vqrn.\nAnzrfcnprf ner bar ubaxvat terng vqrn -- yrg'f qb zber bs gubfr!\"\"\"\n\nd = {}\nfor c in (65, 97):\n    for i in range(26):\n        d[chr(i+c)] = chr((i+13) % 26 + c)\n\nprint \"\".join([d.get(c, c) for c in s])\n", "src/lib/webgl/primitives.js": "// most of this file is from 'tdl'\n\nvar $builtinmodule = function(name)\n{\n    var mod = {};\n\n\n\n    /**\n     * AttribBuffer manages a TypedArray as an array of vectors.\n     *\n     * @param {number} numComponents Number of components per\n     *     vector.\n     * @param {number|!Array.<number>} numElements Number of vectors or the data.\n     * @param {string} opt_type The type of the TypedArray to\n     *     create. Default = 'Float32Array'.\n     * @param {!Array.<number>} opt_data The data for the array.\n     */\n    var AttribBuffer = function(\n            numComponents, numElements, opt_type) {\n        opt_type = opt_type || 'Float32Array';\n        var type = window[opt_type];\n        if (numElements.length) {\n            this.buffer = new type(numElements);\n            numElements = this.buffer.length / numComponents;\n            this.cursor = numElements;\n        } else {\n            this.buffer = new type(numComponents * numElements);\n            this.cursor = 0;\n        }\n        this.numComponents = numComponents;\n        this.numElements = numElements;\n        this.type = opt_type;\n    };\n\n    AttribBuffer.prototype.stride = function() {\n        return 0;\n    };\n\n    AttribBuffer.prototype.offset = function() {\n        return 0;\n    };\n\n    AttribBuffer.prototype.getElement = function(index) {\n        var offset = index * this.numComponents;\n        var value = [];\n        for (var ii = 0; ii < this.numComponents; ++ii) {\n            value.push(this.buffer[offset + ii]);\n        }\n        return value;\n    };\n\n    AttribBuffer.prototype.setElement = function(index, value) {\n        var offset = index * this.numComponents;\n        for (var ii = 0; ii < this.numComponents; ++ii) {\n            this.buffer[offset + ii] = value[ii];\n        }\n    };\n\n    AttribBuffer.prototype.clone = function() {\n        var copy = new AttribBuffer(\n                this.numComponents, this.numElements, this.type);\n        copy.pushArray(this);\n        return copy;\n    }\n\n    AttribBuffer.prototype.push = function(value) {\n        this.setElement(this.cursor++, value);\n    };\n\n    AttribBuffer.prototype.pushArray = function(array) {\n        //  this.buffer.set(array, this.cursor * this.numComponents);\n        //  this.cursor += array.numElements;\n        for (var ii = 0; ii < array.numElements; ++ii) {\n            this.push(array.getElement(ii));\n        }\n    };\n\n    AttribBuffer.prototype.pushArrayWithOffset =\n    function(array, offset) {\n        for (var ii = 0; ii < array.numElements; ++ii) {\n            var elem = array.getElement(ii);\n            for (var jj = 0; jj < offset.length; ++jj) {\n                elem[jj] += offset[jj];\n            }\n            this.push(elem);\n        }\n    };\n\n    /**\n    * Computes the extents\n    * @param {!AttribBuffer} positions The positions\n    * @return {!{min: !tdl.math.Vector3, max:!tdl.math.Vector3}}\n    *     The min and max extents.\n    */\n    AttribBuffer.prototype.computeExtents = function() {\n        var numElements = this.numElements;\n        var numComponents = this.numComponents;\n        var minExtent = this.getElement(0);\n        var maxExtent = this.getElement(0);\n        for (var ii = 1; ii < numElements; ++ii) {\n            var element = this.getElement(ii);\n            for (var jj = 0; jj < numComponents; ++jj) {\n                minExtent[jj] = Math.min(minExtent[jj], element[jj]);\n                maxExtent[jj] = Math.max(maxExtent[jj], element[jj]);\n            }\n        }\n        return {min: minExtent, max: maxExtent};\n    };\n\n\n    /**\n     * Creates the vertices and indices for a cube. The\n     * cube will be created around the origin. (-size / 2, size / 2)\n     *\n     * @param {number} size Width, height and depth of the cube.\n     * @return {!Object.<string, !tdl.primitives.AttribBuffer>} The\n     *         created plane vertices.\n     */\n    mod.createCube = new Sk.builtin.func(function(size)\n            {\n                var CUBE_FACE_INDICES_ = [\n                    [3, 7, 5, 1],\n                    [0, 4, 6, 2],\n                    [6, 7, 3, 2],\n                    [0, 1, 5, 4],\n                    [5, 7, 6, 4],\n                    [2, 3, 1, 0]\n                ];\n\n                var k = size / 2;\n\n                var cornerVertices = [\n                        [-k, -k, -k],\n                        [+k, -k, -k],\n                        [-k, +k, -k],\n                        [+k, +k, -k],\n                        [-k, -k, +k],\n                        [+k, -k, +k],\n                        [-k, +k, +k],\n                        [+k, +k, +k]\n                    ];\n\n                var faceNormals = [\n                        [+1, +0, +0],\n                        [-1, +0, +0],\n                        [+0, +1, +0],\n                        [+0, -1, +0],\n                        [+0, +0, +1],\n                        [+0, +0, -1]\n                    ];\n\n                var uvCoords = [\n                        [0, 0],\n                        [1, 0],\n                        [1, 1],\n                        [0, 1]\n                    ];\n\n                var numVertices = 6 * 4;\n                var positions = new AttribBuffer(3, numVertices);\n                var normals = new AttribBuffer(3, numVertices);\n                var texCoords = new AttribBuffer(2, numVertices);\n                var indices = new AttribBuffer(3, 6 * 2, 'Uint16Array');\n\n                for (var f = 0; f < 6; ++f) {\n                    var faceIndices = CUBE_FACE_INDICES_[f];\n                    for (var v = 0; v < 4; ++v) {\n                        var position = cornerVertices[faceIndices[v]];\n                        var normal = faceNormals[f];\n                        var uv = uvCoords[v];\n\n                        // Each face needs all four vertices because the normals and texture\n                        // coordinates are not all the same.\n                        positions.push(position);\n                        normals.push(normal);\n                        texCoords.push(uv);\n\n                    }\n                    // Two triangles make a square face.\n                    var offset = 4 * f;\n                    indices.push([offset + 0, offset + 1, offset + 2]);\n                    indices.push([offset + 0, offset + 2, offset + 3]);\n                }\n\n                return {\n                        position: positions,\n                        normal: normals,\n                        texCoord: texCoords,\n                        indices: indices\n                };\n            });\n\n    return mod;\n};\n", "src/lib/document/__init__.js": "var $builtinmodule = function(name) {\n    var mod = {};\n\n    mod.getElementById = new Sk.builtin.func(function(id) {\n        var result = document.getElementById(id.v);\n        if (result) {\n            return Sk.misceval.callsim(mod.Element,result);\n        }\n        return Sk.builtin.none.none$;\n    });\n\n    mod.createElement = new Sk.builtin.func(function(eName) {\n            var r = document.createElement(eName.v);\n            if (r) {\n                return Sk.misceval.callsim(mod.Element,r);\n            }\n        });\n\n\n    mod.getElementsByTagName = new Sk.builtin.func(function(tag) {\n        var r = document.getElementsByTagName(tag.v)\n        var reslist = [];\n        for (var i = r.length - 1; i >= 0; i--) {\n            reslist.push(Sk.misceval.callsim(mod.Element,r[i]))\n        }\n        return new Sk.builtin.list(reslist)\n    });\n\n    mod.getElementsByClassName = new Sk.builtin.func(function(cname) {\n        var r = document.getElementsByClassName(cname.v);\n        var reslist = [];\n        for (var i = 0; i < r.length; i++) {\n            reslist.push(Sk.misceval.callsim(mod.Element,r[i]));\n        };\n        return new Sk.builtin.list(reslist);\n    });\n    \n    mod.getElementsByName = new Sk.builtin.func(function(cname) {\n        var r = document.getElementsByName(cname.v);\n        var reslist = [];\n        for (var i = 0; i < r.length; i++) {\n            reslist.push(Sk.misceval.callsim(mod.Element,r[i]));\n        };\n        return new Sk.builtin.list(reslist);\n    });\n        \n    mod.currentDiv = new Sk.builtin.func(function() {\n        if (Sk.divid !== undefined) {\n            return new Sk.builtin.str(Sk.divid)\n        }\n        else {\n            throw new Sk.builtin.AttributeError(\"There is no value set for divid\");\n        }\n    })\n    var elementClass = function($gbl, $loc) {\n        /*\n            Notes:  self['$d'] is the dictionary used by the GenericGetAttr mechanism for an object.\n                    for various reasons  if you create a class in Javascript and have self.xxxx instance\n                    variables, you cannot say instance.xxx and get the value of the instance variable unless \n                    it is stored in the self['$d'] object.  This seems like a duplication of storage to me\n                    but that is how it works right now  (5/2013)\n\n                    Writing your own __getattr__ is also an option but this gets very tricky when an attr is \n                    a method...\n        */\n        $loc.__init__ = new Sk.builtin.func(function(self,elem) {\n            self.v = elem\n            self.innerHTML = elem.innerHTML\n            self.innerText = elem.innerText\n            if (elem.value !== undefined) {\n                self.value = elem.value\n                Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str('value'), new Sk.builtin.str(self.value))                \n            }\n\n            if (elem.checked !== undefined) {\n                self.checked = elem.checked\n                Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str('checked'), new Sk.builtin.str(self.checked))                \n            }\n\n            Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str('innerHTML'), new Sk.builtin.str(self.innerHTML))\n            Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str('innerText'), new Sk.builtin.str(self.innerText))            \n\n        })\n\n        $loc.tp$getattr = Sk.builtin.object.prototype.GenericGetAttr;\n\n        $loc.__setattr__ = new Sk.builtin.func(function(self,key,value) {\n            if (key === 'innerHTML') {\n                self.innerHTML = value\n                self.v.innerHTML = value.v\n                Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str('innerHTML'), value)                \n            }\n            if (key === 'innerText') {\n                self.innerText = value\n                self.v.innerText = value.v\n                Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str('innerText'), value)            \n            }\n        });\n\n\n        $loc.appendChild = new Sk.builtin.func(function(self,ch) {\n            self.v.appendChild(ch.v);\n        });\n\n        $loc.removeChild = new Sk.builtin.func(function(self,node) {\n            self.v.removeChild(node.v)\n        })\n\n        // getCSS\n                    \n        $loc.getCSS = new Sk.builtin.func(function(self,key) {\n            return new Sk.builtin.str(self.v.style[key.v]);\n        });\n    \n\n        $loc.setCSS = new Sk.builtin.func(function(self,attr,value) {\n            self.v.style[attr.v] = value.v\n\n        })\n\n        $loc.getAttribute = new Sk.builtin.func(function(self,key) {\n            var res = self.v.getAttribute(key.v)\n            if (res) {\n                return new Sk.builtin.str(res)\n            } else {\n                return Sk.builtin.none.none$;\n            }\n        });\n\n        $loc.setAttribute = new Sk.builtin.func(function(self,attr,value) {\n                self.v.setAttribute(attr.v,value.v)\n        });\n            \n        $loc.getProperty = new Sk.builtin.func(function(self,key) {\n            var res = self.v[key.v]\n            if (res) {\n                return new Sk.builtin.str(res)\n            } else {\n                return Sk.builtin.none.none$;\n            }\n        });\n\n        $loc.__str__ = new Sk.builtin.func(function(self) {\n            console.log(self.v.tagName);\n            return new Sk.builtin.str(self.v.tagName)\n        })\n\n        $loc.__repr__ = new Sk.builtin.func(function(self) {\n            return new Sk.builtin.str('[DOM Element]')\n        })\n\n    \n    };\n\n    mod.Element = Sk.misceval.buildClass(mod,elementClass,'Element', []);\n\n    return mod;\n\n}   ", "src/lib/webgl/matrix4.js": "// more from 'tdl'\nvar $builtinmodule = function(name)\n{\n    var mod = {};\n\n    var temp0v3_ = new Float32Array(3);\n    var temp1v3_ = new Float32Array(3);\n    var temp2v3_ = new Float32Array(3);\n\n    var temp0v4_ = new Float32Array(4);\n    var temp1v4_ = new Float32Array(4);\n    var temp2v4_ = new Float32Array(4);\n\n    var temp0m4_ = new Float32Array(16);\n    var temp1m4_ = new Float32Array(16);\n    var temp2m4_ = new Float32Array(16);\n\n    var normalize = function(dst, a) {\n        var n = 0.0;\n        var aLength = a.length;\n        for (var i = 0; i < aLength; ++i)\n            n += a[i] * a[i];\n        n = Math.sqrt(n);\n        if (n > 0.00001) {\n            for (var i = 0; i < aLength; ++i)\n                dst[i] = a[i] / n;\n        } else {\n            for (var i = 0; i < aLength; ++i)\n                dst[i] = 0;\n        }\n        return dst;\n    };\n\n    var cross = function(dst, a, b) {\n        dst[0] = a[1] * b[2] - a[2] * b[1];\n        dst[1] = a[2] * b[0] - a[0] * b[2];\n        dst[2] = a[0] * b[1] - a[1] * b[0];\n        return dst;\n    };\n\n    var subVector = function(dst, a, b) {\n        var aLength = a.length;\n        for (var i = 0; i < aLength; ++i)\n            dst[i] = a[i] - b[i];\n        return dst;\n    };\n\n    var dot = function(a, b) {\n        return (a[0] * b[0]) + (a[1] * b[1]) + (a[2] * b[2]);\n    };\n\n    mod.lookAt = new Sk.builtin.func(function(view, eye, target, up)\n            {\n                var t0 = temp0v3_;\n                var t1 = temp1v3_;\n                var t2 = temp2v3_;\n\n                var vz = normalize(t0, subVector(t0, eye.v, target.v));\n                var vx = normalize(t1, cross(t1, up.v, vz));\n                var vy = cross(t2, vz, vx);\n\n                var dst = view.v;\n                dst[ 0] = vx[0];\n                dst[ 1] = vy[0];\n                dst[ 2] = vz[0];\n                dst[ 3] = 0;\n                dst[ 4] = vx[1];\n                dst[ 5] = vy[1];\n                dst[ 6] = vz[1];\n                dst[ 7] = 0;\n                dst[ 8] = vx[2];\n                dst[ 9] = vy[2];\n                dst[10] = vz[2];\n                dst[11] = 0;\n                dst[12] = -dot(vx, eye.v);\n                dst[13] = -dot(vy, eye.v);\n                dst[14] = -dot(vz, eye.v);\n                dst[15] = 1;\n\n                return view;\n            });\n\n    mod.perspective = new Sk.builtin.func(function(proj, angle, aspect, near, far)\n            {\n                var f = Math.tan(Math.PI * 0.5 - 0.5 * (angle * Math.PI / 180));\n                var rangeInv = 1.0 / (near - far);\n\n                var dst = proj.v;\n\n                dst[0]  = f / aspect;\n                dst[1]  = 0;\n                dst[2]  = 0;\n                dst[3]  = 0;\n\n                dst[4]  = 0;\n                dst[5]  = f;\n                dst[6]  = 0;\n                dst[7]  = 0;\n\n                dst[8]  = 0;\n                dst[9]  = 0;\n                dst[10] = (near + far) * rangeInv;\n                dst[11] = -1;\n\n                dst[12] = 0;\n                dst[13] = 0;\n                dst[14] = near * far * rangeInv * 2;\n                dst[15] = 0;\n\n                return proj;\n            });\n\n    // builds, not appending\n    mod.rotationY = new Sk.builtin.func(function(target, angle)\n            {\n                var dst = target.v;\n                var c = Math.cos(angle * Math.PI / 180);\n                var s = Math.sin(angle * Math.PI / 180);\n\n                dst[ 0] = c;\n                dst[ 1] = 0;\n                dst[ 2] = -s;\n                dst[ 3] = 0;\n                dst[ 4] = 0;\n                dst[ 5] = 1;\n                dst[ 6] = 0;\n                dst[ 7] = 0;\n                dst[ 8] = s;\n                dst[ 9] = 0;\n                dst[10] = c;\n                dst[11] = 0;\n                dst[12] = 0;\n                dst[13] = 0;\n                dst[14] = 0;\n                dst[15] = 1;\n\n                return target;\n            });\n\n    mod.identity = new Sk.builtin.func(function(target)\n            {\n                var dst = target.v;\n                dst[ 0] = 1;\n                dst[ 1] = 0;\n                dst[ 2] = 0;\n                dst[ 3] = 0;\n                dst[ 4] = 0;\n                dst[ 5] = 1;\n                dst[ 6] = 0;\n                dst[ 7] = 0;\n                dst[ 8] = 0;\n                dst[ 9] = 0;\n                dst[10] = 1;\n                dst[11] = 0;\n                dst[12] = 0;\n                dst[13] = 0;\n                dst[14] = 0;\n                dst[15] = 1;\n                return target;\n            });\n\n    // row major\n    mod.mul = new Sk.builtin.func(function(target, x, y)\n            {\n                var dst = target.v;\n                var a = x.v;\n                var b = y.v;\n                var a00 = a[0];\n                var a01 = a[1];\n                var a02 = a[2];\n                var a03 = a[3];\n                var a10 = a[ 4 + 0];\n                var a11 = a[ 4 + 1];\n                var a12 = a[ 4 + 2];\n                var a13 = a[ 4 + 3];\n                var a20 = a[ 8 + 0];\n                var a21 = a[ 8 + 1];\n                var a22 = a[ 8 + 2];\n                var a23 = a[ 8 + 3];\n                var a30 = a[12 + 0];\n                var a31 = a[12 + 1];\n                var a32 = a[12 + 2];\n                var a33 = a[12 + 3];\n                var b00 = b[0];\n                var b01 = b[1];\n                var b02 = b[2];\n                var b03 = b[3];\n                var b10 = b[ 4 + 0];\n                var b11 = b[ 4 + 1];\n                var b12 = b[ 4 + 2];\n                var b13 = b[ 4 + 3];\n                var b20 = b[ 8 + 0];\n                var b21 = b[ 8 + 1];\n                var b22 = b[ 8 + 2];\n                var b23 = b[ 8 + 3];\n                var b30 = b[12 + 0];\n                var b31 = b[12 + 1];\n                var b32 = b[12 + 2];\n                var b33 = b[12 + 3];\n                dst[ 0] = a00 * b00 + a01 * b10 + a02 * b20 + a03 * b30;\n                dst[ 1] = a00 * b01 + a01 * b11 + a02 * b21 + a03 * b31;\n                dst[ 2] = a00 * b02 + a01 * b12 + a02 * b22 + a03 * b32;\n                dst[ 3] = a00 * b03 + a01 * b13 + a02 * b23 + a03 * b33;\n                dst[ 4] = a10 * b00 + a11 * b10 + a12 * b20 + a13 * b30;\n                dst[ 5] = a10 * b01 + a11 * b11 + a12 * b21 + a13 * b31;\n                dst[ 6] = a10 * b02 + a11 * b12 + a12 * b22 + a13 * b32;\n                dst[ 7] = a10 * b03 + a11 * b13 + a12 * b23 + a13 * b33;\n                dst[ 8] = a20 * b00 + a21 * b10 + a22 * b20 + a23 * b30;\n                dst[ 9] = a20 * b01 + a21 * b11 + a22 * b21 + a23 * b31;\n                dst[10] = a20 * b02 + a21 * b12 + a22 * b22 + a23 * b32;\n                dst[11] = a20 * b03 + a21 * b13 + a22 * b23 + a23 * b33;\n                dst[12] = a30 * b00 + a31 * b10 + a32 * b20 + a33 * b30;\n                dst[13] = a30 * b01 + a31 * b11 + a32 * b21 + a33 * b31;\n                dst[14] = a30 * b02 + a31 * b12 + a32 * b22 + a33 * b32;\n                dst[15] = a30 * b03 + a31 * b13 + a32 * b23 + a33 * b33;\n                return target;\n            });\n\n    mod.invert = new Sk.builtin.func(function(target, mat)\n            {\n                var dst = target.v;\n                var m = mat.v;\n                var m00 = m[0 * 4 + 0];\n                var m01 = m[0 * 4 + 1];\n                var m02 = m[0 * 4 + 2];\n                var m03 = m[0 * 4 + 3];\n                var m10 = m[1 * 4 + 0];\n                var m11 = m[1 * 4 + 1];\n                var m12 = m[1 * 4 + 2];\n                var m13 = m[1 * 4 + 3];\n                var m20 = m[2 * 4 + 0];\n                var m21 = m[2 * 4 + 1];\n                var m22 = m[2 * 4 + 2];\n                var m23 = m[2 * 4 + 3];\n                var m30 = m[3 * 4 + 0];\n                var m31 = m[3 * 4 + 1];\n                var m32 = m[3 * 4 + 2];\n                var m33 = m[3 * 4 + 3];\n                var tmp_0  = m22 * m33;\n                var tmp_1  = m32 * m23;\n                var tmp_2  = m12 * m33;\n                var tmp_3  = m32 * m13;\n                var tmp_4  = m12 * m23;\n                var tmp_5  = m22 * m13;\n                var tmp_6  = m02 * m33;\n                var tmp_7  = m32 * m03;\n                var tmp_8  = m02 * m23;\n                var tmp_9  = m22 * m03;\n                var tmp_10 = m02 * m13;\n                var tmp_11 = m12 * m03;\n                var tmp_12 = m20 * m31;\n                var tmp_13 = m30 * m21;\n                var tmp_14 = m10 * m31;\n                var tmp_15 = m30 * m11;\n                var tmp_16 = m10 * m21;\n                var tmp_17 = m20 * m11;\n                var tmp_18 = m00 * m31;\n                var tmp_19 = m30 * m01;\n                var tmp_20 = m00 * m21;\n                var tmp_21 = m20 * m01;\n                var tmp_22 = m00 * m11;\n                var tmp_23 = m10 * m01;\n\n                var t0 = (tmp_0 * m11 + tmp_3 * m21 + tmp_4 * m31) -\n                    (tmp_1 * m11 + tmp_2 * m21 + tmp_5 * m31);\n                var t1 = (tmp_1 * m01 + tmp_6 * m21 + tmp_9 * m31) -\n                    (tmp_0 * m01 + tmp_7 * m21 + tmp_8 * m31);\n                var t2 = (tmp_2 * m01 + tmp_7 * m11 + tmp_10 * m31) -\n                    (tmp_3 * m01 + tmp_6 * m11 + tmp_11 * m31);\n                var t3 = (tmp_5 * m01 + tmp_8 * m11 + tmp_11 * m21) -\n                    (tmp_4 * m01 + tmp_9 * m11 + tmp_10 * m21);\n\n                var d = 1.0 / (m00 * t0 + m10 * t1 + m20 * t2 + m30 * t3);\n\n                dst[ 0] = d * t0;\n                dst[ 1] = d * t1;\n                dst[ 2] = d * t2;\n                dst[ 3] = d * t3;\n                dst[ 4] = d * ((tmp_1 * m10 + tmp_2 * m20 + tmp_5 * m30) -\n                        (tmp_0 * m10 + tmp_3 * m20 + tmp_4 * m30));\n                dst[ 5] = d * ((tmp_0 * m00 + tmp_7 * m20 + tmp_8 * m30) -\n                        (tmp_1 * m00 + tmp_6 * m20 + tmp_9 * m30));\n                dst[ 6] = d * ((tmp_3 * m00 + tmp_6 * m10 + tmp_11 * m30) -\n                        (tmp_2 * m00 + tmp_7 * m10 + tmp_10 * m30));\n                dst[ 7] = d * ((tmp_4 * m00 + tmp_9 * m10 + tmp_10 * m20) -\n                        (tmp_5 * m00 + tmp_8 * m10 + tmp_11 * m20));\n                dst[ 8] = d * ((tmp_12 * m13 + tmp_15 * m23 + tmp_16 * m33) -\n                        (tmp_13 * m13 + tmp_14 * m23 + tmp_17 * m33));\n                dst[ 9] = d * ((tmp_13 * m03 + tmp_18 * m23 + tmp_21 * m33) -\n                        (tmp_12 * m03 + tmp_19 * m23 + tmp_20 * m33));\n                dst[10] = d * ((tmp_14 * m03 + tmp_19 * m13 + tmp_22 * m33) -\n                        (tmp_15 * m03 + tmp_18 * m13 + tmp_23 * m33));\n                dst[11] = d * ((tmp_17 * m03 + tmp_20 * m13 + tmp_23 * m23) -\n                        (tmp_16 * m03 + tmp_21 * m13 + tmp_22 * m23));\n                dst[12] = d * ((tmp_14 * m22 + tmp_17 * m32 + tmp_13 * m12) -\n                        (tmp_16 * m32 + tmp_12 * m12 + tmp_15 * m22));\n                dst[13] = d * ((tmp_20 * m32 + tmp_12 * m02 + tmp_19 * m22) -\n                        (tmp_18 * m22 + tmp_21 * m32 + tmp_13 * m02));\n                dst[14] = d * ((tmp_18 * m12 + tmp_23 * m32 + tmp_15 * m02) -\n                        (tmp_22 * m32 + tmp_14 * m02 + tmp_19 * m12));\n                dst[15] = d * ((tmp_22 * m22 + tmp_16 * m02 + tmp_21 * m12) -\n                        (tmp_20 * m12 + tmp_23 * m22 + tmp_17 * m02));\n                return target;\n            });\n\n    mod.transpose = new Sk.builtin.func(function(target, mat)\n            {\n                var dst = target.v;\n                var m = mat.v;\n                for (var j = 0; j < 4; ++j) {\n                    for (var i = 0; i < 4; ++i)\n                    dst[j * 4 + i] = m[i * 4 + j];\n                }\n                return dst;\n            });\n\n    return mod;\n};\n", "src/lib/re/__init__.js": "var $builtinmodule = function(name)\n{\n    var mod = {};\n\n    // Constants (mostly unsupported)\n    mod.I = 2;\n    mod.IGNORECASE = 2;\n    // mod.L = 4;\n    // mod.LOCALE = 4;\n    mod.M = 8;\n    mod.MULTILINE = 8;\n    // mod.S = 16;\n    // mod.DOTALL = 16;\n    // mod.U = 32;\n    // mod.UNICODE = 32;\n    // mod.X = 64;\n    // mod.VERBOSE = 64;\n\n    var validGroups = [\"(?:\", \"(?=\", \"(?!\"];\n\n    var convert = function(pattern) {\n        var newpattern;\n        var match;\n        var i;\n\n        // Look for disallowed constructs\n        match = pattern.match(/\\(\\?./g);\n        if (match) {\n            for (i=0; i<match.length; i++) {\n                if (validGroups.indexOf(match[i]) == -1) {\n                    throw new Sk.builtin.ValueError(\"Disallowed group in pattern: '\"\n                                                    + match[i] + \"'\");\n                };\n            };\n        };\n\n        newpattern = pattern.replace('/\\\\/g', '\\\\\\\\');\n        newpattern = pattern.replace(/([^\\\\]){,(?![^\\[]*\\])/g, '$1{0,');\n\n        return newpattern;\n    };\n\n    var getFlags = function(flags) {\n        var jsflags = \"g\";\n        if ((flags & mod.IGNORECASE) == mod.IGNORECASE) {\n            jsflags += \"i\";\n        };\n        if ((flags & mod.MULTILINE) == mod.MULTILINE) {\n            jsflags += \"m\";\n        }; \n        return jsflags;\n    };\n\n    mod.split = Sk.nativejs.func(function split(pattern, string, maxsplit, flags) {\n        Sk.builtin.pyCheckArgs(\"split\", arguments, 2, 4);\n        if (!Sk.builtin.checkString(pattern)) {\n            throw new Sk.builtin.TypeError(\"pattern must be a string\");\n        };\n        if (!Sk.builtin.checkString(string)) {\n            throw new Sk.builtin.TypeError(\"string must be a string\");\n        };\n        if (maxsplit === undefined) {\n            maxsplit = 0;\n        };\n        if (!Sk.builtin.checkNumber(maxsplit)) {\n            throw new Sk.builtin.TypeError(\"maxsplit must be a number\");\n        };\n        if (flags === undefined) {\n            flags = 0;\n        };\n        if (!Sk.builtin.checkNumber(flags)) {\n            throw new Sk.builtin.TypeError(\"flags must be a number\");\n        };\n\n\tmaxsplit = Sk.builtin.asnum$(maxsplit);\n        var pat = Sk.ffi.unwrapo(pattern);\n        var str = Sk.ffi.unwrapo(string);\n        \n        // Convert pat from Python to Javascript regex syntax\n        pat = convert(pat);\n        //print(\"Pat: \" + pat);\n        //print(\"Str: \" + str);\n\n        var captured = !(pat.match(/^\\(.*\\)$/) === null);\n        //print(\"Captured: \", captured);\n\n        var jsflags = getFlags(flags);\n        //print(\"Flags: \", jsflags);\n\n        var regex = new RegExp(pat, jsflags);\n\n        var result = [];\n        var match;\n        var index = 0;\n        var splits = 0;\n        while ((match = regex.exec(str)) != null) {\n            //print(\"Matched '\" + match[0] + \"' at position \" + match.index + \n            //      \"; next search at \" + regex.lastIndex);\n            if (match.index === regex.lastIndex) {\n                // empty match\n                break;\n            };\n            result.push(new Sk.builtin.str(str.substring(index, match.index)));\n            if (captured) {\n                // Add matching pattern, too\n                result.push(new Sk.builtin.str(match[0]));\n            };\n            index = regex.lastIndex;\n            splits += 1;\n            if (maxsplit && (splits >= maxsplit)) {\n                break;\n            };\n        };\n        result.push(new Sk.builtin.str(str.substring(index)));\n\n        return new Sk.builtin.list(result);\n    });\n\n    mod.findall = Sk.nativejs.func(function findall(pattern, string, flags) {\n        Sk.builtin.pyCheckArgs(\"findall\", arguments, 2, 3);\n        if (!Sk.builtin.checkString(pattern)) {\n            throw new Sk.builtin.TypeError(\"pattern must be a string\");\n        };\n        if (!Sk.builtin.checkString(string)) {\n            throw new Sk.builtin.TypeError(\"string must be a string\");\n        };\n        if (flags === undefined) {\n            flags = 0;\n        };\n        if (!Sk.builtin.checkNumber(flags)) {\n            throw new Sk.builtin.TypeError(\"flags must be a number\");\n        };\n\n        var pat = Sk.ffi.unwrapo(pattern);\n        var str = Sk.ffi.unwrapo(string);\n        \n        // Convert pat from Python to Javascript regex syntax\n        pat = convert(pat);\n        //print(\"Pat: \" + pat);\n        //print(\"Str: \" + str);\n\n        var jsflags = getFlags(flags);\n        //print(\"Flags: \", jsflags);\n\n        var regex = new RegExp(pat, jsflags);\n\n        if (pat.match(/\\$/)) {\n\t    var newline_at_end = new RegExp(/\\n$/);\n\t    if (str.match(newline_at_end)) {\n\t        str = str.slice(0,-1);\n\t    }\n        }\n\n        var result = [];\n        var match;\n        while ((match = regex.exec(str)) != null) {\n            //print(\"Matched '\" + match[0] + \"' at position \" + match.index + \n            //      \"; next search at \" + regex.lastIndex);\n            // print(\"match: \" + JSON.stringify(match));\n            if (match.length < 2) {\n                result.push(new Sk.builtin.str(match[0]));\n            } else if (match.length == 2) {\n                result.push(new Sk.builtin.str(match[1]));\n            } else {\n                var groups = [];\n                for (var i=1; i<match.length; i++) {\n                    groups.push(new Sk.builtin.str(match[i]));  \n                };\n                result.push(new Sk.builtin.tuple(groups));\n            };\n            if (match.index === regex.lastIndex) {\n                regex.lastIndex += 1;\n            };\n        };\n\n        return new Sk.builtin.list(result);\n    });\n\n\n    var matchobj = function($gbl, $loc) {\n        $loc.__init__ = new Sk.builtin.func(function(self,thematch, pattern, string) {\n            self.thematch = thematch;\n\t    self.re = pattern;\n\t    self.string = string;\n        });\n\n\t$loc.groups = new Sk.builtin.func(function(self) {\n\t    return new Sk.builtin.tuple(self.thematch.v.slice(1))\n\t});\n\n\t$loc.group = new Sk.builtin.func(function(self,grpnum) {\n\t    if (grpnum === undefined) {\n                grpnum = 0;\n            }\n            else {\n                grpnum = Sk.builtin.asnum$(grpnum);\n            }\n\t    if(grpnum >= self.thematch.v.length) {\n\t\tthrow new Sk.builtin.IndexError(\"Index out of range: \" + grpnum);\n\t\t}\n\t    return self.thematch.v[grpnum]\n\t});\n\n    }\n\n    mod.MatchObject = Sk.misceval.buildClass(mod, matchobj, 'MatchObject', []);\n\n    // Internal function to return a Python list of strings \n    // From a JS regular expression string\n    mod._findre = function(res, string) {\n\tres = res.replace(/([^\\\\]){,(?![^\\[]*\\])/g, '$1{0,');\n        var re = eval(res);\n\tvar patt = new RegExp('\\n$');\n\tif (string.v.match(patt))\n\t    var matches = string.v.slice(0,-1).match(re);\n\telse\n            var matches = string.v.match(re);\n        retval = new Sk.builtin.list();\n        if ( matches == null ) return retval;\n        for (var i = 0; i < matches.length; ++i) {\n            var sitem = new Sk.builtin.str(matches[i]);\n            retval.v.push(sitem);\n        }\n        return retval;\n    }\n\n    mod.search = new Sk.builtin.func(function(pattern, string, flags) {\n\tSk.builtin.pyCheckArgs('search', arguments, 2, 3);\n        if (!Sk.builtin.checkString(pattern)) {\n            throw new Sk.builtin.TypeError(\"pattern must be a string\");\n        };\n        if (!Sk.builtin.checkString(string)) {\n            throw new Sk.builtin.TypeError(\"string must be a string\");\n        };\n\tif (flags === undefined) {\n            flags = 0;\n        };\n        if (!Sk.builtin.checkNumber(flags)) {\n            throw new Sk.builtin.TypeError(\"flags must be a number\");\n        };\n        var res = \"/\"+pattern.v.replace(/\\//g,\"\\\\/\")+\"/\";\n        lst = mod._findre(res,string);\n        if ( lst.v.length < 1 ) return Sk.builtin.none.none$;\n        var mob = Sk.misceval.callsim(mod.MatchObject, lst, pattern, string);\n        return mob;\n    });\n\n    mod.match = new Sk.builtin.func(function(pattern, string, flags) {\n\tSk.builtin.pyCheckArgs('match', arguments, 2, 3);\n        if (!Sk.builtin.checkString(pattern)) {\n            throw new Sk.builtin.TypeError(\"pattern must be a string\");\n        };\n        if (!Sk.builtin.checkString(string)) {\n            throw new Sk.builtin.TypeError(\"string must be a string\");\n        };\n\tif (flags === undefined) {\n            flags = 0;\n        };\n        if (!Sk.builtin.checkNumber(flags)) {\n            throw new Sk.builtin.TypeError(\"flags must be a number\");\n        };\n        var res = \"/^\"+pattern.v.replace(/\\//g,\"\\\\/\")+\"/\";\n        lst = mod._findre(res,string);\n        if ( lst.v.length < 1 ) return Sk.builtin.none.none$;\n        var mob = Sk.misceval.callsim(mod.MatchObject, lst, pattern, string);\n        return mob;\n    });\n\n    return mod;\n}\n", "src/lib/unittest/gui.py": "import document\nfrom unittest import TestCase\n\nclass TestCaseGui(TestCase):\n\tdef __init__(self):\n\t\tTestCase.__init__(self)\n\n\t\tself.divid = document.currentDiv()\n\t\tself.mydiv = document.getElementById(self.divid)\n\t\tres = document.getElementById(self.divid+'_unit_results')\n\t\tif res:\n\t\t\tself.resdiv = res\n\t\t\tres.innerHTML = ''\n\t\telse:\n\t\t\tself.resdiv = document.createElement('div')\n\t\t\tself.resdiv.setAttribute('id',self.divid+'_unit_results')\n\t\t\tself.resdiv.setAttribute('class','unittest-results')\n\t\tself.mydiv.appendChild(self.resdiv)\n\n\n\tdef main(self):\n\t\tl = document.createElement('ul')\n\t\tself.resdiv.appendChild(l)\n\t\tself.resList = l\n\n\t\tfor func in self.tlist:\n\t\t\ttry:\n\t\t\t\tself.setup()\n\t\t\t\tfunc()\n\t\t\t\tself.tearDown()\n\t\t\texcept:\n\t\t\t\tself.appendResult('Error')\n\t\t\t\tself.numFailed += 1\n\t\tself.showSummary()\n\n\tdef appendResult(self,res,actual,expected,feedback):\n\t\tif res == 'Error':\n\t\t\tmsg = 'Error'\n\t\telif res:\n\t\t\tmsg = 'Pass'\n\t\t\tself.numPassed += 1\n\t\telse:\n\t\t\tmsg = 'Fail: expected %s  %s ' % (str(actual),str(expected)) + feedback\n\t\t\tself.numFailed += 1\n\n\t\tpTag = document.createElement('li')\n\t\tpTag.innerHTML = msg\n\t\tself.resList.appendChild(pTag)\n\n\n\n\tdef showSummary(self):\n\t\tpct = self.numPassed / (self.numPassed+self.numFailed) * 100\n\t\tpTag = document.createElement('p')\n\t\tpTag.innerHTML = \"You passed: \" + str(pct) + \"% of the tests\"\n\t\tself.resdiv.appendChild(pTag)\n\t\tif pct < 90:\n\t\t\tself.resdiv.setCSS('background-color','#de8e96')\n\t\telse:\n\t\t\tself.resdiv.setCSS('background-color','#83d382')\n", "src/lib/urllib/__init__.js": "var $builtinmodule = function(name)\n{\n  var urllib = {};\n\n  return urllib;\n};\n", "src/lib/random/__init__.js": "\n/*\n  I've wrapped Makoto Matsumoto and Takuji Nishimura's code in a namespace\n  so it's better encapsulated. Now you can have multiple random number generators\n  and they won't stomp all over eachother's state.\n  \n  If you want to use this as a substitute for Math.random(), use the random()\n  method like so:\n  \n  var m = new MersenneTwister();\n  var randomNumber = m.random();\n  \n  You can also call the other genrand_{foo}() methods on the instance.\n\n  If you want to use a specific seed in order to get a repeatable random\n  sequence, pass an integer into the constructor:\n\n  var m = new MersenneTwister(123);\n\n  and that will always produce the same random sequence.\n\n  Sean McCullough (banksean@gmail.com)\n*/\n\n/* \n   A C-program for MT19937, with initialization improved 2002/1/26.\n   Coded by Takuji Nishimura and Makoto Matsumoto.\n \n   Before using, initialize the state by using init_genrand(seed)  \n   or init_by_array(init_key, key_length).\n \n   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,\n   All rights reserved.                          \n \n   Redistribution and use in source and binary forms, with or without\n   modification, are permitted provided that the following conditions\n   are met:\n \n     1. Redistributions of source code must retain the above copyright\n        notice, this list of conditions and the following disclaimer.\n \n     2. Redistributions in binary form must reproduce the above copyright\n        notice, this list of conditions and the following disclaimer in the\n        documentation and/or other materials provided with the distribution.\n \n     3. The names of its contributors may not be used to endorse or promote \n        products derived from this software without specific prior written \n        permission.\n \n   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n   \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR\n   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n \n \n   Any feedback is very welcome.\n   http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html\n   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)\n*/\n\nvar MersenneTwister = function(seed) {\n  if (seed == undefined) {\n    seed = new Date().getTime();\n  } \n  /* Period parameters */  \n  this.N = 624;\n  this.M = 397;\n  this.MATRIX_A = 0x9908b0df;   /* constant vector a */\n  this.UPPER_MASK = 0x80000000; /* most significant w-r bits */\n  this.LOWER_MASK = 0x7fffffff; /* least significant r bits */\n \n  this.mt = new Array(this.N); /* the array for the state vector */\n  this.mti=this.N+1; /* mti==N+1 means mt[N] is not initialized */\n\n  this.init_genrand(seed);\n}  \n \n/* initializes mt[N] with a seed */\nMersenneTwister.prototype.init_genrand = function(s) {\n  this.mt[0] = s >>> 0;\n  for (this.mti=1; this.mti<this.N; this.mti++) {\n      var s = this.mt[this.mti-1] ^ (this.mt[this.mti-1] >>> 30);\n   this.mt[this.mti] = (((((s & 0xffff0000) >>> 16) * 1812433253) << 16) + (s & 0x0000ffff) * 1812433253)\n  + this.mti;\n      /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */\n      /* In the previous versions, MSBs of the seed affect   */\n      /* only MSBs of the array mt[].                        */\n      /* 2002/01/09 modified by Makoto Matsumoto             */\n      this.mt[this.mti] >>>= 0;\n      /* for >32 bit machines */\n  }\n}\n \n/* initialize by an array with array-length */\n/* init_key is the array for initializing keys */\n/* key_length is its length */\n/* slight change for C++, 2004/2/26 */\nMersenneTwister.prototype.init_by_array = function(init_key, key_length) {\n  var i, j, k;\n  this.init_genrand(19650218);\n  i=1; j=0;\n  k = (this.N>key_length ? this.N : key_length);\n  for (; k; k--) {\n    var s = this.mt[i-1] ^ (this.mt[i-1] >>> 30)\n    this.mt[i] = (this.mt[i] ^ (((((s & 0xffff0000) >>> 16) * 1664525) << 16) + ((s & 0x0000ffff) * 1664525)))\n      + init_key[j] + j; /* non linear */\n    this.mt[i] >>>= 0; /* for WORDSIZE > 32 machines */\n    i++; j++;\n    if (i>=this.N) { this.mt[0] = this.mt[this.N-1]; i=1; }\n    if (j>=key_length) j=0;\n  }\n  for (k=this.N-1; k; k--) {\n    var s = this.mt[i-1] ^ (this.mt[i-1] >>> 30);\n    this.mt[i] = (this.mt[i] ^ (((((s & 0xffff0000) >>> 16) * 1566083941) << 16) + (s & 0x0000ffff) * 1566083941))\n      - i; /* non linear */\n    this.mt[i] >>>= 0; /* for WORDSIZE > 32 machines */\n    i++;\n    if (i>=this.N) { this.mt[0] = this.mt[this.N-1]; i=1; }\n  }\n\n  this.mt[0] = 0x80000000; /* MSB is 1; assuring non-zero initial array */ \n}\n \n/* generates a random number on [0,0xffffffff]-interval */\nMersenneTwister.prototype.genrand_int32 = function() {\n  var y;\n  var mag01 = new Array(0x0, this.MATRIX_A);\n  /* mag01[x] = x * MATRIX_A  for x=0,1 */\n\n  if (this.mti >= this.N) { /* generate N words at one time */\n    var kk;\n\n    if (this.mti == this.N+1)   /* if init_genrand() has not been called, */\n      this.init_genrand(5489); /* a default initial seed is used */\n\n    for (kk=0;kk<this.N-this.M;kk++) {\n      y = (this.mt[kk]&this.UPPER_MASK)|(this.mt[kk+1]&this.LOWER_MASK);\n      this.mt[kk] = this.mt[kk+this.M] ^ (y >>> 1) ^ mag01[y & 0x1];\n    }\n    for (;kk<this.N-1;kk++) {\n      y = (this.mt[kk]&this.UPPER_MASK)|(this.mt[kk+1]&this.LOWER_MASK);\n      this.mt[kk] = this.mt[kk+(this.M-this.N)] ^ (y >>> 1) ^ mag01[y & 0x1];\n    }\n    y = (this.mt[this.N-1]&this.UPPER_MASK)|(this.mt[0]&this.LOWER_MASK);\n    this.mt[this.N-1] = this.mt[this.M-1] ^ (y >>> 1) ^ mag01[y & 0x1];\n\n    this.mti = 0;\n  }\n\n  y = this.mt[this.mti++];\n\n  /* Tempering */\n  y ^= (y >>> 11);\n  y ^= (y << 7) & 0x9d2c5680;\n  y ^= (y << 15) & 0xefc60000;\n  y ^= (y >>> 18);\n\n  return y >>> 0;\n}\n \n/* generates a random number on [0,0x7fffffff]-interval */\nMersenneTwister.prototype.genrand_int31 = function() {\n  return (this.genrand_int32()>>>1);\n}\n \n/* generates a random number on [0,1]-real-interval */\nMersenneTwister.prototype.genrand_real1 = function() {\n  return this.genrand_int32()*(1.0/4294967295.0); \n  /* divided by 2^32-1 */ \n}\n\n/* generates a random number on [0,1)-real-interval */\nMersenneTwister.prototype.random = function() {\n  return this.genrand_int32()*(1.0/4294967296.0); \n  /* divided by 2^32 */\n}\n \n/* generates a random number on (0,1)-real-interval */\nMersenneTwister.prototype.genrand_real3 = function() {\n  return (this.genrand_int32() + 0.5)*(1.0/4294967296.0); \n  /* divided by 2^32 */\n}\n \n/* generates a random number on [0,1) with 53-bit resolution*/\nMersenneTwister.prototype.genrand_res53 = function() { \n  var a=this.genrand_int32()>>>5, b=this.genrand_int32()>>>6; \n  return(a*67108864.0+b)*(1.0/9007199254740992.0); \n} \n\n/* These real versions are due to Isaku Wada, 2002/01/09 added */\n\n\n\nvar $builtinmodule = function(name)\n{\n\n    var mod = {};\n\n    var myGenerator = new MersenneTwister();\n\n    mod.seed = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"seed\", arguments, 0, 1);\n\tx = Sk.builtin.asnum$(x);\n\n        if (arguments.length > 0)\n            myGenerator = new MersenneTwister(x);\n        else\n            myGenerator = new MersenneTwister();\n\n\treturn Sk.builtin.none.none$;\n    });\n\n    mod.random = new Sk.builtin.func(function() {\n        Sk.builtin.pyCheckArgs(\"random\", arguments, 0, 0);\n\n\treturn new Sk.builtin.nmber(myGenerator.genrand_res53(), Sk.builtin.nmber.float$);\n    });\n\n    var toInt = function(num) {\n        return num | 0;\n    };\n\n    var randrange = function(start, stop, step) {\n        // Ported from CPython 2.7\n        var width, n, ret;\n\n        if (!Sk.builtin.checkInt(start)) {\n            throw new Sk.builtin.ValueError(\"non-integer first argument for randrange()\");\n        };\n\n        if (stop === undefined) {\n            // Random in [0, start)\n            ret = toInt(myGenerator.genrand_res53() * start);\n\t    return new Sk.builtin.nmber(ret, Sk.builtin.nmber.int$);\n        };\n\n        if (!Sk.builtin.checkInt(stop)) {\n            throw new Sk.builtin.ValueError(\"non-integer stop for randrange()\");\n        };\n\n        if (step === undefined) {\n            step = 1;\n        };\n\n        width = stop - start;\n\n        if ((step == 1) && (width > 0)) {\n            // Random in [start, stop), must use toInt on product for correct results with negative ranges\n            ret = start + toInt(myGenerator.genrand_res53() * width);\n\t    return new Sk.builtin.nmber(ret, Sk.builtin.nmber.int$);\n        };\n\n        if (step == 1) {\n            throw new Sk.builtin.ValueError(\"empty range for randrange() (\" + start + \", \" + stop + \", \" + width + \")\");\n        };\n\n        if (!Sk.builtin.checkInt(step)) {\n            throw new Sk.builtin.ValueError(\"non-integer step for randrange()\");\n        };\n\n        if (step > 0) {\n            n = toInt((width + step - 1) / step);\n        } else if (step < 0) {\n            n = toInt((width + step + 1) / step);\n        } else {\n            throw new Sk.builtin.ValueError(\"zero step for randrange()\");\n        };\n\n        if (n <= 0) {\n            throw new Sk.builtin.ValueError(\"empty range for randrange()\");\n        };\n\n        // Random in range(start, stop, step)\n        ret = start + (step * toInt(myGenerator.genrand_res53() * n));\n\treturn new Sk.builtin.nmber(ret, Sk.builtin.nmber.int$);\n    };\n\n    mod.randint = new Sk.builtin.func(function(a, b) {\n        Sk.builtin.pyCheckArgs(\"randint\", arguments, 2, 2);\n\n\ta = Sk.builtin.asnum$(a);\n\tb = Sk.builtin.asnum$(b);\n        return randrange(a, b+1);\n    });\n\n    mod.randrange = new Sk.builtin.func(function(start, stop, step) {\n        Sk.builtin.pyCheckArgs(\"randrange\", arguments, 1, 3);\n\n\tstart = Sk.builtin.asnum$(start);\n\tstop = Sk.builtin.asnum$(stop);\n\tstep = Sk.builtin.asnum$(step);\n        return randrange(start, stop, step);\n    });\n\n    mod.choice = new Sk.builtin.func(function(seq) {\n        Sk.builtin.pyCheckArgs(\"choice\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"seq\", \"sequence\", Sk.builtin.checkSequence(seq));\n\n        if (seq.sq$length !== undefined) {\n            var r = toInt(myGenerator.genrand_res53() * seq.sq$length());\n            return seq.mp$subscript(r);\n        } else {\n            throw new Sk.builtin.TypeError(\"object has no length\");\n        }\n    });\n\n    mod.shuffle = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"shuffle\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"sequence\", Sk.builtin.checkSequence(x));\n\n        if (x.sq$length !== undefined) {\n            if (x.mp$ass_subscript !== undefined) {\n                for (var i = x.sq$length() - 1; i > 0; i -= 1) {\n                    var r = toInt(myGenerator.genrand_res53() * (i + 1));\n                    var tmp = x.mp$subscript(r);\n                    x.mp$ass_subscript(r, x.mp$subscript(i));\n                    x.mp$ass_subscript(i, tmp);\n                };\n            } else {\n                throw new Sk.builtin.TypeError(\"object is immutable\");\n            };\n        } else {\n            throw new Sk.builtin.TypeError(\"object has no length\");\n        };        \n\n\treturn Sk.builtin.none.none$;\n    });\n\n    return mod;\n}\n", "src/lib/webgl/__init__.js": "var $builtinmodule = function(name)\n{\n  var mod = {};\n\n  var makeFailHTML = function(msg) {\n    return '' +\n      '<table style=\"background-color: #8CE; width: 100%; height: 100%;\"><tr>' +\n      '<td align=\"center\">' +\n      '<div style=\"display: table-cell; vertical-align: middle;\">' +\n      '<div style=\"\">' + msg + '</div>' +\n      '</div>' +\n      '</td></tr></table>';\n  };\n\n  var GET_A_WEBGL_BROWSER = '' +\n    'This page requires a browser that supports WebGL.<br/>' +\n    '<a href=\"http://get.webgl.org\">Click here to upgrade your browser.</a>';\n\n  var NEED_HARDWARE = '' +\n    \"It doesn't appear your computer can support WebGL.<br/>\" +\n    '<a href=\"http://get.webgl.org\">Click here for more information.</a>';\n  \n  var create3DContext = function(canvas) {\n    var names = [\"webgl\", \"experimental-webgl\", \"webkit-3d\", \"moz-webgl\"];\n    var gl = null;\n    for (var ii = 0; ii < names.length; ++ii) {\n      try {\n        gl = canvas.getContext(names[ii]);\n      }\n      catch(e) {\n      }\n      if (gl) {\n          break;\n      }\n    }\n    if (gl) {\n      // Disallow selection by default. This keeps the cursor from changing to an\n      // I-beam when the user clicks and drags. It's easier on the eyes.\n      function returnFalse() {\n        return false;\n      }\n\n      canvas.onselectstart = returnFalse;\n      canvas.onmousedown = returnFalse;\n    }\n    return gl;\n  };\n\n  var setupWebGL = function(canvasContainerId, opt_canvas) {\n    var container = document.getElementById(canvasContainerId);\n    var context;\n    if (!opt_canvas) {\n      opt_canvas = container.getElementsByTagName(\"canvas\")[0];\n    }\n    if (!opt_canvas) {\n        // this browser doesn't support the canvas tag at all. Not even 2d.\n      container.innerHTML = makeFailHTML(GET_A_WEBGL_BROWSER);\n      return;\n    }\n\n    var gl = create3DContext(opt_canvas);\n    if (!gl) {\n      // TODO(gman): fix to official way to detect that it's the user's machine, not the browser.\n      var browserStrings = navigator.userAgent.match(/(\\w+\\/.*? )/g);\n      var browsers = {};\n      try {\n        for (var b = 0; b < browserStrings.length; ++b) {\n          var parts = browserStrings[b].match(/(\\w+)/g);\n          var bb = [];\n          for (var ii = 1; ii < parts.length; ++ii) {\n            bb.push(parseInt(parts[ii]));\n          }\n          browsers[parts[0]] = bb;\n        }\n      }\n      catch (e) {\n      }\n      if (browsers.Chrome &&\n           (browsers.Chrome[0] > 7 ||\n                 (browsers.Chrome[0] == 7 && browsers.Chrome[1] > 0) ||\n                 (browsers.Chrome[0] == 7 && browsers.Chrome[1] == 0 && browsers.Chrome[2] >= 521))) {\n        container.innerHTML = makeFailHTML(NEED_HARDWARE);\n      }\n      else {\n        container.innerHTML = makeFailHTML(GET_A_WEBGL_BROWSER);\n      }\n    }\n    return gl;\n  };\n\n  /**\n   * The Context encapsulates the underlying WebGL native JavaScript API.\n   */\n  mod.Context = Sk.misceval.buildClass(mod, function($gbl, $loc) {\n    $loc.__init__ = new Sk.builtin.func(\n      function(self, canvasid) {\n        var canvas = document.getElementById(canvasid.v);\n        var gl = setupWebGL(canvasid.v, canvas)\n        if (!gl) {\n          throw new Error(\"Your browser does not appear to support WebGL.\");\n        }\n\n        self.gl = gl;\n\n        // Copy symbolic constants and functions from native WebGL, encapsulating where necessary.       \n        for (var k in gl.__proto__) {\n          if (typeof gl.__proto__[k] === 'number') {\n            Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str(k), gl.__proto__[k]);\n          }\n          else if (typeof gl.__proto__[k] === \"function\") {\n            switch(k) {\n              case 'bufferData': {\n              }\n              break;\n              case 'clearColor': {\n              }\n              break;\n              case 'drawArrays': {\n              }\n              break;\n              case 'getAttribLocation': {\n              }\n              break;\n              case 'getUniformLocation': {\n              }\n              break;\n              case 'shaderSource': {\n              }\n              break;\n              case 'uniformMatrix4fv': {\n              }\n              break;\n              case 'vertexAttribPointer': {\n              }\n              break;\n              case 'viewport': {\n              }\n              break;\n              default: {\n                (function(key) {\n                  Sk.abstr.objectSetItem(self['$d'], new Sk.builtin.str(k), new Sk.builtin.func(function() {\n                    var f = gl.__proto__[key];\n                    return f.apply(gl, arguments);\n                  }));\n                 }(k));\n              }\n            }\n          }\n        }\n\n        gl.clearColor(100.0/255.0, 149.0/255.0, 237.0/255.0, 1.0);\n        gl.clear(gl.COLOR_BUFFER_BIT);\n      }\n    );\n\n    $loc.tp$getattr = Sk.builtin.object.prototype.GenericGetAttr;\n\n    $loc.bufferData = new Sk.builtin.func(\n      function(self, target, data, usage) {\n        self.gl.bufferData(target, data.v, usage);\n      }\n    );\n\n    $loc.clearColor = new Sk.builtin.func(\n      function(self, red, green, blue, alpha) {\n        self.gl.clearColor(Sk.builtin.asnum$(red), Sk.builtin.asnum$(green), Sk.builtin.asnum$(blue), Sk.builtin.asnum$(alpha));\n      }\n    );\n\n    $loc.getAttribLocation = new Sk.builtin.func(\n      function(self, program, name) {\n        return self.gl.getAttribLocation(program, name.v);\n      }\n    );\n\n    $loc.getUniformLocation = new Sk.builtin.func(\n      function(self, program, name) {\n        return self.gl.getUniformLocation(program, name.v);\n      }\n    );\n\n    $loc.shaderSource = new Sk.builtin.func(\n      function(self, shader, src) {\n        self.gl.shaderSource(shader, src.v);\n      }\n    );\n\n    $loc.drawArrays = new Sk.builtin.func(\n      function(self, mode, first, count) {\n        self.gl.drawArrays(Sk.builtin.asnum$(mode), Sk.builtin.asnum$(first), Sk.builtin.asnum$(count));\n      }\n    );\n\n    $loc.vertexAttribPointer = new Sk.builtin.func(\n      function(self, index, size, type, normalized, stride, dunno) {\n        self.gl.vertexAttribPointer(index, Sk.builtin.asnum$(size), Sk.builtin.asnum$(type), normalized, Sk.builtin.asnum$(stride), Sk.builtin.asnum$(dunno));\n      }\n    );\n\n    $loc.viewport = new Sk.builtin.func(\n      function(self, x, y, width, height) {\n        self.gl.viewport(Sk.builtin.asnum$(x), Sk.builtin.asnum$(y), Sk.builtin.asnum$(width), Sk.builtin.asnum$(height));\n      }\n    );\n\n    $loc.uniformMatrix4fv = new Sk.builtin.func(\n      function(self, location, transpose, values) {\n//        console.log(\"location  \" + (typeof location));\n//        console.log(\"transpose \" + (typeof transpose));\n//        console.log(\"values.v  \" + (typeof values.v));\n        self.gl.uniformMatrix4fv(Sk.builtin.asnum$(location), transpose, values.v);\n      }\n    );\n\n    $loc.setDrawFunc = new Sk.builtin.func(function(self, func) {\n      var startTime = (new Date()).getTime();\n      var intervalId = setInterval(\n        function() {\n          Sk.misceval.callsim(func, self, (new Date()).getTime() - startTime);\n        }, 1000.0 / 60.0); // 60 fps\n    });\n\n  }, 'Context', []);\n\n  mod.Float32Array = Sk.misceval.buildClass(mod, function($gbl, $loc) {\n    $loc.__init__ = new Sk.builtin.func(function(self, data) {\n      if (typeof data === \"number\") {\n        self.v = new Float32Array(data);\n      }\n      else {\n        self.v = new Float32Array(Sk.ffi.remapToJs(data));\n      }\n    });\n\n    $loc.__repr__ = new Sk.builtin.func(function(self) {\n      var copy = [];\n      for (var i = 0; i < self.v.length; ++i) {\n        copy.push(self.v[i]);\n      }\n      return new Sk.builtin.str(\"[\" + copy.join(', ') + \"]\");\n     });\n  }, 'Float32Array', []);\n\n  /**\n   * A 4x4 (mutable) matrix suitable for OpenGL.\n   *\n   * Mutability is chosen for performance.\n   * The inderlying implementation is Float32Array.\n   * The indexing of the elements is\n   * 0 4  8 12\n   * 1 5  9 13\n   * 2 6 10 14\n   * 3 7 11 15\n   */\n  mod.Matrix4x4 = Sk.misceval.buildClass(mod, function($gbl, $loc) {\n    $loc.__init__ = new Sk.builtin.func(function(self, data) {\n      self.v = new Float32Array(Sk.ffi.remapToJs(data));\n    });\n\n    $loc.identity = new Sk.builtin.func(\n      function(self) {\n\n        var m = self.v;\n\n        m[0]  = 1;\n        m[1]  = 0;\n        m[2]  = 0;\n        m[3]  = 0;\n\n        m[4]  = 0;\n        m[5]  = 1;\n        m[6]  = 0;\n        m[7]  = 0;\n\n        m[8]  = 0;\n        m[9]  = 0;\n        m[10] = 1;\n        m[11] = 0;\n\n        m[12] = 0;\n        m[13] = 0;\n        m[14] = 0;\n        m[15] = 1;\n      }\n    );\n\n    $loc.perspective = new Sk.builtin.func(\n      function(self, fov, aspect, near, far) {\n        \n        var t = Math.tan(Math.PI * 0.5 - 0.5 * (Sk.builtin.asnum$(fov) * Math.PI / 180));\n        var a = Sk.builtin.asnum$(aspect)\n        var n = Sk.builtin.asnum$(near)\n        var f = Sk.builtin.asnum$(far)\n        var k = 1.0 / (n - f);\n\n        var m = self.v;\n\n        m[0]  = t / a;\n        m[1]  = 0;\n        m[2]  = 0;\n        m[3]  = 0;\n\n        m[4]  = 0;\n        m[5]  = t;\n        m[6]  = 0;\n        m[7]  = 0;\n\n        m[8]  = 0;\n        m[9]  = 0;\n        m[10] = (n + f) * k;\n        m[11] = -1;\n\n        m[12] = 0;\n        m[13] = 0;\n        m[14] = n * f * k * 2;\n        m[15] = 0;\n      }\n    );\n\n    $loc.translate = new Sk.builtin.func(\n      function(self, translation) {\n\n        var m = self.v;\n        var t = Sk.ffi.remapToJs(translation);\n\n        m[0]  = 1;\n        m[1]  = 0;\n        m[2]  = 0;\n        m[3]  = 0;\n\n        m[4]  = 0;\n        m[5]  = 1;\n        m[6]  = 0;\n        m[7]  = 0;\n\n        m[8]  = 0;\n        m[9]  = 0;\n        m[10] = 1;\n        m[11] = 0;\n\n        m[12] = t[0];\n        m[13] = t[1];\n        m[14] = t[2];\n        m[15] = 1;\n      }\n    );\n\n    $loc.__repr__ = new Sk.builtin.func(function(self) {\n      var copy = [];\n      for (var i = 0; i < self.v.length; ++i) {\n        copy.push(self.v[i]);\n      }\n      return new Sk.builtin.str(\"[\" + copy.join(', ') + \"]\");\n     });\n  }, 'Matrix4x4', []);\n\n  return mod;\n};", "src/lib/math/__init__.js": "var $builtinmodule = function(name)\n{\n    var mod = {};\n    mod.pi = Sk.builtin.assk$(Math.PI, Sk.builtin.nmber.float$);\n    mod.e =  Sk.builtin.assk$(Math.E, Sk.builtin.nmber.float$);\n\n//\tRNL\tadded\n    mod.fabs = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"fabs\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\treturn new Sk.builtin.nmber(Math.abs(Sk.builtin.asnum$(x)), Sk.builtin.nmber.float$);\n    });\n\n    mod.asin = new Sk.builtin.func(function(rad) {\n        Sk.builtin.pyCheckArgs(\"asin\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"rad\", \"number\", Sk.builtin.checkNumber(rad));\n\n\treturn new Sk.builtin.nmber(Math.asin(Sk.builtin.asnum$(rad)), Sk.builtin.nmber.float$);\n    });\n\n    mod.acos = new Sk.builtin.func(function(rad) {\n        Sk.builtin.pyCheckArgs(\"acos\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"rad\", \"number\", Sk.builtin.checkNumber(rad));\n\n\treturn new Sk.builtin.nmber(Math.acos(Sk.builtin.asnum$(rad)), Sk.builtin.nmber.float$);\n    });\n\n    mod.atan = new Sk.builtin.func(function(rad) {\n        Sk.builtin.pyCheckArgs(\"atan\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"rad\", \"number\", Sk.builtin.checkNumber(rad));\n\n\treturn new Sk.builtin.nmber(Math.atan(Sk.builtin.asnum$(rad)), Sk.builtin.nmber.float$);\n    });\n\n    mod.atan2 = new Sk.builtin.func(function(y, x) {\n        Sk.builtin.pyCheckArgs(\"atan2\", arguments, 2, 2);\n        Sk.builtin.pyCheckType(\"y\", \"number\", Sk.builtin.checkNumber(y));\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\treturn new Sk.builtin.nmber(Math.atan2(Sk.builtin.asnum$(y), Sk.builtin.asnum$(x)), Sk.builtin.nmber.float$);\n    });\n\n    mod.sin = new Sk.builtin.func(function(rad) {\n        Sk.builtin.pyCheckArgs(\"sin\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"rad\", \"number\", Sk.builtin.checkNumber(rad));\n\n\treturn new Sk.builtin.nmber(Math.sin(Sk.builtin.asnum$(rad)), Sk.builtin.nmber.float$);\n    });\n\n    mod.cos = new Sk.builtin.func(function(rad) {\n        Sk.builtin.pyCheckArgs(\"cos\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"rad\", \"number\", Sk.builtin.checkNumber(rad));\n\n\treturn new Sk.builtin.nmber(Math.cos(Sk.builtin.asnum$(rad)), Sk.builtin.nmber.float$);\n    });\n\n    mod.tan = new Sk.builtin.func(function(rad) {\n        Sk.builtin.pyCheckArgs(\"tan\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"rad\", \"number\", Sk.builtin.checkNumber(rad));\n\n\treturn new Sk.builtin.nmber(Math.tan(Sk.builtin.asnum$(rad)), Sk.builtin.nmber.float$);\n    });\n\n    mod.asinh = new Sk.builtin.func(function(x) {\n\tSk.builtin.pyCheckArgs(\"asinh\", arguments, 1, 1);\n\tSk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\tx = Sk.builtin.asnum$(x);\n\n\tvar L = x + Math.sqrt(x*x+1);\n\n\treturn new Sk.builtin.nmber(Math.log(L), Sk.builtin.nmber.float$);\n    });\n\n    mod.acosh = new Sk.builtin.func(function(x) {\n\tSk.builtin.pyCheckArgs(\"acosh\", arguments, 1, 1);\n\tSk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\tx = Sk.builtin.asnum$(x);\n\n\tvar L = x + Math.sqrt(x*x-1);\n\n\treturn new Sk.builtin.nmber(Math.log(L), Sk.builtin.nmber.float$);\n    });\n\n    mod.atanh = new Sk.builtin.func(function(x) {\n\tSk.builtin.pyCheckArgs(\"atanh\", arguments, 1, 1);\n\tSk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\tx = Sk.builtin.asnum$(x);\n\n\tvar L = (1+x)/(1-x);\n\n\treturn new Sk.builtin.nmber(Math.log(L)/2, Sk.builtin.nmber.float$);\n    });\n\n    mod.sinh = new Sk.builtin.func(function(x) {\n\tSk.builtin.pyCheckArgs(\"sinh\", arguments, 1, 1);\n\tSk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\tx = Sk.builtin.asnum$(x);\n\n\tvar e = Math.E;\n\tvar p = Math.pow(e, x);\n\tvar n = 1/p;\n\tvar result = (p-n)/2;\n\n\treturn new Sk.builtin.nmber(result, Sk.builtin.nmber.float$);\n    });\n\n    mod.cosh = new Sk.builtin.func(function(x) {\n\tSk.builtin.pyCheckArgs(\"cosh\", arguments, 1, 1);\n\tSk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\tx = Sk.builtin.asnum$(x);\n\n\tvar e = Math.E;\n\tvar p = Math.pow(e, x);\n\tvar n = 1/p;\n\tvar result = (p+n)/2;\n\n\treturn new Sk.builtin.nmber(result, Sk.builtin.nmber.float$);\n    });\n\n    mod.tanh = new Sk.builtin.func(function(x) {\n\tSk.builtin.pyCheckArgs(\"tanh\", arguments, 1, 1);\n\tSk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\tx = Sk.builtin.asnum$(x);\n\n\tvar e = Math.E;\n\tvar p = Math.pow(e, x);\n\tvar n = 1/p;\n\tvar result = ((p-n)/2)/((p+n)/2);\n\n\treturn new Sk.builtin.nmber(result, Sk.builtin.nmber.float$);\n    });\n\n    mod.ceil = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"ceil\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\treturn new Sk.builtin.nmber(Math.ceil(Sk.builtin.asnum$(x)), Sk.builtin.nmber.float$);\n    });\n\n    mod.floor = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"floor\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\treturn new Sk.builtin.nmber(Math.floor(Sk.builtin.asnum$(x)), Sk.builtin.nmber.float$);\n    });\n\n    mod.sqrt = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"sqrt\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\treturn new Sk.builtin.nmber(Math.sqrt(Sk.builtin.asnum$(x)), Sk.builtin.nmber.float$);\n    });\n\n    mod.trunc = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"trunc\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n        return new Sk.builtin.nmber(Sk.builtin.asnum$(x)|0, Sk.builtin.nmber.int$);\n    });\n\n    mod.log = new Sk.builtin.func(function(x, base) {\n        Sk.builtin.pyCheckArgs(\"log\", arguments, 1, 2);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n        if (base === undefined) {\n\t    return new Sk.builtin.nmber(Math.log(Sk.builtin.asnum$(x)), Sk.builtin.nmber.float$);\n        } else {\n            Sk.builtin.pyCheckType(\"base\", \"number\", Sk.builtin.checkNumber(base));\n            var ret = Math.log(Sk.builtin.asnum$(x)) / Math.log(Sk.builtin.asnum$(base));\n\t    return new Sk.builtin.nmber(ret, Sk.builtin.nmber.float$);\n        }\n    });\n\n    mod.log10 = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"log10\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n        var ret = Math.log(Sk.builtin.asnum$(x)) / Math.log(10);\n\treturn new Sk.builtin.nmber(ret, Sk.builtin.nmber.float$);\n    });\n\n    mod.exp = new Sk.builtin.func(function(x) {\n        Sk.builtin.pyCheckArgs(\"exp\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\treturn new Sk.builtin.nmber(Math.exp(Sk.builtin.asnum$(x)), Sk.builtin.nmber.float$);\n    });\n\n    mod.pow = new Sk.builtin.func(function(x,y) {\n        Sk.builtin.pyCheckArgs(\"pow\", arguments, 2, 2);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n        Sk.builtin.pyCheckType(\"y\", \"number\", Sk.builtin.checkNumber(y));\n\n\treturn new Sk.builtin.nmber(Math.pow(Sk.builtin.asnum$(x), Sk.builtin.asnum$(y)), Sk.builtin.nmber.float$);\n    });\n\n    mod.radians = new Sk.builtin.func(function(deg) {\n        Sk.builtin.pyCheckArgs(\"radians\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"deg\", \"number\", Sk.builtin.checkNumber(deg));\n\n\tvar ret = Math.PI / 180.0 * Sk.builtin.asnum$(deg);\n\treturn new Sk.builtin.nmber(ret, Sk.builtin.nmber.float$);\n    });\n\n    mod.degrees = new Sk.builtin.func(function(rad) {\n        Sk.builtin.pyCheckArgs(\"degrees\", arguments, 1, 1);\n        Sk.builtin.pyCheckType(\"rad\", \"number\", Sk.builtin.checkNumber(rad));\n\n\tvar ret = 180.0 / Math.PI * Sk.builtin.asnum$(rad);\n\treturn new Sk.builtin.nmber(ret, Sk.builtin.nmber.float$);\n    });\n\n    mod.hypot = new Sk.builtin.func(function(x, y) {\n\tSk.builtin.pyCheckArgs(\"hypot\", arguments, 2, 2);\n        Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\tSk.builtin.pyCheckType(\"y\", \"number\", Sk.builtin.checkNumber(y));\n\n\t\tx = Sk.builtin.asnum$(x);\n\t\ty = Sk.builtin.asnum$(y);\n\treturn new Sk.builtin.nmber(Math.sqrt((x*x)+(y*y)), Sk.builtin.nmber.float$);\n    });\n\n\tmod.factorial = new Sk.builtin.func(function(x) {\n\t    Sk.builtin.pyCheckArgs(\"factorial\", arguments, 1, 1);\n            Sk.builtin.pyCheckType(\"x\", \"number\", Sk.builtin.checkNumber(x));\n\n\t\tx = Math.floor(Sk.builtin.asnum$(x));\n\t\tvar r = 1;\n\t\tfor (var i = 2; i <= x; i++)\n\t\t\tr *= i;\n\t\treturn new Sk.builtin.nmber(r, Sk.builtin.nmber.int$);\n\t});\n\n    return mod;\n}"}}