function [quality, quality_map] = imageQualityIndex (img1, img2, block_size)

if (nargin == 1 | nargin > 3)
   quality = -Inf;
   quality_map = -1*ones(size(img1));
   return;
end

if (size(img1) ~= size(img2))
   quality = -Inf;
   quality_map = -1*ones(size(img1));
   return;
end

if (nargin == 2)  % sliding window, B by B
   block_size = 8;
end

img1 = double(img1); % I add this
img2 = double(img2); % I add this

N = block_size.^2;
sum2_filter = ones(block_size);

img1_sq   = img1.*img1;

img2_sq   = img2.*img2;
img12 = img1.*img2;

img1_sum   = filter2(sum2_filter, img1, 'valid');
disp(sum(img1_sum(:)));
img2_sum   = filter2(sum2_filter, img2, 'valid');
% disp(sum(img2_sum(:)));
img1_sq_sum = filter2(sum2_filter, img1_sq, 'valid');
% disp(sum(img1_sq_sum(:)));
img2_sq_sum = filter2(sum2_filter, img2_sq, 'valid');
% disp(sum(img2_sq_sum(:)));
img12_sum = filter2(sum2_filter, img12, 'valid');
% disp(sum(img12_sum(:)));

img12_sum_mul = img1_sum.*img2_sum;
img12_sq_sum_mul = img1_sum.*img1_sum + img2_sum.*img2_sum;
numerator = 4*(N*img12_sum - img12_sum_mul).*img12_sum_mul;
denominator1 = N*(img1_sq_sum + img2_sq_sum) - img12_sq_sum_mul;
denominator = denominator1.*img12_sq_sum_mul;

% disp(sum(denominator(:)));


quality_map = ones(size(denominator));
index = (denominator1 == 0) & (img12_sq_sum_mul ~= 0);
quality_map(index) = 2*img12_sum_mul(index)./img12_sq_sum_mul(index);
index = (denominator ~= 0);
quality_map(index) = numerator(index)./denominator(index);

quality = mean2(quality_map);