"""A setuptools based setup module.
See:
https://packaging.python.org/en/latest/distributing.html
https://github.com/pypa/sampleproject
"""

# Always prefer setuptools over distutils
from setuptools import setup, find_packages
# To use a consistent encoding
from codecs import open
from os import path

here = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()


setup(
    name='pyspedas',
    version='0.6.29',
    description='Python Space Physics Environment Data Analysis \
                    Software (SPEDAS)',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/nickssl/pyspedas',
    author='Nick Hatzigeorgiu',
    author_email='nikos@berkeley.edu',
    license='MIT',
    classifiers=['Development Status :: 4 - Beta',
                 'Intended Audience :: Science/Research',
                 'Topic :: Scientific/Engineering',
                 'License :: OSI Approved :: MIT License',
                 'Programming Language :: Python :: 3',
                 ],
    keywords='spedas data tools',
    project_urls={'Information': 'http://spedas.org/wiki/',
                  },
    packages=find_packages(exclude=['contrib', 'docs', 'tests*']),
    install_requires=['pytplot', 'cdflib', 'msgpack', 'bokeh', 'nodejs',
                      'pyqtgraph', 'numpy', 'pydivide'],
    python_requires='>=3.5',
)
