from dataclasses import dataclass
from typing import Any, Callable, ClassVar, Literal, Optional, Type

from pydantic import BaseModel, ConfigDict
from typer.core import MarkupMode, TyperGroup

# noinspection PyProtectedMember
from ...config._names import (
    ExternalPluginLoaderDefinitions as Epdf,
)

# noinspection PyProtectedMember
from ...config._names import (
    InternalPluginLoaderDefinitions as Ipdf,
)
from ...names import AppIdentity
from ...pre_utils import LayerLoader, PublicLayerNames


class TyperArgs(BaseModel, validate_assignment=True):
    model_config = ConfigDict(arbitrary_types_allowed=True)
    name: Optional[str] = None
    cls: Optional[Type[TyperGroup]] = None  # Modified
    invoke_without_command: bool = False
    no_args_is_help: bool = True  # Modified
    subcommand_metavar: Optional[str] = None
    chain: bool = False
    result_callback: Optional[Callable[..., Any]] = None
    # Command
    context_settings: Optional[dict[Any, Any]] = None
    callback: Optional[Callable[..., Any]] = None
    help: Optional[str] = None
    epilog: Optional[str] = None
    short_help: Optional[str] = None
    options_metavar: str = "[OPTIONS]"
    add_help_option: bool = True
    hidden: bool = False
    deprecated: bool = False
    add_completion: bool = True
    # Rich settings
    rich_markup_mode: MarkupMode | Literal["rich-click"] = "markdown"  # Modified
    rich_help_panel: str | None = None
    suggest_commands: bool = True
    pretty_exceptions_enable: bool = True
    pretty_exceptions_show_locals: bool = False
    pretty_exceptions_short: bool = True


@dataclass
class TyperRichPanelNames:
    internal_plugins: ClassVar[str] = f"{Ipdf.name.capitalize()} plugins"
    external_plugins: ClassVar[str] = f"{Epdf.name.capitalize()} plugins"
    messages: ClassVar[str] = "ⓘ Messages"
    callback: ClassVar[str] = f"{AppIdentity.app_fancy_name} global options"


@dataclass
class TyperGlobalOptions:
    config_file: ClassVar[tuple[str, str]] = (
        "--config-file",
        "--C",
    )


if LayerLoader.is_bootstrap_mode():
    LayerLoader.load_layers(
        globals(),
        layer_names=(PublicLayerNames.names,),
    )
