"""add API transaction table [857843db1bcf].

Revision ID: 857843db1bcf
Revises: 0.83.0
Create Date: 2025-06-13 19:47:14.165158

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op
from sqlalchemy.dialects.mysql import MEDIUMTEXT

# revision identifiers, used by Alembic.
revision = "857843db1bcf"
down_revision = "0.83.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "api_transaction",
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column(
            "method", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("url", sa.TEXT(), nullable=False),
        sa.Column("completed", sa.Boolean(), nullable=False),
        sa.Column(
            "result",
            MEDIUMTEXT
            if op.get_bind().dialect.name == "mysql"
            else sa.String(length=16777215),
            nullable=True,
        ),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("expired", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_api_transaction_user_id_user",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        "ix_api_transaction_completed_expired",
        "api_transaction",
        ["completed", "expired"],
        unique=False,
    )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "ix_api_transaction_completed_expired",
        table_name="api_transaction",
    )
    op.drop_table("api_transaction")
    # ### end Alembic commands ###
