# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessRuleArgs', 'AccessRule']

@pulumi.input_type
class AccessRuleArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['AccessRuleConfigurationArgs'],
                 mode: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessRule resource.
        :param pulumi.Input['AccessRuleConfigurationArgs'] configuration: The rule configuration.
        :param pulumi.Input[_builtins.str] mode: The action to apply to a matched request.
               Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        :param pulumi.Input[_builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[_builtins.str] notes: An informative summary of the rule, typically used as a reminder or explanation.
        :param pulumi.Input[_builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "mode", mode)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['AccessRuleConfigurationArgs']:
        """
        The rule configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['AccessRuleConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        The action to apply to a matched request.
        Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the rule, typically used as a reminder or explanation.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _AccessRuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configuration: Optional[pulumi.Input['AccessRuleConfigurationArgs']] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input['AccessRuleScopeArgs']] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessRule resources.
        :param pulumi.Input[_builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_modes: The available actions that a rule can apply to a matched request.
        :param pulumi.Input['AccessRuleConfigurationArgs'] configuration: The rule configuration.
        :param pulumi.Input[_builtins.str] created_on: The timestamp of when the rule was created.
        :param pulumi.Input[_builtins.str] mode: The action to apply to a matched request.
               Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        :param pulumi.Input[_builtins.str] modified_on: The timestamp of when the rule was last modified.
        :param pulumi.Input[_builtins.str] notes: An informative summary of the rule, typically used as a reminder or explanation.
        :param pulumi.Input['AccessRuleScopeArgs'] scope: All zones owned by the user will have the rule applied.
        :param pulumi.Input[_builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allowed_modes is not None:
            pulumi.set(__self__, "allowed_modes", allowed_modes)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedModes")
    def allowed_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The available actions that a rule can apply to a matched request.
        """
        return pulumi.get(self, "allowed_modes")

    @allowed_modes.setter
    def allowed_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_modes", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['AccessRuleConfigurationArgs']]:
        """
        The rule configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['AccessRuleConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the rule was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to apply to a matched request.
        Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the rule, typically used as a reminder or explanation.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['AccessRuleScopeArgs']]:
        """
        All zones owned by the user will have the rule applied.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['AccessRuleScopeArgs']]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/accessRule:AccessRule")
class AccessRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['AccessRuleConfigurationArgs', 'AccessRuleConfigurationArgsDict']]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_access_rule = cloudflare.AccessRule("example_access_rule",
            configuration={
                "target": "ip",
                "value": "198.51.100.4",
            },
            mode="challenge",
            zone_id="zone_id",
            notes="This rule is enabled because of an event that occurred on date X.")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessRule:AccessRule example '<{accounts|zones}/{account_id|zone_id}>/<rule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Union['AccessRuleConfigurationArgs', 'AccessRuleConfigurationArgsDict']] configuration: The rule configuration.
        :param pulumi.Input[_builtins.str] mode: The action to apply to a matched request.
               Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        :param pulumi.Input[_builtins.str] notes: An informative summary of the rule, typically used as a reminder or explanation.
        :param pulumi.Input[_builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_access_rule = cloudflare.AccessRule("example_access_rule",
            configuration={
                "target": "ip",
                "value": "198.51.100.4",
            },
            mode="challenge",
            zone_id="zone_id",
            notes="This rule is enabled because of an event that occurred on date X.")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessRule:AccessRule example '<{accounts|zones}/{account_id|zone_id}>/<rule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param AccessRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['AccessRuleConfigurationArgs', 'AccessRuleConfigurationArgsDict']]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessRuleArgs.__new__(AccessRuleArgs)

            __props__.__dict__["account_id"] = account_id
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["notes"] = notes
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["allowed_modes"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["scope"] = None
        super(AccessRule, __self__).__init__(
            'cloudflare:index/accessRule:AccessRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            configuration: Optional[pulumi.Input[Union['AccessRuleConfigurationArgs', 'AccessRuleConfigurationArgsDict']]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            notes: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[Union['AccessRuleScopeArgs', 'AccessRuleScopeArgsDict']]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessRule':
        """
        Get an existing AccessRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_modes: The available actions that a rule can apply to a matched request.
        :param pulumi.Input[Union['AccessRuleConfigurationArgs', 'AccessRuleConfigurationArgsDict']] configuration: The rule configuration.
        :param pulumi.Input[_builtins.str] created_on: The timestamp of when the rule was created.
        :param pulumi.Input[_builtins.str] mode: The action to apply to a matched request.
               Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        :param pulumi.Input[_builtins.str] modified_on: The timestamp of when the rule was last modified.
        :param pulumi.Input[_builtins.str] notes: An informative summary of the rule, typically used as a reminder or explanation.
        :param pulumi.Input[Union['AccessRuleScopeArgs', 'AccessRuleScopeArgsDict']] scope: All zones owned by the user will have the rule applied.
        :param pulumi.Input[_builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessRuleState.__new__(_AccessRuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allowed_modes"] = allowed_modes
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["mode"] = mode
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["notes"] = notes
        __props__.__dict__["scope"] = scope
        __props__.__dict__["zone_id"] = zone_id
        return AccessRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="allowedModes")
    def allowed_modes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The available actions that a rule can apply to a matched request.
        """
        return pulumi.get(self, "allowed_modes")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.AccessRuleConfiguration']:
        """
        The rule configuration.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the rule was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        The action to apply to a matched request.
        Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An informative summary of the rule, typically used as a reminder or explanation.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output['outputs.AccessRuleScope']:
        """
        All zones owned by the user will have the rule applied.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

