# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApiShieldDiscoveryOperationArgs', 'ApiShieldDiscoveryOperation']

@pulumi.input_type
class ApiShieldDiscoveryOperationArgs:
    def __init__(__self__, *,
                 operation_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApiShieldDiscoveryOperation resource.
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[_builtins.str] state: Mark state of operation in API Discovery
                 * `review` - Mark operation as for review
                 * `ignored` - Mark operation as ignored
               Available values: "review", "ignored".
        """
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> pulumi.Input[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mark state of operation in API Discovery
          * `review` - Mark operation as for review
          * `ignored` - Mark operation as ignored
        Available values: "review", "ignored".
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _ApiShieldDiscoveryOperationState:
    def __init__(__self__, *,
                 operation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiShieldDiscoveryOperation resources.
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] state: Mark state of operation in API Discovery
                 * `review` - Mark operation as for review
                 * `ignored` - Mark operation as ignored
               Available values: "review", "ignored".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID.
        """
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mark state of operation in API Discovery
          * `review` - Mark operation as for review
          * `ignored` - Mark operation as ignored
        Available values: "review", "ignored".
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/apiShieldDiscoveryOperation:ApiShieldDiscoveryOperation")
class ApiShieldDiscoveryOperation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 operation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_api_shield_discovery_operation = cloudflare.ApiShieldDiscoveryOperation("example_api_shield_discovery_operation",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            operation_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            state="review")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] state: Mark state of operation in API Discovery
                 * `review` - Mark operation as for review
                 * `ignored` - Mark operation as ignored
               Available values: "review", "ignored".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiShieldDiscoveryOperationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_api_shield_discovery_operation = cloudflare.ApiShieldDiscoveryOperation("example_api_shield_discovery_operation",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            operation_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            state="review")
        ```

        :param str resource_name: The name of the resource.
        :param ApiShieldDiscoveryOperationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiShieldDiscoveryOperationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 operation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiShieldDiscoveryOperationArgs.__new__(ApiShieldDiscoveryOperationArgs)

            if operation_id is None and not opts.urn:
                raise TypeError("Missing required property 'operation_id'")
            __props__.__dict__["operation_id"] = operation_id
            __props__.__dict__["state"] = state
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(ApiShieldDiscoveryOperation, __self__).__init__(
            'cloudflare:index/apiShieldDiscoveryOperation:ApiShieldDiscoveryOperation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            operation_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiShieldDiscoveryOperation':
        """
        Get an existing ApiShieldDiscoveryOperation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] state: Mark state of operation in API Discovery
                 * `review` - Mark operation as for review
                 * `ignored` - Mark operation as ignored
               Available values: "review", "ignored".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiShieldDiscoveryOperationState.__new__(_ApiShieldDiscoveryOperationState)

        __props__.__dict__["operation_id"] = operation_id
        __props__.__dict__["state"] = state
        __props__.__dict__["zone_id"] = zone_id
        return ApiShieldDiscoveryOperation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "operation_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mark state of operation in API Discovery
          * `review` - Mark operation as for review
          * `ignored` - Mark operation as ignored
        Available values: "review", "ignored".
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

