# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudConnectorRulesArgs', 'CloudConnectorRules']

@pulumi.input_type
class CloudConnectorRulesArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[_builtins.str],
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConnectorRulesRuleArgs']]]] = None):
        """
        The set of arguments for constructing a CloudConnectorRules resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudConnectorRulesRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConnectorRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _CloudConnectorRulesState:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConnectorRulesRuleArgs']]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudConnectorRules resources.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudConnectorRulesRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConnectorRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/cloudConnectorRules:CloudConnectorRules")
class CloudConnectorRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudConnectorRulesRuleArgs', 'CloudConnectorRulesRuleArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloud_connector_rules = cloudflare.CloudConnectorRules("example_cloud_connector_rules",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            rules=[{
                "id": "95c365e17e1b46599cd99e5b231fac4e",
                "description": "Rule description",
                "enabled": True,
                "expression": "http.cookie eq \\"a=b\\"",
                "parameters": {
                    "host": "examplebucket.s3.eu-north-1.amazonaws.com",
                },
                "provider": "aws_s3",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudConnectorRules:CloudConnectorRules example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudConnectorRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloud_connector_rules = cloudflare.CloudConnectorRules("example_cloud_connector_rules",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            rules=[{
                "id": "95c365e17e1b46599cd99e5b231fac4e",
                "description": "Rule description",
                "enabled": True,
                "expression": "http.cookie eq \\"a=b\\"",
                "parameters": {
                    "host": "examplebucket.s3.eu-north-1.amazonaws.com",
                },
                "provider": "aws_s3",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudConnectorRules:CloudConnectorRules example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param CloudConnectorRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudConnectorRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudConnectorRulesRuleArgs', 'CloudConnectorRulesRuleArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudConnectorRulesArgs.__new__(CloudConnectorRulesArgs)

            __props__.__dict__["rules"] = rules
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(CloudConnectorRules, __self__).__init__(
            'cloudflare:index/cloudConnectorRules:CloudConnectorRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudConnectorRulesRuleArgs', 'CloudConnectorRulesRuleArgsDict']]]]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudConnectorRules':
        """
        Get an existing CloudConnectorRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudConnectorRulesState.__new__(_CloudConnectorRulesState)

        __props__.__dict__["rules"] = rules
        __props__.__dict__["zone_id"] = zone_id
        return CloudConnectorRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.CloudConnectorRulesRule']]]:
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

