# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeviceManagedNetworksArgs', 'DeviceManagedNetworks']

@pulumi.input_type
class DeviceManagedNetworksArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 config: pulumi.Input['DeviceManagedNetworksConfigArgs'],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DeviceManagedNetworks resource.
        :param pulumi.Input['DeviceManagedNetworksConfigArgs'] config: The configuration object containing information for the WARP client to detect the managed network.
        :param pulumi.Input[_builtins.str] name: The name of the device managed network. This name must be unique.
        :param pulumi.Input[_builtins.str] type: The type of device managed network.
               Available values: "tls".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['DeviceManagedNetworksConfigArgs']:
        """
        The configuration object containing information for the WARP client to detect the managed network.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['DeviceManagedNetworksConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the device managed network. This name must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of device managed network.
        Available values: "tls".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DeviceManagedNetworksState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input['DeviceManagedNetworksConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DeviceManagedNetworks resources.
        :param pulumi.Input['DeviceManagedNetworksConfigArgs'] config: The configuration object containing information for the WARP client to detect the managed network.
        :param pulumi.Input[_builtins.str] name: The name of the device managed network. This name must be unique.
        :param pulumi.Input[_builtins.str] network_id: API UUID.
        :param pulumi.Input[_builtins.str] type: The type of device managed network.
               Available values: "tls".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DeviceManagedNetworksConfigArgs']]:
        """
        The configuration object containing information for the WARP client to detect the managed network.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DeviceManagedNetworksConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the device managed network. This name must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API UUID.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of device managed network.
        Available values: "tls".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


warnings.warn("""cloudflare.index/devicemanagednetworks.DeviceManagedNetworks has been deprecated in favor of cloudflare.index/zerotrustdevicemanagednetworks.ZeroTrustDeviceManagedNetworks""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/deviceManagedNetworks:DeviceManagedNetworks")
class DeviceManagedNetworks(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/devicemanagednetworks.DeviceManagedNetworks has been deprecated in favor of cloudflare.index/zerotrustdevicemanagednetworks.ZeroTrustDeviceManagedNetworks""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['DeviceManagedNetworksConfigArgs', 'DeviceManagedNetworksConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/deviceManagedNetworks:DeviceManagedNetworks example '<account_id>/<network_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeviceManagedNetworksConfigArgs', 'DeviceManagedNetworksConfigArgsDict']] config: The configuration object containing information for the WARP client to detect the managed network.
        :param pulumi.Input[_builtins.str] name: The name of the device managed network. This name must be unique.
        :param pulumi.Input[_builtins.str] type: The type of device managed network.
               Available values: "tls".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceManagedNetworksArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/deviceManagedNetworks:DeviceManagedNetworks example '<account_id>/<network_id>'
        ```

        :param str resource_name: The name of the resource.
        :param DeviceManagedNetworksArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceManagedNetworksArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['DeviceManagedNetworksConfigArgs', 'DeviceManagedNetworksConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""DeviceManagedNetworks is deprecated: cloudflare.index/devicemanagednetworks.DeviceManagedNetworks has been deprecated in favor of cloudflare.index/zerotrustdevicemanagednetworks.ZeroTrustDeviceManagedNetworks""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceManagedNetworksArgs.__new__(DeviceManagedNetworksArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["network_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/deviceManagedNetworks:DeviceManagedNetworks")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(DeviceManagedNetworks, __self__).__init__(
            'cloudflare:index/deviceManagedNetworks:DeviceManagedNetworks',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[Union['DeviceManagedNetworksConfigArgs', 'DeviceManagedNetworksConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DeviceManagedNetworks':
        """
        Get an existing DeviceManagedNetworks resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeviceManagedNetworksConfigArgs', 'DeviceManagedNetworksConfigArgsDict']] config: The configuration object containing information for the WARP client to detect the managed network.
        :param pulumi.Input[_builtins.str] name: The name of the device managed network. This name must be unique.
        :param pulumi.Input[_builtins.str] network_id: API UUID.
        :param pulumi.Input[_builtins.str] type: The type of device managed network.
               Available values: "tls".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceManagedNetworksState.__new__(_DeviceManagedNetworksState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["config"] = config
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["type"] = type
        return DeviceManagedNetworks(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.DeviceManagedNetworksConfig']:
        """
        The configuration object containing information for the WARP client to detect the managed network.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the device managed network. This name must be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        API UUID.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of device managed network.
        Available values: "tls".
        """
        return pulumi.get(self, "type")

