# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DnsZoneTransfersTsigArgs', 'DnsZoneTransfersTsig']

@pulumi.input_type
class DnsZoneTransfersTsigArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 algo: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 secret: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DnsZoneTransfersTsig resource.
        :param pulumi.Input[_builtins.str] algo: TSIG algorithm.
        :param pulumi.Input[_builtins.str] name: TSIG key name.
        :param pulumi.Input[_builtins.str] secret: TSIG secret.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "algo", algo)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def algo(self) -> pulumi.Input[_builtins.str]:
        """
        TSIG algorithm.
        """
        return pulumi.get(self, "algo")

    @algo.setter
    def algo(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algo", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        TSIG key name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Input[_builtins.str]:
        """
        TSIG secret.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class _DnsZoneTransfersTsigState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 algo: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsZoneTransfersTsig resources.
        :param pulumi.Input[_builtins.str] algo: TSIG algorithm.
        :param pulumi.Input[_builtins.str] name: TSIG key name.
        :param pulumi.Input[_builtins.str] secret: TSIG secret.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if algo is not None:
            pulumi.set(__self__, "algo", algo)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def algo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TSIG algorithm.
        """
        return pulumi.get(self, "algo")

    @algo.setter
    def algo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algo", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TSIG key name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TSIG secret.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)


@pulumi.type_token("cloudflare:index/dnsZoneTransfersTsig:DnsZoneTransfersTsig")
class DnsZoneTransfersTsig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 algo: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_dns_zone_transfers_tsig = cloudflare.DnsZoneTransfersTsig("example_dns_zone_transfers_tsig",
            account_id="01a7362d577a6c3019a474fd6f485823",
            algo="hmac-sha512.",
            name="tsig.customer.cf.",
            secret="caf79a7804b04337c9c66ccd7bef9190a1e1679b5dd03d8aa10f7ad45e1a9dab92b417896c15d4d007c7c14194538d2a5d0feffdecc5a7f0e1c570cfa700837c")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dnsZoneTransfersTsig:DnsZoneTransfersTsig example '<account_id>/<tsig_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algo: TSIG algorithm.
        :param pulumi.Input[_builtins.str] name: TSIG key name.
        :param pulumi.Input[_builtins.str] secret: TSIG secret.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsZoneTransfersTsigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_dns_zone_transfers_tsig = cloudflare.DnsZoneTransfersTsig("example_dns_zone_transfers_tsig",
            account_id="01a7362d577a6c3019a474fd6f485823",
            algo="hmac-sha512.",
            name="tsig.customer.cf.",
            secret="caf79a7804b04337c9c66ccd7bef9190a1e1679b5dd03d8aa10f7ad45e1a9dab92b417896c15d4d007c7c14194538d2a5d0feffdecc5a7f0e1c570cfa700837c")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dnsZoneTransfersTsig:DnsZoneTransfersTsig example '<account_id>/<tsig_id>'
        ```

        :param str resource_name: The name of the resource.
        :param DnsZoneTransfersTsigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsZoneTransfersTsigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 algo: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsZoneTransfersTsigArgs.__new__(DnsZoneTransfersTsigArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if algo is None and not opts.urn:
                raise TypeError("Missing required property 'algo'")
            __props__.__dict__["algo"] = algo
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if secret is None and not opts.urn:
                raise TypeError("Missing required property 'secret'")
            __props__.__dict__["secret"] = None if secret is None else pulumi.Output.secret(secret)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DnsZoneTransfersTsig, __self__).__init__(
            'cloudflare:index/dnsZoneTransfersTsig:DnsZoneTransfersTsig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            algo: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsZoneTransfersTsig':
        """
        Get an existing DnsZoneTransfersTsig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algo: TSIG algorithm.
        :param pulumi.Input[_builtins.str] name: TSIG key name.
        :param pulumi.Input[_builtins.str] secret: TSIG secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsZoneTransfersTsigState.__new__(_DnsZoneTransfersTsigState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["algo"] = algo
        __props__.__dict__["name"] = name
        __props__.__dict__["secret"] = secret
        return DnsZoneTransfersTsig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def algo(self) -> pulumi.Output[_builtins.str]:
        """
        TSIG algorithm.
        """
        return pulumi.get(self, "algo")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        TSIG key name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[_builtins.str]:
        """
        TSIG secret.
        """
        return pulumi.get(self, "secret")

