# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EmailSecurityBlockSenderArgs', 'EmailSecurityBlockSender']

@pulumi.input_type
class EmailSecurityBlockSenderArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 is_regex: pulumi.Input[_builtins.bool],
                 pattern: pulumi.Input[_builtins.str],
                 pattern_type: pulumi.Input[_builtins.str],
                 comments: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EmailSecurityBlockSender resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] pattern_type: Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "is_regex", is_regex)
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "pattern_type", pattern_type)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="isRegex")
    def is_regex(self) -> pulumi.Input[_builtins.bool]:
        return pulumi.get(self, "is_regex")

    @is_regex.setter
    def is_regex(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_regex", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Input[_builtins.str]:
        """
        Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pattern_type", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)


@pulumi.input_type
class _EmailSecurityBlockSenderState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 is_regex: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EmailSecurityBlockSender resources.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] pattern_type: Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if is_regex is not None:
            pulumi.set(__self__, "is_regex", is_regex)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_type is not None:
            pulumi.set(__self__, "pattern_type", pattern_type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="isRegex")
    def is_regex(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_regex")

    @is_regex.setter
    def is_regex(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_regex", value)

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern_type", value)


@pulumi.type_token("cloudflare:index/emailSecurityBlockSender:EmailSecurityBlockSender")
class EmailSecurityBlockSender(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 is_regex: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_security_block_sender = cloudflare.EmailSecurityBlockSender("example_email_security_block_sender",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            is_regex=True,
            pattern="x",
            pattern_type="EMAIL",
            comments="comments")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailSecurityBlockSender:EmailSecurityBlockSender example '<account_id>/<pattern_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] pattern_type: Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailSecurityBlockSenderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_security_block_sender = cloudflare.EmailSecurityBlockSender("example_email_security_block_sender",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            is_regex=True,
            pattern="x",
            pattern_type="EMAIL",
            comments="comments")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailSecurityBlockSender:EmailSecurityBlockSender example '<account_id>/<pattern_id>'
        ```

        :param str resource_name: The name of the resource.
        :param EmailSecurityBlockSenderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailSecurityBlockSenderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 is_regex: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailSecurityBlockSenderArgs.__new__(EmailSecurityBlockSenderArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["comments"] = comments
            if is_regex is None and not opts.urn:
                raise TypeError("Missing required property 'is_regex'")
            __props__.__dict__["is_regex"] = is_regex
            if pattern is None and not opts.urn:
                raise TypeError("Missing required property 'pattern'")
            __props__.__dict__["pattern"] = pattern
            if pattern_type is None and not opts.urn:
                raise TypeError("Missing required property 'pattern_type'")
            __props__.__dict__["pattern_type"] = pattern_type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["last_modified"] = None
        super(EmailSecurityBlockSender, __self__).__init__(
            'cloudflare:index/emailSecurityBlockSender:EmailSecurityBlockSender',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            is_regex: Optional[pulumi.Input[_builtins.bool]] = None,
            last_modified: Optional[pulumi.Input[_builtins.str]] = None,
            pattern: Optional[pulumi.Input[_builtins.str]] = None,
            pattern_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'EmailSecurityBlockSender':
        """
        Get an existing EmailSecurityBlockSender resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] pattern_type: Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailSecurityBlockSenderState.__new__(_EmailSecurityBlockSenderState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["comments"] = comments
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["is_regex"] = is_regex
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["pattern_type"] = pattern_type
        return EmailSecurityBlockSender(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="isRegex")
    def is_regex(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_regex")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Output[_builtins.str]:
        """
        Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        return pulumi.get(self, "pattern_type")

