# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEmailRoutingCatchAllResult',
    'AwaitableGetEmailRoutingCatchAllResult',
    'get_email_routing_catch_all',
    'get_email_routing_catch_all_output',
]

@pulumi.output_type
class GetEmailRoutingCatchAllResult:
    """
    A collection of values returned by getEmailRoutingCatchAll.
    """
    def __init__(__self__, actions=None, enabled=None, id=None, matchers=None, name=None, tag=None, zone_id=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if matchers and not isinstance(matchers, list):
            raise TypeError("Expected argument 'matchers' to be a list")
        pulumi.set(__self__, "matchers", matchers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetEmailRoutingCatchAllActionResult']:
        """
        List actions for the catch-all routing rule.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Routing rule status.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Routing rule identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def matchers(self) -> Sequence['outputs.GetEmailRoutingCatchAllMatcherResult']:
        """
        List of matchers for the catch-all routing rule.
        """
        return pulumi.get(self, "matchers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Routing rule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> _builtins.str:
        """
        Routing rule tag. (Deprecated, replaced by routing rule identifier)
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetEmailRoutingCatchAllResult(GetEmailRoutingCatchAllResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailRoutingCatchAllResult(
            actions=self.actions,
            enabled=self.enabled,
            id=self.id,
            matchers=self.matchers,
            name=self.name,
            tag=self.tag,
            zone_id=self.zone_id)


def get_email_routing_catch_all(zone_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailRoutingCatchAllResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_routing_catch_all = cloudflare.get_email_routing_catch_all(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getEmailRoutingCatchAll:getEmailRoutingCatchAll', __args__, opts=opts, typ=GetEmailRoutingCatchAllResult).value

    return AwaitableGetEmailRoutingCatchAllResult(
        actions=pulumi.get(__ret__, 'actions'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        matchers=pulumi.get(__ret__, 'matchers'),
        name=pulumi.get(__ret__, 'name'),
        tag=pulumi.get(__ret__, 'tag'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_email_routing_catch_all_output(zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailRoutingCatchAllResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_routing_catch_all = cloudflare.get_email_routing_catch_all(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getEmailRoutingCatchAll:getEmailRoutingCatchAll', __args__, opts=opts, typ=GetEmailRoutingCatchAllResult)
    return __ret__.apply(lambda __response__: GetEmailRoutingCatchAllResult(
        actions=pulumi.get(__response__, 'actions'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        matchers=pulumi.get(__response__, 'matchers'),
        name=pulumi.get(__response__, 'name'),
        tag=pulumi.get(__response__, 'tag'),
        zone_id=pulumi.get(__response__, 'zone_id')))
