# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLoadBalancerMonitorResult',
    'AwaitableGetLoadBalancerMonitorResult',
    'get_load_balancer_monitor',
    'get_load_balancer_monitor_output',
]

@pulumi.output_type
class GetLoadBalancerMonitorResult:
    """
    A collection of values returned by getLoadBalancerMonitor.
    """
    def __init__(__self__, account_id=None, allow_insecure=None, consecutive_down=None, consecutive_up=None, created_on=None, description=None, expected_body=None, expected_codes=None, follow_redirects=None, header=None, id=None, interval=None, method=None, modified_on=None, monitor_id=None, path=None, port=None, probe_zone=None, retries=None, timeout=None, type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if allow_insecure and not isinstance(allow_insecure, bool):
            raise TypeError("Expected argument 'allow_insecure' to be a bool")
        pulumi.set(__self__, "allow_insecure", allow_insecure)
        if consecutive_down and not isinstance(consecutive_down, int):
            raise TypeError("Expected argument 'consecutive_down' to be a int")
        pulumi.set(__self__, "consecutive_down", consecutive_down)
        if consecutive_up and not isinstance(consecutive_up, int):
            raise TypeError("Expected argument 'consecutive_up' to be a int")
        pulumi.set(__self__, "consecutive_up", consecutive_up)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expected_body and not isinstance(expected_body, str):
            raise TypeError("Expected argument 'expected_body' to be a str")
        pulumi.set(__self__, "expected_body", expected_body)
        if expected_codes and not isinstance(expected_codes, str):
            raise TypeError("Expected argument 'expected_codes' to be a str")
        pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects and not isinstance(follow_redirects, bool):
            raise TypeError("Expected argument 'follow_redirects' to be a bool")
        pulumi.set(__self__, "follow_redirects", follow_redirects)
        if header and not isinstance(header, dict):
            raise TypeError("Expected argument 'header' to be a dict")
        pulumi.set(__self__, "header", header)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interval and not isinstance(interval, int):
            raise TypeError("Expected argument 'interval' to be a int")
        pulumi.set(__self__, "interval", interval)
        if method and not isinstance(method, str):
            raise TypeError("Expected argument 'method' to be a str")
        pulumi.set(__self__, "method", method)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if monitor_id and not isinstance(monitor_id, str):
            raise TypeError("Expected argument 'monitor_id' to be a str")
        pulumi.set(__self__, "monitor_id", monitor_id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if probe_zone and not isinstance(probe_zone, str):
            raise TypeError("Expected argument 'probe_zone' to be a str")
        pulumi.set(__self__, "probe_zone", probe_zone)
        if retries and not isinstance(retries, int):
            raise TypeError("Expected argument 'retries' to be a int")
        pulumi.set(__self__, "retries", retries)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> _builtins.bool:
        """
        Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "allow_insecure")

    @_builtins.property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> _builtins.int:
        """
        To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_down")

    @_builtins.property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> _builtins.int:
        """
        To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_up")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> _builtins.str:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_body")

    @_builtins.property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> _builtins.str:
        """
        The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_codes")

    @_builtins.property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> _builtins.bool:
        """
        Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "follow_redirects")

    @_builtins.property
    @pulumi.getter
    def header(self) -> Mapping[str, Sequence[_builtins.str]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="probeZone")
    def probe_zone(self) -> _builtins.str:
        """
        Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "probe_zone")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        The timeout (in seconds) before marking the health check as failed.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
        Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        return pulumi.get(self, "type")


class AwaitableGetLoadBalancerMonitorResult(GetLoadBalancerMonitorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancerMonitorResult(
            account_id=self.account_id,
            allow_insecure=self.allow_insecure,
            consecutive_down=self.consecutive_down,
            consecutive_up=self.consecutive_up,
            created_on=self.created_on,
            description=self.description,
            expected_body=self.expected_body,
            expected_codes=self.expected_codes,
            follow_redirects=self.follow_redirects,
            header=self.header,
            id=self.id,
            interval=self.interval,
            method=self.method,
            modified_on=self.modified_on,
            monitor_id=self.monitor_id,
            path=self.path,
            port=self.port,
            probe_zone=self.probe_zone,
            retries=self.retries,
            timeout=self.timeout,
            type=self.type)


def get_load_balancer_monitor(account_id: Optional[_builtins.str] = None,
                              monitor_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancerMonitorResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer_monitor = cloudflare.get_load_balancer_monitor(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        monitor_id="f1aba936b94213e5b8dca0c0dbf1f9cc")
    ```


    :param _builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['monitorId'] = monitor_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getLoadBalancerMonitor:getLoadBalancerMonitor', __args__, opts=opts, typ=GetLoadBalancerMonitorResult).value

    return AwaitableGetLoadBalancerMonitorResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        allow_insecure=pulumi.get(__ret__, 'allow_insecure'),
        consecutive_down=pulumi.get(__ret__, 'consecutive_down'),
        consecutive_up=pulumi.get(__ret__, 'consecutive_up'),
        created_on=pulumi.get(__ret__, 'created_on'),
        description=pulumi.get(__ret__, 'description'),
        expected_body=pulumi.get(__ret__, 'expected_body'),
        expected_codes=pulumi.get(__ret__, 'expected_codes'),
        follow_redirects=pulumi.get(__ret__, 'follow_redirects'),
        header=pulumi.get(__ret__, 'header'),
        id=pulumi.get(__ret__, 'id'),
        interval=pulumi.get(__ret__, 'interval'),
        method=pulumi.get(__ret__, 'method'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        monitor_id=pulumi.get(__ret__, 'monitor_id'),
        path=pulumi.get(__ret__, 'path'),
        port=pulumi.get(__ret__, 'port'),
        probe_zone=pulumi.get(__ret__, 'probe_zone'),
        retries=pulumi.get(__ret__, 'retries'),
        timeout=pulumi.get(__ret__, 'timeout'),
        type=pulumi.get(__ret__, 'type'))
def get_load_balancer_monitor_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     monitor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadBalancerMonitorResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer_monitor = cloudflare.get_load_balancer_monitor(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        monitor_id="f1aba936b94213e5b8dca0c0dbf1f9cc")
    ```


    :param _builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['monitorId'] = monitor_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getLoadBalancerMonitor:getLoadBalancerMonitor', __args__, opts=opts, typ=GetLoadBalancerMonitorResult)
    return __ret__.apply(lambda __response__: GetLoadBalancerMonitorResult(
        account_id=pulumi.get(__response__, 'account_id'),
        allow_insecure=pulumi.get(__response__, 'allow_insecure'),
        consecutive_down=pulumi.get(__response__, 'consecutive_down'),
        consecutive_up=pulumi.get(__response__, 'consecutive_up'),
        created_on=pulumi.get(__response__, 'created_on'),
        description=pulumi.get(__response__, 'description'),
        expected_body=pulumi.get(__response__, 'expected_body'),
        expected_codes=pulumi.get(__response__, 'expected_codes'),
        follow_redirects=pulumi.get(__response__, 'follow_redirects'),
        header=pulumi.get(__response__, 'header'),
        id=pulumi.get(__response__, 'id'),
        interval=pulumi.get(__response__, 'interval'),
        method=pulumi.get(__response__, 'method'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        monitor_id=pulumi.get(__response__, 'monitor_id'),
        path=pulumi.get(__response__, 'path'),
        port=pulumi.get(__response__, 'port'),
        probe_zone=pulumi.get(__response__, 'probe_zone'),
        retries=pulumi.get(__response__, 'retries'),
        timeout=pulumi.get(__response__, 'timeout'),
        type=pulumi.get(__response__, 'type')))
