# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNotificationPolicyWebhooksResult',
    'AwaitableGetNotificationPolicyWebhooksResult',
    'get_notification_policy_webhooks',
    'get_notification_policy_webhooks_output',
]

@pulumi.output_type
class GetNotificationPolicyWebhooksResult:
    """
    A collection of values returned by getNotificationPolicyWebhooks.
    """
    def __init__(__self__, account_id=None, created_at=None, id=None, last_failure=None, last_success=None, name=None, secret=None, type=None, url=None, webhook_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_failure and not isinstance(last_failure, str):
            raise TypeError("Expected argument 'last_failure' to be a str")
        pulumi.set(__self__, "last_failure", last_failure)
        if last_success and not isinstance(last_success, str):
            raise TypeError("Expected argument 'last_success' to be a str")
        pulumi.set(__self__, "last_success", last_success)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if webhook_id and not isinstance(webhook_id, str):
            raise TypeError("Expected argument 'webhook_id' to be a str")
        pulumi.set(__self__, "webhook_id", webhook_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account id
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Timestamp of when the webhook destination was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of a webhook
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastFailure")
    def last_failure(self) -> _builtins.str:
        """
        Timestamp of the last time an attempt to dispatch a notification to this webhook failed.
        """
        return pulumi.get(self, "last_failure")

    @_builtins.property
    @pulumi.getter(name="lastSuccess")
    def last_success(self) -> _builtins.str:
        """
        Timestamp of the last time Cloudflare was able to successfully dispatch a notification using this webhook.
        """
        return pulumi.get(self, "last_success")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the webhook destination. This will be included in the request body when you receive a webhook notification.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        Optional secret that will be passed in the `cf-webhook-auth` header when dispatching generic webhook notifications or formatted for supported destinations. Secrets are not returned in any API response body.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of webhook endpoint.
        Available values: "datadog", "discord", "feishu", "gchat", "generic", "opsgenie", "slack", "splunk".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The POST endpoint to call when dispatching a notification.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="webhookId")
    def webhook_id(self) -> Optional[_builtins.str]:
        """
        The unique identifier of a webhook
        """
        return pulumi.get(self, "webhook_id")


class AwaitableGetNotificationPolicyWebhooksResult(GetNotificationPolicyWebhooksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationPolicyWebhooksResult(
            account_id=self.account_id,
            created_at=self.created_at,
            id=self.id,
            last_failure=self.last_failure,
            last_success=self.last_success,
            name=self.name,
            secret=self.secret,
            type=self.type,
            url=self.url,
            webhook_id=self.webhook_id)


def get_notification_policy_webhooks(account_id: Optional[_builtins.str] = None,
                                     webhook_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationPolicyWebhooksResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_notification_policy_webhooks = cloudflare.get_notification_policy_webhooks(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        webhook_id="b115d5ec-15c6-41ee-8b76-92c449b5227b")
    ```


    :param _builtins.str account_id: The account id
    :param _builtins.str webhook_id: The unique identifier of a webhook
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['webhookId'] = webhook_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getNotificationPolicyWebhooks:getNotificationPolicyWebhooks', __args__, opts=opts, typ=GetNotificationPolicyWebhooksResult).value

    return AwaitableGetNotificationPolicyWebhooksResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        last_failure=pulumi.get(__ret__, 'last_failure'),
        last_success=pulumi.get(__ret__, 'last_success'),
        name=pulumi.get(__ret__, 'name'),
        secret=pulumi.get(__ret__, 'secret'),
        type=pulumi.get(__ret__, 'type'),
        url=pulumi.get(__ret__, 'url'),
        webhook_id=pulumi.get(__ret__, 'webhook_id'))
def get_notification_policy_webhooks_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            webhook_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNotificationPolicyWebhooksResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_notification_policy_webhooks = cloudflare.get_notification_policy_webhooks(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        webhook_id="b115d5ec-15c6-41ee-8b76-92c449b5227b")
    ```


    :param _builtins.str account_id: The account id
    :param _builtins.str webhook_id: The unique identifier of a webhook
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['webhookId'] = webhook_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getNotificationPolicyWebhooks:getNotificationPolicyWebhooks', __args__, opts=opts, typ=GetNotificationPolicyWebhooksResult)
    return __ret__.apply(lambda __response__: GetNotificationPolicyWebhooksResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        last_failure=pulumi.get(__response__, 'last_failure'),
        last_success=pulumi.get(__response__, 'last_success'),
        name=pulumi.get(__response__, 'name'),
        secret=pulumi.get(__response__, 'secret'),
        type=pulumi.get(__response__, 'type'),
        url=pulumi.get(__response__, 'url'),
        webhook_id=pulumi.get(__response__, 'webhook_id')))
