# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPagesDomainResult',
    'AwaitableGetPagesDomainResult',
    'get_pages_domain',
    'get_pages_domain_output',
]

@pulumi.output_type
class GetPagesDomainResult:
    """
    A collection of values returned by getPagesDomain.
    """
    def __init__(__self__, account_id=None, certificate_authority=None, created_on=None, domain_id=None, domain_name=None, id=None, name=None, project_name=None, status=None, validation_data=None, verification_data=None, zone_tag=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if certificate_authority and not isinstance(certificate_authority, str):
            raise TypeError("Expected argument 'certificate_authority' to be a str")
        pulumi.set(__self__, "certificate_authority", certificate_authority)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if validation_data and not isinstance(validation_data, dict):
            raise TypeError("Expected argument 'validation_data' to be a dict")
        pulumi.set(__self__, "validation_data", validation_data)
        if verification_data and not isinstance(verification_data, dict):
            raise TypeError("Expected argument 'verification_data' to be a dict")
        pulumi.set(__self__, "verification_data", verification_data)
        if zone_tag and not isinstance(zone_tag, str):
            raise TypeError("Expected argument 'zone_tag' to be a str")
        pulumi.set(__self__, "zone_tag", zone_tag)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> _builtins.str:
        """
        Available values: "google", "lets_encrypt".
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        Name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Name of the domain.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        Name of the project.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Available values: "initializing", "pending", "active", "deactivated", "blocked", "error".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> 'outputs.GetPagesDomainValidationDataResult':
        return pulumi.get(self, "validation_data")

    @_builtins.property
    @pulumi.getter(name="verificationData")
    def verification_data(self) -> 'outputs.GetPagesDomainVerificationDataResult':
        return pulumi.get(self, "verification_data")

    @_builtins.property
    @pulumi.getter(name="zoneTag")
    def zone_tag(self) -> _builtins.str:
        return pulumi.get(self, "zone_tag")


class AwaitableGetPagesDomainResult(GetPagesDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPagesDomainResult(
            account_id=self.account_id,
            certificate_authority=self.certificate_authority,
            created_on=self.created_on,
            domain_id=self.domain_id,
            domain_name=self.domain_name,
            id=self.id,
            name=self.name,
            project_name=self.project_name,
            status=self.status,
            validation_data=self.validation_data,
            verification_data=self.verification_data,
            zone_tag=self.zone_tag)


def get_pages_domain(account_id: Optional[_builtins.str] = None,
                     domain_name: Optional[_builtins.str] = None,
                     project_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPagesDomainResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_pages_domain = cloudflare.get_pages_domain(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        project_name="this-is-my-project-01",
        domain_name="this-is-my-domain-01.com")
    ```


    :param _builtins.str account_id: Identifier
    :param _builtins.str domain_name: Name of the domain.
    :param _builtins.str project_name: Name of the project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['domainName'] = domain_name
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getPagesDomain:getPagesDomain', __args__, opts=opts, typ=GetPagesDomainResult).value

    return AwaitableGetPagesDomainResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        certificate_authority=pulumi.get(__ret__, 'certificate_authority'),
        created_on=pulumi.get(__ret__, 'created_on'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_name=pulumi.get(__ret__, 'project_name'),
        status=pulumi.get(__ret__, 'status'),
        validation_data=pulumi.get(__ret__, 'validation_data'),
        verification_data=pulumi.get(__ret__, 'verification_data'),
        zone_tag=pulumi.get(__ret__, 'zone_tag'))
def get_pages_domain_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                            domain_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            project_name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPagesDomainResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_pages_domain = cloudflare.get_pages_domain(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        project_name="this-is-my-project-01",
        domain_name="this-is-my-domain-01.com")
    ```


    :param _builtins.str account_id: Identifier
    :param _builtins.str domain_name: Name of the domain.
    :param _builtins.str project_name: Name of the project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['domainName'] = domain_name
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getPagesDomain:getPagesDomain', __args__, opts=opts, typ=GetPagesDomainResult)
    return __ret__.apply(lambda __response__: GetPagesDomainResult(
        account_id=pulumi.get(__response__, 'account_id'),
        certificate_authority=pulumi.get(__response__, 'certificate_authority'),
        created_on=pulumi.get(__response__, 'created_on'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_name=pulumi.get(__response__, 'project_name'),
        status=pulumi.get(__response__, 'status'),
        validation_data=pulumi.get(__response__, 'validation_data'),
        verification_data=pulumi.get(__response__, 'verification_data'),
        zone_tag=pulumi.get(__response__, 'zone_tag')))
