# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetQueueConsumersResult',
    'AwaitableGetQueueConsumersResult',
    'get_queue_consumers',
    'get_queue_consumers_output',
]

@pulumi.output_type
class GetQueueConsumersResult:
    """
    A collection of values returned by getQueueConsumers.
    """
    def __init__(__self__, account_id=None, id=None, max_items=None, queue_id=None, results=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if queue_id and not isinstance(queue_id, str):
            raise TypeError("Expected argument 'queue_id' to be a str")
        pulumi.set(__self__, "queue_id", queue_id)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> _builtins.str:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "queue_id")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetQueueConsumersResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")


class AwaitableGetQueueConsumersResult(GetQueueConsumersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueConsumersResult(
            account_id=self.account_id,
            id=self.id,
            max_items=self.max_items,
            queue_id=self.queue_id,
            results=self.results)


def get_queue_consumers(account_id: Optional[_builtins.str] = None,
                        max_items: Optional[_builtins.int] = None,
                        queue_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueConsumersResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_queue_consumers = cloudflare.get_queue_consumers(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        queue_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: A Resource identifier.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str queue_id: A Resource identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['queueId'] = queue_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getQueueConsumers:getQueueConsumers', __args__, opts=opts, typ=GetQueueConsumersResult).value

    return AwaitableGetQueueConsumersResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        queue_id=pulumi.get(__ret__, 'queue_id'),
        results=pulumi.get(__ret__, 'results'))
def get_queue_consumers_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                               max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                               queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueueConsumersResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_queue_consumers = cloudflare.get_queue_consumers(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        queue_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: A Resource identifier.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str queue_id: A Resource identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['queueId'] = queue_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getQueueConsumers:getQueueConsumers', __args__, opts=opts, typ=GetQueueConsumersResult)
    return __ret__.apply(lambda __response__: GetQueueConsumersResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        queue_id=pulumi.get(__response__, 'queue_id'),
        results=pulumi.get(__response__, 'results')))
