# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetR2BucketResult',
    'AwaitableGetR2BucketResult',
    'get_r2_bucket',
    'get_r2_bucket_output',
]

@pulumi.output_type
class GetR2BucketResult:
    """
    A collection of values returned by getR2Bucket.
    """
    def __init__(__self__, account_id=None, bucket_name=None, creation_date=None, id=None, jurisdiction=None, location=None, name=None, storage_class=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jurisdiction and not isinstance(jurisdiction, str):
            raise TypeError("Expected argument 'jurisdiction' to be a str")
        pulumi.set(__self__, "jurisdiction", jurisdiction)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if storage_class and not isinstance(storage_class, str):
            raise TypeError("Expected argument 'storage_class' to be a str")
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Creation timestamp.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> _builtins.str:
        """
        Jurisdiction where objects in this bucket are guaranteed to be stored.
        Available values: "default", "eu", "fedramp".
        """
        return pulumi.get(self, "jurisdiction")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Location of the bucket.
        Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Storage class for newly uploaded objects, unless specified otherwise.
        Available values: "Standard", "InfrequentAccess".
        """
        return pulumi.get(self, "storage_class")


class AwaitableGetR2BucketResult(GetR2BucketResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetR2BucketResult(
            account_id=self.account_id,
            bucket_name=self.bucket_name,
            creation_date=self.creation_date,
            id=self.id,
            jurisdiction=self.jurisdiction,
            location=self.location,
            name=self.name,
            storage_class=self.storage_class)


def get_r2_bucket(account_id: Optional[_builtins.str] = None,
                  bucket_name: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetR2BucketResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket = cloudflare.get_r2_bucket(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getR2Bucket:getR2Bucket', __args__, opts=opts, typ=GetR2BucketResult).value

    return AwaitableGetR2BucketResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        id=pulumi.get(__ret__, 'id'),
        jurisdiction=pulumi.get(__ret__, 'jurisdiction'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        storage_class=pulumi.get(__ret__, 'storage_class'))
def get_r2_bucket_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                         bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetR2BucketResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket = cloudflare.get_r2_bucket(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getR2Bucket:getR2Bucket', __args__, opts=opts, typ=GetR2BucketResult)
    return __ret__.apply(lambda __response__: GetR2BucketResult(
        account_id=pulumi.get(__response__, 'account_id'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        id=pulumi.get(__response__, 'id'),
        jurisdiction=pulumi.get(__response__, 'jurisdiction'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        storage_class=pulumi.get(__response__, 'storage_class')))
