# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetR2BucketLifecycleResult',
    'AwaitableGetR2BucketLifecycleResult',
    'get_r2_bucket_lifecycle',
    'get_r2_bucket_lifecycle_output',
]

@pulumi.output_type
class GetR2BucketLifecycleResult:
    """
    A collection of values returned by getR2BucketLifecycle.
    """
    def __init__(__self__, account_id=None, bucket_name=None, id=None, rules=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetR2BucketLifecycleRuleResult']:
        return pulumi.get(self, "rules")


class AwaitableGetR2BucketLifecycleResult(GetR2BucketLifecycleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetR2BucketLifecycleResult(
            account_id=self.account_id,
            bucket_name=self.bucket_name,
            id=self.id,
            rules=self.rules)


def get_r2_bucket_lifecycle(account_id: Optional[_builtins.str] = None,
                            bucket_name: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetR2BucketLifecycleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket_lifecycle = cloudflare.get_r2_bucket_lifecycle(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getR2BucketLifecycle:getR2BucketLifecycle', __args__, opts=opts, typ=GetR2BucketLifecycleResult).value

    return AwaitableGetR2BucketLifecycleResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        id=pulumi.get(__ret__, 'id'),
        rules=pulumi.get(__ret__, 'rules'))
def get_r2_bucket_lifecycle_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetR2BucketLifecycleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket_lifecycle = cloudflare.get_r2_bucket_lifecycle(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getR2BucketLifecycle:getR2BucketLifecycle', __args__, opts=opts, typ=GetR2BucketLifecycleResult)
    return __ret__.apply(lambda __response__: GetR2BucketLifecycleResult(
        account_id=pulumi.get(__response__, 'account_id'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        id=pulumi.get(__response__, 'id'),
        rules=pulumi.get(__response__, 'rules')))
