# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStreamResult',
    'AwaitableGetStreamResult',
    'get_stream',
    'get_stream_output',
]

@pulumi.output_type
class GetStreamResult:
    """
    A collection of values returned by getStream.
    """
    def __init__(__self__, account_id=None, allowed_origins=None, created=None, creator=None, duration=None, id=None, identifier=None, input=None, live_input=None, max_duration_seconds=None, meta=None, modified=None, playback=None, preview=None, ready_to_stream=None, ready_to_stream_at=None, require_signed_urls=None, scheduled_deletion=None, size=None, status=None, thumbnail=None, thumbnail_timestamp_pct=None, uid=None, upload_expiry=None, uploaded=None, watermark=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if allowed_origins and not isinstance(allowed_origins, list):
            raise TypeError("Expected argument 'allowed_origins' to be a list")
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if duration and not isinstance(duration, float):
            raise TypeError("Expected argument 'duration' to be a float")
        pulumi.set(__self__, "duration", duration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if input and not isinstance(input, dict):
            raise TypeError("Expected argument 'input' to be a dict")
        pulumi.set(__self__, "input", input)
        if live_input and not isinstance(live_input, str):
            raise TypeError("Expected argument 'live_input' to be a str")
        pulumi.set(__self__, "live_input", live_input)
        if max_duration_seconds and not isinstance(max_duration_seconds, int):
            raise TypeError("Expected argument 'max_duration_seconds' to be a int")
        pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)
        if meta and not isinstance(meta, str):
            raise TypeError("Expected argument 'meta' to be a str")
        pulumi.set(__self__, "meta", meta)
        if modified and not isinstance(modified, str):
            raise TypeError("Expected argument 'modified' to be a str")
        pulumi.set(__self__, "modified", modified)
        if playback and not isinstance(playback, dict):
            raise TypeError("Expected argument 'playback' to be a dict")
        pulumi.set(__self__, "playback", playback)
        if preview and not isinstance(preview, str):
            raise TypeError("Expected argument 'preview' to be a str")
        pulumi.set(__self__, "preview", preview)
        if ready_to_stream and not isinstance(ready_to_stream, bool):
            raise TypeError("Expected argument 'ready_to_stream' to be a bool")
        pulumi.set(__self__, "ready_to_stream", ready_to_stream)
        if ready_to_stream_at and not isinstance(ready_to_stream_at, str):
            raise TypeError("Expected argument 'ready_to_stream_at' to be a str")
        pulumi.set(__self__, "ready_to_stream_at", ready_to_stream_at)
        if require_signed_urls and not isinstance(require_signed_urls, bool):
            raise TypeError("Expected argument 'require_signed_urls' to be a bool")
        pulumi.set(__self__, "require_signed_urls", require_signed_urls)
        if scheduled_deletion and not isinstance(scheduled_deletion, str):
            raise TypeError("Expected argument 'scheduled_deletion' to be a str")
        pulumi.set(__self__, "scheduled_deletion", scheduled_deletion)
        if size and not isinstance(size, float):
            raise TypeError("Expected argument 'size' to be a float")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if thumbnail and not isinstance(thumbnail, str):
            raise TypeError("Expected argument 'thumbnail' to be a str")
        pulumi.set(__self__, "thumbnail", thumbnail)
        if thumbnail_timestamp_pct and not isinstance(thumbnail_timestamp_pct, float):
            raise TypeError("Expected argument 'thumbnail_timestamp_pct' to be a float")
        pulumi.set(__self__, "thumbnail_timestamp_pct", thumbnail_timestamp_pct)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if upload_expiry and not isinstance(upload_expiry, str):
            raise TypeError("Expected argument 'upload_expiry' to be a str")
        pulumi.set(__self__, "upload_expiry", upload_expiry)
        if uploaded and not isinstance(uploaded, str):
            raise TypeError("Expected argument 'uploaded' to be a str")
        pulumi.set(__self__, "uploaded", uploaded)
        if watermark and not isinstance(watermark, dict):
            raise TypeError("Expected argument 'watermark' to be a dict")
        pulumi.set(__self__, "watermark", watermark)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date and time the media item was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> _builtins.str:
        """
        A user-defined identifier for the media creator.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.float:
        """
        The duration of the video in seconds. A value of `-1` means the duration is unknown. The duration becomes available after the upload and before the video is ready.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def input(self) -> 'outputs.GetStreamInputResult':
        return pulumi.get(self, "input")

    @_builtins.property
    @pulumi.getter(name="liveInput")
    def live_input(self) -> _builtins.str:
        """
        The live input ID used to upload a video with Stream Live.
        """
        return pulumi.get(self, "live_input")

    @_builtins.property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> _builtins.int:
        """
        The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        """
        return pulumi.get(self, "max_duration_seconds")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> _builtins.str:
        """
        A user modifiable key-value store used to reference other systems of record for managing videos.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> _builtins.str:
        """
        The date and time the media item was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    def playback(self) -> 'outputs.GetStreamPlaybackResult':
        return pulumi.get(self, "playback")

    @_builtins.property
    @pulumi.getter
    def preview(self) -> _builtins.str:
        """
        The video's preview page URI. This field is omitted until encoding is complete.
        """
        return pulumi.get(self, "preview")

    @_builtins.property
    @pulumi.getter(name="readyToStream")
    def ready_to_stream(self) -> _builtins.bool:
        """
        Indicates whether the video is playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        """
        return pulumi.get(self, "ready_to_stream")

    @_builtins.property
    @pulumi.getter(name="readyToStreamAt")
    def ready_to_stream_at(self) -> _builtins.str:
        """
        Indicates the time at which the video became playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        """
        return pulumi.get(self, "ready_to_stream_at")

    @_builtins.property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> _builtins.bool:
        """
        Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        """
        return pulumi.get(self, "require_signed_urls")

    @_builtins.property
    @pulumi.getter(name="scheduledDeletion")
    def scheduled_deletion(self) -> _builtins.str:
        """
        Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        """
        return pulumi.get(self, "scheduled_deletion")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.float:
        """
        The size of the media item in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> 'outputs.GetStreamStatusResult':
        """
        Specifies a detailed status for a video. If the `state` is `inprogress` or `error`, the `step` field returns `encoding` or `manifest`. If the `state` is `inprogress`, `pctComplete` returns a number between 0 and 100 to indicate the approximate percent of completion. If the `state` is `error`, `errorReasonCode` and `errorReasonText` provide additional details.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def thumbnail(self) -> _builtins.str:
        """
        The media item's thumbnail URI. This field is omitted until encoding is complete.
        """
        return pulumi.get(self, "thumbnail")

    @_builtins.property
    @pulumi.getter(name="thumbnailTimestampPct")
    def thumbnail_timestamp_pct(self) -> _builtins.float:
        """
        The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        """
        return pulumi.get(self, "thumbnail_timestamp_pct")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="uploadExpiry")
    def upload_expiry(self) -> _builtins.str:
        """
        The date and time when the video upload URL is no longer valid for direct user uploads.
        """
        return pulumi.get(self, "upload_expiry")

    @_builtins.property
    @pulumi.getter
    def uploaded(self) -> _builtins.str:
        """
        The date and time the media item was uploaded.
        """
        return pulumi.get(self, "uploaded")

    @_builtins.property
    @pulumi.getter
    def watermark(self) -> 'outputs.GetStreamWatermarkResult':
        return pulumi.get(self, "watermark")


class AwaitableGetStreamResult(GetStreamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamResult(
            account_id=self.account_id,
            allowed_origins=self.allowed_origins,
            created=self.created,
            creator=self.creator,
            duration=self.duration,
            id=self.id,
            identifier=self.identifier,
            input=self.input,
            live_input=self.live_input,
            max_duration_seconds=self.max_duration_seconds,
            meta=self.meta,
            modified=self.modified,
            playback=self.playback,
            preview=self.preview,
            ready_to_stream=self.ready_to_stream,
            ready_to_stream_at=self.ready_to_stream_at,
            require_signed_urls=self.require_signed_urls,
            scheduled_deletion=self.scheduled_deletion,
            size=self.size,
            status=self.status,
            thumbnail=self.thumbnail,
            thumbnail_timestamp_pct=self.thumbnail_timestamp_pct,
            uid=self.uid,
            upload_expiry=self.upload_expiry,
            uploaded=self.uploaded,
            watermark=self.watermark)


def get_stream(account_id: Optional[_builtins.str] = None,
               identifier: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream = cloudflare.get_stream(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        identifier="ea95132c15732412d22c1476fa83f27a")
    ```


    :param _builtins.str account_id: The account identifier tag.
    :param _builtins.str identifier: A Cloudflare-generated unique identifier for a media item.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getStream:getStream', __args__, opts=opts, typ=GetStreamResult).value

    return AwaitableGetStreamResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        allowed_origins=pulumi.get(__ret__, 'allowed_origins'),
        created=pulumi.get(__ret__, 'created'),
        creator=pulumi.get(__ret__, 'creator'),
        duration=pulumi.get(__ret__, 'duration'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        input=pulumi.get(__ret__, 'input'),
        live_input=pulumi.get(__ret__, 'live_input'),
        max_duration_seconds=pulumi.get(__ret__, 'max_duration_seconds'),
        meta=pulumi.get(__ret__, 'meta'),
        modified=pulumi.get(__ret__, 'modified'),
        playback=pulumi.get(__ret__, 'playback'),
        preview=pulumi.get(__ret__, 'preview'),
        ready_to_stream=pulumi.get(__ret__, 'ready_to_stream'),
        ready_to_stream_at=pulumi.get(__ret__, 'ready_to_stream_at'),
        require_signed_urls=pulumi.get(__ret__, 'require_signed_urls'),
        scheduled_deletion=pulumi.get(__ret__, 'scheduled_deletion'),
        size=pulumi.get(__ret__, 'size'),
        status=pulumi.get(__ret__, 'status'),
        thumbnail=pulumi.get(__ret__, 'thumbnail'),
        thumbnail_timestamp_pct=pulumi.get(__ret__, 'thumbnail_timestamp_pct'),
        uid=pulumi.get(__ret__, 'uid'),
        upload_expiry=pulumi.get(__ret__, 'upload_expiry'),
        uploaded=pulumi.get(__ret__, 'uploaded'),
        watermark=pulumi.get(__ret__, 'watermark'))
def get_stream_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                      identifier: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream = cloudflare.get_stream(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        identifier="ea95132c15732412d22c1476fa83f27a")
    ```


    :param _builtins.str account_id: The account identifier tag.
    :param _builtins.str identifier: A Cloudflare-generated unique identifier for a media item.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getStream:getStream', __args__, opts=opts, typ=GetStreamResult)
    return __ret__.apply(lambda __response__: GetStreamResult(
        account_id=pulumi.get(__response__, 'account_id'),
        allowed_origins=pulumi.get(__response__, 'allowed_origins'),
        created=pulumi.get(__response__, 'created'),
        creator=pulumi.get(__response__, 'creator'),
        duration=pulumi.get(__response__, 'duration'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        input=pulumi.get(__response__, 'input'),
        live_input=pulumi.get(__response__, 'live_input'),
        max_duration_seconds=pulumi.get(__response__, 'max_duration_seconds'),
        meta=pulumi.get(__response__, 'meta'),
        modified=pulumi.get(__response__, 'modified'),
        playback=pulumi.get(__response__, 'playback'),
        preview=pulumi.get(__response__, 'preview'),
        ready_to_stream=pulumi.get(__response__, 'ready_to_stream'),
        ready_to_stream_at=pulumi.get(__response__, 'ready_to_stream_at'),
        require_signed_urls=pulumi.get(__response__, 'require_signed_urls'),
        scheduled_deletion=pulumi.get(__response__, 'scheduled_deletion'),
        size=pulumi.get(__response__, 'size'),
        status=pulumi.get(__response__, 'status'),
        thumbnail=pulumi.get(__response__, 'thumbnail'),
        thumbnail_timestamp_pct=pulumi.get(__response__, 'thumbnail_timestamp_pct'),
        uid=pulumi.get(__response__, 'uid'),
        upload_expiry=pulumi.get(__response__, 'upload_expiry'),
        uploaded=pulumi.get(__response__, 'uploaded'),
        watermark=pulumi.get(__response__, 'watermark')))
