# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStreamWatermarkResult',
    'AwaitableGetStreamWatermarkResult',
    'get_stream_watermark',
    'get_stream_watermark_output',
]

@pulumi.output_type
class GetStreamWatermarkResult:
    """
    A collection of values returned by getStreamWatermark.
    """
    def __init__(__self__, account_id=None, created=None, downloaded_from=None, height=None, id=None, identifier=None, name=None, opacity=None, padding=None, position=None, scale=None, size=None, uid=None, width=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if downloaded_from and not isinstance(downloaded_from, str):
            raise TypeError("Expected argument 'downloaded_from' to be a str")
        pulumi.set(__self__, "downloaded_from", downloaded_from)
        if height and not isinstance(height, int):
            raise TypeError("Expected argument 'height' to be a int")
        pulumi.set(__self__, "height", height)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opacity and not isinstance(opacity, float):
            raise TypeError("Expected argument 'opacity' to be a float")
        pulumi.set(__self__, "opacity", opacity)
        if padding and not isinstance(padding, float):
            raise TypeError("Expected argument 'padding' to be a float")
        pulumi.set(__self__, "padding", padding)
        if position and not isinstance(position, str):
            raise TypeError("Expected argument 'position' to be a str")
        pulumi.set(__self__, "position", position)
        if scale and not isinstance(scale, float):
            raise TypeError("Expected argument 'scale' to be a float")
        pulumi.set(__self__, "scale", scale)
        if size and not isinstance(size, float):
            raise TypeError("Expected argument 'size' to be a float")
        pulumi.set(__self__, "size", size)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if width and not isinstance(width, int):
            raise TypeError("Expected argument 'width' to be a int")
        pulumi.set(__self__, "width", width)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date and a time a watermark profile was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="downloadedFrom")
    def downloaded_from(self) -> _builtins.str:
        """
        The source URL for a downloaded image. If the watermark profile was created via direct upload, this field is null.
        """
        return pulumi.get(self, "downloaded_from")

    @_builtins.property
    @pulumi.getter
    def height(self) -> _builtins.int:
        """
        The height of the image in pixels.
        """
        return pulumi.get(self, "height")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        The unique identifier for a watermark profile.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A short description of the watermark profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def opacity(self) -> _builtins.float:
        """
        The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        """
        return pulumi.get(self, "opacity")

    @_builtins.property
    @pulumi.getter
    def padding(self) -> _builtins.float:
        """
        The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        """
        return pulumi.get(self, "padding")

    @_builtins.property
    @pulumi.getter
    def position(self) -> _builtins.str:
        """
        The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def scale(self) -> _builtins.float:
        """
        The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        """
        return pulumi.get(self, "scale")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.float:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        The unique identifier for a watermark profile.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter
    def width(self) -> _builtins.int:
        """
        The width of the image in pixels.
        """
        return pulumi.get(self, "width")


class AwaitableGetStreamWatermarkResult(GetStreamWatermarkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamWatermarkResult(
            account_id=self.account_id,
            created=self.created,
            downloaded_from=self.downloaded_from,
            height=self.height,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            opacity=self.opacity,
            padding=self.padding,
            position=self.position,
            scale=self.scale,
            size=self.size,
            uid=self.uid,
            width=self.width)


def get_stream_watermark(account_id: Optional[_builtins.str] = None,
                         identifier: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamWatermarkResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream_watermark = cloudflare.get_stream_watermark(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        identifier="ea95132c15732412d22c1476fa83f27a")
    ```


    :param _builtins.str account_id: The account identifier tag.
    :param _builtins.str identifier: The unique identifier for a watermark profile.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getStreamWatermark:getStreamWatermark', __args__, opts=opts, typ=GetStreamWatermarkResult).value

    return AwaitableGetStreamWatermarkResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created=pulumi.get(__ret__, 'created'),
        downloaded_from=pulumi.get(__ret__, 'downloaded_from'),
        height=pulumi.get(__ret__, 'height'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        opacity=pulumi.get(__ret__, 'opacity'),
        padding=pulumi.get(__ret__, 'padding'),
        position=pulumi.get(__ret__, 'position'),
        scale=pulumi.get(__ret__, 'scale'),
        size=pulumi.get(__ret__, 'size'),
        uid=pulumi.get(__ret__, 'uid'),
        width=pulumi.get(__ret__, 'width'))
def get_stream_watermark_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                identifier: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamWatermarkResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream_watermark = cloudflare.get_stream_watermark(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        identifier="ea95132c15732412d22c1476fa83f27a")
    ```


    :param _builtins.str account_id: The account identifier tag.
    :param _builtins.str identifier: The unique identifier for a watermark profile.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getStreamWatermark:getStreamWatermark', __args__, opts=opts, typ=GetStreamWatermarkResult)
    return __ret__.apply(lambda __response__: GetStreamWatermarkResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created=pulumi.get(__response__, 'created'),
        downloaded_from=pulumi.get(__response__, 'downloaded_from'),
        height=pulumi.get(__response__, 'height'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        opacity=pulumi.get(__response__, 'opacity'),
        padding=pulumi.get(__response__, 'padding'),
        position=pulumi.get(__response__, 'position'),
        scale=pulumi.get(__response__, 'scale'),
        size=pulumi.get(__response__, 'size'),
        uid=pulumi.get(__response__, 'uid'),
        width=pulumi.get(__response__, 'width')))
