# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetWebAnalyticsSitesResult',
    'AwaitableGetWebAnalyticsSitesResult',
    'get_web_analytics_sites',
    'get_web_analytics_sites_output',
]

@pulumi.output_type
class GetWebAnalyticsSitesResult:
    """
    A collection of values returned by getWebAnalyticsSites.
    """
    def __init__(__self__, account_id=None, id=None, max_items=None, order_by=None, results=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        """
        The property used to sort the list of results.
        Available values: "host", "created".
        """
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetWebAnalyticsSitesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")


class AwaitableGetWebAnalyticsSitesResult(GetWebAnalyticsSitesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebAnalyticsSitesResult(
            account_id=self.account_id,
            id=self.id,
            max_items=self.max_items,
            order_by=self.order_by,
            results=self.results)


def get_web_analytics_sites(account_id: Optional[_builtins.str] = None,
                            max_items: Optional[_builtins.int] = None,
                            order_by: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebAnalyticsSitesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_web_analytics_sites = cloudflare.get_web_analytics_sites(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        order_by="host")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order_by: The property used to sort the list of results.
           Available values: "host", "created".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWebAnalyticsSites:getWebAnalyticsSites', __args__, opts=opts, typ=GetWebAnalyticsSitesResult).value

    return AwaitableGetWebAnalyticsSitesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        order_by=pulumi.get(__ret__, 'order_by'),
        results=pulumi.get(__ret__, 'results'))
def get_web_analytics_sites_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                   order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebAnalyticsSitesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_web_analytics_sites = cloudflare.get_web_analytics_sites(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        order_by="host")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order_by: The property used to sort the list of results.
           Available values: "host", "created".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWebAnalyticsSites:getWebAnalyticsSites', __args__, opts=opts, typ=GetWebAnalyticsSitesResult)
    return __ret__.apply(lambda __response__: GetWebAnalyticsSitesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        order_by=pulumi.get(__response__, 'order_by'),
        results=pulumi.get(__response__, 'results')))
