# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustDlpPredefinedProfileResult',
    'AwaitableGetZeroTrustDlpPredefinedProfileResult',
    'get_zero_trust_dlp_predefined_profile',
    'get_zero_trust_dlp_predefined_profile_output',
]

@pulumi.output_type
class GetZeroTrustDlpPredefinedProfileResult:
    """
    A collection of values returned by getZeroTrustDlpPredefinedProfile.
    """
    def __init__(__self__, account_id=None, ai_context_enabled=None, allowed_match_count=None, confidence_threshold=None, context_awareness=None, created_at=None, description=None, entries=None, id=None, name=None, ocr_enabled=None, open_access=None, profile_id=None, type=None, updated_at=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if ai_context_enabled and not isinstance(ai_context_enabled, bool):
            raise TypeError("Expected argument 'ai_context_enabled' to be a bool")
        pulumi.set(__self__, "ai_context_enabled", ai_context_enabled)
        if allowed_match_count and not isinstance(allowed_match_count, int):
            raise TypeError("Expected argument 'allowed_match_count' to be a int")
        pulumi.set(__self__, "allowed_match_count", allowed_match_count)
        if confidence_threshold and not isinstance(confidence_threshold, str):
            raise TypeError("Expected argument 'confidence_threshold' to be a str")
        pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_awareness and not isinstance(context_awareness, dict):
            raise TypeError("Expected argument 'context_awareness' to be a dict")
        pulumi.set(__self__, "context_awareness", context_awareness)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if ocr_enabled and not isinstance(ocr_enabled, bool):
            raise TypeError("Expected argument 'ocr_enabled' to be a bool")
        pulumi.set(__self__, "ocr_enabled", ocr_enabled)
        if open_access and not isinstance(open_access, bool):
            raise TypeError("Expected argument 'open_access' to be a bool")
        pulumi.set(__self__, "open_access", open_access)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "ai_context_enabled")

    @_builtins.property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> _builtins.int:
        """
        Related DLP policies will trigger when the match count exceeds the number set.
        """
        return pulumi.get(self, "allowed_match_count")

    @_builtins.property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> _builtins.str:
        """
        Available values: "low", "medium", "high", "very_high".
        """
        return pulumi.get(self, "confidence_threshold")

    @_builtins.property
    @pulumi.getter(name="contextAwareness")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def context_awareness(self) -> 'outputs.GetZeroTrustDlpPredefinedProfileContextAwarenessResult':
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        When the profile was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetZeroTrustDlpPredefinedProfileEntryResult']:
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the profile (uuid).
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "ocr_enabled")

    @_builtins.property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> _builtins.bool:
        """
        Whether this profile can be accessed by anyone.
        """
        return pulumi.get(self, "open_access")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> _builtins.str:
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        When the profile was lasted updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetZeroTrustDlpPredefinedProfileResult(GetZeroTrustDlpPredefinedProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustDlpPredefinedProfileResult(
            account_id=self.account_id,
            ai_context_enabled=self.ai_context_enabled,
            allowed_match_count=self.allowed_match_count,
            confidence_threshold=self.confidence_threshold,
            context_awareness=self.context_awareness,
            created_at=self.created_at,
            description=self.description,
            entries=self.entries,
            id=self.id,
            name=self.name,
            ocr_enabled=self.ocr_enabled,
            open_access=self.open_access,
            profile_id=self.profile_id,
            type=self.type,
            updated_at=self.updated_at)


def get_zero_trust_dlp_predefined_profile(account_id: Optional[_builtins.str] = None,
                                          profile_id: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustDlpPredefinedProfileResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_dlp_predefined_profile = cloudflare.get_zero_trust_dlp_predefined_profile(account_id="account_id",
        profile_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['profileId'] = profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustDlpPredefinedProfile:getZeroTrustDlpPredefinedProfile', __args__, opts=opts, typ=GetZeroTrustDlpPredefinedProfileResult).value

    return AwaitableGetZeroTrustDlpPredefinedProfileResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        ai_context_enabled=pulumi.get(__ret__, 'ai_context_enabled'),
        allowed_match_count=pulumi.get(__ret__, 'allowed_match_count'),
        confidence_threshold=pulumi.get(__ret__, 'confidence_threshold'),
        context_awareness=pulumi.get(__ret__, 'context_awareness'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        entries=pulumi.get(__ret__, 'entries'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        ocr_enabled=pulumi.get(__ret__, 'ocr_enabled'),
        open_access=pulumi.get(__ret__, 'open_access'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_zero_trust_dlp_predefined_profile_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustDlpPredefinedProfileResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_dlp_predefined_profile = cloudflare.get_zero_trust_dlp_predefined_profile(account_id="account_id",
        profile_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['profileId'] = profile_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustDlpPredefinedProfile:getZeroTrustDlpPredefinedProfile', __args__, opts=opts, typ=GetZeroTrustDlpPredefinedProfileResult)
    return __ret__.apply(lambda __response__: GetZeroTrustDlpPredefinedProfileResult(
        account_id=pulumi.get(__response__, 'account_id'),
        ai_context_enabled=pulumi.get(__response__, 'ai_context_enabled'),
        allowed_match_count=pulumi.get(__response__, 'allowed_match_count'),
        confidence_threshold=pulumi.get(__response__, 'confidence_threshold'),
        context_awareness=pulumi.get(__response__, 'context_awareness'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        entries=pulumi.get(__response__, 'entries'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        ocr_enabled=pulumi.get(__response__, 'ocr_enabled'),
        open_access=pulumi.get(__response__, 'open_access'),
        profile_id=pulumi.get(__response__, 'profile_id'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at')))
