# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZeroTrustGatewayCertificateResult',
    'AwaitableGetZeroTrustGatewayCertificateResult',
    'get_zero_trust_gateway_certificate',
    'get_zero_trust_gateway_certificate_output',
]

@pulumi.output_type
class GetZeroTrustGatewayCertificateResult:
    """
    A collection of values returned by getZeroTrustGatewayCertificate.
    """
    def __init__(__self__, account_id=None, binding_status=None, certificate=None, certificate_id=None, created_at=None, expires_on=None, fingerprint=None, id=None, in_use=None, issuer_org=None, issuer_raw=None, type=None, updated_at=None, uploaded_on=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if binding_status and not isinstance(binding_status, str):
            raise TypeError("Expected argument 'binding_status' to be a str")
        pulumi.set(__self__, "binding_status", binding_status)
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if expires_on and not isinstance(expires_on, str):
            raise TypeError("Expected argument 'expires_on' to be a str")
        pulumi.set(__self__, "expires_on", expires_on)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_use and not isinstance(in_use, bool):
            raise TypeError("Expected argument 'in_use' to be a bool")
        pulumi.set(__self__, "in_use", in_use)
        if issuer_org and not isinstance(issuer_org, str):
            raise TypeError("Expected argument 'issuer_org' to be a str")
        pulumi.set(__self__, "issuer_org", issuer_org)
        if issuer_raw and not isinstance(issuer_raw, str):
            raise TypeError("Expected argument 'issuer_raw' to be a str")
        pulumi.set(__self__, "issuer_raw", issuer_raw)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if uploaded_on and not isinstance(uploaded_on, str):
            raise TypeError("Expected argument 'uploaded_on' to be a str")
        pulumi.set(__self__, "uploaded_on", uploaded_on)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bindingStatus")
    def binding_status(self) -> _builtins.str:
        """
        The read only deployment status of the certificate on Cloudflare's edge. Certificates in the 'available' (previously called 'active') state may be used for Gateway TLS interception.
        Available values: "pending*deployment", "available", "pending*deletion", "inactive".
        """
        return pulumi.get(self, "binding_status")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> _builtins.str:
        """
        The CA certificate(read only).
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        Certificate UUID tag.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> _builtins.str:
        return pulumi.get(self, "expires_on")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        The SHA256 fingerprint of the certificate(read only).
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Certificate UUID tag.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inUse")
    def in_use(self) -> _builtins.bool:
        """
        Read-only field that shows whether Gateway TLS interception is using this certificate. This value cannot be set directly. To configure the certificate for interception, use the Gateway configuration setting named certificate.
        """
        return pulumi.get(self, "in_use")

    @_builtins.property
    @pulumi.getter(name="issuerOrg")
    def issuer_org(self) -> _builtins.str:
        """
        The organization that issued the certificate(read only).
        """
        return pulumi.get(self, "issuer_org")

    @_builtins.property
    @pulumi.getter(name="issuerRaw")
    def issuer_raw(self) -> _builtins.str:
        """
        The entire issuer field of the certificate(read only).
        """
        return pulumi.get(self, "issuer_raw")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of certificate, either BYO-PKI (custom) or Gateway-managed(read only).
        Available values: "custom", "gateway_managed".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> _builtins.str:
        return pulumi.get(self, "uploaded_on")


class AwaitableGetZeroTrustGatewayCertificateResult(GetZeroTrustGatewayCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustGatewayCertificateResult(
            account_id=self.account_id,
            binding_status=self.binding_status,
            certificate=self.certificate,
            certificate_id=self.certificate_id,
            created_at=self.created_at,
            expires_on=self.expires_on,
            fingerprint=self.fingerprint,
            id=self.id,
            in_use=self.in_use,
            issuer_org=self.issuer_org,
            issuer_raw=self.issuer_raw,
            type=self.type,
            updated_at=self.updated_at,
            uploaded_on=self.uploaded_on)


def get_zero_trust_gateway_certificate(account_id: Optional[_builtins.str] = None,
                                       certificate_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustGatewayCertificateResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_gateway_certificate = cloudflare.get_zero_trust_gateway_certificate(account_id="699d98642c564d2e855e9661899b7252",
        certificate_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str certificate_id: Certificate UUID tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustGatewayCertificate:getZeroTrustGatewayCertificate', __args__, opts=opts, typ=GetZeroTrustGatewayCertificateResult).value

    return AwaitableGetZeroTrustGatewayCertificateResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        binding_status=pulumi.get(__ret__, 'binding_status'),
        certificate=pulumi.get(__ret__, 'certificate'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        expires_on=pulumi.get(__ret__, 'expires_on'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        in_use=pulumi.get(__ret__, 'in_use'),
        issuer_org=pulumi.get(__ret__, 'issuer_org'),
        issuer_raw=pulumi.get(__ret__, 'issuer_raw'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        uploaded_on=pulumi.get(__ret__, 'uploaded_on'))
def get_zero_trust_gateway_certificate_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              certificate_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustGatewayCertificateResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_gateway_certificate = cloudflare.get_zero_trust_gateway_certificate(account_id="699d98642c564d2e855e9661899b7252",
        certificate_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str certificate_id: Certificate UUID tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustGatewayCertificate:getZeroTrustGatewayCertificate', __args__, opts=opts, typ=GetZeroTrustGatewayCertificateResult)
    return __ret__.apply(lambda __response__: GetZeroTrustGatewayCertificateResult(
        account_id=pulumi.get(__response__, 'account_id'),
        binding_status=pulumi.get(__response__, 'binding_status'),
        certificate=pulumi.get(__response__, 'certificate'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        expires_on=pulumi.get(__response__, 'expires_on'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        in_use=pulumi.get(__response__, 'in_use'),
        issuer_org=pulumi.get(__response__, 'issuer_org'),
        issuer_raw=pulumi.get(__response__, 'issuer_raw'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        uploaded_on=pulumi.get(__response__, 'uploaded_on')))
