# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZeroTrustListResult',
    'AwaitableGetZeroTrustListResult',
    'get_zero_trust_list',
    'get_zero_trust_list_output',
]

@pulumi.output_type
class GetZeroTrustListResult:
    """
    A collection of values returned by getZeroTrustList.
    """
    def __init__(__self__, account_id=None, created_at=None, description=None, filter=None, id=None, items=None, list_count=None, list_id=None, name=None, type=None, updated_at=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if list_count and not isinstance(list_count, float):
            raise TypeError("Expected argument 'list_count' to be a float")
        pulumi.set(__self__, "list_count", list_count)
        if list_id and not isinstance(list_id, str):
            raise TypeError("Expected argument 'list_id' to be a str")
        pulumi.set(__self__, "list_id", list_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the list.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetZeroTrustListFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        API Resource UUID tag.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetZeroTrustListItemResult']:
        """
        The items in the list.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="listCount")
    def list_count(self) -> _builtins.float:
        """
        The number of items in the list.
        """
        return pulumi.get(self, "list_count")

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[_builtins.str]:
        """
        API Resource UUID tag.
        """
        return pulumi.get(self, "list_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the list.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of list.
        Available values: "SERIAL", "URL", "DOMAIN", "EMAIL", "IP".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")


class AwaitableGetZeroTrustListResult(GetZeroTrustListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustListResult(
            account_id=self.account_id,
            created_at=self.created_at,
            description=self.description,
            filter=self.filter,
            id=self.id,
            items=self.items,
            list_count=self.list_count,
            list_id=self.list_id,
            name=self.name,
            type=self.type,
            updated_at=self.updated_at)


def get_zero_trust_list(account_id: Optional[_builtins.str] = None,
                        filter: Optional[Union['GetZeroTrustListFilterArgs', 'GetZeroTrustListFilterArgsDict']] = None,
                        list_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustListResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_list = cloudflare.get_zero_trust_list(account_id="699d98642c564d2e855e9661899b7252",
        list_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str list_id: API Resource UUID tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['listId'] = list_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustList:getZeroTrustList', __args__, opts=opts, typ=GetZeroTrustListResult).value

    return AwaitableGetZeroTrustListResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        list_count=pulumi.get(__ret__, 'list_count'),
        list_id=pulumi.get(__ret__, 'list_id'),
        name=pulumi.get(__ret__, 'name'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_zero_trust_list_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                               filter: Optional[pulumi.Input[Optional[Union['GetZeroTrustListFilterArgs', 'GetZeroTrustListFilterArgsDict']]]] = None,
                               list_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustListResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_list = cloudflare.get_zero_trust_list(account_id="699d98642c564d2e855e9661899b7252",
        list_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str list_id: API Resource UUID tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['listId'] = list_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustList:getZeroTrustList', __args__, opts=opts, typ=GetZeroTrustListResult)
    return __ret__.apply(lambda __response__: GetZeroTrustListResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        list_count=pulumi.get(__response__, 'list_count'),
        list_id=pulumi.get(__response__, 'list_id'),
        name=pulumi.get(__response__, 'name'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at')))
