# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['HostnameTlsSettingArgs', 'HostnameTlsSetting']

@pulumi.input_type
class HostnameTlsSettingArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[_builtins.str],
                 setting_id: pulumi.Input[_builtins.str],
                 value: Any,
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a HostnameTlsSetting resource.
        :param pulumi.Input[_builtins.str] hostname: The hostname for which the tls settings are set.
        :param pulumi.Input[_builtins.str] setting_id: The TLS Setting name.
               Available values: "ciphers", "min*tls*version", "http2".
        :param Any value: The tls setting value.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "setting_id", setting_id)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        The hostname for which the tls settings are set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> pulumi.Input[_builtins.str]:
        """
        The TLS Setting name.
        Available values: "ciphers", "min*tls*version", "http2".
        """
        return pulumi.get(self, "setting_id")

    @setting_id.setter
    def setting_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "setting_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Any:
        """
        The tls setting value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Any):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _HostnameTlsSettingState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[Any] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HostnameTlsSetting resources.
        :param pulumi.Input[_builtins.str] created_at: This is the time the tls setting was originally created for this hostname.
        :param pulumi.Input[_builtins.str] hostname: The hostname for which the tls settings are set.
        :param pulumi.Input[_builtins.str] setting_id: The TLS Setting name.
               Available values: "ciphers", "min*tls*version", "http2".
        :param pulumi.Input[_builtins.str] status: Deployment status for the given tls setting.
        :param pulumi.Input[_builtins.str] updated_at: This is the time the tls setting was updated.
        :param Any value: The tls setting value.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if setting_id is not None:
            pulumi.set(__self__, "setting_id", setting_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the time the tls setting was originally created for this hostname.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname for which the tls settings are set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TLS Setting name.
        Available values: "ciphers", "min*tls*version", "http2".
        """
        return pulumi.get(self, "setting_id")

    @setting_id.setter
    def setting_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "setting_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment status for the given tls setting.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the time the tls setting was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The tls setting value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[Any]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/hostnameTlsSetting:HostnameTlsSetting")
class HostnameTlsSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[Any] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_hostname_tls_setting = cloudflare.HostnameTlsSetting("example_hostname_tls_setting",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            setting_id="ciphers",
            hostname="app.example.com",
            value=[
                "ECDHE-RSA-AES128-GCM-SHA256",
                "AES128-GCM-SHA256",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/hostnameTlsSetting:HostnameTlsSetting example '<zone_id>/<setting_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] hostname: The hostname for which the tls settings are set.
        :param pulumi.Input[_builtins.str] setting_id: The TLS Setting name.
               Available values: "ciphers", "min*tls*version", "http2".
        :param Any value: The tls setting value.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostnameTlsSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_hostname_tls_setting = cloudflare.HostnameTlsSetting("example_hostname_tls_setting",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            setting_id="ciphers",
            hostname="app.example.com",
            value=[
                "ECDHE-RSA-AES128-GCM-SHA256",
                "AES128-GCM-SHA256",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/hostnameTlsSetting:HostnameTlsSetting example '<zone_id>/<setting_id>'
        ```

        :param str resource_name: The name of the resource.
        :param HostnameTlsSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostnameTlsSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[Any] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostnameTlsSettingArgs.__new__(HostnameTlsSettingArgs)

            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'setting_id'")
            __props__.__dict__["setting_id"] = setting_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(HostnameTlsSetting, __self__).__init__(
            'cloudflare:index/hostnameTlsSetting:HostnameTlsSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            setting_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[Any] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'HostnameTlsSetting':
        """
        Get an existing HostnameTlsSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: This is the time the tls setting was originally created for this hostname.
        :param pulumi.Input[_builtins.str] hostname: The hostname for which the tls settings are set.
        :param pulumi.Input[_builtins.str] setting_id: The TLS Setting name.
               Available values: "ciphers", "min*tls*version", "http2".
        :param pulumi.Input[_builtins.str] status: Deployment status for the given tls setting.
        :param pulumi.Input[_builtins.str] updated_at: This is the time the tls setting was updated.
        :param Any value: The tls setting value.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostnameTlsSettingState.__new__(_HostnameTlsSettingState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["setting_id"] = setting_id
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["value"] = value
        __props__.__dict__["zone_id"] = zone_id
        return HostnameTlsSetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        This is the time the tls setting was originally created for this hostname.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname for which the tls settings are set.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> pulumi.Output[_builtins.str]:
        """
        The TLS Setting name.
        Available values: "ciphers", "min*tls*version", "http2".
        """
        return pulumi.get(self, "setting_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment status for the given tls setting.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        This is the time the tls setting was updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[Any]:
        """
        The tls setting value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

