# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 queue_name: pulumi.Input[_builtins.str],
                 settings: Optional[pulumi.Input['QueueSettingsArgs']] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "queue_name", queue_name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['QueueSettingsArgs']]:
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['QueueSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _QueueState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input['QueueConsumerArgs']]]] = None,
                 consumers_total_count: Optional[pulumi.Input[_builtins.float]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 producers: Optional[pulumi.Input[Sequence[pulumi.Input['QueueProducerArgs']]]] = None,
                 producers_total_count: Optional[pulumi.Input[_builtins.float]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input['QueueSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering Queue resources.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if consumers is not None:
            pulumi.set(__self__, "consumers", consumers)
        if consumers_total_count is not None:
            pulumi.set(__self__, "consumers_total_count", consumers_total_count)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if producers is not None:
            pulumi.set(__self__, "producers", producers)
        if producers_total_count is not None:
            pulumi.set(__self__, "producers_total_count", producers_total_count)
        if queue_id is not None:
            pulumi.set(__self__, "queue_id", queue_id)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueueConsumerArgs']]]]:
        return pulumi.get(self, "consumers")

    @consumers.setter
    def consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueueConsumerArgs']]]]):
        pulumi.set(self, "consumers", value)

    @_builtins.property
    @pulumi.getter(name="consumersTotalCount")
    def consumers_total_count(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "consumers_total_count")

    @consumers_total_count.setter
    def consumers_total_count(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "consumers_total_count", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def producers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueueProducerArgs']]]]:
        return pulumi.get(self, "producers")

    @producers.setter
    def producers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueueProducerArgs']]]]):
        pulumi.set(self, "producers", value)

    @_builtins.property
    @pulumi.getter(name="producersTotalCount")
    def producers_total_count(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "producers_total_count")

    @producers_total_count.setter
    def producers_total_count(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "producers_total_count", value)

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "queue_id")

    @queue_id.setter
    def queue_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_id", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['QueueSettingsArgs']]:
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['QueueSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.type_token("cloudflare:index/queue:Queue")
class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['QueueSettingsArgs', 'QueueSettingsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_queue = cloudflare.Queue("example_queue",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            queue_name="example-queue")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/queue:Queue example '<account_id>/<queue_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_queue = cloudflare.Queue("example_queue",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            queue_name="example-queue")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/queue:Queue example '<account_id>/<queue_id>'
        ```

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['QueueSettingsArgs', 'QueueSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if queue_name is None and not opts.urn:
                raise TypeError("Missing required property 'queue_name'")
            __props__.__dict__["queue_name"] = queue_name
            __props__.__dict__["settings"] = settings
            __props__.__dict__["consumers"] = None
            __props__.__dict__["consumers_total_count"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["producers"] = None
            __props__.__dict__["producers_total_count"] = None
            __props__.__dict__["queue_id"] = None
        super(Queue, __self__).__init__(
            'cloudflare:index/queue:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueueConsumerArgs', 'QueueConsumerArgsDict']]]]] = None,
            consumers_total_count: Optional[pulumi.Input[_builtins.float]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            producers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueueProducerArgs', 'QueueProducerArgsDict']]]]] = None,
            producers_total_count: Optional[pulumi.Input[_builtins.float]] = None,
            queue_id: Optional[pulumi.Input[_builtins.str]] = None,
            queue_name: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[Union['QueueSettingsArgs', 'QueueSettingsArgsDict']]] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueueState.__new__(_QueueState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["consumers"] = consumers
        __props__.__dict__["consumers_total_count"] = consumers_total_count
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["producers"] = producers
        __props__.__dict__["producers_total_count"] = producers_total_count
        __props__.__dict__["queue_id"] = queue_id
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["settings"] = settings
        return Queue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> pulumi.Output[Sequence['outputs.QueueConsumer']]:
        return pulumi.get(self, "consumers")

    @_builtins.property
    @pulumi.getter(name="consumersTotalCount")
    def consumers_total_count(self) -> pulumi.Output[_builtins.float]:
        return pulumi.get(self, "consumers_total_count")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def producers(self) -> pulumi.Output[Sequence['outputs.QueueProducer']]:
        return pulumi.get(self, "producers")

    @_builtins.property
    @pulumi.getter(name="producersTotalCount")
    def producers_total_count(self) -> pulumi.Output[_builtins.float]:
        return pulumi.get(self, "producers_total_count")

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "queue_id")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "queue_name")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.QueueSettings']:
        return pulumi.get(self, "settings")

