# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecordArgs', 'Record']

@pulumi.input_type
class RecordArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 ttl: pulumi.Input[_builtins.float],
                 type: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input['RecordDataArgs']] = None,
                 priority: Optional[pulumi.Input[_builtins.float]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 settings: Optional[pulumi.Input['RecordSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Record resource.
        :param pulumi.Input[_builtins.str] name: DNS record name (or @ for the zone apex) in Punycode.
        :param pulumi.Input[_builtins.float] ttl: Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        :param pulumi.Input[_builtins.str] type: Record type.
               Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[_builtins.str] comment: Comments or notes about the DNS record. This field has no effect on DNS responses.
        :param pulumi.Input[_builtins.str] content: A valid IPv4 address.
        :param pulumi.Input['RecordDataArgs'] data: Components of a CAA record.
        :param pulumi.Input[_builtins.float] priority: Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        :param pulumi.Input[_builtins.bool] proxied: Whether the record is receiving the performance and security benefits of Cloudflare.
        :param pulumi.Input['RecordSettingsArgs'] settings: Settings for the DNS record.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Custom tags for the DNS record. This field has no effect on DNS responses.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_id", zone_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        DNS record name (or @ for the zone apex) in Punycode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[_builtins.float]:
        """
        Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Record type.
        Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comments or notes about the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid IPv4 address.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input['RecordDataArgs']]:
        """
        Components of a CAA record.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input['RecordDataArgs']]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the record is receiving the performance and security benefits of Cloudflare.
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxied", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['RecordSettingsArgs']]:
        """
        Settings for the DNS record.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['RecordSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Custom tags for the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RecordState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 comment_modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input['RecordDataArgs']] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.float]] = None,
                 proxiable: Optional[pulumi.Input[_builtins.bool]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 settings: Optional[pulumi.Input['RecordSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags_modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Record resources.
        :param pulumi.Input[_builtins.str] comment: Comments or notes about the DNS record. This field has no effect on DNS responses.
        :param pulumi.Input[_builtins.str] comment_modified_on: When the record comment was last modified. Omitted if there is no comment.
        :param pulumi.Input[_builtins.str] content: A valid IPv4 address.
        :param pulumi.Input[_builtins.str] created_on: When the record was created.
        :param pulumi.Input['RecordDataArgs'] data: Components of a CAA record.
        :param pulumi.Input[_builtins.str] meta: Extra Cloudflare-specific information about the record.
        :param pulumi.Input[_builtins.str] modified_on: When the record was last modified.
        :param pulumi.Input[_builtins.str] name: DNS record name (or @ for the zone apex) in Punycode.
        :param pulumi.Input[_builtins.float] priority: Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        :param pulumi.Input[_builtins.bool] proxiable: Whether the record can be proxied by Cloudflare or not.
        :param pulumi.Input[_builtins.bool] proxied: Whether the record is receiving the performance and security benefits of Cloudflare.
        :param pulumi.Input['RecordSettingsArgs'] settings: Settings for the DNS record.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Custom tags for the DNS record. This field has no effect on DNS responses.
        :param pulumi.Input[_builtins.str] tags_modified_on: When the record tags were last modified. Omitted if there are no tags.
        :param pulumi.Input[_builtins.float] ttl: Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        :param pulumi.Input[_builtins.str] type: Record type.
               Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if comment_modified_on is not None:
            pulumi.set(__self__, "comment_modified_on", comment_modified_on)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proxiable is not None:
            pulumi.set(__self__, "proxiable", proxiable)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_modified_on is not None:
            pulumi.set(__self__, "tags_modified_on", tags_modified_on)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comments or notes about the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="commentModifiedOn")
    def comment_modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the record comment was last modified. Omitted if there is no comment.
        """
        return pulumi.get(self, "comment_modified_on")

    @comment_modified_on.setter
    def comment_modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment_modified_on", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid IPv4 address.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the record was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input['RecordDataArgs']]:
        """
        Components of a CAA record.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input['RecordDataArgs']]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Extra Cloudflare-specific information about the record.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the record was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS record name (or @ for the zone apex) in Punycode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def proxiable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the record can be proxied by Cloudflare or not.
        """
        return pulumi.get(self, "proxiable")

    @proxiable.setter
    def proxiable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxiable", value)

    @_builtins.property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the record is receiving the performance and security benefits of Cloudflare.
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxied", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['RecordSettingsArgs']]:
        """
        Settings for the DNS record.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['RecordSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Custom tags for the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsModifiedOn")
    def tags_modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the record tags were last modified. Omitted if there are no tags.
        """
        return pulumi.get(self, "tags_modified_on")

    @tags_modified_on.setter
    def tags_modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags_modified_on", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record type.
        Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


warnings.warn("""cloudflare.index/record.Record has been deprecated in favor of cloudflare.index/dnsrecord.DnsRecord""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/record:Record")
class Record(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/record.Record has been deprecated in favor of cloudflare.index/dnsrecord.DnsRecord""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.float]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 settings: Optional[pulumi.Input[Union['RecordSettingsArgs', 'RecordSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/record:Record example '<zone_id>/<dns_record_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Comments or notes about the DNS record. This field has no effect on DNS responses.
        :param pulumi.Input[_builtins.str] content: A valid IPv4 address.
        :param pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']] data: Components of a CAA record.
        :param pulumi.Input[_builtins.str] name: DNS record name (or @ for the zone apex) in Punycode.
        :param pulumi.Input[_builtins.float] priority: Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        :param pulumi.Input[_builtins.bool] proxied: Whether the record is receiving the performance and security benefits of Cloudflare.
        :param pulumi.Input[Union['RecordSettingsArgs', 'RecordSettingsArgsDict']] settings: Settings for the DNS record.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Custom tags for the DNS record. This field has no effect on DNS responses.
        :param pulumi.Input[_builtins.float] ttl: Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        :param pulumi.Input[_builtins.str] type: Record type.
               Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/record:Record example '<zone_id>/<dns_record_id>'
        ```

        :param str resource_name: The name of the resource.
        :param RecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.float]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 settings: Optional[pulumi.Input[Union['RecordSettingsArgs', 'RecordSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""Record is deprecated: cloudflare.index/record.Record has been deprecated in favor of cloudflare.index/dnsrecord.DnsRecord""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecordArgs.__new__(RecordArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["content"] = content
            __props__.__dict__["data"] = data
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["proxied"] = proxied
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            if ttl is None and not opts.urn:
                raise TypeError("Missing required property 'ttl'")
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["comment_modified_on"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["meta"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["proxiable"] = None
            __props__.__dict__["tags_modified_on"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/record:Record")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Record, __self__).__init__(
            'cloudflare:index/record:Record',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            comment_modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            data: Optional[pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']]] = None,
            meta: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.float]] = None,
            proxiable: Optional[pulumi.Input[_builtins.bool]] = None,
            proxied: Optional[pulumi.Input[_builtins.bool]] = None,
            settings: Optional[pulumi.Input[Union['RecordSettingsArgs', 'RecordSettingsArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags_modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.float]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Record':
        """
        Get an existing Record resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Comments or notes about the DNS record. This field has no effect on DNS responses.
        :param pulumi.Input[_builtins.str] comment_modified_on: When the record comment was last modified. Omitted if there is no comment.
        :param pulumi.Input[_builtins.str] content: A valid IPv4 address.
        :param pulumi.Input[_builtins.str] created_on: When the record was created.
        :param pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']] data: Components of a CAA record.
        :param pulumi.Input[_builtins.str] meta: Extra Cloudflare-specific information about the record.
        :param pulumi.Input[_builtins.str] modified_on: When the record was last modified.
        :param pulumi.Input[_builtins.str] name: DNS record name (or @ for the zone apex) in Punycode.
        :param pulumi.Input[_builtins.float] priority: Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        :param pulumi.Input[_builtins.bool] proxiable: Whether the record can be proxied by Cloudflare or not.
        :param pulumi.Input[_builtins.bool] proxied: Whether the record is receiving the performance and security benefits of Cloudflare.
        :param pulumi.Input[Union['RecordSettingsArgs', 'RecordSettingsArgsDict']] settings: Settings for the DNS record.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Custom tags for the DNS record. This field has no effect on DNS responses.
        :param pulumi.Input[_builtins.str] tags_modified_on: When the record tags were last modified. Omitted if there are no tags.
        :param pulumi.Input[_builtins.float] ttl: Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        :param pulumi.Input[_builtins.str] type: Record type.
               Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecordState.__new__(_RecordState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["comment_modified_on"] = comment_modified_on
        __props__.__dict__["content"] = content
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["data"] = data
        __props__.__dict__["meta"] = meta
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["proxiable"] = proxiable
        __props__.__dict__["proxied"] = proxied
        __props__.__dict__["settings"] = settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_modified_on"] = tags_modified_on
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return Record(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comments or notes about the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="commentModifiedOn")
    def comment_modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the record comment was last modified. Omitted if there is no comment.
        """
        return pulumi.get(self, "comment_modified_on")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        A valid IPv4 address.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the record was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional['outputs.RecordData']]:
        """
        Components of a CAA record.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[_builtins.str]:
        """
        Extra Cloudflare-specific information about the record.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the record was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        DNS record name (or @ for the zone apex) in Punycode.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def proxiable(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the record can be proxied by Cloudflare or not.
        """
        return pulumi.get(self, "proxiable")

    @_builtins.property
    @pulumi.getter
    def proxied(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the record is receiving the performance and security benefits of Cloudflare.
        """
        return pulumi.get(self, "proxied")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.RecordSettings']:
        """
        Settings for the DNS record.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Custom tags for the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsModifiedOn")
    def tags_modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the record tags were last modified. Omitted if there are no tags.
        """
        return pulumi.get(self, "tags_modified_on")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.float]:
        """
        Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Record type.
        Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

