# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamArgs', 'Stream']

@pulumi.input_type
class StreamArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 max_duration_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[_builtins.bool]] = None,
                 scheduled_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_timestamp_pct: Optional[pulumi.Input[_builtins.float]] = None,
                 upload_expiry: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Stream resource.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        :param pulumi.Input[_builtins.str] creator: A user-defined identifier for the media creator.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.int] max_duration_seconds: The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing videos.
        :param pulumi.Input[_builtins.bool] require_signed_urls: Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        :param pulumi.Input[_builtins.str] scheduled_deletion: Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        :param pulumi.Input[_builtins.float] thumbnail_timestamp_pct: The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        :param pulumi.Input[_builtins.str] upload_expiry: The date and time when the video upload URL is no longer valid for direct user uploads.
        """
        pulumi.set(__self__, "account_id", account_id)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if max_duration_seconds is not None:
            pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if require_signed_urls is not None:
            pulumi.set(__self__, "require_signed_urls", require_signed_urls)
        if scheduled_deletion is not None:
            pulumi.set(__self__, "scheduled_deletion", scheduled_deletion)
        if thumbnail_timestamp_pct is not None:
            pulumi.set(__self__, "thumbnail_timestamp_pct", thumbnail_timestamp_pct)
        if upload_expiry is not None:
            pulumi.set(__self__, "upload_expiry", upload_expiry)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-defined identifier for the media creator.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        """
        return pulumi.get(self, "max_duration_seconds")

    @max_duration_seconds.setter
    def max_duration_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_duration_seconds", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user modifiable key-value store used to reference other systems of record for managing videos.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        """
        return pulumi.get(self, "require_signed_urls")

    @require_signed_urls.setter
    def require_signed_urls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_signed_urls", value)

    @_builtins.property
    @pulumi.getter(name="scheduledDeletion")
    def scheduled_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        """
        return pulumi.get(self, "scheduled_deletion")

    @scheduled_deletion.setter
    def scheduled_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_deletion", value)

    @_builtins.property
    @pulumi.getter(name="thumbnailTimestampPct")
    def thumbnail_timestamp_pct(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        """
        return pulumi.get(self, "thumbnail_timestamp_pct")

    @thumbnail_timestamp_pct.setter
    def thumbnail_timestamp_pct(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "thumbnail_timestamp_pct", value)

    @_builtins.property
    @pulumi.getter(name="uploadExpiry")
    def upload_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the video upload URL is no longer valid for direct user uploads.
        """
        return pulumi.get(self, "upload_expiry")

    @upload_expiry.setter
    def upload_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upload_expiry", value)


@pulumi.input_type
class _StreamState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.float]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 input: Optional[pulumi.Input['StreamInputArgs']] = None,
                 live_input: Optional[pulumi.Input[_builtins.str]] = None,
                 max_duration_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 modified: Optional[pulumi.Input[_builtins.str]] = None,
                 playback: Optional[pulumi.Input['StreamPlaybackArgs']] = None,
                 preview: Optional[pulumi.Input[_builtins.str]] = None,
                 ready_to_stream: Optional[pulumi.Input[_builtins.bool]] = None,
                 ready_to_stream_at: Optional[pulumi.Input[_builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[_builtins.bool]] = None,
                 scheduled_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 status: Optional[pulumi.Input['StreamStatusArgs']] = None,
                 thumbnail: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_timestamp_pct: Optional[pulumi.Input[_builtins.float]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 upload_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 uploaded: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark: Optional[pulumi.Input['StreamWatermarkArgs']] = None):
        """
        Input properties used for looking up and filtering Stream resources.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        :param pulumi.Input[_builtins.str] created: The date and time the media item was created.
        :param pulumi.Input[_builtins.str] creator: A user-defined identifier for the media creator.
        :param pulumi.Input[_builtins.float] duration: The duration of the video in seconds. A value of `-1` means the duration is unknown. The duration becomes available after the upload and before the video is ready.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] live_input: The live input ID used to upload a video with Stream Live.
        :param pulumi.Input[_builtins.int] max_duration_seconds: The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing videos.
        :param pulumi.Input[_builtins.str] modified: The date and time the media item was last modified.
        :param pulumi.Input[_builtins.str] preview: The video's preview page URI. This field is omitted until encoding is complete.
        :param pulumi.Input[_builtins.bool] ready_to_stream: Indicates whether the video is playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        :param pulumi.Input[_builtins.str] ready_to_stream_at: Indicates the time at which the video became playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        :param pulumi.Input[_builtins.bool] require_signed_urls: Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        :param pulumi.Input[_builtins.str] scheduled_deletion: Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        :param pulumi.Input[_builtins.float] size: The size of the media item in bytes.
        :param pulumi.Input['StreamStatusArgs'] status: Specifies a detailed status for a video. If the `state` is `inprogress` or `error`, the `step` field returns `encoding` or `manifest`. If the `state` is `inprogress`, `pctComplete` returns a number between 0 and 100 to indicate the approximate percent of completion. If the `state` is `error`, `errorReasonCode` and `errorReasonText` provide additional details.
        :param pulumi.Input[_builtins.str] thumbnail: The media item's thumbnail URI. This field is omitted until encoding is complete.
        :param pulumi.Input[_builtins.float] thumbnail_timestamp_pct: The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        :param pulumi.Input[_builtins.str] uid: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] upload_expiry: The date and time when the video upload URL is no longer valid for direct user uploads.
        :param pulumi.Input[_builtins.str] uploaded: The date and time the media item was uploaded.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if live_input is not None:
            pulumi.set(__self__, "live_input", live_input)
        if max_duration_seconds is not None:
            pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if playback is not None:
            pulumi.set(__self__, "playback", playback)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if ready_to_stream is not None:
            pulumi.set(__self__, "ready_to_stream", ready_to_stream)
        if ready_to_stream_at is not None:
            pulumi.set(__self__, "ready_to_stream_at", ready_to_stream_at)
        if require_signed_urls is not None:
            pulumi.set(__self__, "require_signed_urls", require_signed_urls)
        if scheduled_deletion is not None:
            pulumi.set(__self__, "scheduled_deletion", scheduled_deletion)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if thumbnail is not None:
            pulumi.set(__self__, "thumbnail", thumbnail)
        if thumbnail_timestamp_pct is not None:
            pulumi.set(__self__, "thumbnail_timestamp_pct", thumbnail_timestamp_pct)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if upload_expiry is not None:
            pulumi.set(__self__, "upload_expiry", upload_expiry)
        if uploaded is not None:
            pulumi.set(__self__, "uploaded", uploaded)
        if watermark is not None:
            pulumi.set(__self__, "watermark", watermark)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the media item was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-defined identifier for the media creator.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The duration of the video in seconds. A value of `-1` means the duration is unknown. The duration becomes available after the upload and before the video is ready.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['StreamInputArgs']]:
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['StreamInputArgs']]):
        pulumi.set(self, "input", value)

    @_builtins.property
    @pulumi.getter(name="liveInput")
    def live_input(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The live input ID used to upload a video with Stream Live.
        """
        return pulumi.get(self, "live_input")

    @live_input.setter
    def live_input(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "live_input", value)

    @_builtins.property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        """
        return pulumi.get(self, "max_duration_seconds")

    @max_duration_seconds.setter
    def max_duration_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_duration_seconds", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user modifiable key-value store used to reference other systems of record for managing videos.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the media item was last modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified", value)

    @_builtins.property
    @pulumi.getter
    def playback(self) -> Optional[pulumi.Input['StreamPlaybackArgs']]:
        return pulumi.get(self, "playback")

    @playback.setter
    def playback(self, value: Optional[pulumi.Input['StreamPlaybackArgs']]):
        pulumi.set(self, "playback", value)

    @_builtins.property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The video's preview page URI. This field is omitted until encoding is complete.
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preview", value)

    @_builtins.property
    @pulumi.getter(name="readyToStream")
    def ready_to_stream(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the video is playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        """
        return pulumi.get(self, "ready_to_stream")

    @ready_to_stream.setter
    def ready_to_stream(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ready_to_stream", value)

    @_builtins.property
    @pulumi.getter(name="readyToStreamAt")
    def ready_to_stream_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the time at which the video became playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        """
        return pulumi.get(self, "ready_to_stream_at")

    @ready_to_stream_at.setter
    def ready_to_stream_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ready_to_stream_at", value)

    @_builtins.property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        """
        return pulumi.get(self, "require_signed_urls")

    @require_signed_urls.setter
    def require_signed_urls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_signed_urls", value)

    @_builtins.property
    @pulumi.getter(name="scheduledDeletion")
    def scheduled_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        """
        return pulumi.get(self, "scheduled_deletion")

    @scheduled_deletion.setter
    def scheduled_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_deletion", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The size of the media item in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['StreamStatusArgs']]:
        """
        Specifies a detailed status for a video. If the `state` is `inprogress` or `error`, the `step` field returns `encoding` or `manifest`. If the `state` is `inprogress`, `pctComplete` returns a number between 0 and 100 to indicate the approximate percent of completion. If the `state` is `error`, `errorReasonCode` and `errorReasonText` provide additional details.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['StreamStatusArgs']]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def thumbnail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The media item's thumbnail URI. This field is omitted until encoding is complete.
        """
        return pulumi.get(self, "thumbnail")

    @thumbnail.setter
    def thumbnail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thumbnail", value)

    @_builtins.property
    @pulumi.getter(name="thumbnailTimestampPct")
    def thumbnail_timestamp_pct(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        """
        return pulumi.get(self, "thumbnail_timestamp_pct")

    @thumbnail_timestamp_pct.setter
    def thumbnail_timestamp_pct(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "thumbnail_timestamp_pct", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="uploadExpiry")
    def upload_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the video upload URL is no longer valid for direct user uploads.
        """
        return pulumi.get(self, "upload_expiry")

    @upload_expiry.setter
    def upload_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upload_expiry", value)

    @_builtins.property
    @pulumi.getter
    def uploaded(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the media item was uploaded.
        """
        return pulumi.get(self, "uploaded")

    @uploaded.setter
    def uploaded(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uploaded", value)

    @_builtins.property
    @pulumi.getter
    def watermark(self) -> Optional[pulumi.Input['StreamWatermarkArgs']]:
        return pulumi.get(self, "watermark")

    @watermark.setter
    def watermark(self, value: Optional[pulumi.Input['StreamWatermarkArgs']]):
        pulumi.set(self, "watermark", value)


@pulumi.type_token("cloudflare:index/stream:Stream")
class Stream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 max_duration_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[_builtins.bool]] = None,
                 scheduled_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_timestamp_pct: Optional[pulumi.Input[_builtins.float]] = None,
                 upload_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream = cloudflare.Stream("example_stream", account_id="023e105f4ecef8ad9ca31a8372d0c353")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        :param pulumi.Input[_builtins.str] creator: A user-defined identifier for the media creator.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.int] max_duration_seconds: The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing videos.
        :param pulumi.Input[_builtins.bool] require_signed_urls: Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        :param pulumi.Input[_builtins.str] scheduled_deletion: Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        :param pulumi.Input[_builtins.float] thumbnail_timestamp_pct: The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        :param pulumi.Input[_builtins.str] upload_expiry: The date and time when the video upload URL is no longer valid for direct user uploads.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream = cloudflare.Stream("example_stream", account_id="023e105f4ecef8ad9ca31a8372d0c353")
        ```

        :param str resource_name: The name of the resource.
        :param StreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 max_duration_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[_builtins.bool]] = None,
                 scheduled_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_timestamp_pct: Optional[pulumi.Input[_builtins.float]] = None,
                 upload_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamArgs.__new__(StreamArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allowed_origins"] = allowed_origins
            __props__.__dict__["creator"] = creator
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["max_duration_seconds"] = max_duration_seconds
            __props__.__dict__["meta"] = meta
            __props__.__dict__["require_signed_urls"] = require_signed_urls
            __props__.__dict__["scheduled_deletion"] = scheduled_deletion
            __props__.__dict__["thumbnail_timestamp_pct"] = thumbnail_timestamp_pct
            __props__.__dict__["upload_expiry"] = upload_expiry
            __props__.__dict__["created"] = None
            __props__.__dict__["duration"] = None
            __props__.__dict__["input"] = None
            __props__.__dict__["live_input"] = None
            __props__.__dict__["modified"] = None
            __props__.__dict__["playback"] = None
            __props__.__dict__["preview"] = None
            __props__.__dict__["ready_to_stream"] = None
            __props__.__dict__["ready_to_stream_at"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["thumbnail"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["uploaded"] = None
            __props__.__dict__["watermark"] = None
        super(Stream, __self__).__init__(
            'cloudflare:index/stream:Stream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.float]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            input: Optional[pulumi.Input[Union['StreamInputArgs', 'StreamInputArgsDict']]] = None,
            live_input: Optional[pulumi.Input[_builtins.str]] = None,
            max_duration_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            meta: Optional[pulumi.Input[_builtins.str]] = None,
            modified: Optional[pulumi.Input[_builtins.str]] = None,
            playback: Optional[pulumi.Input[Union['StreamPlaybackArgs', 'StreamPlaybackArgsDict']]] = None,
            preview: Optional[pulumi.Input[_builtins.str]] = None,
            ready_to_stream: Optional[pulumi.Input[_builtins.bool]] = None,
            ready_to_stream_at: Optional[pulumi.Input[_builtins.str]] = None,
            require_signed_urls: Optional[pulumi.Input[_builtins.bool]] = None,
            scheduled_deletion: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.float]] = None,
            status: Optional[pulumi.Input[Union['StreamStatusArgs', 'StreamStatusArgsDict']]] = None,
            thumbnail: Optional[pulumi.Input[_builtins.str]] = None,
            thumbnail_timestamp_pct: Optional[pulumi.Input[_builtins.float]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            upload_expiry: Optional[pulumi.Input[_builtins.str]] = None,
            uploaded: Optional[pulumi.Input[_builtins.str]] = None,
            watermark: Optional[pulumi.Input[Union['StreamWatermarkArgs', 'StreamWatermarkArgsDict']]] = None) -> 'Stream':
        """
        Get an existing Stream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        :param pulumi.Input[_builtins.str] created: The date and time the media item was created.
        :param pulumi.Input[_builtins.str] creator: A user-defined identifier for the media creator.
        :param pulumi.Input[_builtins.float] duration: The duration of the video in seconds. A value of `-1` means the duration is unknown. The duration becomes available after the upload and before the video is ready.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] live_input: The live input ID used to upload a video with Stream Live.
        :param pulumi.Input[_builtins.int] max_duration_seconds: The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing videos.
        :param pulumi.Input[_builtins.str] modified: The date and time the media item was last modified.
        :param pulumi.Input[_builtins.str] preview: The video's preview page URI. This field is omitted until encoding is complete.
        :param pulumi.Input[_builtins.bool] ready_to_stream: Indicates whether the video is playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        :param pulumi.Input[_builtins.str] ready_to_stream_at: Indicates the time at which the video became playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        :param pulumi.Input[_builtins.bool] require_signed_urls: Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        :param pulumi.Input[_builtins.str] scheduled_deletion: Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        :param pulumi.Input[_builtins.float] size: The size of the media item in bytes.
        :param pulumi.Input[Union['StreamStatusArgs', 'StreamStatusArgsDict']] status: Specifies a detailed status for a video. If the `state` is `inprogress` or `error`, the `step` field returns `encoding` or `manifest`. If the `state` is `inprogress`, `pctComplete` returns a number between 0 and 100 to indicate the approximate percent of completion. If the `state` is `error`, `errorReasonCode` and `errorReasonText` provide additional details.
        :param pulumi.Input[_builtins.str] thumbnail: The media item's thumbnail URI. This field is omitted until encoding is complete.
        :param pulumi.Input[_builtins.float] thumbnail_timestamp_pct: The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        :param pulumi.Input[_builtins.str] uid: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] upload_expiry: The date and time when the video upload URL is no longer valid for direct user uploads.
        :param pulumi.Input[_builtins.str] uploaded: The date and time the media item was uploaded.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamState.__new__(_StreamState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allowed_origins"] = allowed_origins
        __props__.__dict__["created"] = created
        __props__.__dict__["creator"] = creator
        __props__.__dict__["duration"] = duration
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["input"] = input
        __props__.__dict__["live_input"] = live_input
        __props__.__dict__["max_duration_seconds"] = max_duration_seconds
        __props__.__dict__["meta"] = meta
        __props__.__dict__["modified"] = modified
        __props__.__dict__["playback"] = playback
        __props__.__dict__["preview"] = preview
        __props__.__dict__["ready_to_stream"] = ready_to_stream
        __props__.__dict__["ready_to_stream_at"] = ready_to_stream_at
        __props__.__dict__["require_signed_urls"] = require_signed_urls
        __props__.__dict__["scheduled_deletion"] = scheduled_deletion
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["thumbnail"] = thumbnail
        __props__.__dict__["thumbnail_timestamp_pct"] = thumbnail_timestamp_pct
        __props__.__dict__["uid"] = uid
        __props__.__dict__["upload_expiry"] = upload_expiry
        __props__.__dict__["uploaded"] = uploaded
        __props__.__dict__["watermark"] = watermark
        return Stream(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Lists the origins allowed to display the video. Enter allowed origin domains in an array and use `*` for wildcard subdomains. Empty arrays allow the video to be viewed on any origin.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the media item was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user-defined identifier for the media creator.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[_builtins.float]:
        """
        The duration of the video in seconds. A value of `-1` means the duration is unknown. The duration becomes available after the upload and before the video is ready.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def input(self) -> pulumi.Output['outputs.StreamInput']:
        return pulumi.get(self, "input")

    @_builtins.property
    @pulumi.getter(name="liveInput")
    def live_input(self) -> pulumi.Output[_builtins.str]:
        """
        The live input ID used to upload a video with Stream Live.
        """
        return pulumi.get(self, "live_input")

    @_builtins.property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum duration in seconds for a video upload. Can be set for a video that is not yet uploaded to limit its duration. Uploads that exceed the specified duration will fail during processing. A value of `-1` means the value is unknown.
        """
        return pulumi.get(self, "max_duration_seconds")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user modifiable key-value store used to reference other systems of record for managing videos.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the media item was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    def playback(self) -> pulumi.Output['outputs.StreamPlayback']:
        return pulumi.get(self, "playback")

    @_builtins.property
    @pulumi.getter
    def preview(self) -> pulumi.Output[_builtins.str]:
        """
        The video's preview page URI. This field is omitted until encoding is complete.
        """
        return pulumi.get(self, "preview")

    @_builtins.property
    @pulumi.getter(name="readyToStream")
    def ready_to_stream(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the video is playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        """
        return pulumi.get(self, "ready_to_stream")

    @_builtins.property
    @pulumi.getter(name="readyToStreamAt")
    def ready_to_stream_at(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the time at which the video became playable. The field is empty if the video is not ready for viewing or the live stream is still in progress.
        """
        return pulumi.get(self, "ready_to_stream_at")

    @_builtins.property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the video can be a accessed using the UID. When set to `true`, a signed token must be generated with a signing key to view the video.
        """
        return pulumi.get(self, "require_signed_urls")

    @_builtins.property
    @pulumi.getter(name="scheduledDeletion")
    def scheduled_deletion(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates the date and time at which the video will be deleted. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion. If specified, must be at least 30 days from upload time.
        """
        return pulumi.get(self, "scheduled_deletion")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.float]:
        """
        The size of the media item in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.StreamStatus']:
        """
        Specifies a detailed status for a video. If the `state` is `inprogress` or `error`, the `step` field returns `encoding` or `manifest`. If the `state` is `inprogress`, `pctComplete` returns a number between 0 and 100 to indicate the approximate percent of completion. If the `state` is `error`, `errorReasonCode` and `errorReasonText` provide additional details.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def thumbnail(self) -> pulumi.Output[_builtins.str]:
        """
        The media item's thumbnail URI. This field is omitted until encoding is complete.
        """
        return pulumi.get(self, "thumbnail")

    @_builtins.property
    @pulumi.getter(name="thumbnailTimestampPct")
    def thumbnail_timestamp_pct(self) -> pulumi.Output[_builtins.float]:
        """
        The timestamp for a thumbnail image calculated as a percentage value of the video's duration. To convert from a second-wise timestamp to a percentage, divide the desired timestamp by the total duration of the video.  If this value is not set, the default thumbnail image is taken from 0s of the video.
        """
        return pulumi.get(self, "thumbnail_timestamp_pct")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="uploadExpiry")
    def upload_expiry(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The date and time when the video upload URL is no longer valid for direct user uploads.
        """
        return pulumi.get(self, "upload_expiry")

    @_builtins.property
    @pulumi.getter
    def uploaded(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the media item was uploaded.
        """
        return pulumi.get(self, "uploaded")

    @_builtins.property
    @pulumi.getter
    def watermark(self) -> pulumi.Output['outputs.StreamWatermark']:
        return pulumi.get(self, "watermark")

