# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StreamCaptionLanguageArgs', 'StreamCaptionLanguage']

@pulumi.input_type
class StreamCaptionLanguageArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 language: pulumi.Input[_builtins.str],
                 file: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamCaptionLanguage resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] language: The language tag in BCP 47 format.
        :param pulumi.Input[_builtins.str] file: The WebVTT file containing the caption or subtitle content.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "language", language)
        if file is not None:
            pulumi.set(__self__, "file", file)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Input[_builtins.str]:
        """
        The language tag in BCP 47 format.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WebVTT file containing the caption or subtitle content.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file", value)


@pulumi.input_type
class _StreamCaptionLanguageState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 generated: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamCaptionLanguage resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] file: The WebVTT file containing the caption or subtitle content.
        :param pulumi.Input[_builtins.bool] generated: Whether the caption was generated via AI.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] label: The language label displayed in the native language to users.
        :param pulumi.Input[_builtins.str] language: The language tag in BCP 47 format.
        :param pulumi.Input[_builtins.str] status: The status of a generated caption.
               Available values: "ready", "inprogress", "error".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if generated is not None:
            pulumi.set(__self__, "generated", generated)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WebVTT file containing the caption or subtitle content.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file", value)

    @_builtins.property
    @pulumi.getter
    def generated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the caption was generated via AI.
        """
        return pulumi.get(self, "generated")

    @generated.setter
    def generated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generated", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language label displayed in the native language to users.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language tag in BCP 47 format.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of a generated caption.
        Available values: "ready", "inprogress", "error".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("cloudflare:index/streamCaptionLanguage:StreamCaptionLanguage")
class StreamCaptionLanguage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream_caption_language = cloudflare.StreamCaptionLanguage("example_stream_caption_language",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            identifier="ea95132c15732412d22c1476fa83f27a",
            language="tr")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] file: The WebVTT file containing the caption or subtitle content.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] language: The language tag in BCP 47 format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamCaptionLanguageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream_caption_language = cloudflare.StreamCaptionLanguage("example_stream_caption_language",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            identifier="ea95132c15732412d22c1476fa83f27a",
            language="tr")
        ```

        :param str resource_name: The name of the resource.
        :param StreamCaptionLanguageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamCaptionLanguageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamCaptionLanguageArgs.__new__(StreamCaptionLanguageArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["file"] = file
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            if language is None and not opts.urn:
                raise TypeError("Missing required property 'language'")
            __props__.__dict__["language"] = language
            __props__.__dict__["generated"] = None
            __props__.__dict__["label"] = None
            __props__.__dict__["status"] = None
        super(StreamCaptionLanguage, __self__).__init__(
            'cloudflare:index/streamCaptionLanguage:StreamCaptionLanguage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            file: Optional[pulumi.Input[_builtins.str]] = None,
            generated: Optional[pulumi.Input[_builtins.bool]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            language: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamCaptionLanguage':
        """
        Get an existing StreamCaptionLanguage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] file: The WebVTT file containing the caption or subtitle content.
        :param pulumi.Input[_builtins.bool] generated: Whether the caption was generated via AI.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] label: The language label displayed in the native language to users.
        :param pulumi.Input[_builtins.str] language: The language tag in BCP 47 format.
        :param pulumi.Input[_builtins.str] status: The status of a generated caption.
               Available values: "ready", "inprogress", "error".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamCaptionLanguageState.__new__(_StreamCaptionLanguageState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["file"] = file
        __props__.__dict__["generated"] = generated
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["label"] = label
        __props__.__dict__["language"] = language
        __props__.__dict__["status"] = status
        return StreamCaptionLanguage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The WebVTT file containing the caption or subtitle content.
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter
    def generated(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the caption was generated via AI.
        """
        return pulumi.get(self, "generated")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The language label displayed in the native language to users.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Output[_builtins.str]:
        """
        The language tag in BCP 47 format.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of a generated caption.
        Available values: "ready", "inprogress", "error".
        """
        return pulumi.get(self, "status")

