# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamLiveInputArgs', 'StreamLiveInput']

@pulumi.input_type
class StreamLiveInputArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 default_creator: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_recording_after_days: Optional[pulumi.Input[_builtins.float]] = None,
                 live_input_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input['StreamLiveInputRecordingArgs']] = None):
        """
        The set of arguments for constructing a StreamLiveInput resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] default_creator: Sets the creator ID asssociated with this live input.
        :param pulumi.Input[_builtins.float] delete_recording_after_days: Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        :param pulumi.Input[_builtins.str] live_input_identifier: A unique identifier for a live input.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing live inputs.
        :param pulumi.Input['StreamLiveInputRecordingArgs'] recording: Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        """
        pulumi.set(__self__, "account_id", account_id)
        if default_creator is not None:
            pulumi.set(__self__, "default_creator", default_creator)
        if delete_recording_after_days is not None:
            pulumi.set(__self__, "delete_recording_after_days", delete_recording_after_days)
        if live_input_identifier is not None:
            pulumi.set(__self__, "live_input_identifier", live_input_identifier)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if recording is not None:
            pulumi.set(__self__, "recording", recording)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultCreator")
    def default_creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the creator ID asssociated with this live input.
        """
        return pulumi.get(self, "default_creator")

    @default_creator.setter
    def default_creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_creator", value)

    @_builtins.property
    @pulumi.getter(name="deleteRecordingAfterDays")
    def delete_recording_after_days(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        """
        return pulumi.get(self, "delete_recording_after_days")

    @delete_recording_after_days.setter
    def delete_recording_after_days(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "delete_recording_after_days", value)

    @_builtins.property
    @pulumi.getter(name="liveInputIdentifier")
    def live_input_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for a live input.
        """
        return pulumi.get(self, "live_input_identifier")

    @live_input_identifier.setter
    def live_input_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "live_input_identifier", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user modifiable key-value store used to reference other systems of record for managing live inputs.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def recording(self) -> Optional[pulumi.Input['StreamLiveInputRecordingArgs']]:
        """
        Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        """
        return pulumi.get(self, "recording")

    @recording.setter
    def recording(self, value: Optional[pulumi.Input['StreamLiveInputRecordingArgs']]):
        pulumi.set(self, "recording", value)


@pulumi.input_type
class _StreamLiveInputState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 default_creator: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_recording_after_days: Optional[pulumi.Input[_builtins.float]] = None,
                 live_input_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 modified: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input['StreamLiveInputRecordingArgs']] = None,
                 rtmps: Optional[pulumi.Input['StreamLiveInputRtmpsArgs']] = None,
                 rtmps_playback: Optional[pulumi.Input['StreamLiveInputRtmpsPlaybackArgs']] = None,
                 srt: Optional[pulumi.Input['StreamLiveInputSrtArgs']] = None,
                 srt_playback: Optional[pulumi.Input['StreamLiveInputSrtPlaybackArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 web_rtc: Optional[pulumi.Input['StreamLiveInputWebRtcArgs']] = None,
                 web_rtc_playback: Optional[pulumi.Input['StreamLiveInputWebRtcPlaybackArgs']] = None):
        """
        Input properties used for looking up and filtering StreamLiveInput resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created: The date and time the live input was created.
        :param pulumi.Input[_builtins.str] default_creator: Sets the creator ID asssociated with this live input.
        :param pulumi.Input[_builtins.float] delete_recording_after_days: Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        :param pulumi.Input[_builtins.str] live_input_identifier: A unique identifier for a live input.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing live inputs.
        :param pulumi.Input[_builtins.str] modified: The date and time the live input was last modified.
        :param pulumi.Input['StreamLiveInputRecordingArgs'] recording: Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        :param pulumi.Input['StreamLiveInputRtmpsArgs'] rtmps: Details for streaming to an live input using RTMPS.
        :param pulumi.Input['StreamLiveInputRtmpsPlaybackArgs'] rtmps_playback: Details for playback from an live input using RTMPS.
        :param pulumi.Input['StreamLiveInputSrtArgs'] srt: Details for streaming to a live input using SRT.
        :param pulumi.Input['StreamLiveInputSrtPlaybackArgs'] srt_playback: Details for playback from an live input using SRT.
        :param pulumi.Input[_builtins.str] status: The connection status of a live input.
               Available values: "connected", "reconnected", "reconnecting", "client*disconnect", "ttl*exceeded", "failed*to*connect", "failed*to*reconnect", "new*configuration*accepted".
        :param pulumi.Input[_builtins.str] uid: A unique identifier for a live input.
        :param pulumi.Input['StreamLiveInputWebRtcArgs'] web_rtc: Details for streaming to a live input using WebRTC.
        :param pulumi.Input['StreamLiveInputWebRtcPlaybackArgs'] web_rtc_playback: Details for playback from a live input using WebRTC.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if default_creator is not None:
            pulumi.set(__self__, "default_creator", default_creator)
        if delete_recording_after_days is not None:
            pulumi.set(__self__, "delete_recording_after_days", delete_recording_after_days)
        if live_input_identifier is not None:
            pulumi.set(__self__, "live_input_identifier", live_input_identifier)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if recording is not None:
            pulumi.set(__self__, "recording", recording)
        if rtmps is not None:
            pulumi.set(__self__, "rtmps", rtmps)
        if rtmps_playback is not None:
            pulumi.set(__self__, "rtmps_playback", rtmps_playback)
        if srt is not None:
            pulumi.set(__self__, "srt", srt)
        if srt_playback is not None:
            pulumi.set(__self__, "srt_playback", srt_playback)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if web_rtc is not None:
            pulumi.set(__self__, "web_rtc", web_rtc)
        if web_rtc_playback is not None:
            pulumi.set(__self__, "web_rtc_playback", web_rtc_playback)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the live input was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="defaultCreator")
    def default_creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the creator ID asssociated with this live input.
        """
        return pulumi.get(self, "default_creator")

    @default_creator.setter
    def default_creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_creator", value)

    @_builtins.property
    @pulumi.getter(name="deleteRecordingAfterDays")
    def delete_recording_after_days(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        """
        return pulumi.get(self, "delete_recording_after_days")

    @delete_recording_after_days.setter
    def delete_recording_after_days(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "delete_recording_after_days", value)

    @_builtins.property
    @pulumi.getter(name="liveInputIdentifier")
    def live_input_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for a live input.
        """
        return pulumi.get(self, "live_input_identifier")

    @live_input_identifier.setter
    def live_input_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "live_input_identifier", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user modifiable key-value store used to reference other systems of record for managing live inputs.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the live input was last modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified", value)

    @_builtins.property
    @pulumi.getter
    def recording(self) -> Optional[pulumi.Input['StreamLiveInputRecordingArgs']]:
        """
        Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        """
        return pulumi.get(self, "recording")

    @recording.setter
    def recording(self, value: Optional[pulumi.Input['StreamLiveInputRecordingArgs']]):
        pulumi.set(self, "recording", value)

    @_builtins.property
    @pulumi.getter
    def rtmps(self) -> Optional[pulumi.Input['StreamLiveInputRtmpsArgs']]:
        """
        Details for streaming to an live input using RTMPS.
        """
        return pulumi.get(self, "rtmps")

    @rtmps.setter
    def rtmps(self, value: Optional[pulumi.Input['StreamLiveInputRtmpsArgs']]):
        pulumi.set(self, "rtmps", value)

    @_builtins.property
    @pulumi.getter(name="rtmpsPlayback")
    def rtmps_playback(self) -> Optional[pulumi.Input['StreamLiveInputRtmpsPlaybackArgs']]:
        """
        Details for playback from an live input using RTMPS.
        """
        return pulumi.get(self, "rtmps_playback")

    @rtmps_playback.setter
    def rtmps_playback(self, value: Optional[pulumi.Input['StreamLiveInputRtmpsPlaybackArgs']]):
        pulumi.set(self, "rtmps_playback", value)

    @_builtins.property
    @pulumi.getter
    def srt(self) -> Optional[pulumi.Input['StreamLiveInputSrtArgs']]:
        """
        Details for streaming to a live input using SRT.
        """
        return pulumi.get(self, "srt")

    @srt.setter
    def srt(self, value: Optional[pulumi.Input['StreamLiveInputSrtArgs']]):
        pulumi.set(self, "srt", value)

    @_builtins.property
    @pulumi.getter(name="srtPlayback")
    def srt_playback(self) -> Optional[pulumi.Input['StreamLiveInputSrtPlaybackArgs']]:
        """
        Details for playback from an live input using SRT.
        """
        return pulumi.get(self, "srt_playback")

    @srt_playback.setter
    def srt_playback(self, value: Optional[pulumi.Input['StreamLiveInputSrtPlaybackArgs']]):
        pulumi.set(self, "srt_playback", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection status of a live input.
        Available values: "connected", "reconnected", "reconnecting", "client*disconnect", "ttl*exceeded", "failed*to*connect", "failed*to*reconnect", "new*configuration*accepted".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for a live input.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="webRtc")
    def web_rtc(self) -> Optional[pulumi.Input['StreamLiveInputWebRtcArgs']]:
        """
        Details for streaming to a live input using WebRTC.
        """
        return pulumi.get(self, "web_rtc")

    @web_rtc.setter
    def web_rtc(self, value: Optional[pulumi.Input['StreamLiveInputWebRtcArgs']]):
        pulumi.set(self, "web_rtc", value)

    @_builtins.property
    @pulumi.getter(name="webRtcPlayback")
    def web_rtc_playback(self) -> Optional[pulumi.Input['StreamLiveInputWebRtcPlaybackArgs']]:
        """
        Details for playback from a live input using WebRTC.
        """
        return pulumi.get(self, "web_rtc_playback")

    @web_rtc_playback.setter
    def web_rtc_playback(self, value: Optional[pulumi.Input['StreamLiveInputWebRtcPlaybackArgs']]):
        pulumi.set(self, "web_rtc_playback", value)


@pulumi.type_token("cloudflare:index/streamLiveInput:StreamLiveInput")
class StreamLiveInput(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_creator: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_recording_after_days: Optional[pulumi.Input[_builtins.float]] = None,
                 live_input_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input[Union['StreamLiveInputRecordingArgs', 'StreamLiveInputRecordingArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] default_creator: Sets the creator ID asssociated with this live input.
        :param pulumi.Input[_builtins.float] delete_recording_after_days: Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        :param pulumi.Input[_builtins.str] live_input_identifier: A unique identifier for a live input.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing live inputs.
        :param pulumi.Input[Union['StreamLiveInputRecordingArgs', 'StreamLiveInputRecordingArgsDict']] recording: Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamLiveInputArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param StreamLiveInputArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamLiveInputArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_creator: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_recording_after_days: Optional[pulumi.Input[_builtins.float]] = None,
                 live_input_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input[Union['StreamLiveInputRecordingArgs', 'StreamLiveInputRecordingArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamLiveInputArgs.__new__(StreamLiveInputArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["default_creator"] = default_creator
            __props__.__dict__["delete_recording_after_days"] = delete_recording_after_days
            __props__.__dict__["live_input_identifier"] = live_input_identifier
            __props__.__dict__["meta"] = meta
            __props__.__dict__["recording"] = recording
            __props__.__dict__["created"] = None
            __props__.__dict__["modified"] = None
            __props__.__dict__["rtmps"] = None
            __props__.__dict__["rtmps_playback"] = None
            __props__.__dict__["srt"] = None
            __props__.__dict__["srt_playback"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["web_rtc"] = None
            __props__.__dict__["web_rtc_playback"] = None
        super(StreamLiveInput, __self__).__init__(
            'cloudflare:index/streamLiveInput:StreamLiveInput',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            default_creator: Optional[pulumi.Input[_builtins.str]] = None,
            delete_recording_after_days: Optional[pulumi.Input[_builtins.float]] = None,
            live_input_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            meta: Optional[pulumi.Input[_builtins.str]] = None,
            modified: Optional[pulumi.Input[_builtins.str]] = None,
            recording: Optional[pulumi.Input[Union['StreamLiveInputRecordingArgs', 'StreamLiveInputRecordingArgsDict']]] = None,
            rtmps: Optional[pulumi.Input[Union['StreamLiveInputRtmpsArgs', 'StreamLiveInputRtmpsArgsDict']]] = None,
            rtmps_playback: Optional[pulumi.Input[Union['StreamLiveInputRtmpsPlaybackArgs', 'StreamLiveInputRtmpsPlaybackArgsDict']]] = None,
            srt: Optional[pulumi.Input[Union['StreamLiveInputSrtArgs', 'StreamLiveInputSrtArgsDict']]] = None,
            srt_playback: Optional[pulumi.Input[Union['StreamLiveInputSrtPlaybackArgs', 'StreamLiveInputSrtPlaybackArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            web_rtc: Optional[pulumi.Input[Union['StreamLiveInputWebRtcArgs', 'StreamLiveInputWebRtcArgsDict']]] = None,
            web_rtc_playback: Optional[pulumi.Input[Union['StreamLiveInputWebRtcPlaybackArgs', 'StreamLiveInputWebRtcPlaybackArgsDict']]] = None) -> 'StreamLiveInput':
        """
        Get an existing StreamLiveInput resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created: The date and time the live input was created.
        :param pulumi.Input[_builtins.str] default_creator: Sets the creator ID asssociated with this live input.
        :param pulumi.Input[_builtins.float] delete_recording_after_days: Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        :param pulumi.Input[_builtins.str] live_input_identifier: A unique identifier for a live input.
        :param pulumi.Input[_builtins.str] meta: A user modifiable key-value store used to reference other systems of record for managing live inputs.
        :param pulumi.Input[_builtins.str] modified: The date and time the live input was last modified.
        :param pulumi.Input[Union['StreamLiveInputRecordingArgs', 'StreamLiveInputRecordingArgsDict']] recording: Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        :param pulumi.Input[Union['StreamLiveInputRtmpsArgs', 'StreamLiveInputRtmpsArgsDict']] rtmps: Details for streaming to an live input using RTMPS.
        :param pulumi.Input[Union['StreamLiveInputRtmpsPlaybackArgs', 'StreamLiveInputRtmpsPlaybackArgsDict']] rtmps_playback: Details for playback from an live input using RTMPS.
        :param pulumi.Input[Union['StreamLiveInputSrtArgs', 'StreamLiveInputSrtArgsDict']] srt: Details for streaming to a live input using SRT.
        :param pulumi.Input[Union['StreamLiveInputSrtPlaybackArgs', 'StreamLiveInputSrtPlaybackArgsDict']] srt_playback: Details for playback from an live input using SRT.
        :param pulumi.Input[_builtins.str] status: The connection status of a live input.
               Available values: "connected", "reconnected", "reconnecting", "client*disconnect", "ttl*exceeded", "failed*to*connect", "failed*to*reconnect", "new*configuration*accepted".
        :param pulumi.Input[_builtins.str] uid: A unique identifier for a live input.
        :param pulumi.Input[Union['StreamLiveInputWebRtcArgs', 'StreamLiveInputWebRtcArgsDict']] web_rtc: Details for streaming to a live input using WebRTC.
        :param pulumi.Input[Union['StreamLiveInputWebRtcPlaybackArgs', 'StreamLiveInputWebRtcPlaybackArgsDict']] web_rtc_playback: Details for playback from a live input using WebRTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamLiveInputState.__new__(_StreamLiveInputState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created"] = created
        __props__.__dict__["default_creator"] = default_creator
        __props__.__dict__["delete_recording_after_days"] = delete_recording_after_days
        __props__.__dict__["live_input_identifier"] = live_input_identifier
        __props__.__dict__["meta"] = meta
        __props__.__dict__["modified"] = modified
        __props__.__dict__["recording"] = recording
        __props__.__dict__["rtmps"] = rtmps
        __props__.__dict__["rtmps_playback"] = rtmps_playback
        __props__.__dict__["srt"] = srt
        __props__.__dict__["srt_playback"] = srt_playback
        __props__.__dict__["status"] = status
        __props__.__dict__["uid"] = uid
        __props__.__dict__["web_rtc"] = web_rtc
        __props__.__dict__["web_rtc_playback"] = web_rtc_playback
        return StreamLiveInput(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the live input was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="defaultCreator")
    def default_creator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets the creator ID asssociated with this live input.
        """
        return pulumi.get(self, "default_creator")

    @_builtins.property
    @pulumi.getter(name="deleteRecordingAfterDays")
    def delete_recording_after_days(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        """
        return pulumi.get(self, "delete_recording_after_days")

    @_builtins.property
    @pulumi.getter(name="liveInputIdentifier")
    def live_input_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A unique identifier for a live input.
        """
        return pulumi.get(self, "live_input_identifier")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user modifiable key-value store used to reference other systems of record for managing live inputs.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the live input was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    def recording(self) -> pulumi.Output['outputs.StreamLiveInputRecording']:
        """
        Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        """
        return pulumi.get(self, "recording")

    @_builtins.property
    @pulumi.getter
    def rtmps(self) -> pulumi.Output['outputs.StreamLiveInputRtmps']:
        """
        Details for streaming to an live input using RTMPS.
        """
        return pulumi.get(self, "rtmps")

    @_builtins.property
    @pulumi.getter(name="rtmpsPlayback")
    def rtmps_playback(self) -> pulumi.Output['outputs.StreamLiveInputRtmpsPlayback']:
        """
        Details for playback from an live input using RTMPS.
        """
        return pulumi.get(self, "rtmps_playback")

    @_builtins.property
    @pulumi.getter
    def srt(self) -> pulumi.Output['outputs.StreamLiveInputSrt']:
        """
        Details for streaming to a live input using SRT.
        """
        return pulumi.get(self, "srt")

    @_builtins.property
    @pulumi.getter(name="srtPlayback")
    def srt_playback(self) -> pulumi.Output['outputs.StreamLiveInputSrtPlayback']:
        """
        Details for playback from an live input using SRT.
        """
        return pulumi.get(self, "srt_playback")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The connection status of a live input.
        Available values: "connected", "reconnected", "reconnecting", "client*disconnect", "ttl*exceeded", "failed*to*connect", "failed*to*reconnect", "new*configuration*accepted".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for a live input.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="webRtc")
    def web_rtc(self) -> pulumi.Output['outputs.StreamLiveInputWebRtc']:
        """
        Details for streaming to a live input using WebRTC.
        """
        return pulumi.get(self, "web_rtc")

    @_builtins.property
    @pulumi.getter(name="webRtcPlayback")
    def web_rtc_playback(self) -> pulumi.Output['outputs.StreamLiveInputWebRtcPlayback']:
        """
        Details for playback from a live input using WebRTC.
        """
        return pulumi.get(self, "web_rtc_playback")

