# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TunnelVirtualNetworkArgs', 'TunnelVirtualNetwork']

@pulumi.input_type
class TunnelVirtualNetworkArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default_network: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TunnelVirtualNetwork resource.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the virtual network.
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the virtual network.
        :param pulumi.Input[_builtins.bool] is_default: If `true`, this virtual network is the default for the account.
        :param pulumi.Input[_builtins.bool] is_default_network: If `true`, this virtual network is the default for the account.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if is_default is not None:
            warnings.warn("""Use the is_default_network property instead.""", DeprecationWarning)
            pulumi.log.warn("""is_default is deprecated: Use the is_default_network property instead.""")
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_default_network is not None:
            pulumi.set(__self__, "is_default_network", is_default_network)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A user-friendly name for the virtual network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional remark describing the virtual network.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    @_utilities.deprecated("""Use the is_default_network property instead.""")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, this virtual network is the default for the account.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isDefaultNetwork")
    def is_default_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, this virtual network is the default for the account.
        """
        return pulumi.get(self, "is_default_network")

    @is_default_network.setter
    def is_default_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_network", value)


@pulumi.input_type
class _TunnelVirtualNetworkState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deleted_at: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TunnelVirtualNetwork resources.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the virtual network.
        :param pulumi.Input[_builtins.str] created_at: Timestamp of when the resource was created.
        :param pulumi.Input[_builtins.str] deleted_at: Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        :param pulumi.Input[_builtins.bool] is_default: If `true`, this virtual network is the default for the account.
        :param pulumi.Input[_builtins.bool] is_default_network: If `true`, this virtual network is the default for the account.
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the virtual network.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deleted_at is not None:
            pulumi.set(__self__, "deleted_at", deleted_at)
        if is_default is not None:
            warnings.warn("""Use the is_default_network property instead.""", DeprecationWarning)
            pulumi.log.warn("""is_default is deprecated: Use the is_default_network property instead.""")
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_default_network is not None:
            pulumi.set(__self__, "is_default_network", is_default_network)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional remark describing the virtual network.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        """
        return pulumi.get(self, "deleted_at")

    @deleted_at.setter
    def deleted_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deleted_at", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    @_utilities.deprecated("""Use the is_default_network property instead.""")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, this virtual network is the default for the account.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isDefaultNetwork")
    def is_default_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, this virtual network is the default for the account.
        """
        return pulumi.get(self, "is_default_network")

    @is_default_network.setter
    def is_default_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_network", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name for the virtual network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


warnings.warn("""cloudflare.index/tunnelvirtualnetwork.TunnelVirtualNetwork has been deprecated in favor of cloudflare.index/zerotrusttunnelcloudflaredvirtualnetwork.ZeroTrustTunnelCloudflaredVirtualNetwork""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/tunnelVirtualNetwork:TunnelVirtualNetwork")
class TunnelVirtualNetwork(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/tunnelvirtualnetwork.TunnelVirtualNetwork has been deprecated in favor of cloudflare.index/zerotrusttunnelcloudflaredvirtualnetwork.ZeroTrustTunnelCloudflaredVirtualNetwork""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_tunnel_cloudflared_virtual_network = cloudflare.ZeroTrustTunnelCloudflaredVirtualNetwork("example_zero_trust_tunnel_cloudflared_virtual_network",
            account_id="699d98642c564d2e855e9661899b7252",
            name="us-east-1-vpc",
            comment="Staging VPC for data science",
            is_default=True,
            is_default_network=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/tunnelVirtualNetwork:TunnelVirtualNetwork example '<account_id>/<virtual_network_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the virtual network.
        :param pulumi.Input[_builtins.bool] is_default: If `true`, this virtual network is the default for the account.
        :param pulumi.Input[_builtins.bool] is_default_network: If `true`, this virtual network is the default for the account.
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the virtual network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TunnelVirtualNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_tunnel_cloudflared_virtual_network = cloudflare.ZeroTrustTunnelCloudflaredVirtualNetwork("example_zero_trust_tunnel_cloudflared_virtual_network",
            account_id="699d98642c564d2e855e9661899b7252",
            name="us-east-1-vpc",
            comment="Staging VPC for data science",
            is_default=True,
            is_default_network=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/tunnelVirtualNetwork:TunnelVirtualNetwork example '<account_id>/<virtual_network_id>'
        ```

        :param str resource_name: The name of the resource.
        :param TunnelVirtualNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TunnelVirtualNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""TunnelVirtualNetwork is deprecated: cloudflare.index/tunnelvirtualnetwork.TunnelVirtualNetwork has been deprecated in favor of cloudflare.index/zerotrusttunnelcloudflaredvirtualnetwork.ZeroTrustTunnelCloudflaredVirtualNetwork""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TunnelVirtualNetworkArgs.__new__(TunnelVirtualNetworkArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["comment"] = comment
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["is_default_network"] = is_default_network
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["deleted_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/tunnelVirtualNetwork:TunnelVirtualNetwork")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(TunnelVirtualNetwork, __self__).__init__(
            'cloudflare:index/tunnelVirtualNetwork:TunnelVirtualNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deleted_at: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            is_default_network: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'TunnelVirtualNetwork':
        """
        Get an existing TunnelVirtualNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the virtual network.
        :param pulumi.Input[_builtins.str] created_at: Timestamp of when the resource was created.
        :param pulumi.Input[_builtins.str] deleted_at: Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        :param pulumi.Input[_builtins.bool] is_default: If `true`, this virtual network is the default for the account.
        :param pulumi.Input[_builtins.bool] is_default_network: If `true`, this virtual network is the default for the account.
        :param pulumi.Input[_builtins.str] name: A user-friendly name for the virtual network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TunnelVirtualNetworkState.__new__(_TunnelVirtualNetworkState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deleted_at"] = deleted_at
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["is_default_network"] = is_default_network
        __props__.__dict__["name"] = name
        return TunnelVirtualNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[_builtins.str]:
        """
        Optional remark describing the virtual network.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        """
        return pulumi.get(self, "deleted_at")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    @_utilities.deprecated("""Use the is_default_network property instead.""")
    def is_default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, this virtual network is the default for the account.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isDefaultNetwork")
    def is_default_network(self) -> pulumi.Output[_builtins.bool]:
        """
        If `true`, this virtual network is the default for the account.
        """
        return pulumi.get(self, "is_default_network")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name for the virtual network.
        """
        return pulumi.get(self, "name")

