# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustDlpDatasetArgs', 'ZeroTrustDlpDataset']

@pulumi.input_type
class ZeroTrustDlpDatasetArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 case_sensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding_version: Optional[pulumi.Input[_builtins.int]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ZeroTrustDlpDataset resource.
        :param pulumi.Input[_builtins.bool] case_sensitive: Only applies to custom word lists.
               Determines if the words should be matched in a case-sensitive manner
               Cannot be set to false if `secret` is true or undefined
        :param pulumi.Input[_builtins.str] description: The description of the dataset.
        :param pulumi.Input[_builtins.int] encoding_version: Dataset encoding version
        :param pulumi.Input[_builtins.bool] secret: Generate a secret dataset.
               
               If true, the response will include a secret to use with the EDM encoder.
               If false, the response has no secret and the dataset is uploaded in plaintext.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encoding_version is not None:
            pulumi.set(__self__, "encoding_version", encoding_version)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only applies to custom word lists.
        Determines if the words should be matched in a case-sensitive manner
        Cannot be set to false if `secret` is true or undefined
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "case_sensitive", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encodingVersion")
    def encoding_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Dataset encoding version
        """
        return pulumi.get(self, "encoding_version")

    @encoding_version.setter
    def encoding_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "encoding_version", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generate a secret dataset.

        If true, the response will include a secret to use with the EDM encoder.
        If false, the response has no secret and the dataset is uploaded in plaintext.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class _ZeroTrustDlpDatasetState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpDatasetColumnArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input['ZeroTrustDlpDatasetDatasetArgs']] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding_version: Optional[pulumi.Input[_builtins.int]] = None,
                 max_cells: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_cells: Optional[pulumi.Input[_builtins.int]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 uploads: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpDatasetUploadArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDlpDataset resources.
        :param pulumi.Input[_builtins.bool] case_sensitive: Only applies to custom word lists.
               Determines if the words should be matched in a case-sensitive manner
               Cannot be set to false if `secret` is true or undefined
        :param pulumi.Input[_builtins.str] description: The description of the dataset.
        :param pulumi.Input[_builtins.int] encoding_version: Dataset encoding version
        :param pulumi.Input[_builtins.bool] secret: Generate a secret dataset.
               
               If true, the response will include a secret to use with the EDM encoder.
               If false, the response has no secret and the dataset is uploaded in plaintext.
        :param pulumi.Input[_builtins.str] status: Available values: "empty", "uploading", "pending", "processing", "failed", "complete".
        :param pulumi.Input[_builtins.str] updated_at: When the dataset was last updated.
               
               This includes name or description changes as well as uploads.
        :param pulumi.Input[_builtins.int] version: The version to use when uploading the dataset.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encoding_version is not None:
            pulumi.set(__self__, "encoding_version", encoding_version)
        if max_cells is not None:
            pulumi.set(__self__, "max_cells", max_cells)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_cells is not None:
            pulumi.set(__self__, "num_cells", num_cells)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if uploads is not None:
            pulumi.set(__self__, "uploads", uploads)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only applies to custom word lists.
        Determines if the words should be matched in a case-sensitive manner
        Cannot be set to false if `secret` is true or undefined
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "case_sensitive", value)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpDatasetColumnArgs']]]]:
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpDatasetColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input['ZeroTrustDlpDatasetDatasetArgs']]:
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input['ZeroTrustDlpDatasetDatasetArgs']]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encodingVersion")
    def encoding_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Dataset encoding version
        """
        return pulumi.get(self, "encoding_version")

    @encoding_version.setter
    def encoding_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "encoding_version", value)

    @_builtins.property
    @pulumi.getter(name="maxCells")
    def max_cells(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_cells")

    @max_cells.setter
    def max_cells(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_cells", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numCells")
    def num_cells(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "num_cells")

    @num_cells.setter
    def num_cells(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cells", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generate a secret dataset.

        If true, the response will include a secret to use with the EDM encoder.
        If false, the response has no secret and the dataset is uploaded in plaintext.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Available values: "empty", "uploading", "pending", "processing", "failed", "complete".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the dataset was last updated.

        This includes name or description changes as well as uploads.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def uploads(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpDatasetUploadArgs']]]]:
        return pulumi.get(self, "uploads")

    @uploads.setter
    def uploads(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpDatasetUploadArgs']]]]):
        pulumi.set(self, "uploads", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version to use when uploading the dataset.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("cloudflare:index/zeroTrustDlpDataset:ZeroTrustDlpDataset")
class ZeroTrustDlpDataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dlp_dataset = cloudflare.ZeroTrustDlpDataset("example_zero_trust_dlp_dataset",
            account_id="account_id",
            name="name",
            case_sensitive=True,
            description="description",
            encoding_version=0,
            secret=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] case_sensitive: Only applies to custom word lists.
               Determines if the words should be matched in a case-sensitive manner
               Cannot be set to false if `secret` is true or undefined
        :param pulumi.Input[_builtins.str] description: The description of the dataset.
        :param pulumi.Input[_builtins.int] encoding_version: Dataset encoding version
        :param pulumi.Input[_builtins.bool] secret: Generate a secret dataset.
               
               If true, the response will include a secret to use with the EDM encoder.
               If false, the response has no secret and the dataset is uploaded in plaintext.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDlpDatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dlp_dataset = cloudflare.ZeroTrustDlpDataset("example_zero_trust_dlp_dataset",
            account_id="account_id",
            name="name",
            case_sensitive=True,
            description="description",
            encoding_version=0,
            secret=True)
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDlpDatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDlpDatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDlpDatasetArgs.__new__(ZeroTrustDlpDatasetArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["case_sensitive"] = case_sensitive
            __props__.__dict__["dataset_id"] = dataset_id
            __props__.__dict__["description"] = description
            __props__.__dict__["encoding_version"] = encoding_version
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["secret"] = secret
            __props__.__dict__["columns"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["dataset"] = None
            __props__.__dict__["max_cells"] = None
            __props__.__dict__["num_cells"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["uploads"] = None
            __props__.__dict__["version"] = None
        super(ZeroTrustDlpDataset, __self__).__init__(
            'cloudflare:index/zeroTrustDlpDataset:ZeroTrustDlpDataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            case_sensitive: Optional[pulumi.Input[_builtins.bool]] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpDatasetColumnArgs', 'ZeroTrustDlpDatasetColumnArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            dataset: Optional[pulumi.Input[Union['ZeroTrustDlpDatasetDatasetArgs', 'ZeroTrustDlpDatasetDatasetArgsDict']]] = None,
            dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encoding_version: Optional[pulumi.Input[_builtins.int]] = None,
            max_cells: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            num_cells: Optional[pulumi.Input[_builtins.int]] = None,
            secret: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            uploads: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpDatasetUploadArgs', 'ZeroTrustDlpDatasetUploadArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'ZeroTrustDlpDataset':
        """
        Get an existing ZeroTrustDlpDataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] case_sensitive: Only applies to custom word lists.
               Determines if the words should be matched in a case-sensitive manner
               Cannot be set to false if `secret` is true or undefined
        :param pulumi.Input[_builtins.str] description: The description of the dataset.
        :param pulumi.Input[_builtins.int] encoding_version: Dataset encoding version
        :param pulumi.Input[_builtins.bool] secret: Generate a secret dataset.
               
               If true, the response will include a secret to use with the EDM encoder.
               If false, the response has no secret and the dataset is uploaded in plaintext.
        :param pulumi.Input[_builtins.str] status: Available values: "empty", "uploading", "pending", "processing", "failed", "complete".
        :param pulumi.Input[_builtins.str] updated_at: When the dataset was last updated.
               
               This includes name or description changes as well as uploads.
        :param pulumi.Input[_builtins.int] version: The version to use when uploading the dataset.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDlpDatasetState.__new__(_ZeroTrustDlpDatasetState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["case_sensitive"] = case_sensitive
        __props__.__dict__["columns"] = columns
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["description"] = description
        __props__.__dict__["encoding_version"] = encoding_version
        __props__.__dict__["max_cells"] = max_cells
        __props__.__dict__["name"] = name
        __props__.__dict__["num_cells"] = num_cells
        __props__.__dict__["secret"] = secret
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["uploads"] = uploads
        __props__.__dict__["version"] = version
        return ZeroTrustDlpDataset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Only applies to custom word lists.
        Determines if the words should be matched in a case-sensitive manner
        Cannot be set to false if `secret` is true or undefined
        """
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Sequence['outputs.ZeroTrustDlpDatasetColumn']]:
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Output['outputs.ZeroTrustDlpDatasetDataset']:
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the dataset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encodingVersion")
    def encoding_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Dataset encoding version
        """
        return pulumi.get(self, "encoding_version")

    @_builtins.property
    @pulumi.getter(name="maxCells")
    def max_cells(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "max_cells")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numCells")
    def num_cells(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "num_cells")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Generate a secret dataset.

        If true, the response will include a secret to use with the EDM encoder.
        If false, the response has no secret and the dataset is uploaded in plaintext.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Available values: "empty", "uploading", "pending", "processing", "failed", "complete".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the dataset was last updated.

        This includes name or description changes as well as uploads.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def uploads(self) -> pulumi.Output[Sequence['outputs.ZeroTrustDlpDatasetUpload']]:
        return pulumi.get(self, "uploads")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version to use when uploading the dataset.
        """
        return pulumi.get(self, "version")

