import { Construct } from 'constructs';
import { Dashboard, DashboardProps } from './dashboard';
import { DataSource, DataSourceProps } from './datasource';
export interface GrafanaProps {
    /**
     * Specify a custom image for Grafana.
     * @default "public.ecr.aws/ubuntu/grafana:latest"
     */
    readonly image?: string;
    /**
     * Create an ingress to provide external access to the Grafana cluster.
     * @default true
     */
    readonly ingress?: boolean;
    /**
     * Type of service to be created (NodePort, ClusterIP or LoadBalancer)
     * @default ClusterIP
     */
    readonly serviceType?: string;
    /**
     * Default admin username.
     * @default "root"
     */
    readonly adminUser?: string;
    /**
     * Default admin password.
     * @default "secret"
     */
    readonly adminPassword?: string;
    /**
     * Require login in order to view or manage dashboards.
     * @default false
     */
    readonly requireLogin?: boolean;
    /**
     * Default data source - equivalent to calling `grafana.addDataSource`.
     * @default - no data source added
     */
    readonly defaultDataSource?: DataSourceProps;
    /**
     * Labels to apply to all Grafana resources.
     * @default - { app: "grafana" }
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Namespace to apply to all Grafana resources. The Grafana Operator must be
     * installed in this namespace for resources to be recognized.
     *
     * @default - undefined (will be assigned to the 'default' namespace)
     */
    readonly namespace?: string;
}
/**
 * A Grafana instance.
 */
export declare class Grafana extends Construct {
    private readonly dataSources;
    private readonly dashboards;
    private readonly namespace;
    private readonly labels;
    constructor(scope: Construct, id: string, props?: GrafanaProps);
    /**
     * Adds a data source. By default, labels are automatically added so that
     * the data source is detected by Grafana.
     */
    addDataSource(id: string, props: DataSourceProps): DataSource;
    /**
     * Creates a dashboard associated with a particular data source. By default,
     * labels are automatically added so that the data source is detected by
     * Grafana.
     */
    addDashboard(id: string, props: DashboardProps): Dashboard;
}
