# spotdesirability

* `Python` implementation of the `R` package `desirability`, which provides  S3 classes for multivariate optimization using the desirability function by Derringer and Suich (1980).

# Installation

* Installation can be done with `pip`: 

```{bash}
pip install spotdesirability
```

* Alternatively, you can clone the repository and install it manually.


# Citation

```bibtex
@misc{bartz25a,
      title={Multi-Objective Optimization and Hyperparameter Tuning With Desirability Functions}, 
      author={Thomas Bartz-Beielstein},
      year={2025},
      eprint={2503.23595},
      archivePrefix={arXiv},
      primaryClass={math.OC},
      url={https://arxiv.org/abs/2503.23595}, 
}
```

# Documentation

* The documentation is available at: [https://sequential-parameter-optimization.github.io/spotdesirability/](https://sequential-parameter-optimization.github.io/spotdesirability/)


# References

## Desirability functions

* Derringer, G., and Suich, R. Simultaneous optimization of several response variables. Journal of Quality Technology 12 (1980), 214–219.

## The `R` `desirability` package

* The `R` `desirability` package is maintained and developed by Max Kuhn. It is is available on CRAN:  https://CRAN.R-project.org/package=desirability,  DOI: https://doi.org/10.32614/CRAN.package.desirability
