"""The top-level functions and classes for working with Weave."""

from weave import version
from weave.trace.api import *

__version__ = version.VERSION

from weave.integrations.wandb import wandb_init_hook

wandb_init_hook()

from weave.agent.agent import Agent as Agent
from weave.agent.agent import AgentState as AgentState
from weave.dataset.dataset import Dataset
from weave.evaluation.eval import Evaluation
from weave.evaluation.eval_imperative import EvaluationLogger
from weave.flow.annotation_spec import AnnotationSpec
from weave.flow.model import Model
from weave.flow.monitor import Monitor
from weave.flow.saved_view import SavedView
from weave.flow.scorer import Scorer
from weave.initialization import *
from weave.object.obj import Object
from weave.prompt.prompt import EasyPrompt, MessagesPrompt, Prompt, StringPrompt
from weave.trace.log_call import log_call
from weave.trace.util import Thread as Thread
from weave.trace.util import ThreadPoolExecutor as ThreadPoolExecutor
from weave.type_handlers.Audio.audio import Audio
from weave.type_handlers.File.file import File
from weave.type_handlers.Markdown.markdown import Markdown
from weave.type_wrappers import Content

# Alias for succinct code
P = EasyPrompt

# Special object informing doc generation tooling which symbols
# to document & to associate with this module.
__docspec__ = [
    # Re-exported from trace.api
    init,
    publish,
    ref,
    get,
    require_current_call,
    get_current_call,
    finish,
    op,
    attributes,
    thread,
    # Re-exported from flow module
    Object,
    Dataset,
    Model,
    Prompt,
    StringPrompt,
    MessagesPrompt,
    Evaluation,
    EvaluationLogger,
    Scorer,
    AnnotationSpec,
    File,
    Content,
    Markdown,
    Monitor,
    SavedView,
    Audio,
    log_call,
]

__all__ = [
    "Agent",
    "AgentState",
    "AnnotationSpec",
    "Audio",
    "Content",
    "Dataset",
    "EasyPrompt",
    "Evaluation",
    "EvaluationLogger",
    "File",
    "Markdown",
    "MessagesPrompt",
    "Model",
    "Monitor",
    "Object",
    "Prompt",
    "SavedView",
    "Scorer",
    "StringPrompt",
    "attributes",
    "finish",
    "get",
    "get_current_call",
    "init",
    "log_call",
    "op",
    "publish",
    "ref",
    "require_current_call",
    "set_view",
    "thread",
]
