/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum MediaType {
    TEXT("text/plain", "Plain text", Arrays.asList("txt")),
    LOG("text/plain", "Log file", Arrays.asList("log")),
    OUT("text/plain", "Output file", Arrays.asList("out")),
    CSV("text/csv", "Comma-separated values", Arrays.asList("csv")),
    JSON("application/json", "JSON", Arrays.asList("json", "jsn")),
    RDBMS("application/x-sql", "Relational database", Arrays.asList("sql"));

    private final String mimeType;
    private final String description;
    private final List<String> extensions;

    private MediaType(String mime, String desc, List<String> ext) {
        this.mimeType = mime;
        this.description = desc;
        this.extensions = Collections.unmodifiableList(ext);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrimaryExtension() {
        return this.extensions.get(0);
    }

    public List<String> getAllExtensions() {
        return this.extensions;
    }
}

