/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.chem;

import com.cmayes.common.exception.ExceptionUtils;

public enum InternalMotionType {
    BOND_STRETCHING("R"),
    ANGLE_BENDING("A"),
    DIHEDRAL_ROTATION("D");

    private final String symbol;

    private InternalMotionType(String sym) {
        this.symbol = ExceptionUtils.asNotNull(sym, "Symbol is null", new Object[0]);
    }

    public static InternalMotionType valueOfSymbol(String sym) {
        for (InternalMotionType val : InternalMotionType.values()) {
            if (!val.getSymbol().equals(sym)) continue;
            return val;
        }
        throw new IllegalArgumentException("No motion type for symbol " + sym);
    }

    public String getSymbol() {
        return this.symbol;
    }
}

