/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.exception;

import com.cmayes.common.exception.InvalidDataException;
import java.util.Collection;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void checkNull(Object obj, String errMess, Object ... fmtArgs) {
        if (obj == null) {
            throw new InvalidDataException(String.format(errMess, fmtArgs), new Object[0]);
        }
    }

    public static void checkNullArg(Object obj, String errMess, Object ... fmtArgs) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format(errMess, fmtArgs));
        }
    }

    public static <T> T asNotNull(T input, String message, Object ... fmtArgs) {
        if (null == input) {
            throw new IllegalArgumentException(String.format(message, fmtArgs));
        }
        return input;
    }

    public static String asString(Object input, String message, Object ... fmtArgs) {
        if (null == input) {
            throw new IllegalArgumentException(String.format(message, fmtArgs));
        }
        return input.toString();
    }

    public static String asNotBlank(String input, String message, Object ... fmtArgs) {
        if (null == input || input.length() == 0) {
            throw new IllegalArgumentException(String.format(message, fmtArgs));
        }
        return input;
    }

    public static int asPositive(int input, String message, Object ... fmtArgs) {
        if (input <= 0) {
            throw new IllegalArgumentException(String.format(message, fmtArgs));
        }
        return input;
    }

    public static long asPositive(long input, String message, Object ... fmtArgs) {
        if (input <= 0L) {
            throw new IllegalArgumentException(String.format(message, fmtArgs));
        }
        return input;
    }

    public static int asPositive(int input) {
        return ExceptionUtils.asPositive(input, "Value '%d' is not positive", new Object[]{input});
    }

    public static long asPositive(long input) {
        return ExceptionUtils.asPositive(input, "Value '%d' is not positive", input);
    }

    public static <E> Collection<E> asNotNullCollection(Collection<E> collection, String errMess, Object ... fmtArgs) {
        ExceptionUtils.checkNullArg(collection, errMess, fmtArgs);
        for (E element : collection) {
            ExceptionUtils.checkNullArg(element, errMess, fmtArgs);
        }
        return collection;
    }
}

