/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.util;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.exception.NotFoundException;
import com.cmayes.common.exception.TooManyException;
import com.cmayes.common.model.Atom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;

public final class ChemUtils {
    public static final double BOND_LEN = 1.8;

    private ChemUtils() {
    }

    public static Vector3D vectorForAtom(Atom atom) {
        return new Vector3D(atom.getX(), atom.getY(), atom.getZ());
    }

    public static boolean hasBond(Atom first, Atom second) {
        return ChemUtils.findDistance(first, second) <= 1.8;
    }

    public static Vector3D phiThetaToVector(double phi, double theta) {
        double phiRad = Math.toRadians(phi);
        double thetaRad = Math.toRadians(theta);
        double x = Math.cos(phiRad) * Math.sin(thetaRad);
        double y = Math.sin(phiRad) * Math.sin(thetaRad);
        double z = Math.cos(thetaRad);
        return new Vector3D(x, y, z);
    }

    public static Double findBond(Atom curCarb, List<Atom> otherAtoms, AtomicElement elemType) {
        return ChemUtils.findDistance(curCarb, ChemUtils.findSingleBondAtom(curCarb, otherAtoms, elemType));
    }

    public static Atom findSingleBondAtom(Atom tgtAtom, List<Atom> otherAtoms, AtomicElement elemType) {
        List<Atom> foundAtoms = ChemUtils.findBondAtoms(tgtAtom, otherAtoms, elemType);
        switch (foundAtoms.size()) {
            case 0: {
                throw new NotFoundException(String.format("No %s found for atom %s", elemType.name().toLowerCase(), tgtAtom), new Object[0]);
            }
            case 1: {
                return foundAtoms.get(0);
            }
        }
        throw new TooManyException("Found %d %s bonded atoms where one was expected for atom %s", new Object[]{foundAtoms.size(), elemType, tgtAtom});
    }

    public static List<Atom> findBondAtoms(Atom tgtAtom, List<Atom> otherAtoms, AtomicElement elemType) {
        ArrayList<Atom> founds = new ArrayList<Atom>();
        for (Atom atom : otherAtoms) {
            if (!ChemUtils.hasBond(tgtAtom, atom) || !elemType.equals((Object)atom.getType())) continue;
            founds.add(atom);
        }
        return founds;
    }

    public static Double findDistance(Atom first, Atom second) {
        return ChemUtils.vectorForAtom(first).distance(ChemUtils.vectorForAtom(second));
    }

    public static Atom findSingle(AtomicElement elemType, List<Atom> atoms) {
        List<Atom> allAtoms = ChemUtils.findAllForType(elemType, atoms);
        if (allAtoms.isEmpty()) {
            throw new NotFoundException("No atoms of type %s found", elemType.name());
        }
        if (allAtoms.size() > 1) {
            throw new TooManyException("%d atoms of type %s found where 1 was expected", allAtoms.size(), elemType.name());
        }
        return allAtoms.get(0);
    }

    public static List<Atom> findAllForType(AtomicElement elemType, List<Atom> atoms) {
        ArrayList<Atom> foundList = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            if (!elemType.equals((Object)atom.getType())) continue;
            foundList.add(atom);
        }
        return foundList;
    }

    public static double calcDihedralAngle(Atom atom1, Atom atom2, Atom atom3, Atom atom4) {
        Vector3D atomVec1 = ChemUtils.vectorForAtom(atom1);
        Vector3D atomVec2 = ChemUtils.vectorForAtom(atom2);
        Vector3D atomVec3 = ChemUtils.vectorForAtom(atom3);
        Vector3D atomVec4 = ChemUtils.vectorForAtom(atom4);
        Vector vec2ToVec1 = atomVec1.subtract((Vector)atomVec2);
        Vector vec2ToVec3 = atomVec3.subtract((Vector)atomVec2);
        Vector3D normVec1 = ((Vector3D)vec2ToVec1).crossProduct(vec2ToVec3);
        Vector vec3ToVec2 = atomVec2.subtract((Vector)atomVec3);
        Vector vec3ToVec4 = atomVec4.subtract((Vector)atomVec3);
        Vector3D normVec2 = ((Vector3D)vec3ToVec2).crossProduct(vec3ToVec4);
        double dhAngle = FastMath.toDegrees(Vector3D.angle(normVec1, normVec2));
        return normVec1.dotProduct(atomVec4) < 0.0 ? -dhAngle : dhAngle;
    }
}

