/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.util;

import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.exception.ExceptionUtils;
import com.cmayes.common.exception.NotFoundException;
import com.cmayes.common.exception.TooManyException;
import com.cmayes.common.util.BeanMap;
import com.cmayes.common.util.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CollectionUtils2 {
    private static final Log LOGGER = LogFactory.getLog(CollectionUtils2.class);

    private CollectionUtils2() {
    }

    public static <T> Collection<T> convertCollection(Class<T> tgtType, Collection<?> origTypes) throws IllegalArgumentException {
        ArrayList<T> convList = new ArrayList<T>();
        for (Object origObject : origTypes) {
            try {
                convList.add(TypeUtils.runtimeConvertType(tgtType, origObject));
            }
            catch (EnvironmentException e) {
                Throwable cause = e.getCause();
                Throwable wrapMe = cause == null ? e : cause;
                throw new IllegalArgumentException("Problems converting value %s", wrapMe);
            }
        }
        return convList;
    }

    public static <T> List<T> createList(T ... elements) {
        if (elements == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(elements));
    }

    public static <T> T getSingle(Collection<T> collection) {
        if (ExceptionUtils.asNotNull(collection, "Null collection", new Object[0]).isEmpty()) {
            throw new NotFoundException("No elements in collection", new Object[0]);
        }
        if (collection.size() > 1) {
            throw new TooManyException("Expected one element, got " + collection.size(), new Object[0]);
        }
        if (collection instanceof List) {
            return (T)((List)collection).get(0);
        }
        return collection.iterator().next();
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (ExceptionUtils.asNotNull(collection, "Null collection", new Object[0]).size() < 1) {
            throw new NotFoundException("Empty collection", new Object[0]);
        }
        if (collection instanceof List) {
            return (T)((List)collection).get(0);
        }
        return collection.iterator().next();
    }

    public static <T> Set<T> createSet(T ... elements) {
        HashSet<T> coll = new HashSet<T>();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                coll.add(elements[i]);
            }
        }
        return coll;
    }

    public static <K, V> Collection<V> initCollectionValue(Map<K, Collection<V>> collectionMap, K key) {
        Collection<V> collection = collectionMap.get(key);
        if (collection == null) {
            collection = new ArrayList<V>();
            collectionMap.put(key, collection);
        }
        return collection;
    }

    public static <K, V> V initObjectValue(Map<K, V> objMap, K key, Class<V> valClass) {
        V val = objMap.get(key);
        if (val == null) {
            try {
                val = valClass.newInstance();
                objMap.put(key, val);
            }
            catch (InstantiationException e) {
                throw new EnvironmentException("Instantiation exception for class " + valClass, (Throwable)e, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new EnvironmentException("Illegal access exception for class " + valClass, (Throwable)e, new Object[0]);
            }
        }
        return val;
    }

    public static <I, K, V> Map<K, V> initMapValue(Map<I, Map<K, V>> mapMap, I idxKey) {
        Map<K, V> indexedMap = mapMap.get(idxKey);
        if (indexedMap == null) {
            indexedMap = new HashMap();
            mapMap.put(idxKey, indexedMap);
        }
        return indexedMap;
    }

    public static <K, V> Set<V> initSetValue(Map<K, Set<V>> setMap, K key) {
        Set<V> set = setMap.get(key);
        if (set == null) {
            set = new HashSet<V>();
            setMap.put(key, set);
        }
        return set;
    }

    public static <K, V> List<V> initListValue(Map<K, List<V>> listMap, K key) {
        List<V> list = listMap.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            listMap.put(key, list);
        }
        return list;
    }

    public static <T> Collection<T> collectBeanValues(Collection<?> sources, String fieldName, Class<T> fieldReturnType) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (sources == null) {
            return values;
        }
        for (Object object : sources) {
            BeanMap bean = new BeanMap(object);
            values.add(bean.get(fieldName));
        }
        return values;
    }

    public static <T> Collection<T> removeByBeanValue(Collection<T> sources, String fieldName, Object value) {
        ArrayList<T> retainedValues = new ArrayList<T>();
        for (T candidate : sources) {
            BeanMap<T> bean = new BeanMap<T>(candidate);
            if (bean.get(fieldName) == null) {
                retainedValues.add(candidate);
                continue;
            }
            if (bean.get(fieldName).equals(value)) continue;
            retainedValues.add(candidate);
        }
        return retainedValues;
    }

    public static <T> Collection<T> retainByBeanValue(Collection<T> sources, String fieldName, Object value) {
        ArrayList<T> retainedValues = new ArrayList<T>();
        for (T candidate : sources) {
            BeanMap<T> bean = new BeanMap<T>(candidate);
            if (bean.get(fieldName) == null || !bean.get(fieldName).equals(value)) continue;
            retainedValues.add(candidate);
        }
        return retainedValues;
    }

    public static <T> Collection<T> removeByBeanValueInCollection(Collection<T> sources, String fieldName, Collection<?> values) {
        ArrayList<T> retainedValues = new ArrayList<T>();
        for (T candidate : sources) {
            BeanMap<T> bean = new BeanMap<T>(candidate);
            Object beanVal = bean.get(fieldName);
            LOGGER.debug("Bean val: " + beanVal);
            LOGGER.debug("values: " + values);
            if (values.contains(beanVal)) continue;
            LOGGER.debug("Adding: " + beanVal);
            retainedValues.add(candidate);
        }
        return retainedValues;
    }

    public static <T> Collection<T> retainByBeanValueInCollection(Collection<T> sources, String fieldName, Collection<?> values) {
        ArrayList<T> retainedValues = new ArrayList<T>();
        for (T candidate : sources) {
            BeanMap<T> bean = new BeanMap<T>(candidate);
            Object beanVal = bean.get(fieldName);
            if (!values.contains(beanVal)) continue;
            retainedValues.add(candidate);
        }
        return retainedValues;
    }

    public static <K, V> Map<K, V> mapByUniqueValue(Collection<V> sources, String fieldName, Class<K> fieldReturnType) {
        return CollectionUtils2.mapByUniqueValue(sources, fieldName, fieldReturnType, false);
    }

    public static <K, V> Map<K, V> mapByUniqueValue(Collection<V> sources, String fieldName, Class<K> fieldReturnType, boolean allowDupes) {
        HashMap<Object, V> valMap = new HashMap<Object, V>();
        for (V curBean : sources) {
            BeanMap<V> beanMap = new BeanMap<V>(curBean);
            V result = valMap.put(beanMap.get(fieldName), curBean);
            if (result == null || allowDupes) continue;
            throw new IllegalArgumentException("Duplicate value for field " + fieldName + ", value " + beanMap.get(fieldName));
        }
        return valMap;
    }

    public static <K, V> Map<K, List<V>> mapByValue(Collection<V> sources, String fieldName, Class<K> fieldReturnType) {
        HashMap valMap = new HashMap();
        for (V curBean : sources) {
            BeanMap<V> beanMap = new BeanMap<V>(curBean);
            Object fieldVal = beanMap.get(fieldName);
            List<V> valList = CollectionUtils2.initListValue(valMap, fieldVal);
            valList.add(curBean);
        }
        return valMap;
    }

    public static List<String> extractEnumNames(Enum<?>[] extractMe) {
        ArrayList<String> names = new ArrayList<String>();
        for (Enum<?> enum1 : extractMe) {
            names.add(enum1.name().toLowerCase());
        }
        return names;
    }
}

