/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import au.com.bytecode.opencsv.CSVReader;
import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.exception.ExceptionUtils;
import com.cmayes.common.exception.InvalidDataException;
import com.cmayes.common.util.ChemUtils;
import com.cmayes.common.util.EnvUtils;
import com.cmayes.common.util.FormatUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.cmayes.hartree.model.def.CremerPopleCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianCremerPoplePuckeringCalculation
implements Calculation {
    private static final String CP_CODES_CSV_FNAME = "CartCPcodes.csv";
    private static final String NULL_ERR_FMT = "Null value for %s in CartCPcodes.csv";
    private static final String CODE_FIELD = "code";
    private static final String Z_FIELD = "z";
    private static final String Y_FIELD = "y";
    private static final String X_FIELD = "x";
    private static final String CODE_NULL_ERR = String.format("Null value for %s in CartCPcodes.csv", "code");
    private static final String X_NULL_ERR = String.format("Null value for %s in CartCPcodes.csv", "x");
    private static final String Y_NULL_ERR = String.format("Null value for %s in CartCPcodes.csv", "y");
    private static final String Z_NULL_ERR = String.format("Null value for %s in CartCPcodes.csv", "z");
    private static final double TO_ZERO_VAL = 360.0;
    private static final double TOLERANCE = 8.0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Vector3D, String> cartConfs = this.createCartesianTable();

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof CpCalculationSnapshot) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((CpCalculationSnapshot)rawInput);
            CremerPopleCoordinates cpCoords = cpSnap.getCpCoords();
            if (cpCoords == null) {
                this.logger.warn(String.format("No CP coordinates for CP Pucker calc: '%s'", rawInput));
                return cpSnap;
            }
            cpCoords.setPucker(this.findPuckerCode(cpCoords));
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    public Map<Vector3D, String> createCartesianTable() {
        HashMap<Vector3D, String> vectorTable = Maps.newHashMap();
        CSVReader reader = null;
        try {
            Object[] line;
            reader = new CSVReader(ExceptionUtils.asNotNull(EnvUtils.getResourceReader(CP_CODES_CSV_FNAME), String.format("Couldn't read CP codes file '%s'", CP_CODES_CSV_FNAME), new Object[0]));
            String[] headerRow = reader.readNext();
            if (headerRow == null) {
                throw new InvalidDataException("No header row in file CartCPcodes.csv", new Object[0]);
            }
            int xIdx = FormatUtils.findIdx(headerRow, X_FIELD);
            int yIdx = FormatUtils.findIdx(headerRow, Y_FIELD);
            int zIdx = FormatUtils.findIdx(headerRow, Z_FIELD);
            int codeIdx = FormatUtils.findIdx(headerRow, CODE_FIELD);
            while (null != (line = reader.readNext())) {
                String curZ;
                String curY;
                String curX;
                String curCode;
                try {
                    curCode = ExceptionUtils.asNotNull(line[codeIdx], CODE_NULL_ERR, new Object[0]);
                    curX = (String)ExceptionUtils.asNotNull(line[xIdx], X_NULL_ERR, new Object[0]);
                    curY = (String)ExceptionUtils.asNotNull(line[yIdx], Y_NULL_ERR, new Object[0]);
                    curZ = (String)ExceptionUtils.asNotNull(line[zIdx], Z_NULL_ERR, new Object[0]);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new InvalidDataException(String.format("The report line for %s in %s is too short (%d elements)", Arrays.toString(line), CP_CODES_CSV_FNAME, line.length), (Throwable)e, new Object[0]);
                }
                String fmtString = "%s on confirmation " + curCode;
                vectorTable.put(new Vector3D(FormatUtils.toDouble(curX, String.format(fmtString, X_FIELD)), FormatUtils.toDouble(curY, String.format(fmtString, Y_FIELD)), FormatUtils.toDouble(curZ, String.format(fmtString, Z_FIELD))), curCode);
            }
        }
        catch (IOException e) {
            throw new EnvironmentException("Problems reading CartCPcodes.csv", (Throwable)e, new Object[0]);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new EnvironmentException("Problems reading CartCPcodes.csv", (Throwable)e, new Object[0]);
            }
        }
        return vectorTable;
    }

    private String findPuckerCode(CremerPopleCoordinates cpCoords) {
        double cpTheta = cpCoords.getTheta();
        if (this.diffMatches(360.0, cpTheta)) {
            cpTheta = 0.0;
        }
        Vector3D tgtCoords = ChemUtils.phiThetaToVector(cpCoords.getPhi(), cpTheta);
        double minAngle = -1.0;
        Vector3D minVec = null;
        for (Vector3D curConf : this.cartConfs.keySet()) {
            double dotProduct = tgtCoords.dotProduct(curConf);
            if (dotProduct > Math.PI && dotProduct - Math.PI < 0.001) {
                dotProduct = Math.PI;
            }
            double calcAngle = Math.acos(dotProduct);
            if (minVec != null && !(calcAngle < minAngle)) continue;
            minAngle = calcAngle;
            minVec = curConf;
        }
        return ExceptionUtils.asNotNull(this.cartConfs.get(ExceptionUtils.asNotNull(minVec, "No vector found for " + cpCoords, new Object[0])), "No confirmation maps to " + minVec, new Object[0]);
    }

    private boolean diffMatches(double val1, double val2) {
        double abs = Math.abs(val1 - val2);
        return abs <= 8.0;
    }
}

