/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import com.cmayes.common.model.Atom;
import com.cmayes.common.util.ChemUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.GlucoseRingResult;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.cmayes.hartree.model.def.CremerPopleCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CremerPopleCalculation
implements Calculation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof CpCalculationSnapshot) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((CpCalculationSnapshot)rawInput);
            List<Atom> gRing = ((GlucoseRingResult)rawInput).getGlucoseRing();
            if (gRing == null) {
                this.logger.warn(String.format("No glucose ring for CP calculation: '%s'", rawInput));
                return cpSnap;
            }
            cpSnap.setCpCoords(this.findCoords(gRing));
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    private CremerPopleCoordinates findCoords(List<Atom> gRing) {
        ArrayList<Vector3D> ringVecs = new ArrayList<Vector3D>();
        for (Atom atom : gRing) {
            ringVecs.add(ChemUtils.vectorForAtom(atom));
        }
        List<Vector3D> cenVecs = this.center(ringVecs);
        Vector3D r1a = null;
        Vector3D r2a = null;
        int i = 0;
        for (Vector3D cenVec : cenVecs) {
            Vector3D sinVec = new Vector3D(Math.sin(Math.PI * 2 * (double)i / 6.0), cenVec);
            r1a = r1a == null ? sinVec : r1a.add((Vector)sinVec);
            Vector3D cosVec = new Vector3D(Math.cos(Math.PI * 2 * (double)i / 6.0), cenVec);
            r2a = r2a == null ? cosVec : r2a.add((Vector)cosVec);
            ++i;
        }
        Vector3D n = r1a.crossProduct(r2a);
        n = new Vector3D(1.0 / n.getNorm(), n);
        ArrayList<Double> z = new ArrayList<Double>();
        for (Vector3D cenVec : cenVecs) {
            z.add(Vector3D.dotProduct(cenVec, n));
        }
        double q2cosphi = 0.0;
        double q2sinphi = 0.0;
        double q3 = 0.0;
        double bigQ = 0.0;
        double sqrt2 = Math.sqrt(2.0);
        double invSqrt6 = Math.sqrt(0.16666666666666666);
        int j = 0;
        for (Double zVal : z) {
            q2cosphi += zVal * Math.cos(Math.PI * 4 * (double)j / 6.0);
            q2sinphi -= zVal * Math.sin(Math.PI * 4 * (double)j / 6.0);
            q3 += zVal * Math.cos((double)j * Math.PI);
            bigQ += zVal * zVal;
            ++j;
        }
        q2cosphi = sqrt2 * invSqrt6 * q2cosphi;
        q2sinphi = sqrt2 * invSqrt6 * q2sinphi;
        q3 = invSqrt6 * q3;
        double q2 = Math.sqrt(q2cosphi * q2cosphi + q2sinphi * q2sinphi);
        bigQ = Math.sqrt(bigQ);
        double phi = q2cosphi > 0.0 ? (q2sinphi > 0.0 ? Math.toDegrees(Math.atan(q2sinphi / q2cosphi)) : 360.0 - Math.abs(Math.toDegrees(Math.atan(q2sinphi / q2cosphi)))) : (q2sinphi > 0.0 ? 180.0 - Math.abs(Math.toDegrees(Math.atan(q2sinphi / q2cosphi))) : 180.0 + Math.abs(Math.toDegrees(Math.atan(q2sinphi / q2cosphi))));
        double theta = Math.toDegrees(Math.atan(q2 / q3));
        theta = q3 > 0.0 ? (q2 > 0.0 ? Math.toDegrees(Math.atan(q2 / q3)) : 360.0 - Math.abs(Math.toDegrees(Math.atan(q2 / q3)))) : (q2 > 0.0 ? 180.0 - Math.abs(Math.toDegrees(Math.atan(q2 / q3))) : 180.0 + Math.abs(Math.toDegrees(Math.atan(q2 / q3))));
        return new CremerPopleCoordinates(phi, theta, bigQ);
    }

    private List<Vector3D> center(List<Vector3D> ringVecs) {
        Vector<Euclidean3D> center = new Vector3D(0.0, 0.0, 0.0);
        for (Vector3D ringVec : ringVecs) {
            center = ((Vector3D)center).add((Vector)ringVec);
        }
        int rSize = ringVecs.size();
        center = new Vector3D(((Vector3D)center).getX() / (double)rSize, ((Vector3D)center).getY() / (double)rSize, ((Vector3D)center).getZ() / (double)rSize);
        ArrayList<Vector3D> centeredVecs = new ArrayList<Vector3D>();
        for (Vector3D ringVec : ringVecs) {
            centeredVecs.add((Vector3D)ringVec.subtract((Vector)center));
        }
        return centeredVecs;
    }
}

