/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.model.Atom;
import com.cmayes.common.util.ChemUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.BaseResult;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlucoseRingCalculation
implements Calculation {
    private static final int DEF_RING_SIZE = 6;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int ringSize = 6;

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof BaseResult) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((BaseResult)rawInput);
            List<Atom> atoms = ((BaseResult)rawInput).getAtoms();
            if (atoms == null) {
                this.logger.warn(String.format("No atoms for glucose ring calculation: '%s'", rawInput));
                return cpSnap;
            }
            cpSnap.setGlucoseRing(this.findGlucoseRing(atoms));
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    private List<Atom> findGlucoseRing(List<Atom> atoms) {
        ArrayList<Atom> oxys = new ArrayList<Atom>();
        ArrayList<Atom> carbs = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            if (AtomicElement.CARBON.equals((Object)atom.getType())) {
                carbs.add(atom);
                continue;
            }
            if (!AtomicElement.OXYGEN.equals((Object)atom.getType())) continue;
            oxys.add(atom);
        }
        for (Atom oxy : oxys) {
            if (!this.hasTwoCarbs(oxy, carbs)) continue;
            ArrayList<Atom> ring = new ArrayList<Atom>();
            ring.add(oxy);
            ArrayList<Atom> carbonCopy = new ArrayList<Atom>(carbs);
            boolean isFound = true;
            while (isFound && ring.size() < this.ringSize) {
                isFound = this.findNextCarbon(carbonCopy, ring);
            }
            if (ring.size() != this.ringSize) {
                this.logger.debug(String.format("Ring size '%d' instead of '%d'. Rejecting.", ring.size(), this.ringSize));
                continue;
            }
            if (!ChemUtils.hasBond((Atom)ring.get(ring.size() - 1), oxy)) {
                this.logger.debug("Last carbon is not bonded to oxygen.  Rejecting.");
                continue;
            }
            return ring;
        }
        this.logger.warn(String.format("No glucose ring of size '%d' found.", this.ringSize));
        return null;
    }

    private boolean hasTwoCarbs(Atom oxy, List<Atom> carbs) {
        int carbCount = 0;
        for (Atom carb : carbs) {
            if (!ChemUtils.hasBond(oxy, carb)) continue;
            ++carbCount;
        }
        return carbCount == 2;
    }

    private boolean findNextCarbon(List<Atom> carbonCopy, List<Atom> ring) {
        Iterator<Atom> iterator = carbonCopy.iterator();
        while (iterator.hasNext()) {
            Atom curCarb = iterator.next();
            if (!ChemUtils.hasBond(ring.get(ring.size() - 1), curCarb)) continue;
            ring.add(curCarb);
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getRingSize() {
        return this.ringSize;
    }

    public void setRingSize(int size) {
        this.ringSize = size;
    }
}

