/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.exception.NotFoundException;
import com.cmayes.common.model.Atom;
import com.cmayes.common.util.ChemUtils;
import java.util.ArrayList;
import java.util.List;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMDihedralAngleCalculation
implements Calculation {
    private static final int C4_LOC = 4;
    private static final int C5_LOC = 5;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof CpCalculationSnapshot) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((CpCalculationSnapshot)rawInput);
            if (cpSnap.getGlucoseRing() == null) {
                this.logger.warn("No glucose ring for HM arm calc {}, skipping.", (Object)cpSnap.getSourceName());
                return cpSnap;
            }
            try {
                this.fillHMDihedralAngles(cpSnap);
            }
            catch (NotFoundException e) {
                this.logger.warn("Missing atoms for HM arm calc {}, skipping.", (Object)cpSnap.getSourceName(), (Object)e);
            }
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    private void fillHMDihedralAngles(CpCalculationSnapshot cpSnap) {
        List<Atom> glucoseRing = cpSnap.getGlucoseRing();
        ArrayList<Atom> otherAtoms = new ArrayList<Atom>(cpSnap.getAtoms());
        otherAtoms.removeAll(glucoseRing);
        Atom hmArmCarbon = ChemUtils.findSingleBondAtom(glucoseRing.get(5), otherAtoms, AtomicElement.CARBON);
        Atom hmArmOxy = ChemUtils.findSingleBondAtom(hmArmCarbon, otherAtoms, AtomicElement.OXYGEN);
        cpSnap.setHmArmAngle1(ChemUtils.calcDihedralAngle(glucoseRing.get(0), glucoseRing.get(5), hmArmCarbon, hmArmOxy));
        cpSnap.setHmArmAngle2(ChemUtils.calcDihedralAngle(glucoseRing.get(4), glucoseRing.get(5), hmArmCarbon, hmArmOxy));
    }
}

