/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.disp.txt;

import com.cmayes.common.CommonConstants;
import com.cmayes.common.MediaType;
import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.model.Atom;
import com.cmayes.common.util.EnvUtils;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.cmayes.hartree.disp.Display;
import org.cmayes.hartree.model.LowestEnergyMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowestEnergyTemplateDisplay
implements Display<LowestEnergyMapper> {
    public static final String DEF_LOWTPL = "lowtpl";
    private static final MediaType TYPE = MediaType.TEXT;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean writeMulti = false;
    private volatile String tplName = "lowtpl";

    @Override
    public void finish(Writer writer) {
    }

    @Override
    public void write(Writer writer, LowestEnergyMapper valToDisp) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        try {
            valueMap.put("atoms", this.formatAtoms(valToDisp.getLowestEnergy()));
            writer.write(StrSubstitutor.replace((Object)EnvUtils.getStringFromReader(new FileReader(this.tplName), true), valueMap));
        }
        catch (FileNotFoundException e) {
            String errMsg = "Couldn't find file " + this.tplName;
            this.logger.error(errMsg, e);
            throw new EnvironmentException(errMsg, new Object[0]);
        }
        catch (IOException e) {
            String errMsg = "problems writing template from def in file " + this.tplName;
            this.logger.error(errMsg, e);
            throw new EnvironmentException(errMsg, new Object[0]);
        }
        catch (IllegalStateException e) {
            String errMsg = "No atoms found";
            this.logger.error("No atoms found", e);
        }
    }

    String formatAtoms(List<Atom> atoms) {
        StringBuilder sb = new StringBuilder();
        for (Atom atom : atoms) {
            sb.append(String.format("%s   % f   % f   % f%s", atom.getType().getSymbol(), atom.getX(), atom.getY(), atom.getZ(), CommonConstants.NL));
        }
        return sb.toString();
    }

    @Override
    public MediaType getMediaType() {
        return TYPE;
    }

    @Override
    public boolean isWriteMulti() {
        return this.writeMulti;
    }

    @Override
    public void setWriteMulti(boolean writeMult) {
        this.writeMulti = writeMult;
    }

    public String getTplName() {
        return this.tplName;
    }

    public void setTplName(String templateName) {
        this.tplName = templateName;
    }
}

