/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.loader.gaussian;

import com.cmayes.common.chem.InternalMotionType;
import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.model.impl.DefaultAtom;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.cmayes.hartree.loader.Loader;
import org.cmayes.hartree.loader.ParseException;
import org.cmayes.hartree.loader.gaussian.BaseGaussianLoader;
import org.cmayes.hartree.model.InternalMotion;
import org.cmayes.hartree.model.NormalModeCalculation;
import org.cmayes.hartree.model.def.DefaultInternalMotion;
import org.cmayes.hartree.model.def.DefaultNormalMode;
import org.cmayes.hartree.model.def.DefaultNormalModeCalculation;
import org.cmayes.hartree.parser.gaussian.antlr.GaussianLexer;
import org.cmayes.hartree.parser.gaussian.antlr.NormalModeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalModeLoader
extends BaseGaussianLoader
implements Loader<NormalModeCalculation> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public NormalModeCalculation load(String srcName, Reader reader) {
        return this.extractNormalModeData(srcName, this.extractAst(srcName, reader));
    }

    private NormalModeCalculation extractNormalModeData(String srcName, CommonTree ast) {
        DefaultNormalModeCalculation result = new DefaultNormalModeCalculation(srcName);
        int atomColCount = 0;
        DefaultAtom curAtom = new DefaultAtom();
        DefaultNormalMode curNormal = null;
        InternalMotion curMotion = null;
        List<? extends Object> eventList = ast.getChildren();
        if (eventList == null) {
            this.logger.error("Parse failed: no AST children found for source " + srcName);
            return result;
        }
        block15: for (CommonTree commonTree : eventList) {
            switch (commonTree.getType()) {
                case -1: {
                    continue block15;
                }
                case 13: {
                    result.getCpuTimes().add(this.processCpuTime(commonTree));
                    continue block15;
                }
                case 37: {
                    result.getTerminationDates().add(this.processTermDate(commonTree));
                    continue block15;
                }
                case 42: {
                    result.setTransPart(this.toDouble(commonTree.getText()));
                    continue block15;
                }
                case 34: {
                    result.setRotPart(this.toDouble(commonTree.getText()));
                    continue block15;
                }
                case 21: {
                    result.setMult(this.toInt(commonTree.getText()));
                    continue block15;
                }
                case 18: {
                    Double freqVal = this.toDouble(commonTree.getText());
                    if (freqVal == null) continue block15;
                    result.getFrequencyValues().add(freqVal);
                    continue block15;
                }
                case 5: {
                    result.setSymmetricTop(false);
                    continue block15;
                }
                case 48: 
                case 49: {
                    this.handleAtom(commonTree.getText(), curAtom, atomColCount);
                    if (++atomColCount % 6 != 0) continue block15;
                    result.getAtoms().add(curAtom);
                    curAtom = new DefaultAtom();
                    continue block15;
                }
                case 31: {
                    curNormal = new DefaultNormalMode();
                    result.getNormalModes().add(curNormal);
                    continue block15;
                }
                case 30: {
                    curMotion = new DefaultInternalMotion();
                    curNormal.getMotions().add(curMotion);
                    curMotion.setType(InternalMotionType.valueOfSymbol(commonTree.getText().substring(0, 1)));
                    continue block15;
                }
                case 26: {
                    curMotion.getMembers().add(this.toInt(commonTree.getText()));
                    continue block15;
                }
                case 29: {
                    if (curMotion.getValue() == null) {
                        curMotion.setValue(this.toDouble(commonTree.getText()));
                        continue block15;
                    }
                    curMotion.setWeight(this.toDouble(commonTree.getText()));
                    continue block15;
                }
            }
            this.logger.warn(String.format("Unhandled data %s %s", commonTree.getType(), commonTree.getText()));
        }
        return result;
    }

    protected CommonTree extractAst(String srcName, Reader reader) {
        try {
            GaussianLexer lexer = new GaussianLexer(new ANTLRReaderStream(reader));
            NormalModeParser parser = new NormalModeParser(new CommonTokenStream(lexer));
            return (CommonTree)parser.script().getTree();
        }
        catch (IOException e) {
            throw new EnvironmentException("Problems reading from " + srcName, (Throwable)e, new Object[0]);
        }
        catch (RecognitionException e) {
            throw new ParseException("Problems parsing data from " + srcName, e);
        }
    }
}

