/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.loader.gaussian;

import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.model.impl.DefaultAtom;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.cmayes.hartree.loader.Loader;
import org.cmayes.hartree.loader.ParseException;
import org.cmayes.hartree.loader.gaussian.BaseGaussianLoader;
import org.cmayes.hartree.model.BaseResult;
import org.cmayes.hartree.model.def.DefaultBaseResult;
import org.cmayes.hartree.parser.gaussian.antlr.SnapshotLexer;
import org.cmayes.hartree.parser.gaussian.antlr.SnapshotParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLoader
extends BaseGaussianLoader
implements Loader<BaseResult> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public BaseResult load(String srcName, Reader reader) {
        return this.extractSnapshotData(srcName, this.extractAst(srcName, reader));
    }

    private BaseResult extractSnapshotData(String srcName, CommonTree ast) {
        DefaultBaseResult result = new DefaultBaseResult(srcName);
        int atomColCount = 0;
        DefaultAtom curAtom = new DefaultAtom();
        List<? extends Object> eventList = ast.getChildren();
        if (eventList == null) {
            this.logger.error("Parse failed: no AST children found for source " + srcName);
            return result;
        }
        block19: for (CommonTree commonTree : eventList) {
            switch (commonTree.getType()) {
                case -1: {
                    continue block19;
                }
                case 16: {
                    result.getCpuTimes().add(this.processCpuTime(commonTree));
                    continue block19;
                }
                case 50: {
                    result.getTerminationDates().add(this.processTermDate(commonTree));
                    continue block19;
                }
                case 37: {
                    result.setMult(this.toInt(commonTree.getText()));
                    continue block19;
                }
                case 28: {
                    Double freqVal = this.toDouble(commonTree.getText());
                    if (freqVal == null) continue block19;
                    result.getFrequencyValues().add(freqVal);
                    continue block19;
                }
                case 58: 
                case 59: {
                    this.handleAtom(commonTree.getText(), curAtom, atomColCount);
                    if (++atomColCount % 6 != 0) continue block19;
                    result.addAtom(curAtom);
                    curAtom = new DefaultAtom();
                    continue block19;
                }
                case 24: {
                    result.setElecEn(this.toDouble(commonTree.getText()));
                    continue block19;
                }
                case 29: {
                    String[] funcSetSplit = commonTree.getText().split("/");
                    result.setFunctional(funcSetSplit[0]);
                    result.setBasisSet(funcSetSplit[1]);
                    continue block19;
                }
                case 46: {
                    result.setSolvent(this.stripEndComma(commonTree.getText()));
                    continue block19;
                }
                case 61: {
                    result.setZpeCorrection(this.toDouble(commonTree.getText()));
                    continue block19;
                }
                case 30: {
                    result.setGibbs298(this.toDouble(commonTree.getText()));
                    continue block19;
                }
                case 32: {
                    result.setEnthalpy298(this.toDouble(commonTree.getText()));
                    continue block19;
                }
                case 5: {
                    result.setBsse(this.toDouble(commonTree.getText()));
                    continue block19;
                }
                case 7: {
                    result.setCharge(this.toInt(commonTree.getText()));
                    continue block19;
                }
                case 48: {
                    result.setStoichiometry(commonTree.getText());
                    continue block19;
                }
                case 22: {
                    result.setDipoleMomentTotal(this.toDouble(commonTree.getText()));
                    continue block19;
                }
                case 40: {
                    result.setAtomCount(this.toInt(commonTree.getText()));
                    continue block19;
                }
            }
            this.logger.warn(String.format("Unhandled data %s %s", commonTree.getType(), commonTree.getText()));
        }
        return result;
    }

    private String stripEndComma(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text.endsWith(",")) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    protected CommonTree extractAst(String srcName, Reader reader) {
        try {
            SnapshotLexer lexer = new SnapshotLexer(new ANTLRReaderStream(reader));
            SnapshotParser parser = new SnapshotParser(new CommonTokenStream(lexer));
            return (CommonTree)parser.script().getTree();
        }
        catch (IOException e) {
            throw new EnvironmentException("Problems reading from " + srcName, (Throwable)e, new Object[0]);
        }
        catch (RecognitionException e) {
            throw new ParseException("Problems parsing data from " + srcName, e);
        }
    }
}

