/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.model;

import com.cmayes.common.chem.AtomIdComparator;
import com.cmayes.common.exception.ExceptionUtils;
import com.cmayes.common.model.Atom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cmayes.hartree.model.NamedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowestEnergyMapper
implements NamedSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<EnergyAtoms> energyAtoms = new ArrayList<EnergyAtoms>();
    private String sourceName;

    public LowestEnergyMapper() {
    }

    public LowestEnergyMapper(String srcName) {
        this.sourceName = srcName;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void setSourceName(String srcName) {
        this.sourceName = srcName;
    }

    public void add(double energy, List<Atom> atoms) {
        ArrayList<Atom> localAtoms = new ArrayList<Atom>(ExceptionUtils.asNotNullCollection(atoms, "Atoms are or contain nulls", new Object[0]));
        Collections.sort(localAtoms, new AtomIdComparator());
        this.energyAtoms.add(new EnergyAtoms(energy, localAtoms));
    }

    public List<Atom> getLowestEnergy() {
        if (this.energyAtoms.size() == 0) {
            throw new IllegalStateException("Atoms list is empty");
        }
        EnergyAtoms lowest = null;
        for (EnergyAtoms curAtom : this.energyAtoms) {
            if (lowest == null) {
                lowest = curAtom;
                continue;
            }
            if (!(curAtom.getElecEn() < lowest.getElecEn())) continue;
            lowest = curAtom;
        }
        this.logger.debug("Lowest energy: " + lowest.getElecEn());
        return lowest.getAtoms();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LowestEnergyMapper)) {
            return false;
        }
        LowestEnergyMapper rhs = (LowestEnergyMapper)object;
        return new EqualsBuilder().append(this.energyAtoms, rhs.energyAtoms).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-910702087, -1866450035).append(this.energyAtoms).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("lowestEnergy", this.getLowestEnergy()).toString();
    }

    public static class EnergyAtoms {
        private final double elecEn;
        private final List<Atom> atoms;

        public EnergyAtoms(double en, List<Atom> atomList) {
            this.elecEn = en;
            this.atoms = atomList;
        }

        public double getElecEn() {
            return this.elecEn;
        }

        public List<Atom> getAtoms() {
            return this.atoms;
        }
    }
}

