/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.model.def;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.cmayes.hartree.model.DihedralPair;
import org.cmayes.hartree.model.NormalModeSummary;

public class DefaultNormalModeSummary
implements NormalModeSummary {
    private Double angleBendingWeight = 0.0;
    private Double bondStretchingWeight = 0.0;
    private Map<DihedralPair, Double> dihedralPairWeights = Maps.newTreeMap();

    @Override
    public Double getAngleBendingWeight() {
        return this.angleBendingWeight;
    }

    @Override
    public void setAngleBendingWeight(Double weight) {
        this.angleBendingWeight = weight;
    }

    public void addToAngleBendingWeight(double weight) {
        this.angleBendingWeight = this.angleBendingWeight + weight;
    }

    @Override
    public Double getBondStretchingWeight() {
        return this.bondStretchingWeight;
    }

    @Override
    public void setBondStretchingWeight(Double weight) {
        this.bondStretchingWeight = weight;
    }

    public void addToBondStretchingWeight(double weight) {
        this.bondStretchingWeight = this.bondStretchingWeight + weight;
    }

    @Override
    public Map<DihedralPair, Double> getDihedralPairWeights() {
        return this.dihedralPairWeights;
    }

    @Override
    public void setDihedralPairWeights(Map<DihedralPair, Double> weights) {
        this.dihedralPairWeights = weights;
    }

    public void addToDihedralPairWeights(DihedralPair pair, double weight) {
        Double curVal = this.dihedralPairWeights.get(pair);
        double initVal = curVal == null ? 0.0 : curVal;
        this.dihedralPairWeights.put(pair, initVal + weight);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultNormalModeSummary)) {
            return false;
        }
        DefaultNormalModeSummary rhs = (DefaultNormalModeSummary)object;
        return new EqualsBuilder().append(this.bondStretchingWeight, rhs.bondStretchingWeight).append(this.dihedralPairWeights, rhs.dihedralPairWeights).append(this.angleBendingWeight, rhs.angleBendingWeight).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(262712407, 1406686309).append(this.bondStretchingWeight).append(this.dihedralPairWeights).append(this.angleBendingWeight).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("bondStretchingWeight", this.bondStretchingWeight).append("dihedralPairWeights", this.dihedralPairWeights).append("angleBendingWeight", this.angleBendingWeight).toString();
    }
}

