/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.parser;

import com.cmayes.common.exception.EnvironmentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Token;
import org.cmayes.hartree.parser.gaussian.antlr.CalcResultParser;
import org.cmayes.hartree.parser.gaussian.antlr.GaussianLexer;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntlrTokenStreamPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntlrTokenStreamPrinter.class);
    private File file;

    protected Lexer createLexer() {
        return new GaussianLexer();
    }

    protected String[] getTokenNames() {
        return CalcResultParser.tokenNames;
    }

    @Option(aliases={"-f"}, name="--file", usage="The file to process", metaVar="TOKENFILE", required=true)
    public void setFile(File theFile) {
        if (!theFile.canRead()) {
            throw new IllegalArgumentException(String.format("File %s is not readable", theFile.getAbsolutePath()));
        }
        this.file = theFile;
    }

    public static void main(String ... args) {
        try {
            new AntlrTokenStreamPrinter().doMain(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("java %s [options...] arguments...", AntlrTokenStreamPrinter.class.getName()));
            e.getParser().printUsage(System.err);
            System.err.println();
            System.err.println(String.format("Example: %s %s", AntlrTokenStreamPrinter.class.getName(), e.getParser().printExample(ExampleMode.ALL)));
            System.exit(1);
        }
        catch (Exception e) {
            LOGGER.error("Top-level exception caught", e);
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    public void doMain(String ... args) throws CmdLineException {
        CmdLineParser parser = new CmdLineParser(this);
        parser.parseArgument(args);
        Lexer lexer = this.createLexer();
        try {
            lexer.setCharStream(new ANTLRReaderStream(new FileReader(this.file)));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("File %s not found", this.file.getAbsolutePath()), e);
        }
        catch (IOException e) {
            throw new EnvironmentException(String.format("Problems reading file %s", this.file.getAbsolutePath()), (Throwable)e, new Object[0]);
        }
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        tokens.fill();
        System.out.println("Start of stream ");
        for (Token token : tokens.getTokens()) {
            Token token2 = token;
            if (45 == token2.getType()) continue;
            System.out.println("=======================================\nEmbeddedCode = " + token2.getText());
            if (token2.getType() > 0) {
                System.out.println("\nType: " + this.getTokenNames()[token2.getType()]);
                continue;
            }
            System.out.println("EOF");
        }
    }
}

